<?php

/**
 * Import emails from Excel file
 */
function import_emails_from_excel() {
    if (!isset($_FILES['import_file']) || empty($_FILES['import_file']['tmp_name'])) {
        return;
    }

    $file = $_FILES['import_file']['tmp_name'];
    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
    $spreadsheet = $reader->load($file);
    $worksheet = $spreadsheet->getActiveSheet();
    $rows = $worksheet->toArray();

    global $wpdb;
    $table_name = $wpdb->prefix . 'newsletter_emails';

    foreach ($rows as $row) {
        $email = sanitize_email($row[0]);
        if (is_email($email)) {
            $wpdb->insert(
                $table_name,
                array(
                    'email' => $email,
                )
            );
        }
    }
}

/**
 * Export emails to Excel file
 */

function export_emails_to_excel() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'newsletter_emails';
    $emails = $wpdb->get_results("SELECT email FROM $table_name", ARRAY_N);

    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $worksheet = $spreadsheet->getActiveSheet();

    $rowNumber = 1;
    foreach ($emails as $email) {
        $worksheet->setCellValueByColumnAndRow(1, $rowNumber, $email[0]);
        $rowNumber++;
    }

    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);

    // Disable output buffering
    while (ob_get_level()) {
        ob_end_clean();
    }

    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="newsletter_emails.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    exit;
}



/**
 * Delete a single email using AJAX
 */
function delete_single_email() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'newsletter_emails';

    if ( isset( $_POST['email_id'] ) ) {
        $email_id = intval( $_POST['email_id'] );
        $wpdb->delete( $table_name, array( 'id' => $email_id ) );
        echo 'ایمیل با موفقیت حذف شد.';
    } else {
        echo 'خطایی رخ داده است.';
    }

    wp_die();
}

add_action( 'wp_ajax_delete_single_email', 'delete_single_email' );