<?php

add_action( 'cmb2_admin_init', 'metaboxe_product_video' );

function metaboxe_product_video()
{

$video = new_cmb2_box(array(
'id' => 'metaboxe_product-video',
'title' => __('ویدیو محصول', 'cmb2'),
'object_types' => array('product'),
'context' => 'normal',
'priority' => 'high',
'show_names' => true,
));
$video ->add_field( array(
'name'    => 'نوع ویدیو',
'id'      => 'span-cale-conditional',
'type'    => 'radio',
'options' => array(
'plays-0'      => __( 'غیر فعال | بدون ویدیو ' ),
'plays-1'      => __( 'کد امبد | Embed code' ),
'plays-2'       => __( 'آپلود ویدیو' ),
),
'default' => 'plays-0',
) );
$video->add_field( array(
'name' => 'کد امبد |embed code ',
'desc' => 'شما میتوانید ویدیو مورد نظر را با پلیر اصلی به وسیله کد امبد به سایت منتقل کنید',
'id'   => 'embed-code-cideo-product',
'type' => 'textarea_code',
'attributes' => array(
'data-conditional-id'     => 'span-cale-conditional',
'data-conditional-value'  => 'plays-1',
'data-conditional-invert' => true,
),
) );
$video->add_field( array(
'name'    => 'آپلود ویدیو',
'desc'    => 'ویدیو محصول خود را آپلود کنید توجه کنید لزومی به آپلود ویدیو نسست در صورت عدم آپلود ویدیو باکس و قسمت ویدیو در صفحه محصول نمایش نخواهد یافت',
'id'      => 'metaboxe_product-videos',
'type'    => 'file',
'text'    => array(
'add_upload_file_text' => 'آپلود ویدیو محصول' // Change upload button text. Default: "Add or Upload File"
),
'attributes' => array(
'data-conditional-id'     => 'span-cale-conditional',
'data-conditional-value'  => 'plays-2',
'data-conditional-invert' => true,
),
) );

}

add_action('cmb2_admin_init', 'metaboxe_productss');

function metaboxe_productss()
{

    $offer = new_cmb2_box(array(
        'id' => 'metaboxe_product-offer',
        'title' => __('تایمر تخفیف', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    ));

    $offer->add_field(array(
        'name' => 'فعال و غیر فعال سازی تایمر تخفیف',
        'id' => 'metaboxe_product-offers',
        'type' => 'radio',
        'options' => array(
            'on' => __('فعالسازی', 'cmb2'),
            'off' => __('غیر فعال سازی', 'cmb2'),
        ),
        'desc' =>  "تاریخ امروز به میلادی :" . " " .date("F j, Y"),
        'default' => "off",
    ));
    $offer->add_field(array(
        'name' => 'انتخاب سال',
        'desc' => 'شما در این قسمت سال اتمام تایمر را انتخاب میکنید ',
        'id' => 'month-years-select-zero',
        'type' => 'select',
        'show_option_none' => true,
        'default' => date("Y"),
        'attributes' => array(
            'data-conditional-id'     => 'metaboxe_product-offers',
            'data-conditional-value'  => 'on',
            'data-conditional-invert' => true,
        ),
        'options' => array(
            '2023' => '2023',
            '2024' => '2024',
            '2025' => '2025',
            '2026' => '2026',
            '2027' => '2027',
            '2028' => '2028',
            '2029' => '2029',
            '2030' => '2030',
            '2031' => '2031',
            '2032' => '2032',
            '2033' => '2033',
        ),
    ));

    $offer->add_field(array(
        'name' => 'انتخاب ماه',
        'desc' => 'ماه اتمام تایمر تخفیف خود را به میلادی انتخاب کنید ',
        'id' => 'month-years-select-one',
        'type' => 'select',
        'show_option_none' => true,
        'default' => date("m"),
        'attributes' => array(
            'data-conditional-id'     => 'metaboxe_product-offers',
            'data-conditional-value'  => 'on',
            'data-conditional-invert' => true,
        ),
        'options' => array(
            '01' => 'ژانویه',
            '02' => 'فوریه',
            '03' => 'مارس',
            '04' => 'آوریل',
            '05' => 'مه',
            '06' => 'ژوئن',
            '07' => 'ژوئیه',
            '08' => 'اوت',
            '09' => 'سپتامبر',
            '10' => 'اکتبر',
            '11' => 'نوامبر',
            '12' => 'دسامبر',
        ),
    ));
    $offer->add_field(array(
        'name' => 'انتخاب روز',
        'desc' => 'روز اتمام تایمر تخفیف خود را برای ااین محصول به میلادی انتخاب نمایید',
        'id' => 'month-years-select-two',
        'type' => 'select',
        'null' => 'false',
        'show_option_none' => true,
        'default' => date("d"),
        'attributes' => array(
            'data-conditional-id'     => 'metaboxe_product-offers',
            'data-conditional-value'  => 'on',
            'data-conditional-invert' => true,
        ),
        'options' => array(
            '01' => '1',
            '02' => '2',
            '03' => '3',
            '04' => '4',
            '05' => '5',
            '06' => '6',
            '07' => '7',
            '08' => '8',
            '09' => '9',
            '10' => '10',
            '11' => '11 ',
            '12' => '12',
            '13' => '13',
            '14' => '14',
            '15' => '15',
            '16' => '16',
            '17' => '17',
            '18' => '18',
            '19' => '19',
            '20' => '20',
            '21' => '21',
            '22' => '22',
            '23' => '23',
            '24' => '24',
            '25' => '25',
            '26' => '26',
            '27' => '27',
            '28' => '28',
            '29' => '29',
            '30' => '30',
            '31' => '31',
        ),
    ));
    $offer->add_field(array(
        'name' => 'انتخاب ساعت',
        'desc' => 'ساعت اتمام تایمر تخفیف خود را برای این محصول را انتخاب نمایید',
        'id' => 'month-years-select-there',
        'type' => 'select',
        'show_option_none' => true,
        'default' => date("H"),
        'attributes' => array(
            'data-conditional-id'     => 'metaboxe_product-offers',
            'data-conditional-value'  => 'on',
            'data-conditional-invert' => true,
        ),
        'options' => array(
            '01' => '01',
            '02' => '02',
            '03' => '03',
            '04' => '04',
            '05' => '05',
            '06' => '06',
            '07' => '07',
            '08' => '08',
            '09' => '09',
            '10' => '10',
            '11' => '11 ',
            '12' => '12',
            '13' => '13',
            '14' => '14',
            '15' => '15',
            '16' => '16',
            '17' => '17',
            '18' => '18',
            '19' => '19',
            '20' => '20',
            '21' => '21',
            '22' => '22',
            '23' => '23',
            '24' => '24',
        ),
    ));

}

add_action( 'cmb2_admin_init', 'metaboxe_product_Estimated_Delivery' );

function metaboxe_product_Estimated_Delivery() {

    $Delivery = new_cmb2_box(array(
        'id' => 'metaboxe_product-Delivery',
        'title' => __('زمان تحویل تخمینی', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    ));
    $Delivery->add_field(array(
        'name' => 'زمان تحویل',
        'desc' => 'شما میتوانید تحویل تخمینی این محصول را به مشتری بگویی مثال (تهران همان روز - شهرستان 1 االی 3 روز) توجه کنید که در صورت خالی بودن نمایش داده نمیشود',
        'id' => 'vera-theme-Delivery',
        'type' => 'text',
    ));

}


add_action( 'cmb2_admin_init', 'metaboxe_product_garanti' );

function metaboxe_product_garanti() {

    $garanti = new_cmb2_box(array(
        'id' => 'metaboxe_product-garanti',
        'title' => __('گارانتی و ضمانت محصول', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    ));
    $garanti->add_field(array(
        'name' => 'گارانتی و ضمانت محصول',
        'desc' => 'شما میتوانید گارانتی و ضمانتی برای محصول خود به مشتری بدهید  مثال (ضمانت اصالت و سلامت محصول و یا 2 سال گاراانتی ویرا شاپ) توجه کنید که در صورت خالی بودن نمایش داده نمیشود',
        'id' => 'vera-theme-garanti',
        'type' => 'text',
    ));

}


add_action('cmb2_admin_init', 'metaboxe_product_question');
function metaboxe_product_question()
{
    $lesson_pro = new_cmb2_box(array(
        'id' => 'metaboxe_product-question',
        'title' => __('سوالات متداول محصول', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    ));


    $lesson_product = $lesson_pro->add_field(array(
        'id' => 'metaboxe_product-questions',
        'type' => 'group',
        'options' => array(
            'group_title' => __('سوالات', 'cmb2'), // since version 1.1.4, {#} gets replaced by row number
            'add_button' => __('افزودن سوال متداول جدید', 'cmb2'),
            'remove_button' => __('حذف کلی سوال متداول', 'cmb2'),
            'sortable' => true,
            'closed' => true, // true to have the groups closed by default
            'remove_confirm' => esc_html__('آیا اطمینان داری میخواهید این سوال را پاک کنید؟', 'cmb2'), // Performs confirmation before removing group.
        ),
    ));
    $lesson_pro->add_group_field($lesson_product, array(
        'name' => 'عنوان سوال',
        'id' => 'questions_1_product',
        'type' => 'text',
        'attributes' => array(
            'placeholder' => 'مثلا آیا محصول دارای شارژر جدا میباشد ؟',
        )
    ));

    $lesson_pro->add_group_field($lesson_product, array(
        'name' => 'جواب سوال',
        'id' => 'questions_2_product',
        'type' => 'text',
        'attributes' => array(
            'placeholder' => 'مثلا بله دستگاه خریداری شده داخل کارتن یک کابل usb ارد که میتوانید با یک کلگی دستگاه را شارژ کنید',
        )
    ));

}



add_action('cmb2_admin_init', 'metaboxe_product_3d_slider');
function metaboxe_product_3d_slider()
{
    $lesson_pro = new_cmb2_box(array(
        'id' => 'metaboxe_product-3d-slider',
        'title' => __('قابلیت 3 بعدی محصول', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    ));


    $lesson_product = $lesson_pro->add_field(array(
        'name' => 'آپلود تصاویر کلی محصول',
        'desc' => 'توضیحات : شما باید از محصول خود به کمک نرم افزار های موجود تصاویر 3 بعدی و یا دوربین خود تصاویر ثابت تهیه و به ترتیب به کمک آپلودر این بخش ر سایت خود آپلود کنید توجه کنید که این قسمت تاثر چندانی در لود اولیه صفحه شما ندارد چون در صورت درخواست و کلیک روی لوگوی 360 تصاویر در همان لحظه به صورت ایجکس دانلود میشوند',
        'id'   => 'list-image-3d_product',
        'type' => 'file_list',
        // 'preview_size' => array( 100, 100 ), // Default: array( 50, 50 )
        // 'query_args' => array( 'type' => 'image' ), // Only images attachment
        // Optional, override default text strings
        'text' => array(
            'add_upload_files_text' => 'افزودن تصاویر ترتیبی 3D', // default: "Add or Upload Files"
            'remove_image_text' => 'Replacement', // default: "Remove Image"
            'file_text' => 'Replacement', // default: "File:"
            'file_download_text' => 'Replacement', // default: "Download"
            'remove_text' => 'Replacement', // default: "Remove"
        ),
    ));


}




add_action('cmb2_admin_init', 'metaboxe_productss_pro_products');

function metaboxe_productss_pro_products()
{

    $offer = new_cmb2_box(array(
        'id' => 'metaboxe_product-offer_daghghg',
        'title' => __('محصول فروش ویژه', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    ));

    $offer->add_field(array(
        'name' => 'وضعیت محصول فروش ویژه',
        'id' => 'metaboxe_product-offer_daghghgs',
        'type' => 'radio',
        'options' => array(
            'on' => __('فعالسازی', 'cmb2'),
            'off' => __('غیر فعال سازی', 'cmb2'),
        ),
        'default' => "off",
    ));

}



add_action('cmb2_admin_init', 'metaboxe_productss_link');

function metaboxe_productss_link()
{

    $links = new_cmb2_box(array(
        'id' => 'metaboxe_product-links',
        'title' => __('همکاری در فروش', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    ));

    $links->add_field(array(
        'name' => 'فعال و غیر فعال سازی همکاری در فروش',
        'id' => 'metaboxe_product-linkss',
        'type' => 'radio',
        'options' => array(
            'on' => __('فعالسازی', 'cmb2'),
            'off' => __('غیر فعال سازی', 'cmb2'),
        ),
        'desc' =>  "میتوانید با فعال سازی این بخش دکمه خرید کالا را به یکی از سایتی که میخواهید با متن دلخواه هدایت کنید توجه کنید که با فعال سازی این قابلیت دیگر شما در سایت خود این محصول را به فروش نمیگذارید و به لینک وارد شده هدایت خواهد شد این قابلیت صرفا جهت محصولاتی ااست که میخواهید به سایت اصلی فروش هدایت گردد مثل همکاری در فروش یک محصول محصولات دیجیکالا که یک قابلیتی است که میتوانید از هر محصولی که کاربر از لینک هدایت شما خریداری کند مبلغی را دریافت کنید توجه کنید با فعال سازی این بخش دکمه افزودن به سبد خرید برای سایت شما غیر فعال میگردد و فقط دکمه ایجادی نمایش داده میگردد",
        'default' => "off",
    ));
    $links->add_field(array(
        'name' => 'متن دکمه هدایت به لینک ',
        'desc' => 'شما میتوانید متن دکمه هدایت به لینک را شخصی سازی کنید مثل خرید این محصول از دیجیکالا',
        'id' => 'vera-theme-linssss',
        'type' => 'text',
        'default' => "هدایت به صفحه فروشگاه",
        'attributes' => array(
            'data-conditional-id'     => 'metaboxe_product-linkss',
            'data-conditional-value'  => 'on',
            'data-conditional-invert' => true,
        ),
    ));
    $links->add_field(array(
        'name' => 'لینک هدایت ',
        'desc' => 'شما میتوانید لینکی که میخواهید به آن هدایت گردد مثل لینک همکاری در فروش',
        'id' => 'vera-theme-linsssss',
        'type' => 'text',
        'attributes' => array(
            'data-conditional-id'     => 'metaboxe_product-linkss',
            'data-conditional-value'  => 'on',
            'data-conditional-invert' => true,
        ),
    ));
    $links->add_field(array(
        'name' => 'انتقال به لینک در برگه جدید تا همان برگه',
        'id' => 'metaboxe_product-linkss-blank',
        'type' => 'radio',
        'options' => array(
            'on' => __('فعالسازی', 'cmb2'),
            'off' => __('غیر فعال سازی', 'cmb2'),
        ),
        'desc' =>  "شما میتوانید روش انتقال به لینک را تغییر دهید باا فعال سازی این گذینه لینک شما در برگه جدید و یا به اصطلاح تب خرید در مرورگر باز میگردد و سایت شما در یکی از تب های مرورگر کاربر باز میباشد و به صورت پیش فرض این لینک در همان برگه باز خواهد شد",
        'default' => "off",
    ));

}




add_action('cmb2_admin_init', 'metaboxe_productss_gift');

function metaboxe_productss_gift()
{

    $gift = new_cmb2_box(array(
        'id' => 'metaboxe_product-fifts',
        'title' => __('خدمات بسته بندی طرح کادو برای هدیه', 'cmb2'),
        'object_types' => array('product'),
        'context' => 'normal',
        'show_names' => true,
    ));

    $gift->add_field(array(
        'name' => 'فعال و غیر فعال سازی خدمات کادو پیچی محصول',
        'id' => 'metaboxe_product-giftss',
        'type' => 'radio',
        'options' => array(
            'on' => __('فعالسازی', 'cmb2'),
            'off' => __('غیر فعال سازی', 'cmb2'),
        ),
        'desc' =>  "میتوانید با فعال سازی این بخش به صفحه این محصول تیک انتخابی اضافه کنید که تایید کردن این گزینه توسط خریدار به شما در صفحه سفارش ها متنی برای کادو پیچی اضافه میگردد که توسط متن بله و نخیر به شما این پیاام را میدهد که آیا محصول را کادو پیچ کنید و یا خیر و اینکه اگر جهت انجام این خدمات هزینه ای میخواهید دریافت کنید میتوانید از قسمت تنظیمات قالب قسمت فروشگاه تنظیمات عمومی این هزینه را که به صورت پیش فرض روی 10 هزار تومان میباشد را تغییر دهید ",
        'default' => "off",
    ));

}