<?php
/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined('ABSPATH') || exit;

if (!class_exists('Redux')) {
	return;
}

// This is your option name where all the Redux data is stored.
$opt_name = 'options_vera_theme';  // YOU MUST CHANGE THIS.  DO NOT USE 'redux_demo' IN YOUR PROJECT!!!

// Uncomment to disable demo mode.
/* Redux::disable_demo(); */  // phpcs:ignore Squiz.PHP.CommentedOutCode

$dir = dirname(__FILE__) . DIRECTORY_SEPARATOR;

/*
 * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
 */

// Background Patterns Reader.
$sample_patterns_path = Redux_Core::$dir . '../sample/patterns/';
$sample_patterns_url = Redux_Core::$url . '../sample/patterns/';
$sample_patterns = array();

if (is_dir($sample_patterns_path)) {
	$sample_patterns_dir = opendir($sample_patterns_path);

	if ($sample_patterns_dir) {

		// phpcs:ignore WordPress.CodeAnalysis.AssignmentInCondition
		while (false !== ($sample_patterns_file = readdir($sample_patterns_dir))) {
			if (stristr($sample_patterns_file, '.png') !== false || stristr($sample_patterns_file, '.jpg') !== false) {
				$name = explode('.', $sample_patterns_file);
				$name = str_replace('.' . end($name), '', $sample_patterns_file);
				$sample_patterns[] = array(
					'alt' => $name,
					'img' => $sample_patterns_url . $sample_patterns_file,
				);
			}
		}
	}
}

// Used to execept HTML tags in description arguments where esc_html would remove.
$kses_exceptions = array(
	'a' => array(
		'href' => array(),
	),
	'strong' => array(),
	'br' => array(),
	'code' => array(),
);

/*
 * ---> BEGIN ARGUMENTS
 */

/**
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://devs.redux.io/core/arguments/
 */
$theme = wp_get_theme(); // For use with some settings. Not necessary.



// TYPICAL -> Change these values as you need/desire.
$args = array(
	// This is where your data is stored in the database and also becomes your global variable name.
	'opt_name' => $opt_name,

	// Name that appears at the top of your panel.
	'display_name' => '<p style="text-align: center;width 100%;font-size: 30px;line-height: 0;right: 30px;margin: 0;">تنظیمات قالب</p>',

	// Version that appears at the top of your panel.
	'display_version' => $theme->get('<P>1.0.0</P>'),

	// Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only).
	'menu_type' => 'menu',

	// Show the sections below the admin menu item or not.
	'allow_sub_menu' => true,

	// The text to appear in the admin menu.
	'menu_title' => esc_html__('تنظیمات قالب', 'your-textdomain-here'),

	// The text to appear on the page title.
	'page_title' => 'تنظیمات قالب',

	// Disable to create your own Google fonts loader.
	'disable_google_fonts_link' => false,

	// Show the panel pages on the admin bar.
	'admin_bar' => true,

	// Icon for the admin bar menu.
	'admin_bar_icon' => 'dashicons-admin-generic',

	// Priority for the admin bar menu.
	'admin_bar_priority' => 50,

	// Sets a different name for your global variable other than the opt_name.
	'global_variable' => $opt_name,

	// Show the time the page took to load, etc. (forced on while on localhost or when WP_DEBUG is enabled).
	'dev_mode' => false,

	// Enable basic customizer support.
	'customizer' => true,

	// Allow the panel to open expanded.
	'open_expanded' => false,

	// Disable the save warning when a user changes a field.
	'disable_save_warn' => false,

	// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
	'page_priority' => null,

	// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters.
	'page_parent' => 'themes.php',

	// Permissions needed to access the options panel.
	'page_permissions' => 'manage_options',

	// Specify a custom URL to an icon.
	'menu_icon' => '',

	// Force your panel to always open to a specific tab (by id).
	'last_tab' => '',

	// Icon displayed in the admin panel next to your menu_title.
	'page_icon' => 'icon-themes',

	// Page slug used to denote the panel, will be based off page title, then menu title, then opt_name if not provided.
	'page_slug' => $opt_name,

	// On load save the defaults to DB before user clicks save.
	'save_defaults' => true,

	// Display the default value next to each field when not set to the default value.
	'default_show' => false,

	// What to print by the field's title if the value shown is default.
	'default_mark' => '*',

	// Shows the Import/Export panel when not used as a field.
	'show_import_export' => true,

	// The time transinets will expire when the 'database' arg is set.
	'transient_time' => 60 * MINUTE_IN_SECONDS,

	// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output.
	'output' => true,

	// Allows dynamic CSS to be generated for customizer and google fonts,
	// but stops the dynamic CSS from going to the page head.
	'output_tag' => true,

	// Disable the footer credit of Redux. Please leave if you can help it.
	'footer_credit' => '',

	// If you prefer not to use the CDN for ACE Editor.
	// You may download the Redux Vendor Support plugin to run locally or embed it in your code.
	'use_cdn' => true,

	// Set the theme of the option panel.  Use 'wp' to use a more modern style, default is classic.
	'admin_theme' => 'wp',

	// Enable or disable flyout menus when hovering over a menu with submenus.
	'flyout_submenus' => true,

	// Mode to display fonts (auto|block|swap|fallback|optional)
	// See: https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display.
	'font_display' => 'swap',

	// HINTS.
	'hints' => array(
		'icon' => 'el el-question-sign',
		'icon_position' => 'right',
		'icon_color' => 'lightgray',
		'icon_size' => 'normal',
		'tip_style' => array(
			'color' => 'red',
			'shadow' => true,
			'rounded' => false,
			'style' => '',
		),
		'tip_position' => array(
			'my' => 'top left',
			'at' => 'bottom right',
		),
		'tip_effect' => array(
			'show' => array(
				'effect' => 'slide',
				'duration' => '500',
				'event' => 'show',
			),
			'hide' => array(
				'effect' => 'slide',
				'duration' => '500',
				'event' => 'hide',
			),
		),
	),

	// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
	// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
	'database' => '',
	'network_admin' => true,
	'search' => false,
);


// ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
// PLEASE CHANGE THEME BEFORE RELEASEING YOUR PRODUCT!!
// If these are left unchanged, they will not display in your panel!


// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
// PLEASE CHANGE THEME BEFORE RELEASEING YOUR PRODUCT!!
// If these are left unchanged, they will not display in your panel!
$args['share_icons'][] = array(
	'url' => 'https://www.zhaket.com/store/web/mobopress/intro',
	'title' => 'تیم موبو پرس در مارکت معتبر ژاکت',
	'icon' => 'el el-quote-right ',
);


// Panel Intro text -> before the form.
if (!isset($args['global_variable']) || false !== $args['global_variable']) {
	if (!empty($args['global_variable'])) {
		$v = $args['global_variable'];
	} else {
		$v = str_replace('-', '_', $args['opt_name']);
	}

	// translators:  Panel opt_name.
	$args['intro_text'] = '<p class="animate-welcome-reduxe-diak-theme">این بخش مربوط به تنظیمات قالب فعال روی رودپرس شما است لطفا برای استفاده سریع و راحت از بخش تنظیمات به مستندات قالب مورد استفاده مراجعه فرمایید</p>';
} else {
	$args['intro_text'] = '';
}
$rand_text = rand(1,10);
if ($rand_text == 1 ) {
	$rand_text = 'گر هیچ نشانه نیست اندر وادی | بسیار امیدهاست در نومیدی ';
}
elseif ($rand_text == 2) {
	$rand_text = 'هر که رنجی دید گنجی شد پدید | هر که جدی کرد در جدی رسید ';
}
elseif ($rand_text == 3) {
	$rand_text = 'ای بسا کارا که اول صعب گشت  | بعد از آن بگشاده شد سختی گذشت |  بعد نومیدی بسی امیدهاست |  از پس ظلمت بسی خورشیدهاست ';
}
elseif ($rand_text == 4) {
	$rand_text = 'بیستون هیچ ، دماوند اگر سد بشود | هدفم قسمت من بوده و باید بشود ';
}
elseif ($rand_text == 5) {
	$rand_text = 'اگر گویی که بتوانم  قدم درنه که بتوانی | و گر گویی که نتوانم برو بنشین که نتوانی ';
}
elseif ($rand_text == 6) {
	$rand_text = 'ز کوشش به‌ هر چیز خواهی رسید | به‌ هر چیز خواهی کماهی رسید | برو کارگر باش و امّیدوار | که از یاس جز مرگ ناید به‌بار ';
}
elseif ($rand_text == 7) {
	$rand_text = 'ای دل ! صبور باش بر احداث روزگار | نیکو شود به صبر، سرانجام کار تو ';
}
elseif ($rand_text == 8) {
	$rand_text = 'نابرده رنج گنج میسر نمی‌شود | مزد آن گرفت جان برادر که کار کرد ';
}
elseif ($rand_text == 9) {
	$rand_text = 'چو کوشش نباشد، تن زورمند | نیارد سر از آرزوها بلند ';
}
elseif ($rand_text == 10) {
	$rand_text = 'خدا ار به حکمت ببندد دری  | گشاید به فضل و کرم دیگری ';
}
$args['footer_text'] = '<p style="color:#303841;">'. $rand_text . '</p>';

Redux::set_args($opt_name, $args);

/*
 * ---> END ARGUMENTS
 */

/*
 * ---> START HELP TABS
 */
$help_tabs = array(
	array(
		'id' => 'redux-help-tab-1',
		'title' => esc_html__('راهنمای بازنشانی تنظیمات', 'your-textdomain-here'),
		'content' => '<p>' . esc_html__('شما میتوانید با کلیک روی بازنشانی همه . کل تنظیمات اعمال شده را بازنشانی کنید و با کلیک روی بازنشانی بخش بخشی که در آن هستید را بازنشانی کنید', 'your-textdomain-here') . '</p>',
	),
	array(
		'id' => 'redux-help-tab-2',
		'title' => esc_html__('راهنمای تنظیمات کلی', 'your-textdomain-here'),
		'content' => '<p>' . esc_html__('شما میتوانید برای آموزش کلی قالب ویرا تم به مستندات متنی و یا ویدیو های آموزشی همراه قالب مراجعه فرمایید', 'your-textdomain-here') . '</p>',
	),
	array(
		'id' => 'redux-help-tab-3',
		'title' => esc_html__('راهنمای تنظیمات سربرگ', 'your-textdomain-here'),
		'content' => '<p>' . esc_html__('شما میتوانید برای انتخاب طرح هدر از قسمت اول طرح هدر اقدام کنید و بعد نسبت به ترتیب قرارگیری نمونه هدر ها تنظیمات منحصر با آن هدر را انتخاب و تنظیمات و تغییرات مورد نظر خود را اعمال کنید', 'your-textdomain-here') . '</p>',
	),
	array(
		'id' => 'redux-help-tab-4',
		'title' => esc_html__('راهنمای تنظیمات پاورگی', 'your-textdomain-here'),
		'content' => '<p>' . esc_html__('شما میتوانید برای انتخاب طرح پاورگی از قسمت اول طرح پاورگی اقدام کنید و بعد نسبت به ترتیب قرارگیری نمونه پاورگی ها تنظیمات منحصر با آن پاورگی را انتخاب و تنظیمات و تغییرات مورد نظر خود را اعمال کنید', 'your-textdomain-here') . '</p>',
	),
	array(
		'id' => 'redux-help-tab-5',
		'title' => esc_html__('مشکلات شما', 'your-textdomain-here'),
		'content' => '<p>' . esc_html__('قالب ویرا تم چندین و جند بار توسط ما تست گردیده اما اگر چه هیچ چیز بی عیب نیست لطفا در صورت بروز مشکل و یا نقص در قالب فورا به پشتیبانی ما در ژاکت(تیکت فروشنده) مراجعه و مشکل خود را در میان بگذارید ما حداکثر تلاشمان را میکنیم که مشکل و نقص قالب را برای نسخه بعد رفع نماییم و برای اطلاع از بروزرسانی قالب میتوانید افزونه بروز رسانی هوشمند را از ژاکت دریافت و در مسیر پیشخوان وردپرس > افزونه ها > افزودن > آپلود افزونه > آپلود نمایید و بعد افزونه را فعال که در اولین فرصت نسبت به بروزرسانی قالب دیاک تم بدون مشکل و دردسر اقدام نمایید', 'your-textdomain-here') . '</p>',
	),
	array(
		'id' => 'redux-help-tab-6',
		'title' => esc_html__('راهنمای انتقاد و نظرات', 'your-textdomain-here'),
		'content' => '<p>' . esc_html__('شما میتوانید برای انتقاد و نظر دهی و درخواست ویژگی و المان خاص به صفحه محصول ویرا تم در ژاکت مراجعه و در زیر محصول کامنت خود را ثبت نمایید و اگر نیاز به پاسخ دهی سریع و فوری داشتید میتوانید به تیکت به فروشنده مراجعه کنید', 'your-textdomain-here') . '</p>',
	),
);
Redux::set_help_tab($opt_name, $help_tabs);

// Set the help sidebar.
$content = '<p>' . esc_html__('راهنما کوتاه تنظیمات قالب ', 'your-textdomain-here') . '</p>';

Redux::set_help_sidebar($opt_name, $content);

/*
 * <--- END HELP TABS
 */

/*
 * ---> START SECTIONS
 */


// -> START Basic Fields
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات عمومی',
		'id' => 'basic-options',
		'customizer_width' => '400px',
		'icon' => 'el el-home',
	)
);

require_once Redux_Core::$dir . '../sample/sections/basic-fields/basic-options.php';

// -> START header Fields
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات سربرگ (هدر)',
		'id' => 'basic-options-header',
		'customizer_width' => '400px',
		'icon' => 'el el-website',
	)
);

require_once Redux_Core::$dir . '../sample/sections/header-fields/header-options.php';

// -> START account Fields
Redux::set_section(
	$opt_name,
	array(
		'title' => 'کنترول حساب مشتری ',
		'id' => 'basic-options-account',
		'customizer_width' => '400px',
		'icon' => 'el el-adult',
		'desc' => 'شما میتوانید از این قسمت اطلاعیه سایت و پیام مدیریت و شبکه های اجتماعی حساب کاربری مشتری را کنترول کنید)',
	)
);

require_once Redux_Core::$dir . '../sample/sections/account-fialds/account-options.php';


// -> START popup login $ register Fields
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات ارتباط | شناور ',
		'id' => 'basic-popup-log-widget',
		'customizer_width' => '400px',
		'icon' => 'el el-th-large',
		'desc' => 'میتوانید از این قسسمت تنظیمات مربوط به ویجت های ثابت را تغییر و ویرایش نمایید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/widget-options/widget-options.php';


// -> START popup login $ register Fields
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات پاورگی (فوتر) ',
		'id' => 'basic-popup-footer',
		'customizer_width' => '400px',
		'icon' => 'el  el-website',
		'desc' => 'میتوانید از این قسسمت تنظیمات مربوط به فوتر را تغییر و به طرح مورد نظر خود برسسید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/footer-options/footer-options.php';


// -> START typography
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات فروشگاه',
		'id' => 'basic-shops-page',
		'customizer_width' => '400px',
		'icon' => 'el el-shopping-cart',
		'desc' => 'میتوانید از این طریق تنظیمات مربوط به صفحه محصول سایتتان را تغییر دهید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/shop-options/shop-options.php';
// -> START archive
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات آرشیو',
		'id' => 'basic-archive-page',
		'customizer_width' => '400px',
		'icon' => 'el el-broom',
		'desc' => 'میتوانید از طریق این بخش تنظیمات مربوط به صفحه آرشیو نوشته های خود را تغییر و شخصی سازی کنید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/archive-options/archive-options.php';


// -> START loading page
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات لودینگ سایت ',
		'id' => 'basic-loading-page',
		'customizer_width' => '400px',
		'icon' => 'el el-repeat',
		'desc' => 'میتوانید از این طریق تنظیمات مربوط به لودر یا لودینگ سایت را تغییر دهید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/loading-options/loading-options.php';

// -> START 404 page
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات صفحه 404 ',
		'id' => 'basic-404-page',
		'customizer_width' => '400px',
		'desc' => 'میتوانید از این طریق تنظیمات مربوط به صفحه 404 را اصلاح و تغییر دهید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/404-options/404-options.php';


// -> START typography
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات تایپوگرافی',
		'id' => 'basic-typography-page',
		'customizer_width' => '400px',
		'desc' => 'میتوانید از این طریق تنظیمات مربوط به تایپوگرافی سایتتان را تغییر دهید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/typography-options/typography-options.php';


// -> START designer wordpress
Redux::set_section(
	$opt_name,
	array(
		'title' => 'تنظیمات ورود و عضویت ویرا',
		'id' => 'basic-designer-page',
		'customizer_width' => '400px',
		'desc' => 'میتوانید از این طریق تنظیمات مربوط به شرکت های طراحی سایت و راه اندازی سایت های فروشگاهی را تغییر دهید',
	)
);

require_once Redux_Core::$dir . '../sample/sections/designer-options/designer-options.php';
