<?php

class slider_product_3_diak_theme_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'slider-product-pro-3-diak_thems';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>اسلایدر محصول شگفت انگیز</h2>';
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['slider-product'];
    }

    function get_product_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options [$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('تنظیمات و محتوای کلی اسایدر محصول', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'list_id_category_product_vera',
            [
                'label' => esc_html__('انتخاب دسته بندی محصولات', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'description' => 'در این قسمت شما باید حداقل یک دسته بندی از محصولات را انتخاب کنید تا محصولات مربوط به دسته بندی انتخاب شده نمایش گردد مثال (اگر اسلایدر مربوط به دسته بندی روز مادر باشد محصولاتی که تخفیف و قیمت مربوط به روز مادر را دارد را از لیست انتخاب کنید)',
                'multiple' => true,
                'options' => $this->get_product_cat(),
                'default' => ['title', 'description'],
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme-lkdfjsklfkdlnf321_vera',
            [
                'label' => esc_html__('نام اسلایدر محصول کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'return_value' => 'yes',
                'default' => 'محصولات دیجیتال',
                'description' => 'میتوانید از طریق این قسمت نام اسلایدر شگفت انگیز خود را تغییر دهید توجه کنید این قسمت اجباری نیست و میتوانید خالی بگذارید',
            ]
        );
        $this->add_control(
            'image-slider-sale_price_vera_red_vera',
            [
                'label' => esc_html__( 'انتخاب یا آپلود تصویر', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'description' => 'میتوانید از طریق این قسمت تصویر اسلایدر شگفت انگیز خود را تغییر دهید توجه کنید این قسمت اجباری نیست و میتوانید خالی بگذارید',
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme-lkdfjsklfkdlnf321-1_vera',
            [
                'label' => esc_html__('لینک هدایت مشاهده همه محصولات', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'return_value' => 'yes',
                'default' => 'https://site.com/',
                'description' => 'میتوانید از طریق این لینک هدایت مشاهده همه محصولات خود را تغییر دهید توجه کنید این قسمت اجباری نیست در صورتی که خالی باشد متن نمایش نخواهد یافت',
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme_vera',
            [
                'label' => esc_html__('وضعیت نمایش تایمر تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت فعال و یا غیر فعالسازی تایمر تخفیف را عوض کنید',
            ]
        );
        $this->add_control(
            'show-add-to-cart-product-sliders-theme_vera',
            [
                'label' => esc_html__('وضعیت نمایش اضافه کردن به سبد خرید آجاکس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اضافه کردن به سبد خرید آجاکس | زنده را عوض کنید',
            ]
        );
        $this->add_control(
            'show-add-to-wishlist-product-sliders-theme_verass',
            [
                'label' => esc_html__('وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس | زنده را تغییر کنید',
            ]
        );
        $this->add_control(
            'show-add-to-wishlist-product-sliders-frist-theme_verass',
            [
                'label' => esc_html__('وضعیت نمایش اولین آیتم متن و تصویر اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اولین آیتم متن و تصویر اسلایدر را تغییر کنید',
            ]
        );
        $this->add_control(
            'show-add-to-wishlist-product-sliders-last-theme_verass',
            [
                'label' => esc_html__('وضعیت نمایش آخرین آیتم متن و آیکون اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اولین آیتم متن و تصویر اسلایدر مشاهده همه موارد را تغییر کنید',
            ]
        );
        $this->add_control(
            'number-per-page-slider-pro-one_vera',
            [
                'label' => esc_html__('تعداد حداکثر محصولات نمایش داده شده', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 10,
                'description' => 'میتوانید از طریق این قسسمت مشخص کنید حد اکثر محصولاتی که از ووکامرس دریافت میکند چند عدد باشد',

            ]
        );
        $this->add_control(
            'number-per-page-slider-pro-one_reyaze_vera',
            [
                'label' => esc_html__('درصد موجودی بر حسب تعداد؟', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 10,
                'max' => 500,
                'step' => 10,
                'default' => 100,
                'description' => 'میتوانید از طریق این قسمت درصد موجودی بر حسب تعداد خود رو مشخص کنید توجه کنید که میتوانید درصد موجودی که از طریق الگوریتم ریاضی حساب و موجودی محصول را بر حسب عدد انتخابی شما حساب کرده و نمایش میدهد',

            ]
        );
        $this->add_control(
            'enable_sale-price-product_vera',
            [
                'label' => esc_html__('محصولات دارای تخفیف یا همه', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '_sale_price' => esc_html__('فقط محصولات تخفیف خورده', 'textdomain'),
                    '' => esc_html__('همه', 'textdomain'),
                ],
                'description' => 'میتوانید با انتخاب دو گذینه بالا مشخص کنید محصولاتی که از دسته بندی ها میگیرد به صورت تخفیفی باشد یا عادی که همه را در بر بگیرد',

            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل های اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one1_vera',
            [
                'label' => esc_html__('رنگ پس زمینه کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه کلی به صورت پیشفرض قرمز است را تغییر و شخصی سازی نمایید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-oneas1_vera',
            [
                'label' => esc_html__('رنگ پس زمینه هر آیتم', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه هر آیتم به صورت پیشفرض سفید است را تغییر و شخصی سازی نمایید',
                'default' => '#FFFFFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-name-products-slider_vera',
            [
                'label' => esc_html__(' رنگ قیمت تک', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از طریق این قسمت  رنگ قیمت تک را تغییر و شخصی سازی کنید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-del1-bdi-price_vera',
            [
                'label' => esc_html__(' رنگ قیمت تخفیف خورده % ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ قیمت تخفیف خورده %  را شخصی سازی و تنظیم کنید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-del1_vera',
            [
                'label' => esc_html__(' رنگ پس زمینه درصد تخفیف ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ پس زمینه درصد تخفیف را تنظیم کنید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1_vera',
            [
                'label' => esc_html__(' رنگ عدد درصد تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ عدد درصد تخفیف را تنظیم کنید ',
                'default' => '#FFFFFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1-115212_vera',
            [
                'label' => esc_html__('رنگ درصد باقی مانده', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید از طریق این قسمت رنگ درصد باقی مانده را تنظیم و سفارش سازی کنید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-prodffdfuct-one-ins1-115212_vera',
            [
                'label' => esc_html__('رنگ تایمر تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید از طریق این قسمت رنگ رنگ تایمر تخفیف را تنظیم و سفارش سازی کنید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-prodffdfuct-one-ins1-ddssd115212_vera',
            [
                'label' => esc_html__('رنگ متن بزگ عنوان اسلایدر شگفت انگیز', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید از طریق این قسمت رنگ متن بزگ عنوان اسلایدر شگفت انگیز را تنظیم و سفارش سازی کنید',
                'default' => '#FFFFFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-prodffdfuct-one-ins1-ddssd1fdf15212_vera',
            [
                'label' => esc_html__('رنگ پس زمینه آخرین آیتم اسلاایدر مشاهده همه موارد', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید از طریق این قسمت رنگ آخرین آیتم اسلاایدر مشاهده همه موارد را تنظیم و سفارش سازی کنید',
                'default' => '#FFFFFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-prodffdfuct-one-ins1-ddssd115flkld212_vera',
            [
                'label' => esc_html__('رنگ آیکون آخرین آیتم اسلایدر مشاهده همه موارد', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید از طریق این قسمت رنگ آیکون آخرین آیتم اسلایدر مشاهده همه موارد را تنظیم و سفارش سازی کنید',
                'default' => '#007AFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-prodffdfuct-one-ins1-ddssd1115flkld212_vera',
            [
                'label' => esc_html__('رنگ متن آخرین آیتم اسلایدر مشاهده همه موارد', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید از طریق این قسمت رنگ متن آخرین آیتم اسلایدر مشاهده همه موارد را تنظیم و سفارش سازی کنید',
                'default' => '#080707',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'style_sections',
            [
                'label' => esc_html__('تنظیمات اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'show_autoplay-controle-slider-pro1_vera',
            [
                'label' => esc_html__('حرکت خودکار اسلایدر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'label_off',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدر خودکار حرکت کنید یا نه',
            ]
        );
        $this->add_control(
            'fast-slider-pro-autoplay-Timeout1_vera',
            [
                'label' => esc_html__('سرعت عوض شدن اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2000,
                'max' => 100000,
                'step' => 1000,
                'default' => 5000,
                'description' => 'میتوانید از این قسمت مشخص کنید اسلایدر های در چند ثانبه یک بار تعویض شوند هر 1000 عدد نشانگر 1 ثانیه میباشد بهتر اسست عدد یین 5000(5 ثانیه) تا 20000(20 ثانیه) باشد',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>

        <style>


            .sale-prise-product-slider {
                float: right;
                width: 100%;
                padding: 5px 0;
                border-radius: 15px;
                background-color: #F0003C;
            }


            .sale-prise-product-slider .swiper-slids-text-1-item-slider {
                background: none !important;
                height: auto;
                display: grid;
                align-items: start;
                justify-content: center;
            }

            .sale-prise-product-slider .swiper-slids-text-1-item-slider img {
                max-width: 56%;
                text-align: center;
                margin: auto;
                height: auto;
            }

            .sale-prise-product-slider .swiper-slids-text-1-item-slider h2 {
                font-size: 50px;
                line-height: 55px;
                font-family: 'digikala';
                width: min-content;
                text-align: center;
                color: <?php echo $settings['color-bachground-slider-prodffdfuct-one-ins1-ddssd115212_vera'] ?>;
                margin: auto;
            }

            .sale-prise-product-slider .swiper {
                width: 97%;
                padding: 1.5% 0;
            }

            .sale-prise-product-slider .swiper-slide {
                text-align: center;
                font-size: 18px;
                background: #FFFFFF;
                overflow: hidden;
                height: 100%;
                border-radius: 15px;
                padding: 10px;
            }
            .sale-prise-product-slider .slider_custom_last_child {
                background: <?php echo $settings['color-bachground-slider-prodffdfuct-one-ins1-ddssd1fdf15212_vera'] ?> !important;
            }
            .sale-prise-product-slider .slider_custom_last_child a {
                color: <?php echo $settings['color-bachground-slider-prodffdfuct-one-ins1-ddssd1115flkld212_vera'] ?> !important;
            }

            .sale-prise-product-slider .slider_custom_last_child i {
                color: <?php echo $settings['color-bachground-slider-prodffdfuct-one-ins1-ddssd115flkld212_vera'] ?> !important;
            }

            <?php
                      if (!$settings['show-add-to-wishlist-product-sliders-frist-theme_verass']) {
                      ?>
            .sale-prise-product-slider .swiper-slide {
                border-radius: 10px !important;
            }
            <?php
}
 ?>

            .sale-prise-product-slider .swiper-slide figure {
                position: relative;
                height: 200px;
                display: flex;
                margin: 0 5px 2.5% !important;
                width: 95%;
                align-items: center;
                justify-content: center;
            }

            .sale-prise-product-slider .swiper-slide figure .stock {
                position: absolute;
                right: 5px;
                top: 5px;
                background: #494846;
                z-index: 1;
                color: #ffffff;
                font-size: 10px;
                padding: 0 10px;
                line-height: 2;
                border-radius: 20px;
                box-shadow: 0 0 0 2px #04030338;
            }


            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider {
                z-index: 2;
                display: grid;
                position: absolute;
                right: 10px;
                bottom:10px;
                transform: translatex(150%);
                transition: all .3s ease-in-out;
            }

            .sale-prise-product-slider .swiper-slide:hover .product-digi-slider-image .add_cart_ajax-product_sale_slider {
                transform: translatex(0);
            }
            @media screen and (max-width: 1000px) {
                .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider {
                    transform: translatex(0) !important;
                }
            }


            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider a {
                z-index: 2;
                background: #fff;
                color: var(--main-content);
                box-shadow: 0 0 0 .5px var(--main-color);
                width: 30px;
                height: 30px;
                margin-bottom: 5px;
                border-radius: 50%;
                display: flex;
                padding: 0;
                font-size: 15px;
                justify-content: center;
                align-items: center;
            }
            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider a span {
                width: 100%;
                height: 100%;
                justify-content: center;
            }
            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider a span i {
                margin: 0 !important;
                font-size: 16px;
            }


            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider a {
                text-decoration: none;
                color:var(--main-color);
            }

            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider a.loading i:before  {
                content:"\f3f4";
                font-family: "Font Awesome 5 Pro";
                animation-name: animate-lider-block !important;
                animation-duration: 1s;
                display: block;
                animation-iteration-count: infinite;
            }
            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider a.added i:before  {
                content:"\f00c";
                font-family: "Font Awesome 5 Pro";
            }
            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .add_cart_ajax-product_sale_slider a.added_to_cart  {
                display: none !important;
            }
            .sale-prise-product-slider .swiper-slide  .color-for-product-sliders .woocommerce-loop-product__title {
                font-size: 14px !important;
                font-weight: 500;
                padding: 0 0 5px !important;
                line-height: 25px;
                display: flex;
                position: unset;
                font-family: iranyekanX;
                height: 50px;
                text-align: right;
                overflow: hidden;
                width: 100%;
                text-decoration: none;
                color: #222222;
                float: right;
                display: -webkit-box;
                -webkit-box-orient: vertical;
                -webkit-line-clamp: 2;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }
            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .iconic-available-attributes {
                position: absolute;
                left: 10px;
                top: 10px;
                display: grid;
            }

            .sale-prise-product-slider .swiper-slide  .iconic-available-attributes .item-color-shop-loop-tootal {
                width: 15px;
                height: 15px;
                border-radius: 50%;
                margin-bottom: 5px;
                border: .5px solid #8d8d8d;
                position: relative;
                z-index: 2;
                text-align: center;
            }

            .sale-prise-product-slider .swiper-slide  .iconic-available-attributes .item-color-shop-loop-tootal i {
                margin: 0 !important;
                font-size: 10px !important;
                text-align: center !important;
                width: 10px !important;
                height: 10px;
                background: #fff;
                color: black !important;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 3px 0 2.5px;
                border-radius: 50%;
                line-height: 0;
            }

            .sale-prise-product-slider .swiper-slide  .iconic-available-attributes .item-color-shop-loop-tootal span {
                display: none;
            }

            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .image-1-set-product-digi {
                opacity: 1;
                visibility: visible;
                transition: all .8s ease-in-out;
            }

            .sale-prise-product-slider .swiper-slide .product-digi-slider-image .image-2-set-product-digi {
                opacity: 0;
                visibility: hidden;
                position: absolute;
                display: flex;
                top: 0;
                right: 0;
                width: auto;
                height: auto;
                max-width: 100%;
                left: 0;
                text-align: center;
                max-height: 100%;
                bottom: 0;
                transition: all .8s ease-in-out;
                justify-content: center;
                align-items: center;
                margin: auto;
            }

            .sale-prise-product-slider .swiper-slide:hover .product-digi-slider-image .image-2-set-product-digi {
                opacity: 1;
                visibility: visible;
                transition: all .3s ease-in-out;
            }

            .sale-prise-product-slider .swiper-slide:hover .product-digi-slider-image .image-1-set-product-digi {
                opacity: 0;
                visibility: hidden;
                transition: all .3s ease-in-out;
            }

            .sale-prise-product-slider .swiper-slide .product-digi-slider-image {
                width: 100%;
                float: right;
                position: relative;
                overflow: hidden;
            }

            .sale-prise-product-slider .swiper-slide .product-digi-slider-image img {
                width: auto;
                max-width: 100%;
                height: auto;
                max-height: 100%;
                object-fit: cover;
            }


            .sale-prise-product-slider .swiper-slide .price-product-digi-slider {
                float: right;
                width: 95%;
                padding: 5px 2.5%;
                height: 50px;
                text-align: right;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                display: flex;
                align-items: center;
                justify-content: space-between;
            }

            .sale-prise-product-slider .swiper-slide .price-product-digi-slider span.darsad-takhfif-product-digi {
                background-color: <?php echo $settings['color-bachground-slider-product-one-del1_vera']; ?>;
                color: <?php echo $settings['color-bachground-slider-product-one-ins1_vera']; ?>;
                padding: 0 10px;
                border-radius: 50px;
                font-size: 15px;
                line-height: 22px;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .sale-prise-product-slider .swiper-slide .price-product-digi-slider span.darsad-takhfif-product-digi p span {
                font-size: 15px !important;
            }

            .sale-prise-product-slider .swiper-slide .price-product-digi-slider div > .woocommerce-Price-amount > bdi {
                width: fit-content;
                display: block;
                text-decoration: none;
                color: <?php echo $settings['color-bachground-slider-name-products-slider_vera']; ?>;
                padding-top: 3px;
                font-size: 14px !important;
                font-weight: 600;
            }
            .sale-prise-product-slider .swiper-slide .price-product-digi-slider .price-vera_start_p {
                width: 100%;
                float: right;
                color: #6b6969;
                font-size: 13px
            }
            .sale-prise-product-slider .swiper-slide .price-product-digi-slider del {
                width: fit-content;
                float: right;
                color: #6b6969;
                font-size: 13px;
                text-decoration: none;
                position: relative;
            }
            .sale-prise-product-slider .swiper-slide .price-product-digi-slider del:before {
                content: "";
                position: absolute;
                height: 1px;
                width: 100%;
                top: 50%;
                transform: rotate(-8deg);
                background: #222222a6;
            }

            .sale-prise-product-slider .swiper-slide .price-product-digi-slider ins {
                width: fit-content;
                display: block;
                text-decoration: none;
                color: <?php echo $settings['color-bachground-slider-product-one-del1-bdi-price_vera']; ?>;
                padding-top: 3px;
                font-size: 14px !important;
                font-weight: 600;
            }
            .sale-prise-product-slider .swiper-slide .price-product-digi-slider .woocommerce-Price-currencySymbol {
                padding-right:3px;
            }
            .sale-prise-product-slider .swiper-slide .price-product-digi-slider .woocommerce-Price-currencySymbol:after {
                content: var(--main-content);
            }

            .sale-prise-product-slider .swiper-slide .darsad-mojodi-product-digi {
                content: "";
                width: 96%;
                height: 5px;
                float: right;
                display: block;
                background-color: #dddddd;
                margin: 5px 2% 5px;
                border-radius: 5px;
                overflow: hidden;
                position: relative;
            }

            .sale-prise-product-slider .swiper-slide .darsad-mojodi-product-digi span {
                content: "";
                height: 5px;
                float: right;
                display: block;
                background-color:<?php echo $settings['color-bachground-slider-product-one-ins1-115212_vera'] ?>;;
                border-radius: 5px;
                position: absolute;
                z-index: 1;
                right: 0;
                top: 0;
            }

            .div-timer-darsad-sale-products {
                width: 96%;
                margin: 1%;
                float: right;
                display: flex;
                align-items: center;
                justify-content: space-between;
                align-content: center;
            }

            .sale-prise-product-slider .swiper-slide p.mojodi-product-digi-text {
                float: right;
                font-size: 12px;
                width: 50%;
                padding: 2px 2%;
                text-align: right;
                font-family: digikala;
                color: <?php echo $settings['color-bachground-slider-product-one-ins1-115212_vera'] ?>;
            }

            .sale-prise-product-slider .swiper-slide p.mojodi-product-digi-text span {
                font-family: IRANYekanX;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                font-size: 14px;
                padding: 0 5px;
                color: <?php echo $settings['color-bachground-slider-product-one-ins1-115212_vera'] ?>;
            }

            .sale-prise-product-slider .countdown-timer {
                float: left;
                -moz-font-feature-settings: "ss04" !important;
                -webkit-font-feature-settings: "ss04" !important;
                font-feature-settings: "ss04" !important;
                direction: ltr;
                text-align: center;
                width: 50%;
                padding: 1%;
            }

            .sale-prise-product-slider .timer-section {
                float: right;
                display: flex;
                justify-content: center;
                direction: ltr;
                text-align: center;
                font-size: 12px;
                border-radius: 10px;
                color: <?php echo $settings['color-bachground-slider-prodffdfuct-one-ins1-115212_vera']; ?>;
                font-family: digikala;
            }

            .sale-prise-product-slider .timer-message {
                display: none !important;
            }

            .sale-prise-product-slider .timer-value {
                font-weight: bold;
                font-size: 15px;
                padding: 0 3px;
                font-family: IRANYekanX;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }


            .sale-prise-product-slider .swiper-button-disabled {
                opacity: 0;
                visibility: hidden;
            }

            .sale-prise-product-slider .swiper-button-next {
                padding: 20px;
                background: #fff;
                box-shadow: rgba(17, 17, 26, 0.1) 0px 4px 16px, rgba(17, 17, 26, 0.1) 0px 8px 24px, rgba(17, 17, 26, 0.1) 0px 16px 56px;
                color: var(--main-color3);
                border-radius: 50%;
                font-size: 0 !important;
                width: 40px;
                height: 40px;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .sale-prise-product-slider .swiper-button-next:after {
                font-size: 20px;
            }

            .sale-prise-product-slider .swiper-button-prev:after {
                font-size: 20px;
            }

            .sale-prise-product-slider .swiper-button-prev {
                padding: 20px;
                background: #fff;
                box-shadow: rgba(17, 17, 26, 0.1) 0px 4px 16px, rgba(17, 17, 26, 0.1) 0px 8px 24px, rgba(17, 17, 26, 0.1) 0px 16px 56px;
                color: var(--main-color3);
                border-radius: 50%;
                font-size: 0 !important;
                width: 40px;
                height: 40px;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            /*end slider shegeft anges digikala*/
        </style>

        <script>
            $(function () {
                var swiper = new Swiper(".mySwiper-product-digi", {
                    <?php if ($settings['show_autoplay-controle-slider-pro1_vera']) { ?>
                    autoplay: {
                        delay: <?php echo $settings['fast-slider-pro-autoplay-Timeout1_vera'] ?>,
                        disableOnInteraction: true,
                    },
                    <?php
                    }
                    ?>
                    freeMode: true,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    breakpoints: {
                        "@0.00": {
                            slidesPerView: 2,
                            spaceBetween: 7,
                        },
                        "@0.75": {
                            slidesPerView: 3,
                            spaceBetween: 7,
                        },
                        "@1.00": {
                            slidesPerView: 4,
                            spaceBetween: 7,
                        },
                        "@1.50": {
                            slidesPerView: 6,
                            spaceBetween: 7,
                        },
                    },
                });
            })
        </script>

        <div class="container container_digi">
            <div class="sale-prise-product-slider">
                <div class="swiper mySwiper-product-digi">
                    <div class="swiper-wrapper">
                        <?php
                        if ($settings['show-add-to-wishlist-product-sliders-frist-theme_verass']) {
                        ?>
                        <div class="swiper-slide swiper-slids-text-1-item-slider">
                            <h2><?php echo $settings['show-timer-product-sliders-theme-lkdfjsklfkdlnf321_vera']; ?></h2>
                            <?php
                            if ($settings['image-slider-sale_price_vera_red_vera']['url']) {
                            echo $settings['image-slider-sale_price_vera_red_vera']['url'];
                            }
                            else {
                                ?>
                                <img src="<?php echo get_template_directory_uri()."/img/imaghe-test.png"; ?>">
                            <?php
                            }
                            ?>
                            <?php
                            if ($settings['show-timer-product-sliders-theme-lkdfjsklfkdlnf321-1_vera']) {
                            ?>
                            <a style="text-align: center;text-decoration: none;color: #fff;width: 100%;float: right;font-family: digikala" href="<?php echo $settings['show-timer-product-sliders-theme-lkdfjsklfkdlnf321-1_vera']; ?>">دیدن همه محصولات <i style="padding-right:5px" class="fa-light fa-circle-left fa-bounce"></i></a>
                            <?php
                            }
                            ?>
                        </div>
                        <?php
                        }
                        ?>
                        <?php
                        $pro = new WP_Query(array(
                            'post_type' => 'product',
                            'posts_per_page' => $settings['number-per-page-slider-pro-one_vera'],
                            'meta_key' => $settings['enable_sale-price-product_vera'],
                            'tax_query' => [[
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $settings['list_id_category_product_vera'],
                            ]],
                        ));
                        if ($pro->have_posts()) {
                            while ($pro->have_posts()) : $pro->the_post(); ?>
                                <div class="swiper-slide">
                                    <div class="product-digi-slider-image">
                                        <div class="add_cart_ajax-product_sale_slider">
                                            <?php
                                            global $product;
                                            $product_id = $product->get_id();
                                            if ($settings['show-add-to-wishlist-product-sliders-theme_verass']) : ?>
                                            <a class="like-containers">
                                                <span class="like-buttons" data-product-id="<?php echo $product_id; ?>">
                                                    <i class="fa-light fa-heart"></i>
                                                </span>
                                            </a>
                                            <?php
                                            endif;
                                            ?>

                                            <?php
                                            if ($settings['show-add-to-cart-product-sliders-theme_vera']) {
                                            if ($product->is_type('simple')) {
                                                if ($product->is_in_stock() || $product->get_stock_quantity() > 0) {
                                                    ?>
                                                    <a href="<?php echo $product->add_to_cart_url() ?>"
                                                       value="<?php echo esc_attr($product->get_id()); ?>"
                                                       class="ajax_add_to_cart add_to_cart_button"
                                                       data-product_id="<?php echo get_the_ID(); ?>"
                                                       data-product_sku="<?php //echo esc_attr($sku) 
                                                       echo esc_attr(isset($sku) ? $sku : '');
                                                       ?>"
                                                       aria-label="Add “<?php the_title_attribute() ?>” to your cart">
                                                        <i class="fa-light fa-plus-large"></i>                                    </a>
                                                    <?php
                                                }
                                                else {
                                                    ?>
                                                    <a href="<?php echo get_post_permalink(); ?>"  class="namojod-product">
                                                        <i class="fa-light fa-cart-shopping"></i>
                                                    </a>
                                                    <?php
                                                }
                                            }
                                            elseif ($product->is_type('variable')) {
                                                if ($product->is_in_stock() && $product->get_stock_quantity() > 0) {
                                                    ?>
                                                    <a href="<?php echo get_post_permalink(); ?>"
                                                       class="namojod-productss">
                                                        <i class="fa-light fa-cart-shopping"></i>
                                                    </a>
                                                    <?php
                                                }
                                                else {
                                                    ?>
                                                    <a href="<?php echo get_post_permalink(); ?>"
                                                       class="namojod-products">
                                                        <i class="fa-light fa-cart-shopping"></i>
                                                    </a>
                                                    <?php
                                                }
                                            }
                                            }
                                            ?>

                                        </div>

                                        <a href="<?php echo get_permalink(); ?>">
                                            <figure>
                                                <span class="loading_images loading_imagesss"></span>

                                                <?php
                                                global $product;
                                                if (!$product->is_in_stock()) {
                                                    echo '<p class="stock">ناموجود</p>';
                                                } ?>
                                                <?php
                                                global $product;
                                                if (!empty($product->get_gallery_image_ids())) {
                                                    $attachment_ids = $product->get_gallery_image_ids();
                                                    $product_plan_two_img = wp_get_attachment_url($attachment_ids[0], 'large');
                                                    ?>
                                                    <img class="image-1-set-product-digi loading_image" style="display: none" data-src="<?php echo get_the_post_thumbnail_url() ?>">
                                                    <img class="image-2-set-product-digi"  src="<?php echo $product_plan_two_img; ?>" loading="lazy">
                                                    <?php
                                                } else {
                                                    ?>
                                                    <img  class="loading_image" style="display: none" data-src="<?php echo get_the_post_thumbnail_url() ?>">
                                                    <?php
                                                }
                                                ?>

                                            </figure>
                                        </a>

                                    </div>
                                    <a href="<?php echo get_permalink();  ?>">
                                        <div class="color-for-product-sliders">
                                            <?php do_action('woocommerce_shop_loop_item_title'); ?>
                                        </div>
                                        <div class="price-product-digi-slider">
                                            <div>
                                                <?php
                                                global $product;
                                                echo $product->get_price_html();
                                                ?>
                                            </div>
                                            <span class="darsad-takhfif-product-digi"> <?php echo simple_product_saving_percentage(); ?></span>
                                        </div>

                                        <?php

                                        if ($product->is_type('variable')) {
                                            $variations = $product->get_available_variations();
                                            if (!empty($variations)) {
                                                $stock = 0;
                                                foreach ($variations as $variation) {
                                                    $variation_obj = wc_get_product($variation['variation_id']);
                                                    $stock += $variation_obj->get_stock_quantity();
                                                }
                                                $stock = min($stock, 100);
                                                $percentage = ($stock / 100) * 100;
                                                $percentage = $percentage - 100;
                                                $percentage = str_replace("-", "", $percentage);
                                                echo '<div class="darsad-mojodi-product-digi">';
                                                echo '<span style="width: ' . $percentage . '%"></span>';
                                                echo '</div>';
                                            }
                                            else {
                                                echo '<div style="background: none;" class="darsad-mojodi-product-digi">';
                                                echo '<span></span>';
                                                echo '</div>';
                                            }
                                        } else {
                                            $stock = $product->get_stock_quantity();
                                            if(!empty($stock)) {
                                                $stock = min($stock, $settings['number-per-page-slider-pro-one_reyaze_vera']);
                                                $percentage = ($stock / $settings['number-per-page-slider-pro-one_reyaze_vera']) * $settings['number-per-page-slider-pro-one_reyaze_vera'];
                                                $percentage = $percentage - $settings['number-per-page-slider-pro-one_reyaze_vera'];
                                                $percentage = str_replace("-", "", $percentage);
                                                echo '<div class="darsad-mojodi-product-digi">';
                                                echo '<span style="width: ' . $percentage . '%"></span>';
                                                echo '</div>';
                                            }
                                            else {
                                                echo '<div style="background: none;" class="darsad-mojodi-product-digi">';
                                                echo '<span></span>';
                                                echo '</div>';
                                            }
                                        }

                                        ?>

                                        <div class="div-timer-darsad-sale-products">
                                            <?php
                                            if ($product->is_type('variable')) {
                                                $variations = $product->get_available_variations();
                                                if (!empty($variations)) {
                                                    ?>
                                                    <p class="mojodi-product-digi-text"><span><?php echo $percentage . "%"; ?></span>فروش رفته</p>
                                                    <?php
                                                }
                                                else {
                                                    ?>
                                                    <p class="mojodi-product-digi-text"><span></span></p>
                                                    <?php
                                                }
                                            } else {
                                                $stock = $product->get_stock_quantity();
                                                if(!empty($stock)) {
                                                    ?>
                                                    <p class="mojodi-product-digi-text"><span><?php echo $percentage . "%"; ?></span>فروش رفته</p>
                                                    <?php
                                                }
                                                else {
                                                    ?>
                                                    <p class="mojodi-product-digi-text"><span></span></p>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <?php
                                            if($settings['show-timer-product-sliders-theme_vera'] == true ) {
                                            $off_on_timer = get_post_meta(get_the_id(), 'metaboxe_product-offers', true);
                                            if ($off_on_timer == "on") {
                                                $year = get_post_meta(get_the_id(), 'month-years-select-zero', true);
                                                $month = get_post_meta(get_the_id(), 'month-years-select-one', true);
                                                $day = get_post_meta(get_the_id(), 'month-years-select-two', true);
                                                $hour = get_post_meta(get_the_id(), 'month-years-select-there', true);
                                                if ($year == date("Y") && $month == date("m") && $day == date("d")) {
                                                    ?>

                                                    <div class="countdown-timer" data-target-year="<?php echo $year ?>" data-target-month="<?php echo $month ?>"
                                                         data-target-day="<?php echo $day ?>"
                                                         data-target-hour="<?php echo $hour ?>" data-target-minute="00" data-target-second="00">
                                                        <div style="display: flex;align-items: center" class="massages-heddin">
                                                            <div class="timer-section hours-section"><span
                                                                    class="timer-value hours-value"></span> :
                                                            </div>
                                                            <div class="timer-section minutes-section"><span
                                                                    class="timer-value minutes-value"></span> :
                                                            </div>
                                                            <div class="timer-section seconds-section"><span
                                                                    class="timer-value seconds-value"></span>
                                                            </div>
                                                            <div class="timer-message"><span class="timer-message-text"></span></div>

                                                        </div>
                                                    </div>
                                                    <?php
                                                }
                                            }
                                            }
                                            ?>
                                        </div>
                                    </a>
                                </div>
                            <?php
                            endwhile;
                        }
                        ?>

                        <?php
                        if ($settings['show-add-to-wishlist-product-sliders-last-theme_verass']) {
                        ?>
                        <div class="swiper-slide slider_custom_last_child"
                             style="height: auto !important;display: flex !important;align-items: center !important;color: #fff;">
                            <a style="text-align: center;text-decoration: none;color: #080707;width: 100%;height: 100%;float: right;display: flex;font-family: digikala;justify-content: center;align-items: center;align-content: center;flex-wrap: wrap;"
                               href="#"><i
                                    style="float: right;width: 100%;font-size:50px;padding-bottom:20px;color:var(--main-color2);"
                                    class="fa-thin fa-circle-left"></i>دیدن همه محصولات </a>
                        </div>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </div>



        <?php
    }


    protected function content_template()
    {
    }

}