<?php

class slider_2_widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'slider-product-pro-virax-2';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>اسلایدر محصول شگفت انگیز طرح (2)</h2>';
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['slider-product'];
    }

    function get_product_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options [$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('تنظیمات و محتوای کلی اسایدر محصول', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'list_id_category_product',
            [
                'label' => esc_html__('انتخاب دسته بندی محصولات', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'description' => 'در این قسمت شما باید حداقل یک دسته بندی از محصولات را انتخاب کنید تا محصولات مربوط به دسته بندی انتخاب شده نمایش گردد مثال (اگر اسلایدر مربوط به دسته بندی روز مادر باشد محصولاتی که تخفیف و قیمت مربوط به روز مادر را دارد را از لیست انتخاب کنید)',
                'multiple' => true,
                'options' => $this->get_product_cat(),
                'default' => ['title', 'description'],
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme-lkdfjsklfkdlnf321',
            [
                'label' => esc_html__('نام اسلایدر محصول کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'return_value' => 'yes',
                'default' => 'محصولات دیجیتال',
                'description' => 'میتوانید از طریق این قسمت نام اسلایدر خود را تغییر دهید',
            ]
        );
        $this->add_control(
            'image-slider-sale_price_vera_red_veradasdsd',
            [
                'label' => esc_html__( 'انتخاب یا آپلود تصویر', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'description' => 'میتوانید از طریق این قسمت تصویر اسلایدر شگفت انگیز خود را تغییر دهید توجه کنید این قسمت اجباری نیست و میتوانید خالی بگذارید',
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme-lkdfjskfdlfhgjkdlnf321',
            [
                'label' => esc_html__('عنوان دکمه هدایت در بخش سمت راست', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'return_value' => 'yes',
                'default' => 'مشاهده همه محصولات',
                'description' => 'میتوانید از طریق این قسمت عنوان دکمه هدایت در بخش سمت راست را تغییر دهید',
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme-lkdfdjskfdlfkdaslnf321',
            [
                'label' => esc_html__(' آدرس لینک دکمه هدایت در بخش سمت راست', 'textdomain'),
                'type' => \Elementor\Controls_Manager::URL,
                'return_value' => 'yes',
                'description' => 'میتوانید از طریق این قسمت  آدرس لینک دکمه هدایت در بخش سمت راست را تغییر دهید',
            ]
        );

        $this->add_control(
            'show-add-to-cart-product-sliders-theme',
            [
                'label' => esc_html__('وضعیت نمایش اضافه کردن به سبد خرید آجاکس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اضافه کردن به سبد خرید آجاکس | زنده را عوض کنید',
            ]
        );
        $this->add_control(
            'show-add-to-wishlist-product-sliders-theme',
            [
                'label' => esc_html__('وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس | زنده را عوض کنید',
            ]
        );
        $this->add_control(
            'number-per-page-slider-pro-one',
            [
                'label' => esc_html__('تعداد حداکثر محصولات نمایش داده شده', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 10,
                'description' => 'میتوانید از طریق این قسسمت مشخص کنید حد اکثر محصولاتی که از ووکامرس دریافت میکند چند عدد باشد',

            ]
        );
        $this->add_control(
            'enable-product-right-left-div-slider-product',
            [
                'label' => esc_html__('سمت بخش معرفی اسلایدر کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'right' => esc_html__('راست', 'textdomain'),
                    'left' => esc_html__('چپ', 'textdomain'),
                ],
                'description' => 'میتوانید با انتخاب دو گذینه بالا مشخص کنید سمت بخش معرفی اسلایدر کلی در کدام سو باشد (راست | چپ )',
                'default' => "right",
            ]
        );
        $this->add_control(
            'enable_sale-price-product',
            [
                'label' => esc_html__('محصولات دارای تخفیف یا همه', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '_sale_price' => esc_html__('فقط محصولات تخفیف خورده', 'textdomain'),
                    '' => esc_html__('همه', 'textdomain'),
                ],
                'description' => 'میتوانید با انتخاب دو گذینه بالا مشخص کنید محصولاتی که از دسته بندی ها میگیرد به صورت تخفیفی باشد یا عادی که همه را در بر بگیرد',

            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل های اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-on12131',
            [
                'label' => esc_html__(' رنگ پس زمینه بخش راست نشانک اسلایدر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه بخش راست نشانک اسلایدر که به صورت پیشفرض نارنجی کم رنگ است را تغییر و شخصی سازی نمایید',
                'default' => '#FF7D09FA',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-on1213kdflk',
            [
                'label' => esc_html__(' رنگ متن عنوان بخش راست نشانک اسلایدر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ متن عنوان بخش راست نشانک اسلایدر که به صورت پیشفرض نارنجی است را تغییر و شخصی سازی نمایید',
                'default' => '#FFFFFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one1',
            [
                'label' => esc_html__('  رنگ پس زمینه کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه کلی هر آیتم محصول که به صورت پیشفرض سفید است را تغییر و شخصی سازی نمایید',
                'default' => '#ffffff',
            ]
        );
        $this->add_control(
            'color-bachground-slider-name-products-slider',
            [
                'label' => esc_html__(' رنگ اصلی نام محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از طیرق این قسمت رنگ نام محصول را تغییر و شخصی سازی کنید',
                'default' => '#222222',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-del1-bdi-price',
            [
                'label' => esc_html__(' رنگ قیمت تک ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ قیمت نک که محصولی اگر دارای یک قیسمت منحصر به فرد باشد  را شخصی سازی و تنظیم کنید',
                'default' => '#ff9b44',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-del1',
            [
                'label' => esc_html__(' رنگ قیمت  منسوخ شده تخفیف خورده (del) ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ قیمت تخفیفی که منسوخ شده و به صورت خاکستری پیش فرض نشان میدهد را تنظیم کنید',
                'default' => '#6b6969',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1',
            [
                'label' => esc_html__(' رنگ قیمت تخفیف خورده (ins) ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ قیمت تخفیف خورده تمام شده را تنظیم کنید (نارنجی)',
                'default' => '#ff9b44',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-border-radios-box-21',
            [
                'label' => esc_html__('منحنی باکس سفید محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'description' => 'شما میتوانید از طریق این قسمت بردر ردیوز یا منحنی باکس آیتم اصلی محصول را تنظیم و سفارش سازی کنید',
                'min' => 5,
                'max' => 30,
                'step' => 1,
                'default' => 15,
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1-115212',
            [
                'label' => esc_html__(' رنگ پس زمینه بخش اضافه کردن به سبد خرید ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ پس زمینه بخش اضافه کردن به سبد خرید را شخصی سازی و تنظیم کنید',
                'default' => '#ff9a41fa',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1-115212-1',
            [
                'label' => esc_html__(' رنگ آیکون بخش اضافه کردن به سبد خرید ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ آیگون بخش اضافه کردن به سبد خرید را شخصی سازی و تنظیم کنید',
                'default' => '#ffffff',
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'style_sections',
            [
                'label' => esc_html__('تنظیمات اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'show_autoplay-controle-slider-pro1',
            [
                'label' => esc_html__('حرکت خودکار اسلایدر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدر خودکار حرکت کنید یا نه',
            ]
        );
        $this->add_control(
            'show_loop-controle-slider-pro1',
            [
                'label' => esc_html__('برگرداندن اسلایدر بعد از اتمام', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدربعد از اینکه کل تصاویر موجود را یک بار نشان داد دوباره به اول برگردد و دوباره مراتب را تکرار کنید',
            ]
        );
        $this->add_control(
            'fast-slider-pro-autoplay-Timeout1',
            [
                'label' => esc_html__('سرعت عوض شدن اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2000,
                'max' => 100000,
                'step' => 1000,
                'default' => 5000,
                'description' => 'میتوانید از این قسمت مشخص کنید اسلایدر های در چند ثانبه یک بار تعویض شوند هر 1000 عدد نشانگر 1 ثانیه میباشد بهتر اسست عدد یین 5000(5 ثانیه) تا 20000(20 ثانیه) باشد',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>

        <style>
            .mySwiper-product_pro_2 .image_text_right_slider_image {
                    order: -1;
                    height: 100%;
                    width: 30%;
                    background: <?php echo $settings['color-bachground-slider-product-one-on12131'];  ?>;
                    border-radius: 0 30px 30px 0;
                    text-align: center;
                    position: relative;
                }
            .mySwiper-product_pro_2 .image_text_right_slider_image:after {
                content: "";
                bottom: 0;
                position: absolute;
                left: -100%;
                background: <?php echo $settings['color-bachground-slider-product-one-on12131'];  ?>;
                border-radius: 30px 0 0 30px;
                width: 100%;
                height: 100%;
            }

            .mySwiper-product_pro_2 {
                width: 100%;
                float: right;
                display: flex;
                justify-content: space-around;
                align-items: center;
                height: 400px;
                padding: 20px 0 10px;
            }

                .mySwiper-product_pro_2 .mySwiper-product_pro_21 {
                    width:68%;
                }

            .mySwiper-product_pro_2 .image_text_right_slider_image h2 {
                width: 100%;
                float: right;
                text-align: center;
                padding: 35px 0 20px;
                font-size: 35px;
                font-family: digikala;
                color: <?php echo $settings['color-bachground-slider-product-one-on1213kdflk']; ?>;
            }
            .mySwiper-product_pro_2 .image_text_right_slider_image a {
                width: fit-content;
                text-align: center;
                font-weight: 400;
                display: flex;
                padding: 11px 10px;
                margin: auto;
                position: relative;
                color: unset;
                background: #fff;
                box-shadow: 0 0 0 5px #ffffff54;
                align-items: center;
                z-index: 1;
                margin-top: 15px;
                justify-content: center;
                border-radius: 10px;
            }
            .mySwiper-product_pro_2 .image_text_right_slider_image a i {
                font-weight: 400;
                order: 1;
                opacity: .3;
                padding-right: 10px;
                transition: all .3s ease-in-out;
            }
            .mySwiper-product_pro_2 .image_text_right_slider_image a:hover i {
                transform: scale(1.2);
            }
            .mySwiper-product_pro_2 .image_text_right_slider_image figure img {
                height: 200px;
                max-height: 200px;
                width: auto;
                border-radius:10px;
                position: relative;
                z-index: 1;
            }
            .mySwiper-product_pro_2 .image_text_right_slider_image figure {
                width: auto;
                text-align: center;
                margin: auto;
                height: 200px;
                display: inline-block;
               position:relative;
            }
            .mySwiper-product_pro_2 .image_text_right_slider_image figure:before {
                position: absolute;
                content: "";
                width: 100%;
                height: 100%;
                background: #fff;
                right: 0;
                top: 0;
                box-shadow: inset 0 0 0 10px #ff9b446e;
                border-radius: 50px;
                opacity: .3;
            }

                .mySwiper-product_pro_2 .swiper-wrapper {
                    width: 100%;
                    margin: 5px auto 10px;
                    display: flex;
                    justify-content: right;
                    align-items: start;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide {
                    text-align: center;
                    float: right;
                    overflow: hidden;
                    position: relative;
                    padding: 0 0 5px;
                    background: <?php echo $settings['color-bachground-slider-product-one-one1']; ?>;
                    margin-bottom: 0;
                    border-radius: <?php echo $settings['color-bachground-slider-product-one-border-radios-box-21']."px"; ?>;
                    border: 1px solid #ddd;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide:hover .like-containers {
                    transform: translateX(0);
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .like-containers:before {
                    content: "افزودن به علاقه مندی";
                    position: absolute;
                    right: 100%;
                    top: 3px;
                    background: #ffffff;
                    border-radius: 3px;
                    width: max-content;
                    font-size: 11px;
                    border: 1px solid #ddd;
                    padding: 0 5px;
                    opacity: 0;
                    visibility: hidden;
                    transition: all .3s ease-in-out;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .like-containers:hover:before {
                    opacity: 1;
                    visibility: visible;
                    right: 120%;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .like-containers {
                    position: absolute;
                    top: 10px;
                    transition: all .3s ease-in-out;
                    transform: translateX(150%);
                    width: 35px;
                    height: 35px;
                    right: 10px;
                    font-size: 13px !important;
                    background: #FFFFFF;
                    border-radius: 50%;
                    border: 1px solid #ddd;
                    z-index: 2;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .like-containers span {
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100%;
                    text-align: center;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .like-containers span i {
                    font-size: 17px;
                    padding: 0;
                    margin: 0;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .icon-shop-item-slider {
                    display: flex;
                    transition: all .3s ease-in-out;
                    z-index: 1;
                    float: left;
                    justify-content: left;
                    width: 49%;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .icon-shop-item-slider a {
                    position: relative;
                    background: #fff;
                    padding: 10px;
                    border: 1px solid #e9e9e9;
                    color: var(--main-color5);
                    margin: 0 3px;
                    border-radius: 14px;
                    font-size: 17px;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    text-decoration: none;
                    font-weight: 200;
                    transition: all .3s ease-in-out;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .icon-shop-item-slider a:hover {
                    box-shadow: inset 0 0 0 30px var(--main-color5);
                    color: #ffffff;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .icon-shop-item-slider a i {

                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .icon-shop-item-slider a span {
                    position: absolute;
                    left: 0;
                    bottom: 100%;
                    opacity: 0;
                    visibility: hidden;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .iconic-available-attributes {
                    position: absolute;
                    left: 10px;
                    top: 10px;
                    display: grid;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .iconic-available-attributes .item-color-shop-loop-tootal {
                    width: 10px;
                    height: 10px;
                    border-radius: 50%;
                    margin-bottom: 5px;
                    border: .5px solid #ddd;
                    position: relative;
                    z-index: 2;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .iconic-available-attributes .item-color-shop-loop-tootal:hover span {
                    opacity: 1;
                    visibility: visible;
                    top: -3px;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .iconic-available-attributes .item-color-shop-loop-tootal span {
                    position: absolute;
                    left: 170%;
                    top: 0;
                    background: #ffffff;
                    color: #303841;
                    padding: 4px 10px 5px;
                    line-height: 1;
                    font-size: 11px;
                    width: max-content;
                    border: 1px solid #ddd;
                    float: right;
                    z-index: 2;
                    border-radius: 3px;
                    transition: all .3s ease-in-out;
                    opacity: 0;
                    font-weight: 500;
                    visibility: hidden;
                }


                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide figure {
                    width: 98%;
                    max-width: 98%;
                    position: relative;
                    margin: 10px 1% !important;
                    float: right;
                    padding: 0;
                    overflow: unset !important;
                    height: 150px;
                    display: flex;
                    justify-content: center;
                    position: relative;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide figure .stock {
                    position: absolute;
                    right: 10px;
                    bottom: 10px;
                    background: #494846;
                    z-index: 1;
                    color: #ffffff;
                    font-size: 10px;
                    width: fit-content;
                    padding: 0 10px;
                    line-height: 2;
                    border-radius: 20px;
                    box-shadow: 0 0 0 3px #04030338;
                    margin-bottom: 6px;

                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide figure img {
                    max-width: 100% !important;
                    max-height: 100%;
                    height: fit-content !important;
                    border-radius: 0;
                    margin: auto;
                    width: auto !important;
                }


                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide:hover figure img.image-item-1-slider-product {
                    opacity: 0;
                    visibility: hidden;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide:hover figure img.image-item-2-slider-product {
                    opacity: 1;
                    visibility: visible;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide figure img.image-item-2-slider-product {
                    opacity: 0;
                    visibility: hidden;
                    top: auto;
                    right: auto;
                    width: 100%;
                    position: absolute;
                    transition: all .4s linear 0s;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide figure img {
                    max-width: 100%;
                    height: auto;
                    transition: all .3s ease-in-out;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .name-product {
                    padding: 0 10px 5px;
                    text-align: right;
                    width: auto;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .name-product .cat_one_parent_slider_producty a {
                    font-size: 12px;
                    text-decoration: none;
                    color: #222;
                    opacity: .6;
                    transition: all .3s ease-in-out;
                    font-weight: 400;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .name-product .cat_one_parent_slider_producty a:hover {
                    opacity: 1;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .name-product a {

                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .name-product h2 {
                    font-size: 14px !important;
                    font-weight: 500;
                    padding: 0 0 5px !important;
                    line-height: 25px;
                    display: flex;
                    position: unset;
                    font-family: iranyekanX;
                    height: 50px;
                    text-align: right;
                    overflow: hidden;
                    width: 100%;
                    text-decoration: none;
                    color: <?php echo $settings['color-bachground-slider-name-products-slider']; ?>;
                    float: right;
                    display: -webkit-box;
                    -webkit-box-orient: vertical;
                    -webkit-line-clamp: 2;
                    -moz-font-feature-settings: "ss02" !important;
                    -webkit-font-feature-settings: "ss02" !important;
                    font-feature-settings: "ss02" !important;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    width: 100%;
                    margin: auto;
                    border-radius: 15px;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product {
                    width: 100%;
                    float: right;
                    text-align: right;
                    padding: 5px 10px;
                }

            .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide figure #saving_total_price {
                float: right;
                margin-left: 10px;
                background: #ff9b44;
                color: #fff;
                position: absolute;
                font-family: 'IRANYekanX';
                left: 0;
                bottom: 5px;
                font-size: 10px;
                padding: 4px 8px 2px;
                line-height: 1;
                border-radius: 5px;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                box-shadow: 0 0 0 3px #ff9b447d;
                z-index: 2;
            }
                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product > .amount > bdi {
                    font-size: 17px;
                    font-weight: 600;
                    color: <?php echo $settings['color-bachground-slider-product-one-del1-bdi-price']; ?>;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product {
                    -moz-font-feature-settings: "ss02" !important;
                    -webkit-font-feature-settings: "ss02" !important;
                    font-feature-settings: "ss02" !important;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product del {
                    -moz-font-feature-settings: "ss02" !important;
                    -webkit-font-feature-settings: "ss02" !important;
                    font-feature-settings: "ss02" !important;
                    font-size: 13px;
                    text-decoration: none;
                    color: <?php echo $settings['color-bachground-slider-product-one-del1'] ?>;
                    position: relative;
                    width: fit-content;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product del:before {
                    content: "";
                    position: absolute;
                    height: 1px;
                    width: 100%;
                    top: 50%;
                    transform: rotate(-8deg);
                    background: #222222a6;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product .woocommerce-Price-currencySymbol {
                    padding-right: 3px;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product .woocommerce-Price-currencySymbol:after {
                    content: var(--main-content);
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product .price-vera_start_p {
                    display: grid;
                    color: #6b6969;
                    font-size: 12px;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product .price-vera_start_p bdi {
                    font-size: 17px;
                    font-weight: 600;
                    color: <?php echo $settings['color-bachground-slider-product-one-del1-bdi-price']; ?>;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product ins {
                    text-decoration: none;
                    -moz-font-feature-settings: "ss02" !important;
                    -webkit-font-feature-settings: "ss02" !important;
                    font-feature-settings: "ss02" !important;
                    font-size: 17px;
                    font-weight: 600;
                    color: <?php echo $settings['color-bachground-slider-product-one-ins1'] ?>;
                    display: block;
                }


            .mySwiper-product_pro_2 .swiper-button-next, .mySwiper-product_pro_2 .swiper-button-prev {
                color: var(--main-color3) !important;
                fill: var(--main-color3) !important;
                stroke: var(--main-color3) !important;
                border-radius: 10px;
                background: #fbfbfb;
                padding: 10px !important;
                width: 40px;
                border: 1px solid #DDE;
                height: 40px;
                font-size: 12px !important;
            }
            .mySwiper-product_pro_2 .swiper-button-next:after , .mySwiper-product_pro_2 .swiper-button-prev:after {
               font-size: 20px !important;
            }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product .add-cart-product {
                    margin: 10px;
                    float: left;
                    position: relative;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a {
                    text-decoration: none !important;
                }

            .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a.added_to_cart {
                text-decoration: none !important;
                position: absolute;
                width: max-content;
                left: 0;
                background: #fff;
                content: "";
                margin: 0 2%;
                border-radius: 7px;
                padding: 2px 5px;
                font-size: 12px;
                font-weight: 600;
                color: #222222;
                top: -95%;
                box-shadow: 0 0 0 3px #2222222b;
                display: flex;
                align-items: center;
                justify-content: center;
            }
                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a.loading i:before {
                    content: "\f3f4";
                    font-family: "Font Awesome 5 Pro";
                    animation-name: animate-lider-block !important;
                    animation-duration: 1s;
                    animation-iteration-count: infinite;
                }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a.added i:before {
                    content: "\e3f1";
                    font-family: "Font Awesome 5 Pro";
                }
            .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product .add-cart-product i {
                padding: 12px;
                background: <?php echo $settings['color-bachground-slider-product-one-ins1-115212']; ?>;
                color: <?php echo $settings['color-bachground-slider-product-one-ins1-115212-1']; ?>;
                font-size: 15px;
                border: 1px solid #ddd;
                border-radius: 10px;
                width: 35px;
                height: 35px;
                display: flex;
                align-items: center;
                justify-content: center;
                box-shadow: 0 0 0 3px #ff9a4154;
                transition: all .3s ease-in-out;
            }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .dettle-product .add-cart-product i:hover {
                    box-shadow: 0 0 0 0 #2ea2cc4d;

                }


            .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .timer-isent-product {
                width: fit-content;
                margin: 0 0;
                float: right;
                background: #ff9b44;
                transition: all .3s ease-in-out;
                display: flex;
                border-radius: 10px;
                padding: 0 10px;
                position: absolute;
                box-shadow: 0 4px 0 0px #e06800c4;
                color: #fff;
                right: 10px;
                direction: rtl;
                width: 70px;
                top: 10px;
                justify-content: center;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                align-items: center;
            }

                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .timer-isent-product .countdown-timer {
                    font-size: 20px;
                    float: right;
                    -moz-font-feature-settings: "ss04" !important;
                    -webkit-font-feature-settings: "ss04" !important;
                    font-feature-settings: "ss04" !important;
                    width: fit-content;
                    direction: rtl;
                }

            .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .timer-isent-product .timer-section {
                float: right;
                display: flex;
                text-align: center;
                font-size: 12px;
                padding: 3px 0px;
                margin: 0 0px;
                border-radius: 10px;
                width: fit-content;
            }
                .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .timer-isent-product .timer-value {
                    font-weight: bold;
                    font-size: 15px;
                    font-family: IRANYekanX;
                    -moz-font-feature-settings: "ss02" !important;
                    -webkit-font-feature-settings: "ss02" !important;
                    font-feature-settings: "ss02" !important;
                }

            .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide:hover .timer-isent-product {
                top:-200% !important;
                transition: all .3s ease-in-out;
            }
            <?php
if ($settings['enable-product-right-left-div-slider-product'] == "left") :
?>
            .mySwiper-product_pro_2 .image_text_right_slider_imagesss {
                order: 1 !important;
                border-radius: 30px 0 0 30px !important;
            }
            .mySwiper-product_pro_2 .image_text_right_slider_imagesss:after {
                right: -100% !important;
                border-radius: 0 30px 30px 0 !important;
            }

            <?php
            endif;
            ?>

            @media screen and (max-width: 1000px) {
                    .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide figure {
                        height: 150px;
                    }

                    .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .like-containers {
                        transform: unset !important;
                    }

                    .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product > .amount > bdi {
                        font-size: 14px;
                    }

                    .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product .price-vera_start_p bdi {
                        font-size: 14px;
                    }

                    .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .price-product ins {
                        font-size: 14px !important;
                    }

                    .mySwiper-product_pro_2 .swiper-wrapper .swiper-slide .timer-isent-product {
                       display: none !important;
                    }
                    .mySwiper-product_pro_2 {
                        flex-wrap: wrap;
                    }
                    .mySwiper-product_pro_2 .mySwiper-product_pro_21 {
                        width: 95%;
                    }
                    .mySwiper-product_pro_2 .image_text_right_slider_image {
                        width: 100%;
                    }
                    .mySwiper-product_pro_2 .image_text_right_slider_image figure img {
                        height: 100px;
                        max-height: 100px;
                    }
                    .mySwiper-product_pro_2 .image_text_right_slider_image figure {
                        height: 100px;
                        display: none;
                    }
                    .mySwiper-product_pro_2 .image_text_right_slider_image {
                        height: 70%;
                    }
                    .mySwiper-product_pro_2 {
                        height: unset;
                    }
                .mySwiper-product_pro_2 .image_text_right_slider_image:after {
                    bottom: -200%;
                    right: unset !important;
                    left: 0 !important;
                    border-radius: 0 0 30px 30px !important;
                    height: 200%;
                }
                    .mySwiper-product_pro_2 .image_text_right_slider_image {
                        order: -1 !important;
                        height: 100%;
                        width: 100%;
                        border-radius: 30px 30px 0 0 !important;
                        padding: 0 8px;
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                    }
                    .mySwiper-product_pro_2 .image_text_right_slider_image h2 {
                        font-size: 20px;
                        width:fit-content;
                    }
                    .mySwiper-product_pro_2 .image_text_right_slider_image a {
                        width: fit-content;
                        margin: unset;
                        margin-top: unset;
                        padding: 5px;
                        font-size: 13px;
                    }

                }
            /*end coder slider product woocommerce*/

        </style>
        <script>
            $(function () {
                var swiper = new Swiper(".mySwiper-product_pro_21", {
                    <?php if ($settings['show_loop-controle-slider-pro1']) { ?>
                    loop: true,
                    <?php
                    }
                    ?>
                    <?php if ($settings['show_autoplay-controle-slider-pro1']) { ?>
                    autoplay: {
                        delay: <?php echo $settings['fast-slider-pro-autoplay-Timeout1'] ?>,
                        disableOnInteraction: true,
                    },
                    <?php
                    }
                    ?>
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    breakpoints: {
                        "@0.00": {
                            slidesPerView: 2,
                            spaceBetween: 10,
                        },
                        "@0.75": {
                            slidesPerView: 3,
                            spaceBetween: 10,
                        },
                        "@1.00": {
                            slidesPerView: 3,
                            spaceBetween: 10,
                        },
                        "@1.50": {
                            slidesPerView: 4,
                            spaceBetween: 10,
                        },
                    },
                });
            })
        </script>

        <div class="container">
            <div class="mySwiper-product_pro_2">
                <div class="swiper mySwiper-product_pro_21">
                    <div class="swiper-wrapper">
                        <?php
                        $pro = new WP_Query(array(
                            'post_type' => 'product',
                            'posts_per_page' => $settings['number-per-page-slider-pro-one'],
                            'meta_key' => $settings['enable_sale-price-product'],
                            'tax_query' => [[
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $settings['list_id_category_product'],
                            ]],
                        ));

                        if ($pro->have_posts()) {
                            while ($pro->have_posts()) : $pro->the_post(); ?>
                                <div class="swiper-slide">
                                    <?php global $product;
                                    $product_id = $product->get_id(); ?>
                                    <?php
                                    if ($settings['show-add-to-wishlist-product-sliders-theme'] == true) {
                                        ?>
                                        <a class="like-containers">
                                            <span class=" like-buttons" data-product-id="<?php echo $product_id; ?>"><i
                                                        class="fa-light fa-heart"></i></span>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                    <a href="<?php echo get_permalink(); ?>">
                                        <figure>
                                            <span class="loading_images loading_imagesss"></span>
                                            <?php
                                            echo simple_product_saving_percentage("تخفیف");
                                            ?>
                                            <?php
                                            global $product;
                                            if (!$product->is_in_stock()) {
                                                echo '<p class="stock">ناموجود</p>';
                                            } ?>
                                            <?php
                                            global $product;
                                            if (!empty($product->get_gallery_image_ids())) {
                                                $attachment_ids = $product->get_gallery_image_ids();
                                                $product_plan_two_img = wp_get_attachment_url($attachment_ids[0], 'large');
                                                $image_id = get_post_thumbnail_id();

                                                ?>
                                                <img alt="<?php wp_get_attachment_image_src("$image_id"); ?>"
                                                     style="display: none"
                                                     class="image-item-1-slider-product loading_image"
                                                     data-src="<?php echo get_the_post_thumbnail_url() ?>">
                                                <img class="image-item-2-slider-product"
                                                     src="<?php echo $product_plan_two_img; ?>" loading="lazy">
                                                <?php
                                            } else {
                                                ?>
                                                <img style="display: none" class="loading_image"
                                                     data-src="<?php echo get_the_post_thumbnail_url() ?>">
                                                <?php
                                            }
                                            ?>

                                        </figure>
                                    </a>

                                    <div class="name-product"><h3>
                                            <span class="cat_one_parent_slider_producty"><?php echo get_primary_product_category($product->id); ?></span>
                                            <a href="<?php echo get_permalink(); ?>">
                                                <?php do_action('woocommerce_shop_loop_item_title'); ?>
                                            </a>
                                    </div>
                                    <div class="dettle-product">
                                        <div class="price-product">

                                            <?php
                                            global $product;
                                            echo $product->get_price_html();
                                            ?>
                                        </div>
                                        <?php
                                        if ($settings['show-add-to-cart-product-sliders-theme'] == true) {
                                            ?>
                                            <div class="add-cart-product">
                                                <?php
                                                if ($product->is_type('simple')) { ?>
                                                    <?php
                                                    if ($product->is_in_stock() || $product->get_stock_quantity() > 0) {
                                                        ?>
                                                        <a href="<?php echo $product->add_to_cart_url() ?>"
                                                           value="<?php echo esc_attr($product->get_id()); ?>"
                                                           class="ajax_add_to_cart add_to_cart_button"
                                                           data-product_id="<?php echo get_the_ID(); ?>"
                                                           data-product_sku="<?php echo esc_attr($sku) ?>"
                                                           aria-label="Add “<?php the_title_attribute() ?>” to your cart">
                                                            <i class="fa-light fa-cart-circle-plus"></i>
                                                        </a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <a href="<?php echo get_post_permalink(); ?>"
                                                           class="namojod-product">
                                                            <i class="fa-light fa-cart-shopping"></i>
                                                        </a>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                } elseif ($product->is_type('variable')) {
                                                    ?>

                                                    <?php
                                                    if ($product->is_in_stock() && $product->get_stock_quantity() > 0) {
                                                        ?>
                                                        <a href="<?php echo get_post_permalink(); ?>"
                                                           class="namojod-productss">
                                                            <i class="fa-light fa-cart-shopping"></i>
                                                        </a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <a href="<?php echo get_post_permalink(); ?>"
                                                           class="namojod-products">
                                                            <i class="fa-light fa-cart-circle-plus"></i>
                                                        </a>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>

                                </div>
                            <?php
                            endwhile;
                        }
                        ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
                <div class="image_text_right_slider_image <?php if ($settings['enable-product-right-left-div-slider-product'] == "left") : ?> image_text_right_slider_imagesss  <?php  endif; ?>">
                    <h2><?php echo $settings['show-timer-product-sliders-theme-lkdfjsklfkdlnf321']; ?></h2>
                    <?php
                    if (!empty($settings['image-slider-sale_price_vera_red_veradasdsd']['url'])) {
                    ?>
                    <figure>
                    <img src="<?php echo $settings['image-slider-sale_price_vera_red_veradasdsd']['url']; ?>">
                    </figure>
                        <?php
                    }
                    else  {
                        ?>
                    <figure>
                    <img src="<?php echo get_template_directory_uri()."/img/not_found.jpg"; ?>">
                    </figure>
                        <?php
                    }

                    ?>
                    <a href="<?php echo $settings['show-timer-product-sliders-theme-lkdfdjskfdlfkdaslnf321'] ?>">
                        <?php echo $settings['show-timer-product-sliders-theme-lkdfjskfdlfhgjkdlnf321'] ?><i class="fa-light fa-left"></i>
                    </a>
                </div>
            </div>
        </div>


        <?php
    }


    protected function content_template()
    {
    }

}