<?php

class image_text_lincs_diak_theme_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'image-text-lincs-diak-themes';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p> المان تصویری و متن </h2>';
    }

    public function get_icon()
    {
        return ' eicon-image-box';
    }

    public function get_categories()
    {
        return ['text-image-category'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content-fore-img',
            [
                'label' => esc_html__('المان تصویری و متن دسته بندی', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'list_widgets',
            [
                'label' => esc_html__('لیست آیتم های اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'img-upload-slider_widget_w-2',
                        'label' => esc_html__('آپلود تصویر', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'description' => 'میتوانید از این قسمت هم تصویر اسلایدر را انتخاب و یا آپلود کنید ',
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ]
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-3',
                        'label' => 'متن بخش',
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'description' => 'شما میتوانید برای هر آیتم اسلایدر متن بخصوصی بنویسید',
                        'placeholder' => esc_html__('موبایل و تبلت', 'textdomain'),
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-4',
                        'label' => 'لینک هدایت آیتم اسلایدر',
                        'type' => \Elementor\Controls_Manager::URL,
                        'description' => 'میتوانید از این بخش لینک هدایت بعد از کلیک کاربر را ست کنید که کاربر بعد از کلیک به لینک هدایت شود مثال (آدرس دسته بندی موبایل سامسونگ)',
                        'placeholder' => esc_html__('https://site.com/shop/', 'textdomain'),
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-5',
                        'label' => esc_html__('باز شدن لینک در :', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '_blank',
                        'description' => 'میتوانید از این باکس طریقه باز شدن لین ها را انتخاب کنید مثلا وقتی کاربر بر روی لینک کلیک کرد در تب جدیدی از مرورگر به موضوع هدایت شود یا همان تب اصلی',
                        'options' => [
                            '_blank' => esc_html__('باز شدن در صفحه جدید', 'textdomain'),
                            '_self' => esc_html__('باز شدن در همان صفحه', 'textdomain'),
                        ],
                    ]
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل های المان', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_background-icon-left-link-freast-hover-35225252215242',
            [
                'label' => esc_html__('رنگ عنوان اصلی آیتم', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ عنوان اصلی آیتم را تغییر و شخصی سازی کنید',
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast-hover-355252215242dd',
            [
                'label' => esc_html__('رنگ کناره و بردر و رنگ عنوان آیتم در صورت هاور ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ کناره و بردر آیتم و عنوان در صورت هاور را تغییر و شخصی سازی کنید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast-hover-3521524225422',
            [
                'label' => esc_html__('رنگ پس زمینه هر آیتم', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه هر آیتم را تغییر و شخصی سازی کنید',
                'default' => '#FFFFFF',
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>
        <style>
            /*start code slider cat product*/
            .taxonome-cat-product-slider {
                float: right;
                width: 100%;
                padding-bottom: 10px;
                padding-top: 10px;
                overflow: hidden;
                margin-bottom: 20px;
            }

            .taxonome-cat-product-slider .swiper {
                width: 100%;
                height: max-content;
                padding-bottom: 10px;
                overflow: unset;
            }

            .taxonome-cat-product-slider .swiper-scrollbar {
                bottom: -10px;
            }

            .taxonome-cat-product-slider .swiper-slide {
                text-align: center;
                font-size: 18px;
                background: <?php echo $settings['text_background-icon-left-link-freast-hover-3521524225422'] ?> !important;;
                display: flex;
                justify-content: center;
                align-items: center;
                flex-wrap: wrap;
                border-radius: 20px;
                text-decoration: none;
                color: var(--main-color3);
                transition: all .3s ease-in-out;
            }

            .taxonome-cat-product-slider .swiper-slide:hover {
                transform: scale(.9);
                z-index: 1;
                box-shadow: 0 0 0 3px <?php echo $settings['text_background-icon-left-link-freast-hover-355252215242dd'] ?> !important;
            }

            .taxonome-cat-product-slider .swiper-slide:hover span {
                color: <?php echo $settings['text_background-icon-left-link-freast-hover-355252215242dd'] ?> !important;
            }

            .taxonome-cat-product-slider .swiper-slide span {
                width: 100%;
                float: right;
                padding: 0 0 13px;
                font-family: digikala;
                color: <?php echo $settings['text_background-icon-left-link-freast-hover-35225252215242'] ?> !important;
            }

            .taxonome-cat-product-slider .swiper-slide img {
                display: block;
                width: 100px;
                height: 100px;
                object-fit: cover;
            }

            /*end code slider cat product*/

        </style>
        <script>
            $(function () {
                var swipers_slide = new Swiper(".mySwiper-tax-cat-product", {
                    freeMode: true,
                    grabCursor: true,
                    scrollbar: {
                        el: ".swiper-scrollbar",
                    },
                    breakpoints: {
                        "@0.00": {
                            slidesPerView: 2,
                            spaceBetween: 2,
                        },
                        "@0.75": {
                            slidesPerView: 2,
                            spaceBetween: 2,
                        },
                        "@1.00": {
                            slidesPerView: 3,
                            spaceBetween: 3,
                        },
                        "@1.50": {
                            slidesPerView: 6,
                            spaceBetween: 6,
                        },
                    }

                });
            })
        </script>
        <div class="container">
            <div class="taxonome-cat-product-slider">
                <div class="swiper mySwiper-tax-cat-product">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['list_widgets'] as $index => $item) : ?>
                            <a target="<?php echo $item['img-upload-slider_widget_w-5']; ?>"
                               href="<?php echo $item['img-upload-slider_widget_w-4']['url']; ?>"
                               class="swiper-slide">
                                <img src="<?php echo $item['img-upload-slider_widget_w-2']['url']; ?>">
                                <span><?php echo $item['img-upload-slider_widget_w-3']; ?></span>
                            </a>
                        <?php endforeach; ?>

                    </div>
                    <div class="swiper-scrollbar"></div>
                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </div>


        <?php
    }


    protected function content_template()
    {
    }

}
