<?php

class comments_fake_diak_theme_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'comments_fake_diak-theme';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>نظرات برتر</h2>';
    }

    public function get_icon()
    {
        return 'eicon-review';
    }

    public function get_categories()
    {
        return ['workut-comments'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('برند های سایت', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'text_cole_text_comment_box_slider_h2',
            [
                'label' => esc_html__('متن کلی اسلایدر کامنت', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => 'شما میتوانید از طریق این قسمت متن کلی اسلایدر کامنت را تغییر کنید ',
                'default' => 'نظراتی از شما برای ما',
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => esc_html__('لیست کامنت های برتر شما', 'textdomain'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [

                    [
                        'name' => 'star-counts_style',
                        'label' => esc_html__('امتیاز کاربر به فروشگاهتان:', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'five-star',
                        'options' => [
                            'one-star' => esc_html__('تک ستاره', 'textdomain'),
                            'two-star' => esc_html__('دو ستاره', 'textdomain'),
                            'there-star' => esc_html__('سه ستاره', 'textdomain'),
                            'fore-star' => esc_html__('چهار ستاره', 'textdomain'),
                            'five-star' => esc_html__('پنج ستاره', 'textdomain'),
                        ],
                        ],

                    [
                        'name' => 'men-and-women-image',
                        'label' => esc_html__('آپلود تصویر', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'description' => 'تصویر کامنت گذار را آپلود کنید ',
                        'default' => [
                            'url' => get_template_directory_uri() . '/img/user-image.svg',
                        ]
                    ],

                        [
                            'name' => 'name-comments-users',
                            'label' => esc_html__('نام کامنت گذار', 'textdomain'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('ستایش سلطانی', 'textdomain'),
                            'placeholder' => esc_html__('ستایش سلطانی', 'textdomain'),
                        ],
                        [
                            'name' => 'name-comments-comments-54',
                            'label' => esc_html__('نام محصول یا نام مربوطه کامنت', 'textdomain'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('محصول آیفون 13 پرو', 'textdomain'),
                            'placeholder' => esc_html__('محصول آیفون 13 پرو', 'textdomain'),
                        ],
                        [
                            'name' => 'name-comments-comments-55',
                            'label' => esc_html__('لینک محصول یا مربوطه متن به کامنت', 'textdomain'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('site.com/prodct', 'textdomain'),
                            'placeholder' => esc_html__('site.com/prodct', 'textdomain'),
                        ],

                        [
                            'name' => 'TEXT-comments-users',
                            'label' => esc_html__('متن کامنت', 'textdomain'),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => esc_html__('ممنون از محصولات درجه یک شما از محصولم راضی بودم زودنم به دستم رسید ', 'textdomain'),
                            'placeholder' => esc_html__('ممنون از محصولات درجه یک شما از محصولم راضی بودم زودنم به دستم رسید ', 'textdomain'),
                        ],
                        [
                            'name' => 'TEXT-comments-users_date',
                            'label' => esc_html__('تاریخ کامنت', 'textdomain'),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => esc_html__('12 فروزدین 1400', 'textdomain'),
                            'placeholder' => esc_html__('12 فروزدین 1400', 'textdomain'),
                        ],

                    ]
                ]
		);
        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل های برند', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast-hover',
            [
                'label' => esc_html__('رنگ پس زمینه باکس کامنت', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید از طریق این قسمت رنگ باکس های کامنت را عوض کنید ',
                'default' => '#ffffff',
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast',
            [
                'label' => esc_html__('رنگ متن کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از طریق این قسسمت رنگ نام کلی را عوض کنید',
                'default' => '#222222',
            ]
        );
        $this->add_control(
            'text_background-icon-left-sdsadsd',
            [
                'label' => esc_html__('رنگ آیکون ستاره های امتیاز', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید رنگ آیکون ستاره های امتیاز را تغییر و شخصی سازی  کنید',
                'default' => '#f9860a',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'style_sectionss',
            [
                'label' => esc_html__('تنظیمات اسلایدر کامنت', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'show_navs-sliders',
            [
                'label' => esc_html__('نمایش کنترولر های اسلایدر کامنت', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_navs-sliders-elemant',
            [
                'label' => esc_html__('تکرار کامنت های شما', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('تکرار', 'textdomain'),
                'label_off' => esc_html__('نه', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_navs-sliders-elemant-autoplay',
            [
                'label' => esc_html__('حرکت خودکار اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیر فعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_navs-sliders-elemant-fasst',
            [
                'label' => esc_html__('سرعت حرکت اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2000,
                'max' => 200000,
                'step' => 1000,
                'default' => 5000,
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>
        <style>
            /*start comment slider*/
            .post-comment-slider {
                float: right;
                width: 100%;
                padding: 20px 0;
                overflow: hidden;
            }
            .post-comment-slider > h2 {
                width: 100%;
                float: right;
                text-align: center;
                padding: 20px 0;
                font-family: digikala;
            }

            .post-comment-slider .swiper {
                width: 100%;
                height: max-content;
            }

            .post-comment-slider .swiper-slide {
                text-align: center;
                font-size: 18px;
                background: #FFFFFF;
                color: #222222;
                display: flex;
                border: 1px solid #ddd;
                justify-content: right;
                align-items: center;
                flex-wrap: wrap;
                border-radius: 25px;
            }

            .post-comment-slider .swiper-slide i.commet-icon-quote-right {
                font-size: 15px;
                color: #515962;
                font-weight: 900;
                transform: rotate(180deg);
                position: absolute;
                right: 12px;
                line-height: 1;
                top: 12px;
                background: #fff;
                box-shadow: 0 0 0 3px #00000036;
                padding: 5px 6px;
                border-radius: 50%;
            }

            .post-comment-slider .swiper-slide .div-100-flex-tak-name-img-comments {
                display: flex;
                align-items: center;
                justify-content: right;
                margin-right: 5px;
            }

            .post-comment-slider .swiper-slide .div-100-flex-tak-name-img-comment {
                width: 96%;
                float: right;
                display: flex;
                padding: 10px 1% 0;
                align-items: center;
                justify-content: space-between;
                margin-bottom: 20px;
            }

            .post-comment-slider .swiper-slide .item-comment-image {
                width: 100px;
                height: 100px;
                object-fit: cover;
                display: flex;
            }

            .post-comment-slider .swiper-slide .item-comment-image img {
                display: block;
                width: 100%;
                height: 100%;
                object-fit: cover;
                border-radius: 50%;
                box-shadow: 0 0 0 5px #dddddd82;
            }

            .post-comment-slider .swiper-slide .item-comment-name {
                width: auto;
                display: grid;
                float: right;
                justify-items: start;
            }

            .post-comment-slider .swiper-slide .item-comment-name a:before {
                content: " مشتری ";
            }

            .post-comment-slider .swiper-slide .item-comment-name a:hover {
                opacity: 1;
            }
            .post-comment-slider .swiper-slide .item-comment-name a {
                padding-right: 15px;
                padding-top: 10px;
                font-weight: 400;
                float: right;
                font-size: 15px;
                opacity: .7;
                text-decoration: none;
                color: var(--main-color3);
                transition: all .3s ease-in-out;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }

            .post-comment-slider .swiper-slide .item-comment-name h3 {
                padding-right: 15px;
                font-weight: 300;
                float: right;
            }

            .post-comment-slider .swiper-slide .item-comment-star {
                width: 100%;
                text-align: right;
                padding: 0 10px 15px;
                display: flex;
                justify-content: space-between;
                transition: all .3s ease-in-out;
                align-items: center;
            }

            .post-comment-slider .swiper-slide .item-comment-star span {
                font-weight: 300;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }

            .post-comment-slider .swiper-slide .item-comment-star i {
                color: <?php echo $settings['text_background-icon-left-sdsadsd']; ?>;
            }
            .post-comment-slider .swiper-slide .item-comment-star i.fa-light {
                font-weight: 100;
            }

            .post-comment-slider .swiper-slide .item-comment-text {
                padding: 10px 1% 20px;
                width: 96%;
                text-align: justify;
                font-weight: 400;
                height: 135px;
                font-size: 15px;
                overflow: auto;
            }

            .post-comment-slider .swiper-button-next {
                color: var(--main-color3);
                left: 0;
            }

            .post-comment-slider .swiper-button-prev {
                color: var(--main-color3);
                right: 0;
            }

            .post-comment-slider .swiper-pagination-comment {
                width: 100%;
                text-align: center;
                padding-top: 10px;
                transition: all .3s ease-in-out;
            }

            .post-comment-slider .swiper-pagination-comment .swiper-pagination-bullet-active {
                width: 20px;
                border-radius: 5px;
                background: var(--main-color2);
                transition: all .3s ease-in-out;
            }
            .post-comment-slider .swiper {
                width: 100%;
                float: right;
                overflow: unset;
                padding: 10px 0;
            }
            .post-comment-slider .swiper .swiper-wrapper {
                padding: 20px 0;
            }
            .post-comment-slider .swiper-button-next, .post-comment-slider .swiper-button-prev {
                top: -33px;
                color: var(--main-color3);
            }

            /*end comment slider*/

        </style>
        <script>
            $(function () {

                /*start code js comment*/

                var swiper = new Swiper(".mySwiper-comment-sliders", {
                    <?php if ($settings['show_navs-sliders-elemant']) { ?>
                    loop: true,
                <?php } ?>
                    <?php if ($settings['show_navs-sliders-elemant-autoplay']) { ?>
                    autoplay: {
                        delay: <?php echo $settings['show_navs-sliders-elemant-fasst']; ?>,
                        disableOnInteraction: true,
                    },
                    <?php } ?>
                   slidesPerView: 1,
                   spaceBetween: 10,
                   navigation: {
                       nextEl: ".swiper-button-next",
                       prevEl: ".swiper-button-prev",
                   },
                   pagination: {
                       el: ".swiper-pagination-comment",
                       clickable: true,
                   },
                   breakpoints: {
                       "@0.00": {
                           slidesPerView: 1,
                           spaceBetween: 5,
                       },
                       "@0.75": {
                           slidesPerView: 3,
                           spaceBetween: 5,
                       },
                       "@1.00": {
                           slidesPerView: 3,
                           spaceBetween: 5,
                       },
                       "@1.50": {
                           slidesPerView: 3,
                           spaceBetween: 5,
                       },
                   }
               });
               /*end code js comment*/

            })
        </script>


        <div class="container">
            <div class="post-comment-slider">
                <h2><?php echo $settings['text_cole_text_comment_box_slider_h2']; ?></h2>
                <div class="swiper mySwiper-comment-sliders">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['list'] as $index => $item) : ?>
                        <div class="swiper-slide">
                            <div class="div-100-flex-tak-name-img-comment">
                                <div class="div-100-flex-tak-name-img-comments">
                                    <div class="item-comment-image">
                                        <?php
                                        if (!empty($item['men-and-women-image']['url'])) { ?>
                                            <img src="<?php echo $item['men-and-women-image']['url']; ?>">
                                        <?php }
                                        else  { ?>
                                            <img src="<?php echo get_template_directory_uri() . '/img/user-image.svg' ?>">
                                        <?php }
                                        ?>
                                    </div>
                                    <div class="item-comment-name">
                                        <h3><?php echo $item['name-comments-users']; ?></h3>
                                        <a href="
                                        <?php echo $item['name-comments-comments-55']; ?>
">
                                            <?php echo $item['name-comments-comments-54']; ?>
                                        </a>
                                    </div>
                                </div>
                                <i class="fa-thin fa-quote-right commet-icon-quote-right"></i>
                            </div>
                            <div class="item-comment-text">
                                <?php echo $item['TEXT-comments-users']; ?>
                            </div>
                            <div class="item-comment-star">
                                <div>
                                    <?php $star_conts = $item['star-counts_style'];
                                    if ( $star_conts == 'one-star') {
                                        ?>
                                        <i class="fas fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <i class="fa-light fa-star"></i>

                                        <?php
                                    }
                                    if ( $star_conts == 'two-star') {
                                        ?>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <?php
                                    }
                                    if ( $star_conts == 'there-star') {
                                        ?>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <?php
                                    }
                                    if ( $star_conts == 'fore-star') {
                                        ?>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fa-light fa-star"></i>
                                        <?php
                                    }
                                    if ( $star_conts == 'five-star') {
                                        ?>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <span><?php echo $item['TEXT-comments-users_date']; ?></span>
                            </div>
                        </div>
                        <?php endforeach; ?>

                    </div>
                    <div class="swiper-pagination-comment"></div>
        <?php if ($settings['show_navs-sliders']) { ?>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                    <?php } ?>
                </div>
            </div>
        </div>


        <?php
    }


    protected function content_template()
    {
    }

}

