<?php


function add_elementor_widget_categories($elements_manager)
{

    $elements_manager->add_category(
        'slider-category',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>اسلایدر تصاویر</h2>',
            'icon' => ' eicon-slider-push',
        ]
    );

    $elements_manager->add_category(
        'text-image-category',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>المان تصویر و متن</h2>',
            'icon' => 'eicon-image-box',
        ]
    );
    $elements_manager->add_category(
        'sothianal-category',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>المان شبکه های اجتماعی</h2>',
            'icon' => 'eicon-social-icons',
        ]
    );
    $elements_manager->add_category(
        'eleman-category',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>المان های تصویری</h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'eleman-img-text',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>المان های تصویری / متنی</h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'slider-product',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>  محصولات </h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'header-product',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>طرح های عناوین</h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'workut-blog',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p> وبلاگ</h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'workut-question',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>سوالات</h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'workut-comments',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p> نظرات </h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'workut-chanel',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>شبکه های اجتماعی</h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );
    $elements_manager->add_category(
        'cate-artikut',
        [
            'title' => '<h2><p style="position: absolute;font-family: inherit;font-size:11px;top:18px;left:10%;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding:  5px;">PRO</p>دسته بندی محصولات</h2>',
            'icon' => ' eicon-archive-posts',
        ]
    );


}

add_action('elementor/elements/categories_registered', 'add_elementor_widget_categories');


/**
 * Main Elementor Test Extension Class
 *
 * The main class that initiates and runs the plugin.
 *
 * @since 1.0.0
 */
final class Elementor_teacher_Extension
{

    /**
     * Plugin Version
     *
     * @since 1.0.0
     *
     * @var string The plugin version.
     */
    const VERSION = '1.0.0';

    /**
     * Minimum Elementor Version
     *
     * @since 1.0.0
     *
     * @var string Minimum Elementor version required to run the plugin.
     */
    const MINIMUM_ELEMENTOR_VERSION = '2.0.0';

    /**
     * Minimum PHP Version
     *
     * @since 1.0.0
     *
     * @var string Minimum PHP version required to run the plugin.
     */
    const MINIMUM_PHP_VERSION = '7.0';

    /**
     * Instance
     *
     * @since 1.0.0
     *
     * @access private
     * @static
     *
     * @var Elementor_Test_Extension The single instance of the class.
     */
    private static $_instance = null;

    /**
     * Instance
     *
     * Ensures only one instance of the class is loaded or can be loaded.
     *
     * @return Elementor_Test_Extension An instance of the class.
     * @since 1.0.0
     *
     * @access public
     * @static
     *
     */
    public static function instance()
    {

        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;

    }

    /**
     * Constructor
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function __construct()
    {


        if (!defined('ABSPATH')) {
            exit; // Exit if accessed directly.
        }
        add_action('after_setup_theme', [$this, 'on_plugins_loaded']);

    }

    /**
     * Load Textdomain
     *
     * Load plugin localization files.
     *
     * Fired by `init` action hook.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function i18n()
    {

        load_plugin_textdomain('elementor-test-extension');

    }

    /**
     * On Plugins Loaded
     *
     * Checks if Elementor has loaded, and performs some compatibility checks.
     * If All checks pass, inits the plugin.
     *
     * Fired by `plugins_loaded` action hook.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function on_plugins_loaded()
    {

        if ($this->is_compatible()) {
            add_action('elementor/init', [$this, 'init']);
        }

    }

    /**
     * Compatibility Checks
     *
     * Checks if the installed version of Elementor meets the plugin's minimum requirement.
     * Checks if the installed PHP version meets the plugin's minimum requirement.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function is_compatible()
    {

        // Check if Elementor installed and activated
        if (!did_action('elementor/loaded')) {
            add_action('admin_notices', [$this, 'admin_notice_missing_main_plugin']);

            return false;
        }

        // Check for required Elementor version
        if (!version_compare(ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=')) {
            add_action('admin_notices', [$this, 'admin_notice_minimum_elementor_version']);

            return false;
        }

        // Check for required PHP version
        if (version_compare(PHP_VERSION, self::MINIMUM_PHP_VERSION, '<')) {
            add_action('admin_notices', [$this, 'admin_notice_minimum_php_version']);

            return false;
        }

        return true;

    }

    /**
     * Initialize the plugin
     *
     * Load the plugin only after Elementor (and other plugins) are loaded.
     * Load the files required to run the plugin.
     *
     * Fired by `plugins_loaded` action hook.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function init()
    {

        $this->i18n();

        // Add Plugin actions
        add_action('elementor/widgets/widgets_registered', [$this, 'init_widgets']);
        add_action('elementor/controls/controls_registered', [$this, 'init_controls']);

    }

    /**
     * Init Widgets
     *
     * Include widgets files and register them
     *
     * @since 1.0.0
     *
     * @access public
     */

    public function init_widgets()
    {
        ?>
        <div class="div-elementor">
            <?php
            // Include Widget slider-img-one vera_theme / vera
            require_once(__DIR__ . '/widgets/slider-widget.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \slider_img_workut_Widget());

            // Include Widget text and image / vera
            require_once(__DIR__ . '/widgets/image-text-lincs.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \image_text_lincs_diak_theme_Widget());

            // Include Widget slider product / vera
            require_once(__DIR__ . '/widgets/slider-product-pro.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \slider_product_diak_theme_Widget());


            // Include Widget slider product 2 / vera
            require_once(__DIR__ . '/widgets/slider-product-pro-2.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \slider_product_2_diak_theme_Widget());


            // Include Widget slider product 2 / vera
            require_once(__DIR__ . '/widgets/slider-product-pro-3.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \slider_product_3_diak_theme_Widget());


            // Include Widget 4-img  / vera
            require_once(__DIR__ . '/widgets/4-img-widget.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \fore_img_diak_theme_Widget ());


            // Include Widget 1-img  / vera
            require_once(__DIR__ . '/widgets/1-img-product-pro.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \one_img_product_diak_theme_Widget());

            // Include Widget 2-img / vera
            require_once(__DIR__ . '/widgets/2-img-product-pro.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \two_img_product_diak_theme_Widget());

            // Include Widget 1-img / vera
            require_once(__DIR__ . '/widgets/1-img-product-pro.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \one_img_product_diak_theme_Widget());

            // Include Widget blog slider (pro) / vera
            require_once(__DIR__ . '/widgets/slider-blog-pro-product-pro.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \slider_blog_pro_diak_theme_Widget());

            // Include Widget coments-for-user-fake
            require_once(__DIR__ . '/widgets/comments_fake-workut.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \comments_fake_diak_theme_Widget());


            // Include Widget story create elementor
            require_once(__DIR__ . '/widgets/story_create_elementor.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \story_create_elementor());


            // Include Widget story create elementor
            require_once(__DIR__ . '/widgets/slider-2-widget.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \slider_2_widget());

            // Include Widget story create elementor
            require_once(__DIR__ . '/widgets/slider-widget-2.php');
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \slider_widget_2_elementor());




            ?>
        </div>
        <?php

    }

    /**
     * Init Controls
     *
     * Include controls files and register them
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function init_controls()
    {


    }

    /**
     * Admin notice
     *
     * Warning when the site doesn't have Elementor installed or activated.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function admin_notice_missing_main_plugin()
    {

        if (isset($_GET['activate'])) {
            unset($_GET['activate']);
        }

        $message = sprintf(
        /* translators: 1: Plugin name 2: Elementor */
            esc_html__('"%1$s" requires "%2$s" to be installed and activated.', 'elementor-test-extension'),
            '<strong>' . esc_html__('Elementor Test Extension', 'elementor-test-extension') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'elementor-test-extension') . '</strong>'
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);

    }

    /**
     * Admin notice
     *
     * Warning when the site doesn't have a minimum required Elementor version.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function admin_notice_minimum_elementor_version()
    {

        if (isset($_GET['activate'])) {
            unset($_GET['activate']);
        }

        $message = sprintf(
        /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'elementor-test-extension'),
            '<strong>' . esc_html__('Elementor Test Extension', 'elementor-test-extension') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'elementor-test-extension') . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);

    }

    /**
     * Admin notice
     *
     * Warning when the site doesn't have a minimum required PHP version.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function admin_notice_minimum_php_version()
    {

        if (isset($_GET['activate'])) {
            unset($_GET['activate']);
        }

        $message = sprintf(
        /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'elementor-test-extension'),
            '<strong>' . esc_html__('Elementor Test Extension', 'elementor-test-extension') . '</strong>',
            '<strong>' . esc_html__('PHP', 'elementor-test-extension') . '</strong>',
            self::MINIMUM_PHP_VERSION
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);

    }

}

Elementor_teacher_Extension::instance();
