<?php

//if (!function_exists('wc_get_product')) {
//    include_once ABSPATH . 'wp-content/plugins/woocommerce/includes/wc-product-functions.php';
//}
//if (!function_exists('wc_doing_it_wrong')) {
//    include_once ABSPATH . 'wp-content/plugins/woocommerce/includes/wc-product-functions.php';
//}


class Berozkala_WP_Integration {
    public static function init() {
        add_action('woocommerce_loaded', [__CLASS__, 'load_functions']);
    }

    public static function load_functions() {

        create_new_product();
        update_product();
        save_product_to_wp();
        add_product_attributes_to_woocommerce();
        add_product_gallery_to_woocommerce();
        add_product_variations_to_woocommerce();
        update_product_details();
        get_post_by_meta();
        set_product_image();
    }



//     ADD AND UPdate Product


    private function create_new_product($product_data, $category_name) {
        $log = debug_plugin_log("اضافه کردن محصول");

        $price = preg_replace('/[^\d.]/', '', $product_data['price']);
        $price = ceil($price * 1.12);
        if($price == 0){
            return 0;
            berozkala_log("قیمت محصول صفر بود: " . $product_data['title']);
        }else{

        // ایجاد یک محصول ساده جدید
        $product = new WC_Product_Simple();
        $product->set_name($product_data['title']);
        $product->set_status('publish');
        $product->set_price($price);

        $product->set_regular_price($price);
        $product->set_catalog_visibility('visible'); // قابل نمایش در فروشگاه

        // اضافه کردن دسته‌بندی
//        wp_set_object_terms($product->get_id(), $category_name["categor_item"], 'product_cat', true);

        // متای اضافی
        $product->update_meta_data('b_product_url', $product_data['link']);
        $product->update_meta_data('b_price', $price);
        $product->update_meta_data('b_price_update', $price);
        $product->update_meta_data('b_update_circle', 1);
        $product->update_meta_data('b_product_type_action', 'add');
        $product->update_meta_data('b_product_id', $product_data['id']);
        $product->update_meta_data('b_product_thumbnail', $product_data['image']);
        $product->update_meta_data('b_product_single_sync', 0);

        // ذخیره محصول
        $product_id = $product->save();

        $update = update_post_meta($product_id,'b_price_update', $price);
        $update = update_post_meta($product_id,'b_update_circle', 1);
        $update = update_post_meta($product_id,'b_product_type_action', 'add');
        $update = update_post_meta($product_id,'b_category_list',$category_name);
        $cat_set = wp_set_object_terms($product_id, array((int) $category_name["categor_item"]), 'product_cat', true);
//        //berozkala_log("Product created: " . $product_data['title'] . " (Product ID: $product_id)");
        return $product_id;
        }
    }


    private function update_product($post_id, $product_data, $category_name) {

        $log = debug_plugin_log("آپدیت محصول");
        $log = debug_plugin_log($post_id);
        $price = preg_replace('/[^\d.]/', '', $product_data['price']);
        $price = floatval($price);

        if ($price > 0) {
            $price = ceil($price * 1.12);
        }

        // اضافه کردن دسته‌بندی
        wp_set_object_terms($post_id, array((int) $category_name["categor_item"]), 'product_cat', true);
        update_post_meta($post_id, 'b_category_list', $category_name);

        // بارگذاری محصول موجود
        $product = wc_get_product($post_id);

        $update = update_post_meta($post_id,'b_price_update', $price);
        $update = update_post_meta($post_id,'b_update_circle', 1);
        $update = update_post_meta($post_id,'b_product_type_action', 'add');
        if ($product) {
            $update = update_post_meta($post_id,'b_product_RUn', 'yes');
            $product->set_name($product_data['title']);
            $product->update_meta_data('b_price', $price);
            $product->update_meta_data('b_product_url', $product_data['link']);
            $product->update_meta_data('b_product_id', $product_data['id']);
            $product->update_meta_data('b_product_thumbnail', $product_data['image']);
            $product->update_meta_data('b_product_single_sync', 0);



            if ($price > 0) {
                $product->set_price($price);
                $product->set_regular_price($price);
                $product->set_manage_stock(false); // عدم مدیریت موجودی به صورت دستی
                $product->set_stock_status('instock'); // موجود
            } else {
                $product->set_manage_stock(false);
                $product->set_stock_status('outofstock'); // ناموجود

                berozkala_log($product_data['title']."ناموجود شد.");
            }

            // ذخیره تغییرات
            $product->save();

            return $post_id;
        } else {
            return false;
        }
    }



//    End Add & Update


//    public function save_product_to_wp($product_data) {
//        //berozkala_log("Processing product: " . $product_data['title']);
//
//        // بررسی وجود محصول
//        $existing_post = $this->get_post_by_meta('b_product_id', $product_data['id']);
//        if ($existing_post) {
//            //berozkala_log("Updating existing product: " . $product_data['title']);
//            return $this->update_product($existing_post->ID, $product_data);
//        }
//
//        // ایجاد محصول جدید
//        //berozkala_log("Adding new product: " . $product_data['title']);
//        return $this->create_new_product($product_data);
//    }

    public function save_product_to_wp($product_data, $category_name) {
//        //berozkala_log("Processing product: " . $product_data['title']);

        // بررسی وجود محصول
        $existing_post = $this->get_post_by_meta('b_product_id', $product_data['id']);
        if ($existing_post) {
//            berozkala_log("Updating existing product: " . $product_data['title']);
            berozkala_log("محصول آپدیت شد: " . $product_data['title']);
            return $this->update_product($existing_post->ID, $product_data, $category_name);
        }

        // ایجاد محصول جدید
//        berozkala_log("Adding new product: " . $product_data['title']);
        berozkala_log("محصول اضافه شد: " . $product_data['title']);
        return $this->create_new_product($product_data, $category_name);
    }



//    function add_product_attributes_to_woocommerce($product_id, $attributes) {
//        if (!empty($attributes)) {
//            $product_attributes = wc_get_product($product_id)->get_attributes();
//
//            foreach ($attributes as $index => $attribute) {
//                $attribute_name = sanitize_title($attribute['name']);
//                $attribute_label = $attribute['name'];
//                $attribute_value = $attribute['value'];
//
//                $product_attributes[$attribute_name] = new WC_Product_Attribute([
//                    'name'         => $attribute_label,
//                    'value'        => $attribute_value,
//                    'position'     => $index,
//                    'is_visible'   => 1,
//                    'is_variation' => 0,
//                    'is_taxonomy'  => 0,
//                ]);
//            }
//
//
//            $product = wc_get_product($product_id);
//            $product->set_attributes($product_attributes);
//            $product->save();
//        }
//    }

    public static function add_product_attributes_to_woocommerce($product_id, $attributes) {
//        //berozkala_log("Starting to add attributes for product ID: {$product_id}");
        $update = update_post_meta($product_id,'b_attributes',$attributes);
        $product = wc_get_product($product_id);
        if (!$product) {
//            //berozkala_log("Product not found for ID: {$product_id}");
            return;
        }
        foreach ($attributes as $attribute) {
            if (isset($attribute['name']) && isset($attribute['value'])) {
                // اسلاگ مناسب برای زبان فارسی
                $taxonomy = urldecode($attribute['name']); // نام ترمینولوژی
                $term_value = sanitize_text_field($attribute['value']); // مقدار ترم
                $attribute_label = urldecode($attribute['name']); // لیبل ویژگی

                // بررسی وجود taxonomy
                if (!taxonomy_exists($taxonomy)) {
                    // ایجاد taxonomy جدید
                    register_taxonomy(
                        $taxonomy,
                        'product',
                        array(
                            'label'        => $attribute_label,
                            'public'       => true,
                            'hierarchical' => false,
                            'show_ui'      => true,
                            'show_in_nav_menus' => false,
                        )
                    );

                    // افزودن ویژگی به تنظیمات عمومی ووکامرس
                    $attribute_args = array(
                        'name'         => $attribute_label,
                        'slug'         => sanitize_title_with_dashes($attribute['name']),
                        'type'         => 'select',
                        'order_by'     => 'menu_order',
                        'has_archives' => false,
                    );
                    wc_create_attribute($attribute_args);
                }

                // بررسی وجود مقدار (ترم) در taxonomy
                if (!term_exists($term_value, $taxonomy)) {
                    wp_insert_term($term_value, $taxonomy);
                }

                // اتصال محصول به مقدار ویژگی (ترم)
                wp_set_object_terms($product_id, $term_value, $taxonomy, true);

                // اضافه کردن ویژگی به محصول
                $product_attributes = $product->get_attributes();
                if (!isset($product_attributes[$taxonomy])) {
                    $attribute_object = new WC_Product_Attribute();
                    $attribute_object->set_name($taxonomy);
                    $attribute_object->set_options(array($term_value));
                    $attribute_object->set_visible(true);
                    $attribute_object->set_variation(false);
                    $product_attributes[$taxonomy] = $attribute_object;
                }

                // ذخیره ویژگی‌ها در محصول
                $product->set_attributes($product_attributes);
                $product->save();
            }
        }

    }





    function add_product_gallery_to_woocommerce($product_id, $gallery_urls) {
        if (!empty($gallery_urls)) {

            $attachment_ids = [];

            foreach ($gallery_urls as $url) {
                $url = strtok($url,"?");
                $attachment_id = attachment_url_to_postid($url);

                if (!$attachment_id) {
                    $attachment_id = wp_insert_attachment([
                        'guid'           => $url,
                        'post_mime_type' => 'image/jpeg',
                        'post_title'     => basename($url),
                        'post_content'   => '',
                        'post_status'    => 'inherit',
                    ], $url);

                    if (!is_wp_error($attachment_id)) {
                        require_once(ABSPATH . 'wp-admin/includes/image.php');
                        wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $url));
                    }
                }

                $attachment_ids[] = $attachment_id;
            }

            update_post_meta($product_id, '_product_image_gallery', implode(',', $attachment_ids));
        }
    }

//    public static function add_product_variations_to_woocommerce($product_id, $variations) {
//        //berozkala_log("Adding variations to Product ID: $product_id");
////        //berozkala_log("Variations data: " . json_encode($variations));
//        $update = update_post_meta($product_id,'b_variations',$variations);
//
//        if (!empty($variations)) {
//            $product = wc_get_product($product_id);
//
//            foreach ($variations as $variation_type => $variation_data) {
//                if (!empty($variation_data)) {
//                    foreach ($variation_data as $variation) {
//                        //berozkala_log("Processing variation: " . json_encode($variation));
//                        $variation_id = wp_insert_post([
//                            'post_title'  => $product->get_name() . ' - ' . $variation['name'],
//                            'post_status' => 'publish',
//                            'post_parent' => $product_id,
//                            'post_type'   => 'product_variation',
//                            'meta_input'  => [
//                                'attribute_' . sanitize_title($variation_type) => $variation['name'],
//                                '_regular_price'                                => $variation['price'],
//                                '_price'                                       => $variation['price'],
//                            ],
//                        ]);
//
//                        if (!is_wp_error($variation_id)) {
//                            //berozkala_log("Variation added successfully: $variation_id");
//                        } else {
//                            //berozkala_log("Failed to add variation: " . $variation_id->get_error_message());
//                        }
//                    }
//                }
//            }
//        } else {
//            //berozkala_log("No variations to add for Product ID: $product_id");
//        }
//    }


    function hdm_delete_all_variations( $parent_product_id ) {
        $args = array(
            'post_type'   => 'product_variation',
            'post_status' => array('private', 'publish'),
            'numberposts' => -1,
            'post_parent' => $parent_product_id,
        );

        $variations = get_posts( $args );

        foreach ( $variations as $variation ) {
            wp_delete_post( $variation->ID, true );
        }
    }


//    old Varation 12 / Aprile
//    public static function add_product_variations_to_woocommerce($product_id, $variations) {
////        //berozkala_log("Adding variations to Product ID: $product_id");
////        //berozkala_log("Variations data: " . json_encode($variations));
//        $delete_old_variation = hdm_delete_all_variations( $product_id );
//        $update = update_post_meta($product_id,'b_variations',$variations);
//
//        $post = get_post($product_id);
//        $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//        $b_price = floatval(get_post_meta($post->ID, 'b_price', true));
//
//        // اگر متا خالی بود، خروج
//        if (empty($variations_meta)) {
//            return;
//        }
//
//        // unserialize کردن متا و بررسی اعتبار آن
//        $variations = maybe_unserialize($variations_meta);
//        if (!is_array($variations) || empty($variations)) {
//            return;
//        }
//
//        // دریافت محصول
//        $product = wc_get_product($post->ID);
//
//        // اگر محصول موجود نبود، خروج
//        if (!$product) {
//            return;
//        }
//
//        // تغییر نوع محصول به 'variable'
//        wp_set_object_terms($post->ID, 'variable', 'product_type');
//        update_post_meta($post->ID, '_product_type', 'variable');
//
//        // بازخوانی محصول به عنوان محصول متغیر
//        $product = wc_get_product($post->ID);
//
//        if (!$product || $product->get_type() !== 'variable') {
//            error_log("محصول به متغیر تغییر نکرد. ID: $post->ID");
//            return;
//        }
//
//
////        $product->set_regular_price(0); // در صورت لزوم
////        $product->save();
//        // آماده‌سازی ویژگی‌ها و متغیرها
//        $product_attributes = $product->get_attributes();
//
//        foreach ($variations as $attribute_name => $items) {
//            // جایگزینی نام ویژگی خاص
//            if ($attribute_name == 'warranty') {
//                $attribute_name = 'گارانتی';
//            }
//
//            // ساخت اسلاگ لاتین برای ویژگی
//            $taxonomy = urldecode(sanitize_title($attribute_name));
//
//            // بررسی و ثبت ویژگی در ووکامرس
//            if (!taxonomy_exists($taxonomy)) {
//                $attribute_args = array(
//                    'name'         => urldecode($attribute_name), // نام فارسی برای نمایش
//                    'slug'         => $taxonomy, // اسلاگ لاتین برای ذخیره‌سازی
//                    'type'         => 'select',
//                    'order_by'     => 'menu_order',
//                    'has_archives' => false,
//                );
//                wc_create_attribute($attribute_args);
//            }
//
//            // افزودن ویژگی به محصول
//            $attribute_object = new WC_Product_Attribute();
//            $attribute_object->set_name($taxonomy);
//            $attribute_object->set_visible(true);
//            $attribute_object->set_variation(true);
//
//            $terms = [];
//            foreach ($items as $item) {
//                $item['price'] = $item['price'] + $b_price;
//                print_r($item);
//                if (isset($item['name']) && isset($item['price'])) {
//                    $term_name = sanitize_text_field($item['name']);
//                    $term_price = floatval($item['price']);
//                    $terms[] = $term_name;
//
//                    // افزودن مقدار به ویژگی
//                    if (!term_exists($term_name, $taxonomy)) {
//                        wp_insert_term($term_name, $taxonomy);
//                    }
//
//                    // ایجاد متغیر
//                    $variation = new WC_Product_Variation();
//                    $variation->set_parent_id($post->ID);
//                    $variation->set_attributes([$taxonomy => $term_name]);
//                    $variation->set_regular_price(floatval($term_price)); // تبدیل مقدار به عدد
//                    $variation->set_stock_status('instock');
//                    $variation->set_sku('SKU-' . uniqid());
//                    $variation_id = $variation->save();
//
//// بررسی قیمت پس از ذخیره
//                    $variation_data = wc_get_product($variation_id);
//                    error_log("Variation Created. ID: $variation_id, Term Name: $term_name, Term Price: $term_price, Saved Price: " . $variation_data->get_regular_price());
//
//
//                }
//            }
//
//            $attribute_object->set_options($terms);
//            $product_attributes[$taxonomy] = $attribute_object;
//        }
//
//        // ذخیره ویژگی‌ها و متغیرها
//        $product->set_attributes($product_attributes);
//        $product->save();
//
//        // ثبت لاگ برای بررسی
//        error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: {$post->ID}");
//    }


    public static function add_product_variations_to_woocommerce($product_id, $variations) {
//        //berozkala_log("Adding variations to Product ID: $product_id");
//        //berozkala_log("Variations data: " . json_encode($variations));
//        $delete_old_variation = hdm_delete_all_variations( $product_id );
//        $args = array(
//            'post_type'   => 'product_variation',
//            'post_status' => array('private', 'publish'),
//            'numberposts' => -1,
//            'post_parent' => $product_id,
//        );
//
//        $variations = get_posts( $args );
//
//        foreach ( $variations as $variation ) {
//            wp_delete_post( $variation->ID, true );
//        }


        $update = update_post_meta($product_id,'b_variations',$variations);

        $post = get_post($product_id);
        $variations_meta = get_post_meta($post->ID, 'b_variations', true);
        $b_price = floatval(get_post_meta($post->ID, 'b_price', true));


        // اگر متا خالی بود، خروج
        if (empty($variations_meta)) {
            return;
        }

        // unserialize کردن متا و بررسی اعتبار آن
        $variations = maybe_unserialize($variations_meta);
        if (!is_array($variations) || empty($variations)) {
            return;
        }

        // دریافت محصول
        $product = wc_get_product($post->ID);

        // اگر محصول موجود نبود، خروج
        if (!$product) {
            return;
        }

        // تغییر نوع محصول به 'variable'
        wp_set_object_terms($post->ID, 'variable', 'product_type');
        update_post_meta($post->ID, '_product_type', 'variable');

        // بازخوانی محصول به عنوان محصول متغیر
        $product = wc_get_product($post->ID);

        if (!$product || $product->get_type() !== 'variable') {
            error_log("محصول به متغیر تغییر نکرد. ID: $post->ID");
            return;
        }


//        $product->set_regular_price(0); // در صورت لزوم
//        $product->save();
        // آماده‌سازی ویژگی‌ها و متغیرها
        $product_attributes = $product->get_attributes();

        foreach ($variations as $attribute_name => $items) {
            // جایگزینی نام ویژگی خاص
            if ($attribute_name == 'warranty') {
                $attribute_name = 'گارانتی';
            }

            // ساخت اسلاگ لاتین برای ویژگی
            $taxonomy = urldecode(sanitize_title($attribute_name));

            // بررسی و ثبت ویژگی در ووکامرس
            if (!taxonomy_exists($taxonomy)) {
                $attribute_args = array(
                    'name'         => urldecode($attribute_name), // نام فارسی برای نمایش
                    'slug'         => $taxonomy, // اسلاگ لاتین برای ذخیره‌سازی
                    'type'         => 'select',
                    'order_by'     => 'menu_order',
                    'has_archives' => false,
                );
                wc_create_attribute($attribute_args);
            }

            // افزودن ویژگی به محصول
            $attribute_object = new WC_Product_Attribute();
            $attribute_object->set_name($taxonomy);
            $attribute_object->set_visible(true);
            $attribute_object->set_variation(true);

            $terms = [];
            foreach ($items as $item) {
                $item['price'] = $item['price'] + $b_price;
                print_r($item);
                if (isset($item['name']) && isset($item['price'])) {
                    $term_name = sanitize_text_field($item['name']);
                    $term_price = floatval($item['price']);
                    $terms[] = $term_name;

                    // افزودن مقدار به ویژگی
                    if (!term_exists($term_name, $taxonomy)) {
                        wp_insert_term($term_name, $taxonomy);
                    }

                    // ایجاد متغیر
                    $variation = new WC_Product_Variation();
                    $variation->set_parent_id($post->ID);
                    $variation->set_attributes([$taxonomy => $term_name]);
                    $variation->set_regular_price(floatval($term_price)); // تبدیل مقدار به عدد
                    $variation->set_stock_status('instock');
                    $variation->set_sku('SKU-' . uniqid());
                    $variation_id = $variation->save();

// بررسی قیمت پس از ذخیره
                    $variation_data = wc_get_product($variation_id);
                    error_log("Variation Created. ID: $variation_id, Term Name: $term_name, Term Price: $term_price, Saved Price: " . $variation_data->get_regular_price());


                }
            }

            $attribute_object->set_options($terms);
            $product_attributes[$taxonomy] = $attribute_object;
        }

        // ذخیره ویژگی‌ها و متغیرها
        $product->set_attributes($product_attributes);
        $product->save();

        // ثبت لاگ برای بررسی
        error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: {$post->ID}");
    }



//    public static function update_product_details($post_id, $details) {
//        //berozkala_log("Updating product details for Post ID: $post_id");
//
//        // 1. ذخیره متغیرها
//        if (!empty($details['variations'])) {
//            try {
//                self::add_product_variations_to_woocommerce($post_id, $details['variations']);
//                update_post_meta($post_id, 'b_product_variations', $details['variations']);
//                //berozkala_log("Variations saved: " . json_encode($details['variations']));
//            } catch (Exception $e) {
//                //berozkala_log("Error saving variations: " . $e->getMessage());
//            }
//        } else {
//            //berozkala_log("No variations to save.");
//        }
//
//        // 2. ذخیره گالری
//        if (!empty($details['gallery'])) {
//            try {
//                self::add_product_gallery_to_woocommerce($post_id, $details['gallery']);
//                update_post_meta($post_id, 'b_product_gallery', $details['gallery']);
//                //berozkala_log("Gallery saved: " . json_encode($details['gallery']));
//            } catch (Exception $e) {
//                //berozkala_log("Error saving gallery: " . $e->getMessage());
//            }
//        } else {
//            //berozkala_log("No gallery images to save.");
//        }
//
//        // 3. ذخیره ویژگی‌ها
//        if (!empty($details['attributes'])) {
//            try {
//                self::add_product_attributes_to_woocommerce($post_id, $details['attributes']);
//                update_post_meta($post_id, 'b_product_attributes', $details['attributes']);
//                //berozkala_log("Attributes saved: " . json_encode($details['attributes']));
//            } catch (Exception $e) {
//                //berozkala_log("Error saving attributes: " . $e->getMessage());
//            }
//        } else {
//            //berozkala_log("No attributes to save.");
//        }
//
//        //berozkala_log("Product details updated successfully for Post ID: $post_id");
//    }


    public static function process_attributes_for_woocommerce($attributes) {
        $processed_attributes = [];

        foreach ($attributes as $index => $attribute) {
            $attribute_name = sanitize_title($attribute['name']); // کلید یکتا
            $attribute_value = $attribute['value']; // مقدار ویژگی

            // تبدیل مقدار به آرایه (ووکامرس نیاز به آرایه دارد)
            $attribute_values_array = explode('|', $attribute_value);

            $processed_attributes[$attribute_name] = new WC_Product_Attribute([
                'name'         => $attribute_name,
                'options'      => $attribute_values_array,
                'position'     => $index,
                'is_visible'   => 1,
                'is_variation' => 0,
                'is_taxonomy'  => 0,
            ]);
        }

        return $processed_attributes;
    }
    public function add_product_attributes($product_id, $attributes) {
        $product = wc_get_product($product_id);
        if (!$product) return;

        $processed_attributes = [];
        foreach ($attributes as $attribute) {
            $processed_attributes[sanitize_title($attribute['name'])] = [
                'name'         => $attribute['name'],
                'options'      => explode('|', $attribute['value']),
                'position'     => 0,
                'is_visible'   => 1,
                'is_variation' => 0,
                'is_taxonomy'  => 0,
            ];
        }
        $product->set_attributes($processed_attributes);
        $product->save();

        //berozkala_log("Attributes updated for Product ID: $product_id");
    }



    public static function update_product_details($post_id, $details, $category_name = null) {
        //berozkala_log("Updating product details for Post ID: $post_id");

        // افزودن گالری تصاویر به محصول
//        if (!empty($details['gallery'])) {
//            self::add_product_gallery_to_woocommerce($post_id, $details['gallery']);
//        }

        // افزودن ویژگی‌ها به محصول
        if (!empty($details['attributes'])) {
            self::add_product_attributes_to_woocommerce($post_id, $details['attributes']);
        }

        // افزودن متغیرها به محصول
        if (!empty($details['variations'])) {
            self::add_product_variations_to_woocommerce($post_id, $details['variations']);
        }

        // افزودن دسته‌بندی به محصول
        if (!empty($category_name)) {
            wp_set_object_terms($post_id, $category_name, 'product_cat');
            //berozkala_log("Category '$category_name' added to product ID: $post_id");
        }
    }







    private function get_post_by_meta($meta_key, $meta_value) {
        $query = new WP_Query([
            'post_type'  => 'product',
            'meta_key'   => $meta_key,
            'meta_value' => $meta_value,
            'fields'     => 'ids',
        ]);

        return $query->have_posts() ? get_post($query->posts[0]) : null;
    }

    private function set_product_image($post_id, $image_url) {
        if (!$image_url) {
            return; // اگر تصویر وجود ندارد، متوقف شود
        }

        // دانلود و آپلود تصویر
        $upload_dir = wp_upload_dir();
        $image_data = file_get_contents($image_url);
        $filename = basename($image_url);
        $file_path = $upload_dir['path'] . '/' . $filename;

        if (file_put_contents($file_path, $image_data)) {
            $wp_filetype = wp_check_filetype($filename, null);
            $attachment = [
                'post_mime_type' => $wp_filetype['type'],
                'post_title'     => sanitize_file_name($filename),
                'post_content'   => '',
                'post_status'    => 'inherit',
            ];

            $attach_id = wp_insert_attachment($attachment, $file_path, $post_id);
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
            wp_update_attachment_metadata($attach_id, $attach_data);

            // تنظیم تصویر شاخص
            update_post_meta($post_id, '_thumbnail_id', $attach_id);
        }
    }
}


