# Searchwise API Data Feed

## Overview

The **Searchwise API Data Feed** is a WooCommerce extension that enables store owners to generate a structured, customizable JSON feed of their products through a REST API endpoint. The feed includes detailed product information such as pricing, stock status, categories, images, attributes, brand, shipping cost, and delivery time, with options to include variations and full product content.

This plugin is ideal for integrating WooCommerce product data into external systems such as search engines or recommendation systems.

---

## Features

-   Fetch all products or specify products by **IDs** or **slugs**.
-   Include or exclude **product variations**.
-   Supports **pagination** via `limit` and `page` parameters.
-   Optionally include full **product content** (the main description field).
-   Retrieves all **images**, **categories**, **attributes**, **brand**, **shipping cost**, **delivery time**, and **short descriptions**.
-   **API Key authentication** for secure access.

---

## Requirements

-   **WordPress Version:** 5.0 or higher
-   **WooCommerce Version:** 3.5 or higher
-   **PHP Version:** 7.4 or higher

---

## Installation

1.  Download the plugin as a zip file named `searchwise-API-data-feed.zip`.
2.  In your WordPress admin dashboard, navigate to **Plugins → Add New → Upload Plugin**.
3.  Upload the zip file and activate **Searchwise API Data Feed**.
4.  Once activated, the plugin registers the new REST API route.

---

## API Endpoint

### Endpoint

```
POST /wp-json/v1/product/feed
```
### Authentication

The endpoint is protected by API key authentication. A valid `x-api-key` must be included in the request header.

| Header      | Type   | Required | Description                        |
| ----------- | ------ | -------- | ---------------------------------- |
| `x-api-key` | string | Yes      | Your unique API key from Searchwise. |

### Body Parameters

| Parameter         | Type    | Required | Description                                                |
| ----------------- | ------- | -------- | ---------------------------------------------------------- |
| `limit`           | integer | Optional | Number of products per page. Default: `10`.                |
| `page`            | integer | Optional | Page number for pagination. Default: `1`.                  |
| `products`        | string  | Optional | Comma-separated list of product IDs to fetch.              |
| `slugs`           | string  | Optional | Comma-separated list of product slugs to fetch.            |
| `include_content` | boolean | Optional | Whether to include full product content. Default: `false`. |



### Example cURL Request 

```bash
curl -X POST [https://yourdomain.com/wp-json/v1/product/feed](https://yourdomain.com/wp-json/v1/product/feed) \
  -H "Content-Type: application/json" \
  -H "x-api-key: YOUR_API_KEY_HERE" \
  -d '{
    "products": "19,14"
  }'
  ```


---

### Example JSON Response


```json
{
  "products": [
    {
      "id": 19,
      "slug": "product-slug-1",
      "title": "Product Title 1",
      "sale_price": 99.99,
      "regular_price": 119.99,
      "availability": "instock",
      "category": [
        "Category 1",
        "Category 2"
      ],
      "image_link": [
        "[https://example.com/image1.jpg](https://example.com/image1.jpg)",
        "[https://example.com/image2.jpg](https://example.com/image2.jpg)"
      ],
      "link": "[https://example.com/product-slug-1](https://example.com/product-slug-1)",
      "short_description": "Short description of the product.",
      "description": {
        "Color": "Blue",
        "Size": [
          "Medium",
          "Large"
        ]
      },
      "cost_shipping": 5,
      "time_delivery": 3,
      "brand": "MyBrand"
    }
  ],
  "plugin_version": "1.0.1",
  "wc_version": "8.2.0",
  "wp_version": "6.4.0"
}
```
---

## Architecture Overview

### Route Registration

The plugin registers the REST API route `/wp-json/v1/product/feed`, handled by the `Searchwise_WC_Product_Feed_Controller` class.

### Authentication
API requests are authenticated by sending the site domain and the API key (from the x-api-key header) to the Searchwise validation server. Only requests with a valid API key for the corresponding domain are processed.

### Data Retrieval

- **By Product IDs:** Retrieves specific products via their IDs.
- **By Slugs:** Retrieves products via their unique slugs.
- **All Products:** If no filters are provided, returns all products paginated.

### Data Structure

Products are formatted into a clean JSON structure with attributes like price, category, stock status, images, brand, and shipping details.
### Image Retrieval

The API returns the main image and all gallery images for each product.


---

## License

This project is licensed under the **GNU General Public License v2.0 or later**.\
[https://www.gnu.org/licenses/gpl-2.0.html](https://www.gnu.org/licenses/gpl-2.0.html)

---

## Author

Developed by **SearchWise**\
Website: [https://www.searchwise.ir](https://www.searchwise.ir)\
For support or inquiries, contact the Searchwise team.

