<?php

// جلوگیری از دسترسی مستقیم
if (!defined('ABSPATH')) {
    exit;
}
require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
use Sunra\PhpSimple\HtmlDomParser;
class Berozkala_Crawler {

    private $base_url = 'https://berozkala.com'; // دامنه سایت

    /**
     * کرال کردن صفحه دسته‌بندی
     * @param string $category_url URL صفحه دسته‌بندی
     * @return array اطلاعات محصولات
     */
    public function fetch_category_products($category_url) {
        berozkala_log("Fetching category page: $category_url");

        // دریافت HTML صفحه
        $html = $this->get_html($category_url);
        if (!$html) {
            berozkala_log("Failed to fetch category page: $category_url");
            return [];
        }

        berozkala_log("Successfully fetched category page: $category_url");

        // پردازش HTML
        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);

        if (!$dom) {
            berozkala_log("Failed to parse HTML.");
            return [];
        }

        $products = [];

        // استخراج و پردازش محصولات یکی‌یکی
        foreach ($dom->find('ul.products li.item div.item-area') as $product_area) {
            $link_tag = $product_area->find('a.product-image', 0);
            $title_tag = $product_area->find('div.product-detail-area h3 a', 0);
            $price_tag = $product_area->find('span.price ins span.kalastore-price', 0);
            $image_tag = $product_area->find('.product-image img', 0);

            // لینک و ID محصول
            $product_url = $this->base_url . $link_tag->href;
            preg_match('/\/product\/(\d+)\//', $link_tag->href, $matches);
            $product_id = $matches[1] ?? 'Unknown';

            // اطلاعات محصول
            $product = [
                'title' => trim($title_tag->plaintext ?? 'Unknown'),
                'price' => str_replace(',', '', $price_tag->plaintext ?? 0),
                'link'  => $product_url,
                'id'    => $product_id,
                'image' => $image_tag->src ?? null, // اضافه کردن تصویر
            ];

            // ذخیره در آرایه محصولات
            $products[] = $product;

            // نمایش و ثبت لاگ برای هر محصول
            berozkala_log("Processed product: " . json_encode($product));

            // اضافه کردن استراحت کوتاه برای جلوگیری از فشار زیاد به سرور
            usleep(500000); // 0.5 ثانیه
        }

        berozkala_log("Finished processing all products.");

        return $products;
    }



    function fetch_product_details($url) {
        berozkala_log("Fetching product details: $url");

        // دریافت HTML صفحه
        $html = file_get_contents($url);
        if (!$html) {
            berozkala_log("Failed to fetch product page: $url");
            return false;
        }

        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);

        if (!$dom) {
            berozkala_log("Failed to parse product page: $url");
            return false;
        }

        // لاگ کردن بخشی از HTML صفحه برای دیباگ


        // 1. استخراج متغیرها (گارانتی و رنگ)
        $variations = [];
        foreach ($dom->find('input[type=hidden]') as $input) {
            $category = $input->getAttribute('data-attcat');
            $name = $input->getAttribute('data-attname');
            $value = preg_replace('/[^\d.]/', '', $input->value);

            if ($category == '1') { // گارانتی
                $variations['warranty'][] = [
                    'name' => $name,
                    'price' => $value,
                ];
            } elseif ($category == '2') { // رنگ
                $variations['color'][] = [
                    'name' => $name,
                    'price' => $value,
                ];
            }
        }

        // لاگ کردن متغیرها
        if (!empty($variations)) {
//            berozkala_log("Variations found: " . json_encode($variations));
        } else {
            berozkala_log("No variations found.");
        }

        // 2. استخراج گالری
        $gallery = [];
        if ($dom->find('div.thumbnails img')) {
            foreach ($dom->find('div.thumbnails img') as $img) {
                $gallery[] = $img->src;
                berozkala_log("Found gallery image: " . $img->src);
            }
        }

        // لاگ کردن گالری
        if (!empty($gallery)) {
            berozkala_log("Gallery images found: " . json_encode($gallery));
        } else {
            berozkala_log("No gallery images found.");
        }

        // 3. استخراج ویژگی‌ها
        $attributes = [];
        if ($dom->find('table.shop_attributes tr.attribute_row')) {
            foreach ($dom->find('table.shop_attributes tr.attribute_row') as $row) {
                $name = trim($row->find('td.attribute_name', 0)->plaintext ?? '');
                $value = trim($row->find('td.attribute_value', 0)->plaintext ?? '');

                if ($name && $value) {
                    $attributes[] = [
                        'name' => $name,
                        'value' => $value,
                    ];
                    berozkala_log("Found attribute: Name - $name, Value - $value");
                }
            }
        }

        // لاگ کردن ویژگی‌ها
        if (!empty($attributes)) {
//            berozkala_log("Attributes found: " . json_encode($attributes));
        } else {
            berozkala_log("No attributes found.");
        }

        // بازگرداندن اطلاعات استخراج شده
        return [
            'variations' => $variations,
            'gallery' => $gallery,
            'attributes' => $attributes,
        ];
    }







    /**
     * دریافت HTML یک صفحه
     * @param string $url آدرس صفحه
     * @return string|false محتوای HTML یا خطا
     */
    private function get_html($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $html = curl_exec($ch);
        curl_close($ch);

        return $html;
    }

    /**
     * تجزیه HTML صفحه دسته‌بندی
     * @param string $html محتوای HTML صفحه
     * @return array اطلاعات استخراج‌شده
     */
    private function parse_category_html($html) {
        berozkala_log("Parsing category HTML...");
        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
        $dom = HtmlDomParser::str_get_html($html);

        $products = [];
        foreach ($dom->find('ul.products li.item div.item-area') as $product_area) {
            $link_tag = $product_area->find('a.product-image', 0);
            $title_tag = $product_area->find('div.product-detail-area h3 a', 0);
            $price_tag = $product_area->find('span.price ins span.kalastore-price', 0);

            // لینک و ID محصول
            $product_url = $this->base_url . $link_tag->href;
            preg_match('/\/product\/(\d+)\//', $link_tag->href, $matches);
            $product_id = $matches[1] ?? 'Unknown';

            berozkala_log("Processing product: $product_url");

            $products[] = [
                'title' => trim($title_tag->plaintext ?? 'Unknown'),
                'price' => $this->apply_price_markup(str_replace(',', '', $price_tag->plaintext ?? 0)),
                'link'  => $product_url,
                'id'    => $product_id,
            ];
        }

        berozkala_log("Finished parsing category HTML.");
        return $products;
    }


    /**
     * افزایش قیمت با درصد مشخص
     * @param float $price قیمت اصلی
     * @param float $markup درصد افزایش (پیش‌فرض 12%)
     * @return float قیمت نهایی
     */
    private function apply_price_markup($price, $markup = 12) {
        return round($price * (1 + $markup / 100), 2);
    }
}

