<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();

if ( have_posts() ) {
    ?>

    <div class="container">
        <div class="archive-theme" role="main">
            <div style='background-color: #fff;background-image: url("https://th.bing.com/th/id/OIG.JKj_btu1kltl7l39tyqL?pid=ImgGn");' class="head-archive-title">
                <header>
                    جستجو برای : 
                    <span>
                    <?php
                    echo esc_html( get_search_query() );
                    ?>
                    </span>
                </header>
            </div>
            <div class="blog-post archive-posts">

                <?php
                if (have_posts()) {
                    while (have_posts()) : the_post(); ?>
                        <div class="blog-post-item">
                            <a href="<?php echo get_post_permalink() ?>" target="_blank">
                                <div style='background-color: #cccccc;background-image: url(<?php if (get_the_post_thumbnail()) { echo get_the_post_thumbnail_url(); } ?> )' class="blog-post-item-image">
                                    <?php
                                    $video_product = get_post_meta(get_the_ID(), 'meta-box-post-video-1', true);
                                    if (!empty($video_product)) {
                                        ?>
                                        <span class="video-post"><i class="fa-regular fa-circle-play"></i></span>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <div class="blog-post-item-name">
                                    <h2><?php the_title(); ?></h2>
                                </div>
                                <div class="blog-post-item-d-l-a">
                                    <div class="blog-post-item-d-l-a-i">
                                        <i class="fa-light fa-heart"></i>
                                        <span class="like-count">
                                    <?php
                                    $post_id = get_the_ID();
                                    $post_ids = $post_id;
                                    $likes = get_post_meta($post_ids, 'likes', true);
                                    if ($likes) {
                                        echo  $likes;
                                    }
                                    else {
                                        echo 0;
                                    }

                                    ?>
                                </span>
                                    </div>
                                    <div>
                                        <div class="blog-post-item-d-l-a-i blog-post-item-d-l-a-iss">
                                            <i class="fa-light fa-calendar-week"></i>
                                            <?php
                                            $ti = get_the_date("d/m/Y");

                                            $ve = explode("/",$ti);

                                            $dates = gregorian_to_jalali($ve[2],$ve[1],$ve[0]);

                                            $day = $dates[2];
                                            $month = $dates[1];
                                            $year = $dates[0];

                                            $month_name = jdate(' F ', $year . '/' . $month . '/' . $day);

                                            echo $day .' '. $month_name .' ' . $year;
                                            ?>
                                        </div>
                                        <div class="blog-post-item-d-l-a-i">
                                            <i class="fa-solid fa-fire" style="color: #ff0040;"></i>
                                            <span>
                                <?php
                                $post_id = get_the_ID();
                                $views = get_post_meta($post_id, 'views', true);
                                echo  $views." ".'بازدید';
                                ?>
                            </span>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php
                    endwhile;
                }
                ?>
            </div>
            <div class="pagenation">
                <?php echo
                paginate_links(array(
                    'prev_text' => __('قبلی'),
                    'next_text' => __('بعدی')
                ));
                ?>
            </div>
        </div>
    </div>


    <?php
} else {
    get_template_part( 'template-parts/content/content-none' );
}

get_footer();
