<?php

function create_wishlist_page(){

    $page_slug = 'wishlist';
    $page_title = 'لیست علاقه مندی';

    $wishlist_id = get_option('theme_wishlist_id');

    if( $wishlist_id && get_post($wishlist_id) ) {
        // The saved page exists, do nothing
    }
    else {
        // Page doesn't exist, create it

        $page_id = wp_insert_post( array (
            'post_title' => $page_title,
            'post_name' => $page_slug,
            'post_content' => '[vera_list_wishlist]',
            'post_type' => 'page',
            'post_status' => 'publish'
        ) );

        update_option( 'theme_wishlist_id', $page_id );

    }

}

add_action( 'after_setup_theme', 'create_wishlist_page');


/*add theme like post*/
// ثبت نام فرم مورد نیاز برای استفاده از AJAX
add_action('wp_ajax_handle_product_like', 'handle_product_like');
add_action('wp_ajax_nopriv_handle_product_like', 'handle_product_like');
function handle_product_like() {
    $product_id = $_POST['product_id'];
    $users_ip = $_SERVER['REMOTE_ADDR'];
    $like_action = $_POST['like_action']; // این پارامتر را از جاوااسکریپت دریافت می‌کنیم

    // بررسی آیا آیپی کاربر قبلاً لایک کرده یا خیر
    $likeds_ips = get_post_meta($product_id, 'liked_product_ips', true);
    if (!$likeds_ips) {
        $likeds_ips = array();
    }

    if ($like_action == 'add') { // اگر کاربر می‌خواهد لایک کند
        if (in_array($users_ip, $likeds_ips)) { // این شرط را فقط در این حالت بررسی می‌کنیم
            $response = array(
                'success' => false,
                'message' => 'شما قبلاً این پست را لایک کرده‌اید.'
            );
            wp_send_json($response);
        }

        // ثبت لایک و بروزرسانی تعداد لایک‌ها
        $likess = get_post_meta($product_id, 'likes-pro', true);
        $likess = (empty($likess)) ? 1 : $likess + 1;
        update_post_meta($product_id, 'likes-pro', $likess);

        // ثبت آیپی لایک کننده
        $likeds_ips[] = $users_ip;
        update_post_meta($product_id, 'liked_product_ips', $likeds_ips);

        $response = array(
            'success' => true,
            'likes-pro' => $likess,
            'message' => 'پست با موفقیت لایک شد!'
        );
        wp_send_json($response);
    } elseif ($like_action == 'remove') { // اگر کاربر می‌خواهد لایک را حذف کند
        if (!in_array($users_ip, $likeds_ips)) {
            $response = array(
                'success' => false,
                'message' => 'شما این پست را لایک نکرده‌اید.'
            );
            wp_send_json($response);
        }

        // حذف لایک و بروزرسانی تعداد لایک‌ها
        $likess = get_post_meta($product_id, 'likes-pro', true);
        $likess = (empty($likess)) ? 0 : $likess - 1;
        update_post_meta($product_id, 'likes-pro', $likess);

        // حذف آیپی لایک کننده
        $likeds_ips = array_diff($likeds_ips, array($users_ip));
        update_post_meta($product_id, 'liked_product_ips', $likeds_ips);

        $response = array(
            'success' => true,
            'likes-pro' => $likess,
            'message' => 'پست با موفقیت از لیست علاقه‌مندی‌های شما حذف شد!'
        );
        wp_send_json($response);
    } else { // اگر پارامتر like_action نامعتبر باشد
        $response = array(
            'success' => false,
            'message' => 'عملیات نامشخص است.'
        );
        wp_send_json($response);
    }
}

// این عمل را برای بررسی حالت لایک محصول اضافه می‌کنیم
add_action('wp_ajax_check_product_like', 'check_product_like');
add_action('wp_ajax_nopriv_check_product_like', 'check_product_like');
function check_product_like() {
    $product_id = $_POST['product_id'];
    $users_ip = $_SERVER['REMOTE_ADDR'];

    // بررسی آیا آیپی کاربر در آرایه liked_product_ips موجود است یا خیر
    $likeds_ips = get_post_meta($product_id, 'liked_product_ips', true);
    if (!$likeds_ips) {
        $likeds_ips = array();
    }

    if (in_array($users_ip, $likeds_ips)) { // اگر موجود باشد
        $response = array(
            'success' => true,
            'liked' => true, // این مقدار را به جاوااسکریپت می‌فرستیم
            'message' => 'این محصول توسط شما لایک شده است.'
        );
        wp_send_json($response);
    } else { // اگر موجود نباشد
        $response = array(
            'success' => true,
            'liked' => false, // این مقدار را به جاوااسکریپت می‌فرستیم
            'message' => 'این محصول توسط شما لایک نشده است.'
        );
        wp_send_json($response);
    }
}

add_action('wp_enqueue_scripts', 'add_my_scriptss');
function add_my_scriptss() {
    wp_enqueue_script(
        'your-js-filess',
        get_template_directory_uri() . '/js/empty.js',
        array('jquery'),
        '1.0',
        true
    );
    wp_localize_script( 'your-js-filesss', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
}


function get_user_ip(){

    if (!empty($_SERVER['HTTP_CLIENT_IP'])){

        $user_ip = $_SERVER['HTTP_CLIENT_IP'];

    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {

        $user_ip = $_SERVER['HTTP_X_FORWARDED_FOR'];

    } else {

        $user_ip = $_SERVER['REMOTE_ADDR'];

    }

    return $user_ip;

}
function products_list_shortcode(){

    $user_ip = get_user_ip();

    $liked_products = new WP_Query(array(
        'post_type' => 'product',
        'meta_key' => 'liked_product_ips',
        'meta_value' => $user_ip,
        'meta_compare' => 'LIKE'
    ));


    ob_start();

    if($liked_products->have_posts()) {
        ?>
        <div class="products_list_wishlist">
        <?php
        while($liked_products->have_posts()) {
            $liked_products->the_post();

            $product_id = get_the_ID();

            $product_link = get_the_permalink($product_id);
            $product_title = get_the_title($product_id);

            $product_image = get_the_post_thumbnail($product_id, 'thumbnail');

            ?>

            <div class="product_list_wishlist">
                <div class="like-container">
                    <a class="like-buttons" data-product-id="<?php echo $product_id; ?>">حذف از لیست علاقه مندی</a>
                </div>
                <div class="like-containers">
                    <?php
                    global $product;
                    if ($product->is_in_stock()) {
                        echo "<a class='on-stock'>موجود در انبار</a>";
                    } else {
                        echo "<a class='of-stock'>ناموجود در انبار</a>";
                    }
                    ?>
                </div>
                <a target="_blank" href="<?php echo $product_link; ?>">
                <?php echo $product_image; ?>
                <p><?php echo $product_title; ?></p>
                </a>
            </div>

            <?php

        }
        ?>
        </div>
        <?php
        wp_reset_postdata();
    }
    else {
        ?>
<div class="empty-list-wishlist">
    <i class="fa-thin fa-circle-heart"></i>
    <span>لیست علافه مندی شما خالی است!</span>
</div>
<?php
    }

    echo ob_get_clean();

}

add_shortcode('vera_list_wishlist', 'products_list_shortcode');
