<?php
global $options_vera_theme;
/**remove url box-text is comment single**/
add_filter('comment_form_default_fields', 'remove_website_field');
function remove_website_field($fields)
{
    if (isset($fields['url']))
        unset($fields['url']);
    return $fields;
}

/**add code max execution time wordpress**/
add_action('init', 'increase_max_execution_time');
function increase_max_execution_time()
{
    if (!ini_get('safe_mode')) {
        set_time_limit(600); // 300 seconds = 5 minutes
    }
}

/**add template blog.php post wordpress**/
function set_blog_template($template)
{
    if (is_home()) {
        $template = locate_template('blog.php');
    }
    return $template;
}

add_filter('template_include', 'set_blog_template');

/**show categore woo img**/

add_action('woocommerce_before_main_content', 'show_product_categories', 1);

function show_product_categories()
{

    $parentid = get_queried_object_id();

    $args = array('parent' => $parentid);

    $terms = get_terms('product_cat', $args);

    if ($terms) {
        echo '<ul class="product-cats">';

        foreach ($terms as $term) {

            echo '<li class="category">';

            woocommerce_subcategory_thumbnail($term);

            echo '<h2>';

            echo '<a href="' . esc_url(get_term_link($term)) . '" class="' . $term->slug . '">';

            echo $term->name;

            echo '</a>';

            echo '</h2>';

            echo '</li>';

        }

        echo '</ul>';
    }
}

/**option ajax add cart**/

add_action('wp_ajax_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');
add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');

function woocommerce_ajax_add_to_cart()
{

    $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
    $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
    $variation_id = absint($_POST['variation_id']);
    $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
    $product_status = get_post_status($product_id);
    $is_gift = $_POST['is-gift-checkbox'];

    if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

        do_action('woocommerce_ajax_added_to_cart', $product_id);

        if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
            wc_add_to_cart_message(array($product_id => $quantity), true);
        }

        WC_AJAX:: get_refreshed_fragments();
    } else {

        $data = array(
            'error' => true,
            'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));

        echo wp_send_json($data);
    }

    wp_die();
}


/**ajax cart slide**/
function fab_business_shop_scripts()
{
    wp_enqueue_script('ic-cart-ajax', get_template_directory_uri() . '/js/empty.js', array('jquery'), '1.0', true);
    wp_localize_script('ic-cart-ajax', 'my_ajax_object', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ic-mc-nc'),
        )
    );
}

add_action('wp_enqueue_scripts', 'fab_business_shop_scripts');

add_action('wp_ajax_ic_qty_update', 'ic_qty_update');
add_action('wp_ajax_nopriv_ic_qty_update', 'ic_qty_update');

function ic_qty_update()
{
    $key = sanitize_text_field($_POST['key']);
    $number = intval(sanitize_text_field($_POST['number']));

    $cart = [
        'count' => 0,
        'total' => 0,
        'item_price' => 0,
    ];

    if ($key && $number > 0 && wp_verify_nonce($_POST['security'], 'ic-mc-nc')) {
        WC()->cart->set_quantity($key, $number);
        $items = WC()->cart->get_cart();
        $cart = [];
        $cart['count'] = WC()->cart->cart_contents_count;
        $cart['total'] = WC()->cart->get_cart_total();
        $cart['item_price'] = wc_price($items[$key]['line_total']);
    }

    echo json_encode($cart);
    wp_die();
}

// Here I modify two more hooks for plus/minus button
function ic_display_quantity_plus()
{
    echo '<button type="button" class="ic-item-quantity-btn plus" data-type="plus"><i class="fa-solid fa-plus-large"></i></button>';
}

add_action('woocommerce_after_quantity_input_field', 'ic_display_quantity_plus', 10, 2);


add_action('woocommerce_before_quantity_input_field', 'ic_display_quantity_minus');
function ic_display_quantity_minus()
{
    echo '<button type="button" class="ic-item-quantity-btn minus" data-type="minus"><i class="fa-solid fa-minus"></i></button>';
}

/**show quick viwe**/

add_filter('woocommerce_add_to_cart_fragments', 'iconic_cart_count_fragments', 10, 1);
function iconic_cart_count_fragments($fragments)
{

    $fragments['p.header-cart-count'] = '<p class="header-cart-count">' . WC()->cart->get_cart_contents_count() . '</p>';

    return $fragments;

}

add_filter('woocommerce_add_to_cart_fragments', 'iconic_cart_price_fragments', 10, 1);
function iconic_cart_price_fragments($fragments)
{

    $fragments['p.header-cart-price'] = '<p class="header-cart-price">' . WC()->cart->get_cart_total() . '</p>';

    return $fragments;

}

/***/

/**
 * Snippet Name:     WooCommerce Custom Checkbox On Product
 * Snippet Author:   ecommercehints.com
 */

// Add the new field
add_action('woocommerce_before_add_to_cart_button', 'ecommercehints_custom_product_checkbox_field');

function ecommercehints_custom_product_checkbox_field()
{
    echo '<form method="post">';
    echo '<div class="ecommercehints_custom_product_checkbox_field">
      <label for="is_gift">آیا میخواهید محصول کادو شود؟</label>
      
<div class="checkbox-wrapper-12">
  <div class="cbx">
    <input type="checkbox" id="is-gift-checkbox cbx-12" name="is_gift">
    <label for="cbx-12"></label>
    <svg fill="none" viewBox="0 0 15 14" height="14" width="15">
      <path d="M2 8.36364L6.23077 12L13 2"></path>
    </svg>
  </div>
  
  <svg version="1.1" xmlns="http://www.w3.org/2000/svg">
    <defs>
      <filter id="goo-12">
        <feGaussianBlur result="blur" stdDeviation="4" in="SourceGraphic"></feGaussianBlur>
        <feColorMatrix result="goo-12" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 22 -7" mode="matrix" in="blur"></feColorMatrix>
        <feBlend in2="goo-12" in="SourceGraphic"></feBlend>
      </filter>
    </defs>
  </svg>
</div>      
   </div>';
    '</form>';
}

// Save the field to the cart data
add_filter('woocommerce_add_cart_item_data', 'ecommercehints_save_custom_checkbox_to_cart_data', 10, 3);
function ecommercehints_save_custom_checkbox_to_cart_data($cart_item_data, $product_id, $variation_id)
{
    if ($_POST['is_gift'] == "true") {
        $cart_item_data['is_gift'] = $_POST['is_gift'];
    } else {
        $cart_item_data['is_gift'] = null;
    }
    return $cart_item_data;
}

// Show custom field data on cart, checkout, and thank you page.
add_filter('woocommerce_get_item_data', 'ecommercehints_show_custom_field_data_under_product_name', 10, 2);
function ecommercehints_show_custom_field_data_under_product_name($item_data, $cart_item)
{
    if ($cart_item['is_gift'] == "true") {
        ?>
        <i id="gift-icon-cat-page" class="fas fa-gift"></i>
        <?php
    }
    return $item_data;
}

// Save the custom field data as order meta
add_action('woocommerce_checkout_create_order_line_item', 'ecommercehints_add_custom_field_data_as_order_meta', 10, 4);
function ecommercehints_add_custom_field_data_as_order_meta($item, $cart_item_key, $values, $order)
{
    if ($values['is_gift'] == "true") {
        $item->add_meta_data('آیا میخواهید محصول کادو شود؟', $values['is_gift']);
    }
}

add_action('woocommerce_before_calculate_totals', 'ecommercehints_add_gift_amount_to_product');
function ecommercehints_add_gift_amount_to_product($cart)
{
    if (is_admin() && !defined('DOING_AJAX')) {
        return;
    }
    global $options_vera_theme;
    $gift_amount = $options_vera_theme['on-off-masiat-shop-admi312123n'];

    foreach ($cart->get_cart() as $cart_item_key => $cart_item) {
        if ($cart_item['is_gift'] == "true") {
            $product = $cart_item['data'];
            $price = $product->get_price();

            $product->set_price($price + $gift_amount);
        }
    }
}

/*add aption color piker attrebuti*/
/*ساخت خودکار ویژگی در هنگان setup*/
if ( function_exists( 'is_woocommerce' ) ) {
    $created_color_attr = false;
    add_action('init', 'create_color_attribute');
    function create_color_attribute()
    {
        global $created_color_attr;
        if ($created_color_attr)
            $attr = null;
        $attr = wc_get_attribute('color');
        if (!$attr) {
            $args = array(
                'name' => 'رنگ',
                'slug' => 'color',
                'type' => 'select',
                'order_by' => 'menu_order',
                'has_archives' => false
            );
            wc_create_attribute($args);
        }
    }
}
else {

     }

// اضافه کردن فیلد رنگ به فرم ایجاد مقدار جدید
function add_color_field_new_term($term_id)
{
    $color = get_term_meta($term_id, 'color', true);
    woocommerce_wp_text_input(
        array(
            'id' => 'color',
            'label' => "<br><p>انتخاب رنگ</p>",
            'type' => 'color',
            'value' => $color,
            'description' => "<br><p style='padding: 0 0 10px;color: #dc163e;'>رنگ این مشخصه را میتوانید از این بخش انتخاب کنید و این رنگ در صورت انتخاب در صفحه محصول در کنار لیبل نمایش خواهد گرفت در غیر این صورت به طور لیبل تک نمایش خواهد گرفت</p>",
        )
    );
}

function add_color_field_update_term($term_id)
{
    $term_id = $_GET['tag_ID'];
    $color = get_term_meta($term_id, 'color', true);
    woocommerce_wp_text_input(
        array(
            'id' => 'color',
            'label' => "<br><p>انتخاب رنگ</p>",
            'type' => 'color',
            'value' => $color,
            'description' => "<br><p style='padding: 0 0 10px;color: #dc163e;'>رنگ این مشخصه را میتوانید از این بخش تغییر دهید و این رنگ در صورت انتخاب در صفحه محصول در کنار لیبل نمایش خواهد گرفت در غیر این صورت به طور لیبل تک نمایش خواهد گرفت</p>",
        )
    );
}

add_action('pa_color_edit_form_fields', 'add_color_field_update_term', 10, 1);
add_action('pa_color_add_form_fields', 'add_color_field_new_term', 10, 1);

// ذخیره رنگ انتخاب شده
function save_color_new_term($term_id)
{
    if (isset($_POST['color'])) {
        update_term_meta($term_id, 'color', sanitize_hex_color($_POST['color']));
    }
}

add_action('created_pa_color', 'save_color_new_term', 10, 1);

function save_color_edit_term($term_id)
{
    if (isset($_POST['color'])) {
        update_term_meta($term_id, 'color', sanitize_hex_color($_POST['color']));
    }
}

add_action('edited_pa_color', 'save_color_edit_term', 10, 1);

/*add notification wordpress attribute*/
function attributes_page_notice()
{
    echo '<div style="line-height:24px;padding: 15px 10px;border-right-color: #dc163e !important;border-radius: 10px;" class="notice notice-info">راهنمای ویژگی رنگبندی : کاربران عزیز ویژگی رنگبندی با قابلیت انتخاب رنگ در ویژگی ایجاد شده به صورت خودکار توسط قالب موجود میباشد به قسمت مشخصه های ویژگی در ویژگی رنگ با نامک color مراجعه و رنگ های خود را ایجاد کنید توجه کنید قابلیت رنگبندی تنها در صورت استفاده از نامک color  اضافه خواهد شد توجه کنید در صورت حذف این ویژگی مجدد ویژگی با این نام به صورت خودکار برای شما ایجاد میگردد</div>';
}

add_action('woocommerce_before_add_attribute_fields', 'attributes_page_notice');


/*add email masages email stock product*/

// ایجاد یک جدول برای ذخیره ایمیل های کاربران
function create_email_table()
{
    global $wpdb;
    global $created_table;
    if (!$created_table) {
        $table_name = $wpdb->prefix . 'email_form';
        $charset_collate = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        product_id mediumint(9) NOT NULL,
        email varchar(100) NOT NULL,
        PRIMARY KEY  (id)
    ) $charset_collate;";
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
        $created_table = true;
    }
}

// فراخوانی تابع بالا در هنگام فعال شدن قالب
add_action('init', 'create_email_table');

// اضافه کردن یک فرم ایمیل به صفحه محصولات ناموجود
function add_email_form()
{
    global $product;
    // بررسی اینکه محصول موجود نباشد
    if (!$product->is_in_stock()) {
        // نمایش فرم ایمیل با استفاده از ایجکس
        ?>
        <div id="email-form">
            <p class="text-stock-email">این محصول در حال حاضر موجود نیست. اگر می‌خواهید وقتی محصول موجود شد به شما اطلاع
                داده شود، ایمیل خود را وارد کنید.</p>
            <button class="button-stock-revers">
                <i class="fa-light fa-bell"></i>
                خبرم کن
            </button>

            <div class="pop-up-form-stock">
                <form id="email-form-submit" method="post">
                    <input type="hidden" name="product_id" value="<?php echo $product->get_id(); ?>">
                    <input type="email" name="email" placeholder="ایمیل خود را وارد کنید" required>
                    <input type="submit" value="ثبت ایمیل">
                </form>
            </div>
            <div id="email-form-message"></div>
        </div>
        <script>
            jQuery(document).ready(function ($) {
                // ارسال فرم ایمیل با ایجکس
                $('#email-form-submit').submit(function (e) {
                    e.preventDefault();
                    var data = $(this).serialize();
                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: data + '&action=save_email_form',
                        success: function (response) {
                            $('#email-form-message').html(response);
                            $('form#email-form-submit').removeClass('loadingss');
                            $('form#email-form-submit').addClass("pop-up-form-stock-close");
                            $('.text-stock-email').addClass("pop-up-form-stock-close");
                        }
                    });
                });
            });
        </script>
        <?php
    }
}

// فراخوانی تابع بالا در هنگام نمایش صفحه محصول
add_action('woocommerce_single_product_summary', 'add_email_form', 31);

// ذخیره ایمیل کاربر در جدول ایجاد شده
function save_email_form()
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'email_form';
    // دریافت داده های فرم ایمیل
    $product_id = $_POST['product_id'];
    $email = $_POST['email'];
    // بررسی اینکه ایمیل معتبر باشد
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // بررسی اینکه ایمیل تکراری نباشد
        $exists = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE product_id = %d AND email = %s", $product_id, $email));
        if ($exists > 0) {
            echo '<p style="font-weight: 400;color: #fb8d18;background: rgba(255,195,75,0.48);padding: 10px;text-align: center;border-radius: 7px;border: 1px solid #fb8d18;">ایمیل شما قبلا ثبت گردیده است.</p>';

        } else {
            // ذخیره ایمیل در جدول
            $wpdb->insert($table_name, array('product_id' => $product_id, 'email' => $email));
            echo '<p style="font-weight: 400;color: #0fad49;background: rgba(44,249,81,0.35);padding: 10px;text-align: center;border-radius: 7px;border: 1px solid #0fad49;">ایمیل شما با موفقیت ثبت شد.</p>';
        }
    } else {
        echo '<p style="font-weight: 400;color: #f94646;background: #fd4d4d57;padding: 10px;text-align: center;border-radius: 7px;border: 1px solid #f94646;">ایمیل وارد شده معتبر نیست.</p>';
    }
    wp_die();
}

// فراخوانی تابع بالا با استفاده از ایجکس
add_action('wp_ajax_save_email_form', 'save_email_form');
add_action('wp_ajax_nopriv_save_email_form', 'save_email_form');

// ارسال ایمیل به کاربران وقتی محصول موجود شد
function send_email_when_in_stock($product_id)
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'email_form';
    // دریافت ایمیل های مربوط به محصول
    $emails = $wpdb->get_col($wpdb->prepare("SELECT email FROM $table_name WHERE product_id = %d", $product_id));
    if (!empty($emails)) {
        // ایجاد متن ایمیل
        $product = wc_get_product($product_id);

        $subject = 'محصول مورد نظر شما موجود شد';
        $message = '
        <html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
  	<meta name="viewport" content="width=device-width, initial-scale=1.0;">
 	<meta name="format-detection" content="telephone=no"/>

	<!-- Responsive Mobile-First Email Template by Konstantin Savchenko, 2015.
	https://github.com/konsav/email-templates/  -->

	<style>
/* Reset styles */ 
body { margin: 0; padding: 0; min-width: 100%; width: 100% !important; height: 100% !important;}
body, table, td, div, p, a { -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%; }
table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse !important; border-spacing: 0; }
img { border: 0; line-height: 100%; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; }
#outlook a { padding: 0; }
.ReadMsgBody { width: 100%; } .ExternalClass { width: 100%; }
.ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div { line-height: 100%; }

/* Rounded corners for advanced mail clients only */ 
@media all and (min-width: 560px) {
	.container { border-radius: 8px; -webkit-border-radius: 8px; -moz-border-radius: 8px; -khtml-border-radius: 8px;}
}

/* Set color for auto links (addresses, dates, etc.) */ 
a, a:hover {
	color: #127DB3;
}
.footer a, .footer a:hover {
	color: #999999;
}

 	</style>

</head>

<!-- BODY -->
<!-- Set message background color (twice) and text color (twice) -->
<body topmargin="0" rightmargin="0" bottommargin="0" leftmargin="0" marginwidth="0" marginheight="0" width="100%" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%; height: 100%; -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%;
	background-color: #F0F0F0;
	color: #000000;"
	bgcolor="#F0F0F0"
	text="#000000">

<!-- SECTION / BACKGROUND -->
<!-- Set message background color one again -->
<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%;" class="background"><tr><td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;"
	bgcolor="#F0F0F0">


<!-- WRAPPER / CONTEINER -->
<!-- Set conteiner background color -->
<table border="0" cellpadding="0" cellspacing="0" align="center"
	bgcolor="#FFFFFF"
	width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
	max-width: 560px;" class="container">

	<!-- HEADER -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif") -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 24px; font-weight: bold; line-height: 130%;
			padding-top: 25px;
			color: #000000;
			font-family: sans-serif;" class="header">
				محصول '.$product->get_name().' موجود شد!
		</td>
	</tr>
	



	<!-- PARAGRAPH -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif"). Duplicate all text styles in links, including line-height -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
			padding-top: 25px; 
			color: #000000;
			font-family: sans-serif;" class="paragraph">
          خوشحالیم که محصولی که منتظرش بودید موجود شد شما میتوانید همین الان با کلیک کردن روی دکمه پایین به صفحه محصول '.$product->get_name().' مراجعه کرده و آن را تهیه کنید  	
	        </td>
	       
	    </tr>

	<!-- BUTTON -->
	<!-- Set button background color at TD, link/text color at A and TD, font family ("sans-serif" or "Georgia, serif") at TD. For verification codes add "letter-spacing: 5px;". Link format: http://domain.com/?utm_source={{Campaign-Source}}&utm_medium=email&utm_content={{Button-Name}}&utm_campaign={{Campaign-Name}} -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%;
			padding-top: 25px;
			padding-bottom: 5px;" class="button"><a
			href="https://github.com/konsav/email-templates/" target="_blank" style="text-decoration: underline;">
				<table border="0" cellpadding="0" cellspacing="0" align="center" style="max-width: 240px; min-width: 120px; border-collapse: collapse; border-spacing: 0; padding: 0;"><tr><td align="center" valign="middle" style="padding: 12px 24px; margin: 0; text-decoration: none; background: blue; border-collapse: collapse; border-spacing: 0; border-radius: 4px; -webkit-border-radius: 4px; -moz-border-radius: 4px; -khtml-border-radius: 4px;"
					bgcolor="#E9703E"><a target="_blank" style="text-decoration: none;
					color: #FFFFFF; font-family: sans-serif; font-size: 17px; font-weight: 400; line-height: 120%;"
					href=' . $product->get_permalink() . '>
						هدایت به صفحه محصول
					</a>
			</td></tr></table></a>
		</td>
	</tr>


<!-- End of WRAPPER -->
</table>

</body>
</html>
        ';
        $headers = array('Content-Type: text/html; charset=UTF-8 ','From: '. get_bloginfo("name") .' <person.name@example.com>');
        // ارسال ایمیل به هر کاربر
        foreach ($emails as $email) {
            wp_mail($email, $subject, $message, $headers);
        }
        // حذف ایمیل ها از جدول
        $wpdb->delete($table_name, array('product_id' => $product_id));
    }
}

// فراخوانی تابع بالا در هنگام تغییر وضعیت محصول به موجود
add_action('woocommerce_product_set_stock_status', 'send_email_when_in_stock', 10, 2);


/*add code category shop*/
function get_primary_product_category($product_id)
{
    $product_categories = wc_get_product_category_list($product_id);
    if ($product_categories) {
        $categories = explode(", ", $product_categories);
        return $categories[0];
    } else {
        return false;
    }
}


/**
 * Display available attributes.
 *
 * @return array|void
 */
function iconic_available_attributes()
{
    global $product;

    if (!$product->is_type('variable')) {
        return;
    }

    $attributes = iconic_get_available_attributes($product);

    if (empty($attributes)) {
        return;
    }

    foreach ($attributes as $attribute) {
        ?>
        <div class="iconic-available-attributes">
            <?php
            $colors_shown = 0;
            foreach ($attribute['values'] as  $value) {
                if ($colors_shown == 3 ) {
                    ?>
                    <div style="border: 0 !important;border-radius: 0 !important;box-shadow: none !important;" class="item-color-shop-loop-tootal">
                        <i style="opacity: .5;text-decoration: none;color: #222;font-size: 11px;margin: auto;text-align: center;width: 100%;" class="fas fa-plus"></i>
                    </div>
                    <?php
                    break;
                }
                $color = $value['color'];

                if ($color) {
                    $colors_shown++;

                    ?>
                    <div class="item-color-shop-loop-tootal" style="background-color:<?php echo $color ?>;">
                        <span><?php echo $value['name']; ?></span></div>
                    <?php
                }
                ?>

            <?php } ?>

        </div>
        <?php
    }
}

add_action('woocommerce_shop_loop_item_title', 'iconic_available_attributes', 20);

/**
 * Get available attributes.
 *
 * @param WC_Product_Variable $product
 *
 * @return array
 */
function iconic_get_available_attributes($product)
{
    static $available_attributes = array();

    $product_id = $product->get_id();

    if (isset($available_attributes[$product_id])) {
        return $available_attributes[$product_id];
    }

    $available_attributes[$product_id] = array();

    $attributes = $product->get_variation_attributes();

    if (empty($attributes)) {
        return $available_attributes[$product_id];
    }

    $attributes_to_show = iconic_get_attributes_to_show();

    foreach ($attributes as $attribute => $values) {
        if (!in_array($attribute, $attributes_to_show)) {
            continue;
        }

        $available_attribute = iconic_get_available_attribute($product, $attribute, $values);

        if (empty($available_attribute)) {
            continue;
        }

        $available_attributes[$product_id][] = $available_attribute;
    }

    return $available_attributes[$product_id];
}

function iconic_get_attributes_to_show()
{
    return apply_filters('iconic_get_attributes_to_show', array(
        'pa_color',
    ));
}

/**
 * Get available attribute.
 *
 * @param WC_Product_Variable $product
 * @param string $attribute
 * @param array $values
 *
 * @return array
 */
function iconic_get_available_attribute($product, $attribute, $values)
{
    $available_attribute = array(
        'slug' => $attribute,
    );

    if (!taxonomy_exists($attribute)) {
        $available_attribute['name'] = $attribute;

        foreach ($values as $value) {
            $available_attribute['values'][$value] = array(
                'name' => $value,
                'available' => iconic_has_available_variation($product, $attribute, $value),
            );
        }

        return $available_attribute;
    }

    $taxonomy = get_taxonomy($attribute);
    $labels = get_taxonomy_labels($taxonomy);

    $available_attribute['name'] = $labels->singular_name;
    $available_attribute['values'] = array();

    foreach ($values as $value) {
        $term = get_term_by('slug', $value, $attribute);

        if (!$term) {
            continue;
        }
        $color = get_term_meta($term->term_id, 'color', true);

        $available_attribute['values'][$value] = array(
            'name' => $term->name,
            'available' => iconic_has_available_variation($product, $attribute, $value),
            'color' => $color
        );

    }

    return $available_attribute;
}


/**
 * Has available variation?
 *
 * @param WC_Product_Variable $product
 * @param string $attribute
 * @param string $value
 *
 * @return bool
 */
function iconic_has_available_variation($product, $attribute, $value)
{
    $available_variation = false;
    $attribute = 'attribute_' . sanitize_title($attribute);
    $variations = $product->get_available_variations();

    if (empty($variations)) {
        return $available_variation;
    }

    foreach ($variations as $variation) {
        foreach ($variation['attributes'] as $variation_attribute_name => $variation_attribute_value) {
            if ($attribute !== $variation_attribute_name) {
                continue;
            }

            if ($value !== $variation_attribute_value && !empty($variation_attribute_value)) {
                continue;
            }

            $available_variation = $variation['is_purchasable'] && $variation['is_in_stock'];
            break;
        }

        if ($available_variation) {
            break;
        }
    }

    return $available_variation;
}


add_filter('woocommerce_get_price_html', 'cssigniter_change_variable_price_display', 10, 2);
function cssigniter_change_variable_price_display($price, $product_obj)
{
    global $product;

    if ('variable' !== $product->get_type() || 'product_variation' === $product_obj->post_type) {
        return $price;
    }

    $prices = array($product->get_variation_price('min', true), $product->get_variation_price('max', true));
    // Translators: %s is the lowest variation price.
    $price = $prices[0] !== $prices[1] ? sprintf(__('<div class="price-vera_start_p">' . 'شروع قیمت : %s' . '</div>', 'your-text-domain'), wc_price($prices[0])) : wc_price($prices[0]);

    return $price;
}

/*add filed name | frest - last and form regester $ login vera theme woocommerce*/
// 1.اضافه کردن فیلد ها

add_action('woocommerce_register_form_start', 'bbloomer_add_name_woo_account_registration');

function bbloomer_add_name_woo_account_registration()
{
    ?>

    <p class="form-row form-row-first">
        <label for="reg_billing_first_name"><?php _e('First name', 'woocommerce'); ?> <span
                    class="required">*</span></label>
        <input type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name"
               value="<?php if (!empty($_POST['billing_first_name'])) esc_attr_e($_POST['billing_first_name']); ?>"/>
    </p>

    <p class="form-row form-row-last">
        <label for="reg_billing_last_name"><?php _e('Last name', 'woocommerce'); ?> <span
                    class="required">*</span></label>
        <input type="text" class="input-text" name="billing_last_name" id="reg_billing_last_name"
               value="<?php if (!empty($_POST['billing_last_name'])) esc_attr_e($_POST['billing_last_name']); ?>"/>
    </p>

    <div class="clear"></div>

    <?php
}


add_filter('woocommerce_registration_errors', 'bbloomer_validate_name_fields', 10, 3);

function bbloomer_validate_name_fields($errors, $username, $email)
{
    if (isset($_POST['billing_first_name']) && empty($_POST['billing_first_name'])) {
        $errors->add('billing_first_name_error', __('<strong>Error</strong>: First name is required!', 'woocommerce'));
    }
    if (isset($_POST['billing_last_name']) && empty($_POST['billing_last_name'])) {
        $errors->add('billing_last_name_error', __('<strong>Error</strong>: Last name is required!.', 'woocommerce'));
    }
    return $errors;
}

///////////////////////////////
// 3. ذخیره فیلد ها

add_action('woocommerce_created_customer', 'bbloomer_save_name_fields');

function bbloomer_save_name_fields($customer_id)
{
    if (isset($_POST['billing_first_name'])) {
        update_user_meta($customer_id, 'billing_first_name', sanitize_text_field($_POST['billing_first_name']));
        update_user_meta($customer_id, 'first_name', sanitize_text_field($_POST['billing_first_name']));
    }
    if (isset($_POST['billing_last_name'])) {
        update_user_meta($customer_id, 'billing_last_name', sanitize_text_field($_POST['billing_last_name']));
        update_user_meta($customer_id, 'last_name', sanitize_text_field($_POST['billing_last_name']));
    }

}

/*add form login & regester code*/

function encode($code)
{
    $mapping = array(
        '0' => '3',
        '1' => '7',
        '2' => '1',
        '3' => '9',
        '4' => '2',
        '5' => '5',
        '6' => '8',
        '7' => '4',
        '8' => '6',
        '9' => '0'
    );

    $result = '';
    for ($i = 0; $i < strlen($code); $i++) {
        $digit = $code[$i];
        if (array_key_exists($digit, $mapping)) {
            $result .= $mapping[$digit];
        } else {
            $result .= $digit;
        }
    }

    return $result;
}
function decode($encoded_code)
{
    $mapping = array(
        '3' => '0',
        '7' => '1',
        '1' => '2',
        '9' => '3',
        '2' => '4',
        '5' => '5',
        '8' => '6',
        '4' => '7',
        '6' => '8',
        '0' => '9'
    );

    $result = '';
    for ($i = 0; $i < strlen($encoded_code); $i++) {
        $digit = $encoded_code[$i];
        if (array_key_exists($digit, $mapping)) {
            $result .= $mapping[$digit];
        } else {
            $result .= $digit;
        }
    }

    return $result;
}

function send_and_verfi_code()
{
    if (strpos($_POST['number_phone'], '+980') == 0) {
        $nimber_user = str_replace("980", "98", $_POST['number_phone']);
    }
    $nimber_edit = "";
    $nimber_edit = $nimber_user;
    if (strpos($nimber_edit, '+98') == 0) {
        $nimber_edit = str_replace("+98", "", $nimber_edit);
    }
    if ($nimber_edit[0] == "0") {
        $nimber_edit = substr_replace($nimber_edit, "", 0, 1);
    }
    global $options_vera_theme;
    if ($options_vera_theme['text-admin-account-shop-21231-4'] == 1) {
        $random = rand(1111, 9999);
    }
    if ($options_vera_theme['text-admin-account-shop-21231-4'] == 2) {
        $random = rand(11111, 99999);
    }
    if ($options_vera_theme['text-admin-account-shop-21231-4'] == 3) {
        $random = rand(111111, 999999);
    }

    setcookie("phone_number_send_number_regester", $nimber_edit, time() + 1200);

    setcookie("phone_number_user_edit", $nimber_edit, time() + 1200);
    setcookie("phone_number", $nimber_user, time() + 1200);
    $incode_randoms = $random;
    $incode_random = encode("$incode_randoms");
    setcookie("code_number", $incode_random, time() + 1200);

    global $wpdb;
    $user_id = $wpdb->get_var("SELECT user_id FROM {$wpdb->prefix}usermeta WHERE meta_key = 'billing_phones' AND meta_value = '$nimber_edit'");
    $response = array();
    if ($user_id) {
        $respanse = send_sms("$nimber_user", "$random");
        $exprode_res = explode('"', $respanse);
        $exprode_ress = strlen($exprode_res[3]);
        if ($exprode_ress >= 14) {
            $response['message'] = "پیام به شماره وارد شده ارسال گردید";
            $response['status'] = 'success';
            http_response_code(200); // OK
        } else {
            $response['status'] = 'error';
            $response['message'] = "در ارسال کد خطایی به وجود آمد کد خطا: " . "$exprode_ress";
            http_response_code(404); // Not Found
        }
    } else {
        $response['status'] = 'info';
        $response['message'] = "$nimber_edit";
        http_response_code(400);
    }
    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_send_and_verfi_code', 'send_and_verfi_code');
add_action('wp_ajax_nopriv_send_and_verfi_code', 'send_and_verfi_code');

function send_sms($phone_number, $code)
{
    global $options_vera_theme;
    $user_name_melle_sms = $options_vera_theme["text-admin-account-shop-21231"];
    $pass_melle_sms = $options_vera_theme["text-admin-account-shop-21231-2"];
    $code_body_melle_sms = $options_vera_theme["text-admin-account-shop-56121231-3"];
    $data = array(
        "username" => "$user_name_melle_sms",
        "password" => "$pass_melle_sms",
        "text" => array("$code"),
        "to" => "$phone_number",
        "bodyId" => $code_body_melle_sms
    );
    $post_data = http_build_query($data);
    $handle = curl_init('https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber');
    curl_setopt($handle, CURLOPT_HTTPHEADER, array(
        'content-type' => 'application/x-www-form-urlencoded'
    ));
    curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($handle, CURLOPT_POST, true);
    curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);
    $response = curl_exec($handle);
    return $response;
}

function confirm_and_verfi_code()
{
    $nomber_user = $_COOKIE['phone_number_user_edit'];
    $code_confirm = $_COOKIE['code_number'];
    $decode_code = decode("$code_confirm");

    $response = array();
    if ($_POST['number_code'] == $decode_code ) {
        global $wpdb;
        $user_id = $wpdb->get_var("SELECT user_id FROM {$wpdb->prefix}usermeta WHERE meta_key = 'billing_phones' AND meta_value = '$nomber_user'");
        $user = get_user_by('id', $user_id);
        wp_set_auth_cookie("$user_id",true);
        wp_set_current_user("$user_id", $user->user_login);
        $response['message'] = "شما با موفقیت وارد حساب کاربری خود شدید! در حال هدایت...";
        $response['status'] = 'success';
        http_response_code(200);
    } else {
        $response['status'] = 'error';
        $response['message'] = "کد تایید شما نامعتبر است لطفا دوباره سعی کنید!";
        http_response_code(404); // Not Found
    }
    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_confirm_and_verfi_code', 'confirm_and_verfi_code');
add_action('wp_ajax_nopriv_confirm_and_verfi_code', 'confirm_and_verfi_code');

function resend_and_verfi_code()
{
    $nomber_user = $_COOKIE['phone_number'];
    global $options_vera_theme;
    if ($options_vera_theme['text-admin-account-shop-21231-4'] == 1) {
        $random = rand(1111, 9999);
    }
    if ($options_vera_theme['text-admin-account-shop-21231-4'] == 2) {
        $random = rand(11111, 99999);
    }
    if ($options_vera_theme['text-admin-account-shop-21231-4'] == 3) {
        $random = rand(111111, 999999);
    }
    $incode_randoms = $random;
    $incode_random = encode("$incode_randoms");
    setcookie("code_number", $incode_random, time() + 1200);
    $response = array();

    $respanse = send_sms("$nomber_user", "$random");
    $exprode_res = explode('"', $respanse);
    $exprode_ress = strlen($exprode_res[3]);
    if ($exprode_ress >= 14) {
        $response['message'] = "کد تایید مجدد به شماره شما ارسال گردید!";
        $response['status'] = 'success';
        http_response_code(200); // OK
    } else {
        $response['status'] = 'error';
        $response['message'] = "در ارسال کد خطایی به وجود آمد کد خطا: " . "$exprode_res[3]";
        http_response_code(404); // Not Found
    }
    echo json_encode($response);
    wp_die();
}

add_action('wp_ajax_resend_and_verfi_code', 'resend_and_verfi_code');
add_action('wp_ajax_nopriv_resend_and_verfi_code', 'resend_and_verfi_code');
function pass_and_verfi()
{
    $nomber_user = $_COOKIE['phone_number_user_edit'];
    $code_confirm = $_POST['pass_code'];
    $response = array();
    global $wpdb;
    $user_id = $wpdb->get_var("SELECT user_id FROM {$wpdb->prefix}usermeta WHERE meta_key = 'billing_phones' AND meta_value = '$nomber_user'");
    $user = get_user_by('id', $user_id);

    $user = wp_signon(array(
        'user_login' => $user->user_login,
        'user_password' => $code_confirm,
        'remember' => true
    ));
    if (is_wp_error($user)) {
        $response['status'] = 'error';
        $response['message'] = 'رمز وارد شده صحیح نمیباشد لطفا دوباره سعی نمایید!';

    } else {
        wp_set_auth_cookie($user_id,true);
        wp_set_current_user($user_id);
        $response['status'] = 'success';
        $response['message'] = 'شما با موفقیت وارد حساب کاربری خود شدید! در حال هدایت ...';

    }

    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_pass_and_verfi', 'pass_and_verfi');
add_action('wp_ajax_nopriv_pass_and_verfi', 'pass_and_verfi');

function regester_form_submit()
{
    $your_frest_name = $_POST['your_frest_name'];
    $your_last_name = $_POST['your_last_name'];
    $your_mail = $_POST['your_email'];

    $your_phone = $_POST['your_phone'];
    $your_pass = $_POST['your_pass'];
    $random = rand(1111, 9999);
    setcookie("frest_name", $your_frest_name, time() + 1200);
    setcookie("last_name", $your_last_name, time() + 1200);
    setcookie("your_mail", $your_mail, time() + 1200);
    setcookie("your_pass", $your_pass, time() + 1200);
    setcookie("random_code_regester", $random, time() + 1200);
    $response = array();

    if (strpos($your_phone, '+980') == 0) {
        $your_phone = str_replace("980", "98", $your_phone);
    }


    $nimber_edit = "";
    $nimber_edit = $your_phone;
    if (strpos($nimber_edit, '+98') == 0) {
        $nimber_edit = str_replace("+98", "", $nimber_edit);
    }
    if ($nimber_edit[0] == "0") {
        $nimber_edit = substr_replace($nimber_edit, "", 0, 1);
    }
    setcookie("your_phone", $nimber_edit, time() + 1200);

    global $wpdb;
    $user_id = $wpdb->get_var("SELECT user_id FROM {$wpdb->prefix}usermeta WHERE meta_key = 'billing_phones' AND meta_value = '$nimber_edit'");
    $user = get_user_by('id', $user_id);
    $users = email_exists($your_mail);
    if (!empty($users) || $user) {
        $response['status'] = 'error';
        $response['message'] = 'خطا شما حساب کاربری با این ایمیل قبلا ایجاد کرده اید';
    } else {
        $respanse = send_sms("$your_phone", "$random");
        $exprode_res = explode('"', $respanse);
        $exprode_ress = strlen($exprode_res[3]);
        if ($exprode_ress >= 14) {
            $response['message'] = "پیام به شماره وارد شده ارسال گردید";
            $response['status'] = 'success';
            http_response_code(200); // OK
        } else {
            $response['status'] = 'error';
            $response['message'] = "در ارسال کد خطایی به وجود آمد کد خطا: " . "$exprode_ress";
            http_response_code(404); // Not Found
        }
    }

    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_regester_form_submit', 'regester_form_submit');
add_action('wp_ajax_nopriv_regester_form_submit', 'regester_form_submit');

function regester_form_submit_code()
{
    $your_frest = $_COOKIE['frest_name'];
    $your_last = $_COOKIE['last_name'];
    $your_phone = $_COOKIE['your_phone'];
    $your_email = $_COOKIE['your_mail'];
    $your_pass = $_COOKIE['your_pass'];
    $your_code_random = $_COOKIE['random_code_regester'];
    $your_input_code = $_POST['filed_conferm_regester'];
    if ($your_input_code == $your_code_random) {
        $user_id = wp_create_user($your_phone, $your_pass, $your_email);
        update_user_meta($user_id, 'first_name', $your_frest);
        update_user_meta($user_id, 'last_name', $your_last);
        update_user_meta($user_id, 'billing_email', $your_email);
        update_user_meta($user_id, 'billing_phones', $your_phone);
        $response['status'] = 'success';
        $response['message'] = 'ثبت نام شما با موفقیت انجام گردید در حال هدایت صفحه...';
        wp_set_auth_cookie($user_id,true);
        wp_set_current_user($user_id);
    } else {
        $response['status'] = 'error';
        $response['message'] = 'متاسفانه کد وارد شده صحیح نمیباشد';
    }
    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_regester_form_submit_code', 'regester_form_submit_code');
add_action('wp_ajax_nopriv_regester_form_submit_code', 'regester_form_submit_code');

function regester_form_submit_email()
{
    $response = array();

    $your_email = $_POST['filed_email_regester'];
    setcookie("email_address", $your_email, time() + 1200);
    if (filter_var($your_email, FILTER_VALIDATE_EMAIL)) { //Invalid Email
        $user = get_user_by('email', $your_email);
    } else {
        $user = get_user_by('login', $your_email);
    }
    if ($user) {
        $response['status'] = 'success';
    } else {
        $response['status'] = 'error';
        $response['message'] = $your_email;
    }
    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_regester_form_submit_email', 'regester_form_submit_email');
add_action('wp_ajax_nopriv_regester_form_submit_email', 'regester_form_submit_email');

function regester_form_submit_email_pass()
{
    $response = array();
    $password = $_POST['pass_email_regester'];
    $your_email = $_COOKIE['email_address'];
    if (filter_var($your_email, FILTER_VALIDATE_EMAIL)) { //Invalid Email
        $user = get_user_by('email', $your_email);
    } else {
        $user = get_user_by('login', $your_email);
    }


    if ($user && wp_check_password($password, $user->data->user_pass, $user->ID)) {
        $creds = array('user_login' => $user->data->user_login, 'user_password' => $password);
        $user = wp_signon($creds, false);
        wp_set_auth_cookie($user->ID,true);

        $response['status'] = 'success';
        $response['message'] = 'شما با موفقیت وارد حساب کاربری خود شدید! در حال هدایت ...';
    } else {
        $response['status'] = 'error';
        $response['message'] = 'رمز عبور شما صحیح نمیباشد لطفا دوباره سعی نمایید!';
    }

    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_regester_form_submit_email_pass', 'regester_form_submit_email_pass');
add_action('wp_ajax_nopriv_regester_form_submit_email_pass', 'regester_form_submit_email_pass');

function regester_form_email_submit()
{
    $response = array();
    $your_frest_name = $_POST['your_frest_name_r'];
    $your_last_name = $_POST['your_last_name_r'];
    $your_mail = $_POST['your_email_r'];
    $your_pass = $_POST['your_pass_r'];
    $check_mail = email_exists($your_mail);
    if (empty($check_mail)) {
        if (!empty($your_frest_name) && !empty($your_last_name) && !empty($your_mail) && !empty($your_pass)) {
            $user_id = wp_create_user($your_mail, $your_pass, $your_mail);
            update_user_meta($user_id, 'first_name', $your_frest_name);
            update_user_meta($user_id, 'last_name', $your_last_name);
            $response['status'] = 'success';
            $response['message'] = 'شما با موفقیت حساب کاربری خود را ایجاد کردید! در حال هدایت ...';
            wp_set_auth_cookie($user_id,true);
            wp_set_current_user($user_id);
        } else {
            $response['status'] = 'info';
            $response['message'] = 'لطفا فیلد های فرم ثبت نام را تکمیل و سپس اقدام به ثبت فرم کنید!';
        }
    } else {
        $response['status'] = 'info';
        $response['message'] = 'ایمیل وارد شده قبلا در سایت حساب کاربری ایجاد کرده است لطفا یا از صحت ایمیل خود اطمینان حاصل فرمایید یا از طریق فرم ورود با ایمیل اقداام به ورود به حساب کاربری خود کنید در صورت فراموشی رمز عبور از بخش فراموشی رمز عبور استفاده نمایید';
    }

    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_regester_form_email_submit', 'regester_form_email_submit');
add_action('wp_ajax_nopriv_regester_form_email_submit', 'regester_form_email_submit');

function send_email_form_email_submit()
{
    $your_mail_repass = $_POST['send_email_password'];
    if (filter_var($your_mail_repass, FILTER_VALIDATE_EMAIL)) {
        $user = get_user_by('email', $your_mail_repass);
    } else {
        $user = get_user_by('login', $your_mail_repass);
    }
    if (!$user) {
        $response['status'] = 'info';
        $response['message'] = 'ایمیل و نام کاربری شما در سایت یافت نشد لطفا از صحت ایمیل و یا نام کاربری خود اطمینان حاصل فرموده و سپس اقدام به ارسال ایمیل فرمایید';
    } else {
        $new_pass = wp_generate_password();
        wp_set_password($new_pass, $user->ID);
        $subject = "بازنشانی رمز در سایت";
        $message = '
        <html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
  	<meta name="viewport" content="width=device-width, initial-scale=1.0;">
 	<meta name="format-detection" content="telephone=no"/>

	<!-- Responsive Mobile-First Email Template by Konstantin Savchenko, 2015.
	https://github.com/konsav/email-templates/  -->

	<style>
/* Reset styles */ 
body { margin: 0; padding: 0; min-width: 100%; width: 100% !important; height: 100% !important;}
body, table, td, div, p, a { -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%; }
table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse !important; border-spacing: 0; }
img { border: 0; line-height: 100%; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; }
#outlook a { padding: 0; }
.ReadMsgBody { width: 100%; } .ExternalClass { width: 100%; }
.ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div { line-height: 100%; }

/* Rounded corners for advanced mail clients only */ 
@media all and (min-width: 560px) {
	.container { border-radius: 8px; -webkit-border-radius: 8px; -moz-border-radius: 8px; -khtml-border-radius: 8px;}
}

/* Set color for auto links (addresses, dates, etc.) */ 
a, a:hover {
	color: #127DB3;
}
.footer a, .footer a:hover {
	color: #999999;
}

 	</style>

</head>

<!-- BODY -->
<!-- Set message background color (twice) and text color (twice) -->
<body topmargin="0" rightmargin="0" bottommargin="0" leftmargin="0" marginwidth="0" marginheight="0" width="100%" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%; height: 100%; -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%;
	background-color: #F0F0F0;
	color: #000000;"
	bgcolor="#F0F0F0"
	text="#000000">

<!-- SECTION / BACKGROUND -->
<!-- Set message background color one again -->
<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%;" class="background"><tr><td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;"
	bgcolor="#F0F0F0">


<!-- WRAPPER / CONTEINER -->
<!-- Set conteiner background color -->
<table border="0" cellpadding="0" cellspacing="0" align="center"
	bgcolor="#FFFFFF"
	width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
	max-width: 560px;" class="container">

	<!-- HEADER -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif") -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 24px; font-weight: bold; line-height: 130%;
			padding-top: 25px;
			color: #000000;
			font-family: sans-serif;" class="header">
				' . get_bloginfo('name'). '
		</td>
	</tr>
	
	<!-- SUBHEADER -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif") -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-bottom: 3px; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 14px; font-weight: 300; line-height: 150%;
			padding-top: 5px;
			color: #000000;
			font-family: sans-serif;" class="subheader">
				بازنشانی رمز عبور حساب کاربری
		</td>
	</tr>


	<!-- PARAGRAPH -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif"). Duplicate all text styles in links, including line-height -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
			padding-top: 25px; 
			color: #000000;
			font-family: sans-serif;" class="paragraph">
          سلام و درود خدمت شما . طبق درخواستی که در فروشگاه ثبت کرده بودید رمز جدید ورود به حساب کاربری شما تغییر یافت و رمز به شرح زیر میباشد توجه کنید برای افزایش امنیت حساب کاربری پس از ورود به حساب کاربری خود در فروشگاه از طریق ویرایش اطلاعات اقدام به تغییر رمز کنید
	        </td>
	    </tr>

	<!-- BUTTON -->
	<!-- Set button background color at TD, link/text color at A and TD, font family ("sans-serif" or "Georgia, serif") at TD. For verification codes add "letter-spacing: 5px;". Link format: http://domain.com/?utm_source={{Campaign-Source}}&utm_medium=email&utm_content={{Button-Name}}&utm_campaign={{Campaign-Name}} -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%;
			padding-top: 25px;
			padding-bottom: 5px;" class="button"><a
			 target="_blank" style="text-decoration: underline;">
				<table border="0" cellpadding="0" cellspacing="0" align="center" style="max-width: 240px; min-width: 120px; border-collapse: collapse; border-spacing: 0; padding: 0;"><tr><td align="center" valign="middle" style="padding: 12px 24px; margin: 0; text-decoration: none; background: blue; border-collapse: collapse; border-spacing: 0; border-radius: 4px; -webkit-border-radius: 4px; -moz-border-radius: 4px; -khtml-border-radius: 4px;"
					bgcolor="#E9703E"><a  style="text-decoration: none;
					color: #FFFFFF; font-family: sans-serif; font-size: 17px; font-weight: 400; line-height: 120%;">
						' . $new_pass . '
					</a>
			</td></tr></table></a>
		</td>
	</tr>


<!-- End of WRAPPER -->
</table>

</body>
</html>
        ';
        $headers = array('Content-Type: text/html; charset=UTF-8 ','From: '. get_bloginfo("name") .' <person.name@example.com>');
        $stutos_send_mail = wp_mail($user->user_email, $subject, $message, $headers);
        if ($stutos_send_mail) {
            $response['status'] = 'success';
            $response['message'] = 'ایمیل حاوی روز عبور به آدرس ایمیل شما ارسال گردید توجه فرمایید بعد از دریافت رمز حتما از طریق حساب کاربری اقدام به تغییر رمز عبور خود نمایید';
        }
        else {
            $response['status'] = 'info';
            $response['message'] = 'مشکلی در ارسال ایمیل بازنشانی پیش آمده!';

        }
    }


    echo json_encode($response);

    wp_die();
}

add_action('wp_ajax_send_email_form_email_submit', 'send_email_form_email_submit');
add_action('wp_ajax_nopriv_send_email_form_email_submit', 'send_email_form_email_submit');

/*نمایش اطلاعات کاربر لاگین شده در هدر*/
function display_user_login_d()
{
    ob_start();
    $current_user = wp_get_current_user();
    echo $current_user->user_firstname . ' ' . $current_user->user_lastname . '<br />';
    $output = ob_get_clean();
    return $output;
}

/*هدایت ووکامرس بعد از خروج از account*/
add_action( 'wp_logout', 'owp_redirect_after_logout' );
function owp_redirect_after_logout() {
         wp_redirect( home_url() );
         exit();
}


/*نمایش تاریخ عضویت کاربری woocommerce*/
function display_date_login_d()
{
    ob_start();
    $current_user = wp_get_current_user();
    $date_edit = explode(" " , $current_user->user_registered);
    echo $date_edit[0];
    $output = ob_get_clean();
    $ve = explode("-", $output);
    $dates = gregorian_to_jalali($ve[0], $ve[1], $ve[2]);
    $day = $dates[0];
    $year = $dates[2];
    $outputs = $year . ' / ' . $dates[1] . ' / ' . $day;
    return $outputs;
}
/*نمایش یوزر نیم کاربری woocommerce*/
function display_username_login_d()
{
    ob_start();
    $current_user = wp_get_current_user();
    echo $current_user->user_login;
    $output = ob_get_clean();
    return $output;
}
/*ایجاد سطح جدید برای وضعیت سفارش ووکامرس*/
$new_order_statuses = array(
    'wc-delivered' => array(
        'label' => 'ارسال شده',
        'public' => true,
        'exclude_from_search' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
    )
);
register_post_status('wc-delivered', $new_order_statuses);
function add_new_order_statuses($order_statuses) {
    $order_statuses['wc-delivered'] = 'ارسال شده';
    return $order_statuses;
}
add_filter('wc_order_statuses', 'add_new_order_statuses');
/*تغییر نام وضعیت سفارش در حال انجام*/
function change_processing_label( $order_statuses ) {
    $order_statuses['wc-processing'] = 'در حال پردازش';
    return $order_statuses;
}
add_filter( 'wc_order_statuses', 'change_processing_label' );
/*ایجاد فیلد کد پیگیری مرسوله فروشگاه*/
add_action( 'woocommerce_admin_order_data_after_order_details', 'add_custom_order_field');
function add_custom_order_field( $order ){
    echo '<p><strong>کد پیگیری پستی:</strong><br/><input type="text" name="tracking_code" value="' . get_post_meta( $order->id, '_tracking_code', true ) . '" /></p>';
}
// ذخیره مقدار فیلد جدید هنگام ذخیره سفارش
add_action( 'woocommerce_process_shop_order_meta', 'save_tracking_code_field' );
function save_tracking_code_field( $order_id ) {
    if( isset($_POST['tracking_code']) ) {
        update_post_meta( $order_id, '_tracking_code', sanitize_text_field( $_POST['tracking_code'] ) );
    }
}
/*نمایش ستون کد پیگیری در بخش سفارش ها*/
add_filter( 'manage_edit-shop_order_columns', 'add_new_order_column');
function add_new_order_column($columns) {
    $columns['tracking_code'] = 'کد پیگیری پستی';
    return $columns;
}
add_action( 'manage_shop_order_posts_custom_column' , 'fill_order_column');
function fill_order_column($column) {
    global $post;

    if( $column == 'tracking_code' ) {
        $value = get_post_meta( $post->ID, '_tracking_code', true );
        echo $value;
    }
}
/*نمایش کد پیگیری در بخش سفارشات  حساب کاربری*/
add_action('woocommerce_order_details_after_order_table', 'jamy_add_button');

function jamy_add_button($order) {
    $tracking_code = get_post_meta( $order->get_id(), '_tracking_code', true );
    if (!empty($tracking_code)) {
        echo '<p style="padding: 10px;background: #fff;border: 1px solid #ddd;border-radius: 7px; }">کد رهگیری: ' . $tracking_code . '</p>';
    }
}
/*پیگیری سفارش ایجکس ویرا تم*/
function order_vera_theme_display_tracking() {
    ?>
    <script>
        jQuery(document).ready(function ($) {

            $(".open_tracking_vera_order").click(function () {
                $('.tracking_order_veras').addClass('tracking_order_veras_open');
            })
            $(".close_tracking_vera_order").click(function () {
                $('.tracking_order_veras').removeClass('tracking_order_veras_open');
                $('.tracking_order_vera h3').html("پیگیری سفارش");
                $('#phone-form-message_323').removeClass("display_block_form");
                $('#tracking_vera_order').removeClass("display_none_form");
                $('#tracking_order_vera_table').html("");
                $('.tracking_order_vera .loading_form_vera').removeClass("loadingss");
                $('.tracking_order_vera input[type="text"]').val("");
            })
            $(".tracking_order_verass").click(function () {
                $('.tracking_order_veras').removeClass('tracking_order_veras_open');
                $('.tracking_order_vera h3').html("پیگیری سفارش");
                $('#phone-form-message_323').removeClass("display_block_form");
                $('#tracking_vera_order').removeClass("display_none_form");
                $('#tracking_order_vera_table').html("");
                $('.tracking_order_vera .loading_form_vera').removeClass("loadingss");
                $('.tracking_order_vera input[type="text"]').val("");
            })
            $('#tracking_vera_order').submit(function (e) {
                $('.tracking_order_vera .loading_form_vera').addClass("loadingss");
                e.preventDefault();
                var data = $(this).serialize();
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: data + '&action=action_ajax_trackings',
                    success: function (response) {
                        response = JSON.parse(response);

                        if (response.status === 'error') {
                            $('.tracking_order_vera .loading_form_vera').removeClass("loadingss");
                            $('#phone-form-message_323').html(response.message);
                            $('#phone-form-message_323').addClass("display_block_form");

                        } else if (response.status === 'success') {
                            $('.tracking_order_vera .loading_form_vera').removeClass("loadingss");
                            $('#tracking_order_vera_table').html(response.message);
                            $('#tracking_vera_order').addClass("display_none_form");
                            $('.tracking_order_vera h3').html("وضعیت سفارش شما");
                            $('#phone-form-message_323').removeClass("display_block_form");

                        }
                    }
                });
            });
        });
    </script>
    <div class="tracking_order_veras">
        <div class="tracking_order_verass"></div>
        <div class="tracking_order_vera">
            <i class="fa-light fa-circle-xmark close_tracking_vera_order"></i>
            <h3>پیگیری سفارش</h3>
            <div id="tracking_order_vera_table"></div>

            <span class="loading_form_vera"></span>
            <form method="post" id="tracking_vera_order">
                <input type="text" placeholder="شماره سفارش خود را وارد نمایید" class="tracking_vera" name="tracking_code_order">
                <input type="submit" class="tracking_submit" value="پیگیری سفارش">
            </form>
            <p id="phone-form-message_323"></p>
        </div>
    </div>

    <?php
}
function action_ajax_trackings() {
    $response = array();

    $order = wc_get_order( $_POST['tracking_code_order'] );
    if ( !empty( $order ) ) {
        $order_data = $order->get_data();
        $order_number = $order_data['id'];
        $order_total = $order->get_total();
        $order_date = $order->get_date_created();
        $order_datess = $order->get_payment_method_title();
        $order_status = $order->get_status();
        $tracking_code = get_post_meta( $_POST['tracking_code_order'], '_tracking_code', true );



        if($order_status == "completed") {
            $order_status = "پایان مراحل سفارش";
        }
        if($order_status == "processing") {
            $order_status = "در حال پردازش";
        }
        if($order_status == "delivered") {
            $order_status = "ارسال شده به مقصد";
        }

        if($order_status == "trash") {
            $order_status = "حذف شده";
        }
        if($order_status == "on-hold") {
            $order_status = "در انتظار تایید";
        }
        if($order_status == "cancelled") {
            $order_status = "لغو شده";
        }
        if($order_status == "refunded") {
            $order_status = "مسترد شده";
        }
        $order_name_biling =  $order_data['billing']['first_name']." ".$order_data['billing']['last_name'];
        $date_created =  $order_data['date_created']->date('Y-m-d H:i:s');
        $date_modified =  $order_data['date_modified']->date('Y-m-d H:i:s');



        $date_edit = explode(" " , $date_created);
        $output = $date_edit[0];
        $ve = explode("-", $output);
        $dates = gregorian_to_jalali($ve[0], $ve[1], $ve[2]);
        $day = $dates[0];
        $year = $dates[2];
        $date_created = $day . '/' . $dates[1] . '/' . $year . ' | ' . $date_edit[1];

        $date_editss = explode(" " , $date_modified);
        $outputss = $date_editss[0];
        $vess = explode("-", $outputss);
        $datesss = gregorian_to_jalali($vess[0], $vess[1], $vess[2]);
        $dayss = $datesss[0];
        $yearss = $datesss[2];
        $date_modified = $dayss . '/' . $datesss[1] . '/' . $yearss . ' | ' . $date_editss[1];


        $get_shipping_method =  $order->get_shipping_method();

        $response['status'] = 'success';
        $response['message'] = "
        <div class='dillet_message_tracking'>
<table id='customers'>
  <tr>
    <th>کد سفارش</th>
    <th>نام مشتری</th>
    <th>وضعیت سفارش</th>
    <th>محصولات سفارش</th>
    <th>روش پرداخت</th>
    <th>روش حمل و نقل</th>
    <th>تاریخ سفارش</th>
    <th>تاریخ تکمیل سفارش</th>
    <th>کد پیگیری مرسوله</th>
  </tr>
  <tr>
    <td>$order_number</td>
    <td>$order_name_biling</td>
    <td>$order_status</td>
    <td> ---- </td>
    <td>$order_datess</td>
    <td>$get_shipping_method</td>
    <td>$date_created</td>
    <td>$date_modified</td>
    <td>$tracking_code</td>
  </tr>
 
</table>
<style>
#customers {
  font-family:IRANYekanX;
  border-collapse: collapse;
  width: 100%;
  font-weight: 500;
}

#customers td, #customers th {
  border: 1px solid #ddd;
  padding: 8px;
   font-family: iranyekanX;
    -moz-font-feature-settings: 'ss02' !important;
    -webkit-font-feature-settings: 'ss02' !important;
    font-feature-settings: 'ss02' !important;
}

#customers tr:nth-child(even){background-color: #f2f2f2;}

#customers tr:hover {background-color: #ddd;}
.dillet_message_tracking {
    width: 100%;
    overflow: auto;
}

#customers th {
    padding-top: 12px;
    padding-bottom: 12px;
    text-align: right;
    width: fit-content;
    background-color: #04AA6D;
    color: white;
}

</style>
        </div>
        ";
    }
    else {
        $response['status'] = 'error';
        $response['message'] = "شماره سفارش شما یافت نشد";
    }


    echo json_encode($response);
    wp_die();
}

add_action('wp_ajax_action_ajax_trackings', 'action_ajax_trackings');
add_action('wp_ajax_nopriv_action_ajax_trackings', 'action_ajax_trackings');
add_shortcode("tracking_vera","order_vera_theme_display_tracking");
/*فیلتر وضعیت در صفحه حساب من بخش سفارشات*/
// 1. Let orders query listen to URL parameter

add_filter( 'woocommerce_my_account_my_orders_query', 'ts_my_account_orders_filter_by_status' );

function ts_my_account_orders_filter_by_status( $args ) {
    if ( isset( $_GET['status'] ) && ! empty( $_GET['status'] ) ) {
        $args['status'] = array( $_GET['status'] );
    }
    return $args;
}

// ------------
// 2. Display list of filters

add_action( 'woocommerce_before_account_orders', 'ts_my_account_orders_filters' );

function ts_my_account_orders_filters() {
    echo '<div class="filter_order_account">';
    echo '<p><span class="filter_order_account_head">فیلتر بر اساس</span> ';
    $customer_orders = 0;
    foreach ( wc_get_order_statuses() as $slug => $name ) {
        $status_orders = count( wc_get_orders( [ 'status' => $slug, 'customer' => get_current_user_id(), 'limit' => -1 ] ) );
        if ( $status_orders > 0 ) {
            if ( isset( $_GET['status'] ) && ! empty( $_GET['status'] ) && $_GET['status'] == $slug ) {
                echo '<b>' . $name . ' (' . " " . $status_orders . " " . ')</b><span class="delimit">  </span>';
            } else echo '<a class="order_filters_stutos" href="' . add_query_arg( 'status', $slug, wc_get_endpoint_url( 'orders' ) ) . '">' . $name . ' (' . " " . $status_orders ." ". ')</a><span class="delimit">  </span>';
        }
        $customer_orders += $status_orders;
    }
    echo '</p>';
    echo '</div>';
}

// ------------
// 3. My Account Orders Pagination fix

add_filter( 'woocommerce_get_endpoint_url', 'ts_my_account_orders_filter_by_status_pagination', 9999, 4 );

function ts_my_account_orders_filter_by_status_pagination( $url, $endpoint, $value, $permalink ) {
    if ( 'orders' == $endpoint && isset( $_GET['status'] ) && ! empty( $_GET['status'] ) ) {
        return add_query_arg( 'status', $_GET['status'], $url );
    }
    return $url;
}

/*start search box form ajax code js - php vera (post - page - product) */
function foreach_search_resoult() {
    global $options_vera_theme;
    $foreach_searc = $options_vera_theme['repeater-field-data-noticdsdsd']['text_field-notifications-2252525'];
    $result = '';
    if (!empty($foreach_searc)) {
        foreach ($foreach_searc as $resoult_serach_item) {
            $result .= '<a class="swiper-slide" href="' . home_url() . '/?s=' . $resoult_serach_item . '&post_type=product">' . $resoult_serach_item . '</a>';
        }
    }
    else {
        $result = "";
    }
    return $result;
}
function foreach_search_resoults() {
    global $options_vera_theme;
    $foreach_searc = $options_vera_theme['options-image-search_ads']['url'];
    $foreach_searcs = $options_vera_theme['text_field-notifications-225252sdsdgfdg5'];
    if (!empty($foreach_searc)) {
        $foreach_search = '<a href='.$foreach_searcs.'><img src='. $foreach_searc .'></a>';
    }
    else {
        $foreach_search = '';
    }
    return $foreach_search;
}
function foreach_search_resoultsss() {
    global $options_vera_theme;
    $foreach_searc = $options_vera_theme['text_field-notifications-225252sdsd5'];
    if (!empty($foreach_searc)) {
        $foreach_search = $foreach_searc;
    }
    else {
        $foreach_search = 'جستجو های پیشنهادی';
    }
    return $foreach_search;
}
function foreach_search_resoultssss() {
    global $options_vera_theme;
    $foreach_searc = $options_vera_theme['text-search-box-one'];
    if (!empty($foreach_searc)) {
        $foreach_search = $foreach_searc;
    }
    else {
        $foreach_search = 'محصول مورد نظر خود را جستجو کنید';
    }
    return $foreach_search;
}
add_shortcode( 'asearch', 'asearch_func' );
function asearch_func( $atts ) {
    $atts = shortcode_atts( array(
        'source' => 'page,post,product',
        'image' => 'true',
        'plaseholder' => 'جستجو',
    ), $atts, 'asearch' );
    static $asearch_first_call = 1;
    $source = $atts["source"];
        $image = $atts["image"];
    $plase = $atts["plaseholder"];
    $sForam = '<div class="search_bar">
    <form class="asearch" id="asearch product_search'.$asearch_first_call.'" role="search" action='. esc_url(home_url('/')).' method="get" autocomplete="off">
        <input type="text" placeholder="'.foreach_search_resoultssss().'" id="keyword" class="input_search" onkeyup="searchFetch(this)" name="s"/>
        <button id="mybtn" value='. esc_attr_x('', 'submit button', 'woocommerce').'
                class="button">
        <svg version="1.0" id="katman_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 600 450" style="enable-background:new 0 0 600 450;" xml:space="preserve">
<style type="text/css">
	.st0{fill-rule:evenodd;clip-rule:evenodd;}
</style>
<path class="st0" d="M394.8,213.5c0,58.9-47.7,106.6-106.6,106.6c-58.9,0-106.6-47.7-106.6-106.6c0-58.9,47.7-106.6,106.6-106.6
	C347.1,106.9,394.8,154.6,394.8,213.5z M412.5,304.3c18.6-25.5,29.6-56.8,29.6-90.8c0-85-68.9-153.9-153.9-153.9
	c-85,0-153.9,68.9-153.9,153.9c0,85,68.9,153.9,153.9,153.9c34,0,65.4-11,90.8-29.6l46.4,46.4c9.2,9.3,24.2,9.3,33.5,0
	c9.3-9.2,9.3-24.2,0-33.5L412.5,304.3z"/>
</svg>
</button>
        <input type="hidden" name="post_type" value="product"/>

    </form><div class="search_result" id="datafetch" style="display: none;">
        <ul>
            <li>در حال جستجو<i class="fa-thin fa-spinner fa-spin-pulse"></i></li>
        </ul>
    </div>
    
<div class="focosed_input_search">
'.foreach_search_resoults().'
<div class="hestore_search_ajax_he">
<p><i class="fa-solid fa-fire"></i>'. foreach_search_resoultsss() .'</p>
<div class="hestore_link__he_ajax_tag_a">
                    <div class="swiper mySwiper-search_ajax">
                      <div class="swiper-wrapper">
                      '. foreach_search_resoult() .'
                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
       </div>
</div>
</div>

    </div>';
    $java = '<script>
function searchFetch(e) {
var datafetch = e.parentElement.nextSibling
if (e.value.trim().length > 1) { datafetch.style.display = "block"; $(".focosed_input_search").hide(); } else { datafetch.style.display = "none"; $(".focosed_input_search").show(); }
const searchForm = e.parentElement;	
    

e.nextSibling.value = "در حال جستجو..."
var formdata'.$asearch_first_call.' = new FormData(searchForm);
formdata'.$asearch_first_call.'.append("source", "'.$source.'") 
formdata'.$asearch_first_call.'.append("image", "'.$image.'") 
formdata'.$asearch_first_call.'.append("action", "asearch") 
AjaxAsearch(formdata'.$asearch_first_call.',e) 
}
async function AjaxAsearch(formdata,e) {
  const url = "'.admin_url("admin-ajax.php").'?action=asearch";
  const response = await fetch(url, {
      method: "POST",
      body: formdata,
  });
  const data = await response.text();
if (data){	e.parentElement.nextSibling.innerHTML = data}else  {
e.parentElement.nextSibling.innerHTML = `<ul><a style="text-align:center;width:100%;float:right" href="#" class="not_product_searches"><li>محصولی با جستجوی شما یافت نشد!</li></a></ul>`
}}	
document.addEventListener("click", function(e) {

  if(e.target.closest(".focosed_input_search")) {
    return;
  }

  if (document.activeElement.classList.contains("input_search") == false ) {
    [...document.querySelectorAll("div.search_result")].forEach(e => e.style.display = "none");
    $(".focosed_input_search").hide();
    $(".back_asearch_window").hide();
  } else {
    if  (e.target.value.trim().length > 1) {
      e.target.parentElement.nextSibling.style.display = "block";
      $(".back_asearch_window").show();
    }
  }

});
</script>';
    $css = '<style>form.asearch {display: flex;flex-wrap: nowrap;border-radius: 5px;padding: 3px 5px;}
.focosed_input_search .swiper-button-next:after {
    font-size: 15px;
     color: #222222;
    }
    .focosed_input_search .swiper-button-next.swiper-button-disabled, .focosed_input_search .swiper-button-prev.swiper-button-disabled {
     opacity: .5; 
     cursor: auto; 
    pointer-events: unset;
}
    .focosed_input_search .swiper-button-next {
    height: 0;
    line-height: 1;
    font-size: 10px;
    background: #fff;
    padding: 20px 7px !important;
    border-radius: 50%;
     display: flex; 
     align-items: center; 
    border: 1px solid #ddd;
}
.focosed_input_search .swiper-button-prev:after {
 font-size: 15px;
 color: #222222;
}
.focosed_input_search .swiper-button-prev {
 height: 0;
    line-height: 1;
    font-size: 10px;
    background: #fff;
    padding: 20px 7px !important;
    border-radius: 50%;
     display: flex; 
     align-items: center; 
    border: 1px solid #ddd;
}
.back_asearch_window {
    position: fixed;
    content: " ";
    width: 100%;
    height: 100%;
    top: 0;
    bottom: 0;
    right: 0;
    left: 0;
    z-index: 999;
    animation: animateshow .5s;
    animation-fill-mode: forwards;
}
form.asearch button#mybtn {
    padding: 5px;
    cursor: pointer;
    background: none;
    width: 10%;
}
.focosed_input_search {
    position: absolute;
    right: 0;
    left: 0;
    top: 110%;
    overflow: hidden;
    background: #fff;
    border: 1px solid #ddd;
    display: none;
    padding: 10px;
    border-radius: 10px;
}
.focosed_input_search img {
border-radius: 10px;
margin: 0 auto;
width: 100%;
height: auto;
}
.focosed_input_search p {
    padding: 15px 0 10px;
    text-align: right;
    font-weight: 400;
    font-size: 15px;
    display: flex;
    align-items: center;
}
.focosed_input_search p i {
    order: -1;
    padding-left: 7px;
    font-size: 20px;
    font-weight: 300;
    opacity: .5;
}
.focosed_input_search .hestore_link__he_ajax_tag_a {
width: 100%;
float: right;
}
.focosed_input_search .hestore_link__he_ajax_tag_a a {
    text-decoration: none;
    color: #222222;
    background: #FFFFFF;
    border: .5px solid #ddd;
    padding: 7px 10px;
    border-radius: 10px;
    margin: 3px 0;
    text-align: center;
    width: max-content !important;
    float: right;
    transition: all .3s ease-in-out;
    font-size: 12px;
    -moz-font-feature-settings: "ss02" !important;
    -webkit-font-feature-settings: "ss02" !important;
    font-feature-settings: "ss02" !important;
}
.focosed_input_search .swiper {
	width: 95%;
	overflow: unset;
}
 .focosed_input_search .swiper .swiper-button-prev {
	right: -15px !important;

}
 .focosed_input_search .swiper  .swiper-button-next{
	left: -15px !important;
}
form.asearch button#mybtn svg {
    width: 100%;
    fill: #bfbfbf;
    transition: all .3s ease-in-out;
}
form.asearch button#mybtn:hover svg{
   opacity: .7;
}
form.asearch input#keyword {border: none;}
div#datafetch {
    background: white;
    z-index: 10;
    position: absolute;
    max-height: 425px;
    overflow: auto;
    border: 1px solid #ddd;
    right: 0;
    left: 0;
    top: 105%;
    border-radius: 10px;
}

div#datafetch {
    scrollbar-color: var(--main-color3) rgba(255, 255, 255, 0.38);
    scrollbar-width: auto;
    transition: none !important;
}

div#datafetch::-webkit-scrollbar {
    width: 8px;
    background: #cccccc;
    border-radius: 5px;
}

div#datafetch::-webkit-scrollbar-track {
    background: #cccccc;
    border-radius: 5px;
}

div#datafetch::-webkit-scrollbar-thumb {
    background: rgba(44, 62, 80, 0.46) !important;
    border-radius: 5px;
}

div#datafetch::-webkit-scrollbar-thumb:hover {
    background: #cccccc;
    border-radius: 5px;
}

div.search_bar {
    width: 600px!important;
    max-width: 90%!important;
    position: relative;
}

div.search_result ul a li {
    margin: 0px;
    padding: 5px 0px;
    padding-inline-start: 18px;
    color: #3f3f3f;
    font-weight: 400;
    text-align: right !important;
     -moz-font-feature-settings: "ss02" !important;
    -webkit-font-feature-settings: "ss02" !important;
    font-feature-settings: "ss02" !important;
}
div.search_result li {
    margin-inline-start: 20px;
    text-align: center;
    padding: 20px 0;
    font-weight: 500;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #b3b3b3;
}
div.search_result li i {
    order: -1;
    margin-left: 10px;
    float: right;
    font-size: 20px;
}
div.search_result ul {
    padding: 0;
    list-style: none;
    margin: auto;
}

div.search_result ul a {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 5px;
    padding: 10px;
    text-decoration: none;
    text-align: right;
}
div.search_result ul a:hover {
    background-color: #f3f3f3;
}
.asearch input#keyword {
    width: 100%;
}
.title_product_he_ajax {
    display: grid !important;
    justify-items: start;
}
.title_product_he_ajax .price_search_he_ajax {
    text-align: right;
    width: 100%;
    padding-top: 5px;
}
.title_product_he_ajax .price_search_he_ajax bdi {

}
.title_product_he_ajax .price_search_he_ajax bdi .woocommerce-Price-currencySymbol{
padding-right: 3px;
}
.title_product_he_ajax .price_search_he_ajax bdi .woocommerce-Price-currencySymbol:after{
content:var(--main-content);
}
.title_product_he_ajax .price_search_he_ajax ins {
text-decoration: none;
}
.title_product_he_ajax .price_search_he_ajax del {
opacity: .7;
}
.image_search_he_ajax {
width: 15%;
text-align: center;
}
.image_search_he_ajax img {
width: auto;
height: 60px;
border-radius: 3px;
}
</style>';
    if ( $asearch_first_call == 1 ){
        $asearch_first_call++;
        return "{$sForam}{$java}{$css}"; } elseif  ( $asearch_first_call > 1 ) {
        $asearch_first_call++;
        return "{$sForam}"; }}

add_action('wp_ajax_asearch' , 'asearch');
add_action('wp_ajax_nopriv_asearch','asearch');
function asearch(){
    $the_query = new WP_Query( array( 'posts_per_page' => 10, 's' => esc_attr( $_POST['s'] ), 'post_type' =>  explode(",", esc_attr( $_POST['source'] )))  );
    if( $the_query->have_posts() ) :
        echo '<ul>';
        while( $the_query->have_posts() ): $the_query->the_post(); ?>
            <a href="<?php echo esc_url( post_permalink() ); ?>">
                <li class="title_product_he_ajax"><?php the_title();?><br><p class="price_search_he_ajax"><?php global $product; echo $product->get_price_html();?></p></li>
                <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single-post-thumbnail' );?>
                <?php if ( $image[0] && trim(esc_attr( $_POST['image'] )) == "true" ) {  ?>  <div class="image_search_he_ajax"><img src="<?php the_post_thumbnail_url('thumbnail'); ?>" style="height: 60px;padding: 0px 5px;"></div>  <?php }  ?> </a>
        <?php endwhile;
        echo '</ul>';
        wp_reset_postdata();
    endif;
    die();
}




function function_short_mail_regester_shop() {
    ?>
        <form class="regester_mail_shops" method="post" action="">
            <span id="loading_regester_mail"></span>
            <input name="email_address" type="email" placeholder="ایمیل خود را وارد کنید">
            <button type="submit"><span class="button_regester_newslatter_form"></span>عضویت</button>
        </form>
        <div class="notification_regester_mail_shop_error"></div>
        <div class="notification_regester_mail_shop_socces"></div>
<script>
    jQuery(document).ready(function ($) {
        $('.regester_mail_shops').submit(function (e) {
            $('.button_regester_newslatter_form').addClass("loadingssss");
            e.preventDefault();
        var data = $(this).serialize();
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            security: '<?php echo wp_create_nonce( "send_email_shops_vera" ); ?>',
            type: 'POST',
            data: data + '&action=send_email_shops_vera',
            success: function (response) {
                response = JSON.parse(response);

                if (response.status === 'error') {
                    $('.notification_regester_mail_shop_error').html(response.message);
                    $('.button_regester_newslatter_form').removeClass("loadingssss");
                    $('.notification_regester_mail_shop_error').addClass("display_block_form");
                    $('.notification_regester_mail_shop_socces').removeClass("display_block_form");
                    setTimeout(function () {
                        $('.notification_regester_mail_shop_error').removeClass("display_block_form");
                    }, 10000);
                } else if (response.status === 'success') {
                    $('.notification_regester_mail_shop_socces').html(response.message);
                    $('.button_regester_newslatter_form').removeClass("loadingssss");
                    $('.notification_regester_mail_shop_error').removeClass("display_block_form");
                    $('.notification_regester_mail_shop_socces').addClass("display_block_form");
                    setTimeout(function () {
                        $('.notification_regester_mail_shop_socces').removeClass("display_block_form");

                        Cookies.set('newsletterPopupShown', 'true', { expires: 365 });
                        $('#popup1').removeClass('overlay_news');

                    }, 2000);
                }

            }

        });
    })
    });

</script>

<?php
}
function send_email_shops_vera() {
    $response = array();
    $email_newllater = $_POST['email_address'];
    if (!empty($email_newllater)) {
global $wpdb;
        $is_exists = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM {$wpdb->prefix}newsletter_emails WHERE email = %s",
                $email_newllater
            )
        );
        if($is_exists == 0) {
            $wpdb->insert(
                'wp_newsletter_emails',
                array(
                    'email' => $email_newllater
                )
            );
            $response['status'] = 'success';
            $response['message'] = "ایمیل شما در خبر نامه فروشگاه ثبت گردید";
        } else {
            $response['status'] = 'error';
            $response['message'] = "ایمیل شما قبلا در لیست خبر نامه ثبت گردیده است";
        }

    }
    echo json_encode($response);
    wp_die();
}

add_action('wp_ajax_send_email_shops_vera', 'send_email_shops_vera');
add_action('wp_ajax_nopriv_send_email_shops_vera', 'send_email_shops_vera');
add_shortcode("shorcode_form_mail_shop","function_short_mail_regester_shop");
function create_newsletter_table() {
    global $wpdb;
    $table = $wpdb->prefix . 'newsletter_emails';
    if($wpdb->get_var("SHOW TABLES LIKE '$table'") != $table) {
        $sql = "CREATE TABLE $table (
      id int(11) NOT NULL AUTO_INCREMENT,
      email varchar(255) NOT NULL, 
      PRIMARY KEY (id)
    );";
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}
add_action('after_setup_theme', 'create_newsletter_table');


/*فانکشن مقدار تخفیف در محصولات عادی*/

add_action('woocommerce_single_product_summary', 'simple_product_saving_percentage', 11);
function simple_product_saving_percentage( ?string $text = null )
{
    global $product;

    if ($product->is_type('simple') && $product->is_on_sale()) {
        $regular_price = (float)wc_get_price_to_display($product, array('price' => $product->get_regular_price()));
        $active_price = (float)wc_get_price_to_display($product, array('price' => $product->get_sale_price()));

        $saved_amount = $regular_price - $active_price;
        $percentage = round($saved_amount / $regular_price * 100);

        echo '<p id="saving_total_price">' . $percentage . '<span style="font-size: 10px !important;float: right"> % </span>  '  .  $text  . '  </p>';
    }
}

/*start ajax form load مزیت خرید محصولات*/
add_action('wp_ajax_load_text_dilett_mas', 'load_text_dilett_mas');
add_action('wp_ajax_nopriv_load_text_dilett_mas', 'load_text_dilett_mas');
function load_text_dilett_mas()
{
    global $options_vera_theme;
    $as = $_POST['input_number_foreach'];
    $item_masss = $options_vera_theme['repeater-field-data-noticdsds1212d']['editor-text'][$as];
    if (!empty($item_masss)) {
        $response['status'] = 'success';
        $response['message'] = $item_masss;
    }
    else {
        $response['status'] = 'error';
    }
    echo json_encode($response);
    wp_die();
}
/*form questions vera_ajax*/
add_action('wp_ajax_load_ajax_senf_form_questions', 'load_ajax_senf_form_questions');
add_action('wp_ajax_nopriv_load_ajax_senf_form_questions', 'load_ajax_senf_form_questions');
function load_ajax_senf_form_questions()
{
    $name = $_POST['name_author_form'];
    $email = $_POST['email_author_form'];
    $text = $_POST['text_author_form'];
    $phone = $_POST['phone_author_form'];
    $name_prodcuct = $_POST['name_product_email'];
    if (!empty($name) && !empty($text)) {
        $subject = 'سوال جدیدی توسط کاربر فروشگاه مطرح شده است!';
         $message = '
        <html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
  	<meta name="viewport" content="width=device-width, initial-scale=1.0;">
 	<meta name="format-detection" content="telephone=no"/>

	<!-- Responsive Mobile-First Email Template by Konstantin Savchenko, 2015.
	https://github.com/konsav/email-templates/  -->

	<style>
/* Reset styles */ 
body { margin: 0; padding: 0; min-width: 100%; width: 100% !important; height: 100% !important;}
body, table, td, div, p, a { -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%; }
table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse !important; border-spacing: 0; }
img { border: 0; line-height: 100%; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; }
#outlook a { padding: 0; }
.ReadMsgBody { width: 100%; } .ExternalClass { width: 100%; }
.ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div { line-height: 100%; }

/* Rounded corners for advanced mail clients only */ 
@media all and (min-width: 560px) {
	.container { border-radius: 8px; -webkit-border-radius: 8px; -moz-border-radius: 8px; -khtml-border-radius: 8px;}
}

/* Set color for auto links (addresses, dates, etc.) */ 
a, a:hover {
	color: #127DB3;
}
.footer a, .footer a:hover {
	color: #999999;
}

 	</style>

</head>

<!-- BODY -->
<!-- Set message background color (twice) and text color (twice) -->
<body topmargin="0" rightmargin="0" bottommargin="0" leftmargin="0" marginwidth="0" marginheight="0" width="100%" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%; height: 100%; -webkit-font-smoothing: antialiased; text-size-adjust: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; line-height: 100%;
	background-color: #F0F0F0;
	color: #000000;"
	bgcolor="#F0F0F0"
	text="#000000">

<!-- SECTION / BACKGROUND -->
<!-- Set message background color one again -->
<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%;" class="background"><tr><td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;"
	bgcolor="#F0F0F0">


<!-- WRAPPER / CONTEINER -->
<!-- Set conteiner background color -->
<table border="0" cellpadding="0" cellspacing="0" align="center"
	bgcolor="#FFFFFF"
	width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
	max-width: 560px;" class="container">

	<!-- HEADER -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif") -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 24px; font-weight: bold; line-height: 130%;
			padding-top: 25px;
			color: #000000;
			font-family: sans-serif;" class="header">
				پیام جدید از '.$name.' در صفحه محصول '. $name_prodcuct .' مطرح شد 
		</td>
	</tr>
	



	<!-- PARAGRAPH -->
	<!-- Set text color and font family ("sans-serif" or "Georgia, serif"). Duplicate all text styles in links, including line-height -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
			padding-top: 25px; 
			color: #000000;
			font-family: sans-serif;" class="paragraph">
'. $text .'
	        </td>
	       
	    </tr>

	<!-- BUTTON -->
	<!-- Set button background color at TD, link/text color at A and TD, font family ("sans-serif" or "Georgia, serif") at TD. For verification codes add "letter-spacing: 5px;". Link format: http://domain.com/?utm_source={{Campaign-Source}}&utm_medium=email&utm_content={{Button-Name}}&utm_campaign={{Campaign-Name}} -->
	<tr>
		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%;
			padding-top: 25px;
			padding-bottom: 5px;" class="button"><a
			 target="_blank" style="text-decoration: underline;">
				<table border="0" cellpadding="0" cellspacing="0" align="center" style="max-width: 240px; min-width: 120px; border-collapse: collapse; border-spacing: 0; padding: 0;"><tr><td align="center" valign="middle" style="padding: 12px 24px; margin: 0; text-decoration: none; background: blue; border-collapse: collapse; border-spacing: 0; border-radius: 4px; -webkit-border-radius: 4px; -moz-border-radius: 4px; -khtml-border-radius: 4px;"
					bgcolor="#E9703E"><a target="_blank" style="text-decoration: none;
					color: #FFFFFF; font-family: sans-serif; font-size: 17px; font-weight: 400; line-height: 120%;"
				>
						شماره تماس: '. $phone . '
					</a>
			</td></tr></table></a>
			
				<table border="0" cellpadding="0" cellspacing="0" align="center" style="max-width: 240px; min-width: 120px; border-collapse: collapse; border-spacing: 0; padding: 0;"><tr><td align="center" valign="middle" style="padding: 12px 24px; margin: 0; text-decoration: none; background: blue; border-collapse: collapse; border-spacing: 0; border-radius: 4px; -webkit-border-radius: 4px; -moz-border-radius: 4px; -khtml-border-radius: 4px;"
					bgcolor="#E9703E"><a target="_blank" style="text-decoration: none;
					color: #FFFFFF; font-family: sans-serif; font-size: 17px; font-weight: 400; line-height: 120%;"
					>
						شماره تماس: '. $email . '
					</a>
			</td></tr></table></a>
		</td>
	</tr>


<!-- End of WRAPPER -->
</table>

</body>
</html>
        ';
        $headers = array('Content-Type: text/html; charset=UTF-8 ','From: '. get_bloginfo("name") .' <person.name@example.com>');
        $admin_email = get_option('admin_email');

        $stutos_send_mail =  wp_mail($admin_email, $subject, $message, $headers);
           if ($stutos_send_mail) {
               $response['status'] = 'success';
               $response['message'] = "ارسال پیام با موفقیت انجام گردید!";
           }
           else {
               $response['status'] = 'error';
               $response['message'] = 'ارسال ایمیل موفقیت آمیز نبود کد خطا : 0';
           }
    }
    else {
        $response['status'] = 'error';
        $response['message'] = 'لطفا فیلد های خود را برسی و از کامل بودن بخش نام و پیام اطمینان حاصل فرمایید!';
    }
    echo json_encode($response);
    wp_die();
}
/**/
add_action('wp_dashboard_setup', 'my_custom_dashboard_widgets');
function my_custom_dashboard_widgets() {
    global $wp_meta_boxes;
    wp_add_dashboard_widget('custom_help_widget', 'Recent changes in the template update','vera_dashboard_help','','','side','high');
}
function vera_dashboard_help() {
    global $options_vera_theme;
    ?>
    <div style=" text-align: left;" class="add-version-diak-theme">
        <p style="position:relative;display: flex;align-items: center;justify-content: space-between">
            <img style="width: 20%;height: auto" src="<?php echo get_template_directory_uri()."/img/fiveicon.jpg"; ?>">
            <span style="width: 75%">
The changes of your active template in the version (2.8.0) named Virax are as follows:
            <ul style="text-align: right">
                <li>اضافه شدن بخش مزایا و معایب محصول در نظرات محصول (virax)</li>
                <li>نسخه جدید افزونه خبر نامه ایمیل (virax)</li>
                <li>اضافه شدن امکانات استایلی و رفع مشکلات کنترول (elementor)</li>
                <li> (ligin & regaster) بهنیه سازی فرم ورود و عضویت</li>
                <li>رفع مشکلات هدر مربوط به هدر سبک دوم (header gamo)</li>
                <li>بهینه سازی کد های استایل قالب (style)</li>
                <li>تنظیمات مربوط به بخش لودینگ قالب (loading)</li>
              <li>و موارد دیگر...</li>
            </ul>
            </span>
            <b style="position: absolute;right: 0;font-size: 10px;top: -10px;float: right;background: #fff !important;padding: 3px 6px;border-radius: 20px 3px 0 20px;border: 1px solid #878787;">Version 2.8.0</b>
        </p>
    </div>

<?php }

if (!function_exists('dokan')) {

}
else {
add_action('woocommerce_after_shop_loop_item_title', 'tidaweb_woo_sold_by');
function tidaweb_woo_sold_by() {
    global $product;
    $seller = get_post_field('post_author', $product->get_id());
    $author = get_user_by('id', $seller);
    $vendor = dokan()->vendor->get($seller);
    $store_info = dokan_get_store_info($author->ID);
    if (!empty($store_info['store_name'])) {
        ?>
        <span>
        <?php printf('<a class="details_store" href="%s">%s <i class="fa-thin fa-shop"></i> </a>', $vendor->get_shop_url(), $vendor->get_shop_name()); ?>
        </span>
        <?php
    }
    else {
        ?>
        <span>
        <?php printf('<a class="details_store" href="%s">' . get_bloginfo("name") . '<i class="fa-thin fa-shop"></i> </a>', $vendor->get_shop_url(), $vendor->get_shop_name()); ?>
        </span>
        <?php
    }
}
}



/* add filed phone number for form regester nad save */

// اضافه کردن فیلد شماره موبایل
add_action('woocommerce_register_form', 'add_phone_to_registration_form', 3);
function add_phone_to_registration_form()
{

    ?>
    <p class="form-row form-row-wide">
        <label for="reg_phone"><?php _e('شماره موبایل', 'woocommerce'); ?> <span class="required">*</span></label>
        <input type="text" class="input-text" name="reg_phone" id="reg_phone"
               value="<?php if (!empty($_POST['reg_phone'])) esc_attr_e($_POST['reg_phone']); ?>"/>
    </p>
    <?php

}

// ذخیره شماره موبایل در دیتابیس
add_action('woocommerce_created_customer', 'save_phone_registration');
function save_phone_registration($customer_id)
{
    if (isset($_POST['reg_phone'])) {
        update_user_meta($customer_id, 'billing_phones', sanitize_text_field($_POST['reg_phone']));
    }
}

// نمایش فیلد شماره تلفن در صفحه حساب کاربری
add_action('woocommerce_edit_account_form', 'add_billing_phone_to_account_details');
function add_billing_phone_to_account_details()
{
    $user_id = get_current_user_id();
    $billing_phone = get_user_meta($user_id, 'billing_phones', true);
    ?>
    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="account_phone"><?php _e('شماره موبایل', 'woocommerce'); ?> <span class="required">*</span></label>
        <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_phone"
               id="account_phone" value="<?php echo esc_attr($billing_phone); ?>"/>
    </p>
    <?php
}

// ذخیره فیلد شماره موبایل در صفحه حساب کاربری
add_action('woocommerce_save_account_details', 'save_billing_phone_details');
function save_billing_phone_details($user_id)
{
    if (isset($_POST['account_phone'])) {
        update_user_meta($user_id, 'billing_phones', sanitize_text_field($_POST['account_phone']));
    }
}

// نمایش ستون شماره تلفن در لیست کاربران
add_filter('manage_users_columns', 'add_billing_phone_column');
function add_billing_phone_column($columns)
{
    $columns['billing_phones'] = 'شماره موبایل';
    return $columns;
}

// نمایش مقدار شماره تلفن برای هر کاربر
add_action('manage_users_custom_column', 'add_billing_phone_value', 10, 3);
function add_billing_phone_value($val, $column_name, $user_id)
{
    switch ($column_name) {
        case 'billing_phones' :
            return get_user_meta($user_id, 'billing_phones', true);
            break;
    }
}

// Add phone field to user profile page
add_action('show_user_profile', 'extra_user_profile_fields');
add_action('edit_user_profile', 'extra_user_profile_fields');
function extra_user_profile_fields($user)
{

    // Get current value
    $phone = get_the_author_meta('billing_phones', $user->ID); ?>

    <h3>شماره موبایل</h3>

    <table class="form-table">
        <tr>
            <th>
                <label for="billing_phone"><?php _e("شماره موبایل (فیلد اختصاصی سامانه پیامکی)"); ?></label>
            </th>

            <td>
                <input type="text" name="account_phones" id="billing_phone"
                       value="<?php echo esc_attr($phone); ?>" class="regular-text">
                <br>
            </td>
        </tr>
    </table>

<?php }

// Save phone on profile update
add_action('personal_options_update', 'save_extra_user_profile_fields');
add_action('edit_user_profile_update', 'save_extra_user_profile_fields');
function save_extra_user_profile_fields($user_id)
{

    if (!current_user_can('edit_user', $user_id))
        return false;

    if (isset($_POST['account_phones'])) {
        update_user_meta($user_id, 'billing_phones', sanitize_text_field($_POST['account_phones']));
    }

}

/*حذف فیلد ااختصاصی شماره موباایل بعد از حذف کاربر بر اساس یوز آی دی  برای billing_phones */
function delete_user_billing_phones($user_id)
{
    global $wpdb;
    $wpdb->delete(
        $wpdb->usermeta,
        array(
            'user_id' => $user_id,
            'meta_key' => 'billing_phones'
        )
    );
}

add_action('deleted_user', 'delete_user_billing_phones');


// اضافه کردن فیلد شماره موبایل به فرم پرداخت
add_action('woocommerce_after_checkout_billing_form', 'customs_checkout_field');

function customs_checkout_field($checkout) {
    $user_id = get_current_user_id();
    $phone_number = get_user_meta($user_id, 'billing_phones', true);

    echo '<div id="custom_checkout_field">';
    woocommerce_form_field('billing_phones', array(
        'type' => 'text',
        'class' => array('form-row-wide'),
        'label' => __('شماره موبایل'),
        'required' => true,
        'default' => $phone_number
    ), $checkout->get_value('billing_phones'));
    echo '</div>';
}

add_action('woocommerce_checkout_update_order_meta', 'custom_checkout_field_update_order_meta');

function custom_checkout_field_update_order_meta($order_id) {
    if ($_POST['billing_phones']) {
        update_post_meta($order_id, 'billing_phones', sanitize_text_field($_POST['billing_phones']));
    }
}

add_action('woocommerce_checkout_process', 'custom_checkout_field_validation');

function custom_checkout_field_validation() {
    $field_key = 'billing_phones';
    if (empty($_POST[$field_key])) {
        wc_add_notice(__('<strong>شماره موبایل را وارد کنید</strong> این فیلد اجباری است.', 'woocommerce'), 'error');
    }
}

function save_billing_phone_to_user_meta($user_id) {
    if (isset($_POST['billing_phones'])) {
        $billing_phone = sanitize_text_field($_POST['billing_phones']);
        if (strpos($billing_phone, '+980') == 0) {
            $your_phone = str_replace("980", "98", $billing_phone);
        }

        $nimber_edit = "";
        $nimber_edit = $your_phone;
        if (strpos($nimber_edit, '+98') == 0) {
            $nimber_edit = str_replace("+98", "", $nimber_edit);
        }

        if ($nimber_edit[0] == "0") {
            $nimber_edit = substr_replace($nimber_edit, "", 0, 1);
        }

        update_user_meta($user_id, 'billing_phones', $nimber_edit);
    }
}

add_action("woocommerce_created_customer", "save_billing_phone_to_user_meta");

global $options_vera_theme;

    add_filter('template_include', 'custom_page_account_template', 99);

    function custom_page_account_template($template)
    {
        if (is_page('my-account') && !is_user_logged_in()) {
            global  $options_vera_theme;
            if ($options_vera_theme['on-off-text-admin-212132']) {
                $custom_template = get_template_directory() . '/logins.php';
                if (file_exists($custom_template)) {
                    return $custom_template;
                }
            }

        }
        return $template;
    }

remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_login_form', 10 );
add_action( 'woocommerce_before_checkout_form', 'custom_checkout_login_form', 1 );

function custom_checkout_login_form() {
    ?>
    <div class="woocommerce-info">
        آیا قبلا ثبت نام کرده اید ؟
        <a class="ic-account-header-btn">
            برای ورود اینجا را کلیک کنید
        </a>
    </div>
    <?php
}

/*add pros_cons to comment virax*/

add_action('comment_form_field_comment', 'add_pros_cons_fields');
function add_pros_cons_fields($comment_field)
{
    $pros_field = '<p style="width:49% !important;max-width:49% !important;min-width:49% !important;float:right;margin-bottom:10px" class="comment-form-pros"><label for="pros">مزیت‌ها</label><textarea placeholder="نظر خود را در مورد مزیت های محصول به صورت خط به خط بنویسید..." id="pros" name="pros" rows="3" aria-required="true"></textarea></p>';
    $cons_field = '<p style="width:49% !important;max-width:49% !important;min-width:49% !important;float:right;margin-right:2%;margin-bottom:10px" class="comment-form-cons"><label for="cons">معایب</label><textarea placeholder="نظر خود را در مورد معایب های محصول به صورت خط به خط بنویسید..." id="cons" name="cons" rows="3" aria-required="true"></textarea></p>';

    $comment_field = $comment_field . $pros_field . $cons_field;

    return $comment_field;
}

/*ذخیره در کامنت متا*/
add_action('comment_post', 'save_pros_cons_fields');
function save_pros_cons_fields($comment_id)
{
    if (isset($_POST['pros']))
        $pros = wp_filter_nohtml_kses($_POST['pros']);
    else
        $pros = 'ندارد.';

    if (isset($_POST['cons']))
        $cons = wp_filter_nohtml_kses($_POST['cons']);
    else
        $cons = 'ندارد.';

    add_comment_meta($comment_id, 'pros', $pros);
    add_comment_meta($comment_id, 'cons', $cons);
}

/*نمایش در کامنت ها*/
add_filter('get_comment_text', 'display_pros_cons_fields', 10, 2);
function display_pros_cons_fields($comment_text, $comment)
{
    $pros = get_comment_meta($comment->comment_ID, 'pros', true);
    $cons = get_comment_meta($comment->comment_ID, 'cons', true);

    if ($pros || $cons) {
        $pros_cons_html = '<div  class="pros-cons-container">';
        if ($pros) {
            $pros_cons_html .= '<div  class="pros pros-cons-containers"><div class="name_pos_cos_comment"><strong>مزیت‌ها</strong><i class="fa-light fa-circle-chevron-down"></i></div><br>' . $pros . '</div>';
        }
        if ($cons) {
            $pros_cons_html .= '<div class="cons pros-cons-containers"><div  class="name_pos_cos_comment"><strong>معایب</strong><i class="fa-light fa-circle-chevron-down"></i></div><br>' . $cons . '</div>';
        }
        $pros_cons_html .= '</div>';

        $comment_text = $comment_text . $pros_cons_html;
    }

    return $comment_text;
}
