<?php
/**
 * Redux Framework checkbox config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;

Redux::set_section(
	$opt_name,
	array(
		'title'            => 'لوگو و فایو آیکون سایت',
		'id'               => 'basic-options-one',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p style="border-bottom: 1px solid #ddd;padding-bottom: 10px;">شما میتوانید از طریق این بخش تنظیماتی نظیر لوگو اصلی سایت و فایو آیکون مرورگر و تنظیمات عمومی قالب فعال را تغییر دهید</p>',
		'fields'           => array(

			/**add options theme logo**/
			array(
				'id'       => 'options-image-logo-theme',
				'type'     => 'media',
				'url'      => true,
				'title'    => 'لوگو اصلی سایت',
				'desc'     => 'لوگو اصلی خود را در این قسمت آپلود کنید توجه کنید که لوگو باید دارای عرض و ارتفاع مناسب باشد',
				'subtitle' => 'Original logo',
				'default'  => array(
					'url' => get_template_directory_uri() . '/img/logo.png'
				),
			),
			array(
				'id' => 'on-off-animate_logo_yarag',
				'type' => 'switch',
				'title' => esc_html__('وضعیت انیمیشن آینه ای لوگو', 'your-textdomain-here'),
				'subtitle' => esc_html__('Enable and disable', 'your-textdomain-here'),
				'default' => true,
			),
			/**add options theme five icon**/
			array(
				'id'       => 'options-image-five-icon-theme',
				'type'     => 'media',
				'url'      => true,
				'title'    => 'فایوآیکون سایت',
				'desc'     => 'فایو آیکون سایت خود را آپلود نمایید (به تصویر کوچک مرورگر فایوآیکون گفته میشود)',
				'subtitle' => 'five icon',
				'default'  => array(
					'url' => get_template_directory_uri() . '/img/fiveicon.jpg'
				),
			),
			/**add options logo width & height**/

			array(
				'id'            => 'options-image-logo-width',
				'type'          => 'slider',
				'units'         => array( 'em', 'px', '%' ),
				'title'         => 'پهنای لوگو اصلی شما',
				'subtitle'      => 'width logo',
				'desc'          => 'میتوانید از طریق این قسمت پهنای تصویر لوگو خود را تعیین کنید',
				"default"       => 300,
				"min"           => 100,
				"step"          => 10,
				"max"           => 500,
				'display_value' => 'label',
			),
			/**add options page-body width container**/

			array(
				'id'            => 'options-body-width-vera-container',
				'type'          => 'slider',
				'units'         => array( 'em', 'px', '%' ),
				'title'         => 'عرض کلی محتوای وبسایت',
				'subtitle'      => 'width logo',
				'desc'          => 'شما میتوانید از طریق این بخش عرض کلی container اصلی وبسایت که به عنوان عرض کلی صفحه محتوای شما است را تغییر و شخصی سازی نمایید',
				"default"       => 1500,
				"min"           => 1000,
				"step"          => 10,
				"max"           => 3000,
				'display_value' => 'label',
			),


		),
	)

);

Redux::set_section(
	$opt_name,
	array(
		'title'            => ' رنگبندی کلی سایت ',
		'id'               => 'basic-options-body',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p style="border-bottom: 1px solid #ddd;padding-bottom: 10px;">میتوانید از این قسمت رنگ پس زمینه کلی سایت را عوض کنید</p>',
		'fields'           => array(
			/**add options backgroand color**/
			array(
				'id'       => 'color-background-body',
				'type'     => 'color',
				'title'    => ' رنگ پس زمینه کلی سایت',
				'subtitle' => 'background color body',
				'default'  => '#ffffff',
				'desc'     => 'میتوانید از طریق این قسمت رنگ اصلی پس زمینه کل قالب را عوض کنید',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-background-main-color',
				'type'     => 'color',
				'title'    => ' رنگ پیشفرض اول قالب (*)',
				'subtitle' => 'The first default color theme',
				'default'  => '#F0003C',
				'desc'     => 'در قالب شما دو رنگ اصلی وجود دارد که میتوانید رنگ پیشفرض سبز | #F0003C را از این جا تغییر دهید',
				'validate' => 'color',
			),

			array(
				'id'       => 'color-background-main-color-2',
				'type'     => 'color',
				'title'    => ' رنگ پیشفرض دوم قالب (*)',
				'subtitle' => 'The second default color theme',
				'default'  => '#007aff',
				'desc'     => 'در قالب شما دو رنگ اصلی وجود دارد که میتوانید رنگ پیشفرض قرمز | #007aff را از این جا تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-background-main-color-3',
				'type'     => 'color',
				'title'    => ' رنگ پیشفرض سوم قالب (*)',
				'subtitle' => 'The second default color theme',
				'default'  => '#222222',
				'desc'     => 'در قالب شما دو رنگ اصلی وجود دارد که میتوانید رنگ پیشفرض قرمز | #222222 را از این جا تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-background-main-color-4',
				'type'     => 'color',
				'title'    => ' رنگ پیشفرض چهارم قالب (*)',
				'subtitle' => 'The second default color theme',
				'default'  => '#F5F5F5',
				'desc'     => 'در قالب شما دو رنگ اصلی وجود دارد که میتوانید رنگ پیشفرض قرمز | #222222 را از این جا تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-background-main-color-5',
				'type'     => 'color',
				'title'    => ' رنگ پیشفرض پنجم قالب (*)',
				'subtitle' => 'The second default color theme',
				'default'  => '#FC5185',
				'desc'     => 'در قالب شما دو رنگ اصلی وجود دارد که میتوانید رنگ پیشفرض قرمز | #FC5185 را از این جا تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-background-main-color-6',
				'type'     => 'color',
				'title'    => ' رنگ پیشفرض ششم قالب (*)',
				'subtitle' => 'The second default color theme',
				'default'  => '#FFF0CE',
				'desc'     => 'در قالب شما دو رنگ اصلی وجود دارد که میتوانید رنگ پیشفرض قرمز | #FFF0CE را از این جا تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'    => 'info_sskldjaskldjskladj',
				'type'  => 'info',
				'style' => 'critical',
				'title' => esc_html__('راهنمای رنگبندی های زیر:', 'your-textdomain-here'),
				'icon'  => 'el-icon-info-sign',
				'desc'  => esc_html__( 'توجه کنید رنگبندی های زیر صرفا جهت مدیریت رنگ اصلی دمو دوم قالب (گیمو) ساخنه شده است و میتوانید برای مدیریت گیمو از آن استفاده کنید', 'your-textdomain-here')
			),
			array(
				'id'       => 'color-background-main-color-77',
				'type'     => 'color',
				'title'    => ' رنگ پیشفرض هفتم قالب (دمو گیمو)',
				'subtitle' => 'color',
				'default'  => '#fd7e0d',
				'desc'     => 'در قالب شما دو رنگ اصلی وجود دارد که میتوانید رنگ پیشفرض قرمز | #FFF0CE را از این جا تغییر دهید',
				'validate' => 'color',
			),

		),
	)
);
