<?php

class slider_widget_2_elementor extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'slider-img-vera-theme-2';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>اسلایدر تصویر طرح دوم (2)</h2>';
    }

    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    public function get_categories()
    {
        return ['slider-category'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content-slider',
            [
                'label' => esc_html__('محتوا اسلایدر', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'list',
            [
                'label' => esc_html__('لیسا محتوای اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'img-desktop',
                        'label' => esc_html__('آپلود تصویر اسلایدر دسکتاپ', 'textdomain'),
                        'description' => ' میتوانید از طریق این باکس تصویر اسایدر خود را انتخاب و یا آپلود نمایید توجه کنید این باکس برای تصویر حالت دسکتاپ میباشد و در موبایل و تبلت نمایش داده نمیگردد توجه:( لطفا اگر بک تصویر در اختیار دارید در دو باکس آپلود و انتخاب نمایید)',
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ]
                    ],
                    [
                        'name' => 'img-phone',
                        'label' => esc_html__('آپلود تصویر اسلایدر تبلت و موبایل', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'description' => 'میتوانید از این قسمت هم تصویر اسلایدر را انتخاب و یا آپلود کنید فقط فرق این قسمت با قسمت اول نمایش این قسمت در حالت تبلت و موبایل است و تصویر این باکس فقط در تبلت و موبایل نمایش داده میشود و به شما در نمایش بهینه تصویر کمک میکند ',

                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ]
                    ],
                    [
                        'name' => 'link-target-slider',
                        'label' => 'لینک هدایت اسلایدر',
                        'type' => \Elementor\Controls_Manager::URL,
                        'description' => 'میتوانید از این بخش لینک هدایت بعد از کلیک کاربر را ست کنید که کاربر بعد از کلیک به لینک هدایت شود مثال (آدرس دسته بندی موبایل سامسونگ)',

                        'placeholder' => esc_html__('https://site.com/shop/', 'textdomain'),
                    ],
                    [
                        'name' => 'link-targets-slider',
                        'label' => esc_html__('باز شدن لینک در :', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '_blank',
                        'description' => 'میتوانید از این باکس طریقه باز شدن لین ها را انتخاب کنید مثلا وقتی کاربر بر روی لینک کلیک کرد در تب جدیدی از مرورگر به موضوع هدایت شود یا همان تب اصلی',
                        'options' => [
                            '_blank' => esc_html__('باز شدن در صفحه جدید', 'textdomain'),
                            '_self' => esc_html__('باز شدن در همان صفحه', 'textdomain'),
                        ],
                    ]
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_js_section',
            [
                'label' => esc_html__('تنظیمات اسلایدر', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'show_nav-controls-slider-r-t-l',
            [
                'label' => esc_html__('نمایش کنترولر های چپ و راست', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت وضعیت نمایش دکمه های هدایتگر را انتخاب کنید',

            ]
        );
        $this->add_control(
            'show_dots-controle-slider',
            [
                'label' => esc_html__('نمایش نقطه های نمایشگر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت وضعیت نمایش نشانگی های نقطه ای را انتخاب کنید',
            ]
        );
        $this->add_control(
            'show_autoplay-controle-slider',
            [
                'label' => esc_html__('حرکت خودکار اسلایدر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدر خودکار حرکت کنید یا نه',
            ]
        );
        $this->add_control(
            'show_loop-controle-slider',
            [
                'label' => esc_html__('برگرداندن اسلایدر بعد از اتمام', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدربعد از اینکه کل تصاویر موجود را یک بار نشان داد دوباره به اول برگردد و دوباره مراتب را تکرار کنید',
            ]
        );

        $this->add_control(
            'fast-slider-autoplay-Timeout',
            [
                'label' => esc_html__('سرعت عوض شدن اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2000,
                'max' => 100000,
                'step' => 1000,
                'default' => 5000,
                'description' => 'میتوانید از این قسمت مشخص کنید اسلایدر های در چند ثانبه یک بار تعویض شوند هر 1000 عدد نشانگر 1 ثانیه میباشد بهتر اسست عدد یین 5000(5 ثانیه) تا 20000(20 ثانیه) باشد',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>
        <style>
            /*start code css swiper slider*/
            .slider-image-two-column-2 {
                display: flex;
                justify-content: space-between;
                align-items: center;
                height: max-content;
                margin: 10px auto;
                overflow: hidden;
                float: right;
                width: 100%;
            }

            .slider-image-two-column-2 .swiper {
                width: 100%;
                float: right;
                margin: auto;
                overflow: hidden;
                border-radius:15px;
            }

            .slider-image-two-column-2 .swiper-slide {
                text-align: center;
                font-size: 18px;
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100% !important;
            }

            .slider-image-two-column-2 .swiper-slide figure {
                width: 100% !important;
            }
            .slider-image-two-column-2 .swiper-slide img {
                width: 100%;
                height: 100%;
            }

            .slider-image-two-column-2 .swiper-button-next,
            .slider-image-two-column-2 .swiper-button-prev {
                padding: 20px 20px;
                color: #000000 !important;
                fill: black !important;
                stroke: black !important;
background-color:#ffffff;
            }
            .slider-image-two-column-2 .swiper-button-next:after,
            .slider-image-two-column-2 .swiper-button-prev:after {
                font-size:25px
            }
            .slider-image-two-column-2 .swiper-button-prev {
                border-radius: 20px 0 0 20px;
                right:0
            }
            .slider-image-two-column-2 .swiper-button-next {
                border-radius: 0 20px 20px 0;
                left:0
            }

            .slider-image-two-column-2 .swiper-pagination-bullet {
                border-radius:1px !important;
                transform: scale(1) !important;
                width:15px !important;
            }
            .slider-image-two-column-2 .swiper-pagination-bullet-active {
                opacity: 1;
                background: #ffffff;
            }

            .slider-image-two-column-2 .phone-image-slider-swiper {
                display: none;
            }

@media screen and (max-width: 1000px) {
    .slider-image-two-column-2 .swiper-button-next {
        display: none !important;
    }
}
            /*end code css swiper slider*/
        </style>
        <script>
            $(function () {
                var mySwiper_image = new Swiper(".mySwiper_image_2", {
                    <?php if ($settings['show_loop-controle-slider']) { ?>
                    loop: true,
                    <?php
                    }
                    ?>
                    <?php if ($settings['show_autoplay-controle-slider']) { ?>
                    autoplay: {
                        delay: <?php echo $settings['fast-slider-autoplay-Timeout'] ?>,
                        disableOnInteraction: true,
                    },
                    <?php
                    }
                    ?>
                    <?php if ($settings['show_dots-controle-slider']) { ?>
                    pagination: {
                        el: ".swiper-pagination",
                        dynamicBullets: true,
                    },
                    <?php
                    } ?>
                    <?php if ($settings['show_nav-controls-slider-r-t-l']) { ?>
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    <?php
                    }
                    ?>
                });
            })
        </script>
        <div class="container">
            <div class="slider-image-two-column-2">

                <div class="swiper mySwiper_image_2">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['list'] as $index => $item) : ?>
                            <div class="swiper-slide">
                                <figure>
                                    <a target="<?php echo $item['link-targets-slider']; ?>"
                                       href="<?php echo $item['link-target-slider']['url']; ?>">
                                        <img class="desktop-image-slider-swiper"
                                             src="<?php echo $item['img-desktop']['url']; ?>" loading="lazy">
                                        <img class="phone-image-slider-swiper"
                                             src="<?php echo $item['img-phone']['url']; ?>" loading="lazy">
                                    </a>
                                </figure>
                            </div>
                        <?php endforeach; ?>

                    </div>
                    <?php if ($settings['show_nav-controls-slider-r-t-l']) { ?>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    <?php } ?>

                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </div>

        <?php
    }


    protected function content_template()
    {
    }

}