<?php

class slider_blog_pro_diak_theme_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'slider-weblog-pro-diak_theme';
	}

	public function get_title() {
		return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>اسلایدر وبلاگ حرفه ای </h2>';
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'workut-blog' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'تنظیمات محتوای وبلاگ', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'show-timer-product-sliders-theme-lkdfjsklfkdldffdfflnf321',
            [
                'label' => esc_html__('نام اسلایدر کلی نوشته ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'return_value' => 'yes',
                'default' => 'مطالبی مفید برای شما',
                'description' => 'میتوانید از طریق این قسمت نام اسلایدر کلی نوشته ها خود را تغییر دهید',
            ]
        );
        $this->add_control(
            'fast-slider-pro-autoplay-count-blogs_vera',
            [
                'label'   => esc_html__( 'تعداد حداکثر پست برای نمایش', 'textdomain' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
                'default' => 10,
                'description' =>'شما میتوانید از طریق این بخش تعداد پست های نوشته هایی که میخواهید در اسلایدر نمایش یابد را مشخص کنید',
            ]
        );
		$this->end_controls_section();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'استایل های اسلایدر وبلاگ (حرفه ای)', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'color-bachground-item-blog-slider_vera',
			[
				'label' => esc_html__( '  رنگ پس زمینه آیتم های وبلاگ', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'description' =>'شما میتوانید از طریق این قسمت رنگ پس زمینه آیتم وبلاگ را تغییر و شخصی سازی نمایید',
                'default' => '#FFFFFF',
            ]
		);
		$this->add_control(
			'color-text-h2-weblog-color_vera',
			[
				'label' => esc_html__( ' رنگ متن عنوان مطلب', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'description' =>'میتوانید از این قسمت رنگ متن عنوان نوشته را تغییر و شخصی سازی نمایید',
                'default' => '#222222',
            ]
		);
		$this->add_control(
			'color-text-h2-weblog-color_vera_hover',
			[
				'label' => esc_html__( ' رنگ متن عنوان مطلب در حالت هاور', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'description' =>'میتوانید از این قسمت  رنگ متن عنوان مطلب در حالت هاور را تغییر و شخصی سازی نمایید',
                'default' => '#F0003C',
            ]
		);
		$this->add_control(
			'color-text-h2-weblog-color-night_vera',
			[
				'label' => esc_html__( ' رنگ متن توضیحات کوتاه نوشته', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'description' =>'شما میتوانید از طریق این باکس رنگ نوشته توضیحات کوتاه نوشته خود را تغییر و شخصی سازی کنید',
                'default' => '#222222',
            ]
		);
		$this->add_control(
			'color-bachground-slider-product-one-off-backcolor',
			[
				'label' => esc_html__( ' رنگ متن اطلاعات نوشته ', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'description' =>'شما میتوانید از طریق این بخش رنگ متن دسته بندی را تغییر و شخصی سازی کنید توجه کنید فقط یک دسته بندی در این قسمت نمایش داده میگردد',
                'default' => '#222222',
            ]
		);
        $this->add_control(
            'color-bachground-slider-product-one-off-backcolor-212-1',
            [
                'label' => esc_html__( ' رنگ پس زمینه آیکون اطلاعات نوشته ', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' =>'شما میتوانید از طریق این بخش رنگ آیکون اطلاعات نوشته را تغییر دهید',
                'default' => '#007AFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-off-backcollflgor-212-1',
            [
                'label' => esc_html__( ' رنگ آیکون اطلاعات نوشته ', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' =>'شما میتوانید از طریق این بخش رنگ آیکون اطلاعات نوشته را تغییر دهید',
                'default' => '#FFFFFF',
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'style_sections',
			[
				'label' => esc_html__( 'تنظیمات اسلایدر (وبلاگ حرفه ای)', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_autoplay-controle-slider-pro-vera',
			[
				'label'        => esc_html__( 'حرکت خودکار اسلایدر ', 'textdomain' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'فعال', 'textdomain' ),
				'label_off'    => esc_html__( 'غیرفعال', 'textdomain' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'description' =>'میتوانید از این قسمت مشخص کنید که آیا اسلایدر خودکار حرکت کنید یا نه',
			]
		);
		$this->add_control(
			'show_loop-controle-slider-pro-vera',
			[
				'label'        => esc_html__( 'برگرداندن اسلایدر بعد از اتمام', 'textdomain' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'فعال', 'textdomain' ),
				'label_off'    => esc_html__( 'غیرفعال', 'textdomain' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'description' =>'میتوانید از این قسمت مشخص کنید که آیا اسلایدربعد از اینکه کل تصاویر موجود را یک بار نشان داد دوباره به اول برگردد و دوباره مراتب را تکرار کنید',
			]
		);
		$this->add_control(
			'fast-slider-pro-autoplay-Timeout-vera',
			[
				'label'   => esc_html__( 'سرعت عوض شدن اسلایدر', 'textdomain' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 2000,
				'max'     => 100000,
				'step'    => 1000,
				'default' => 5000,
				'description' =>'میتوانید از این قسمت مشخص کنید اسلایدر های در چند ثانبه یک بار تعویض شوند هر 1000 عدد نشانگر 1 ثانیه میباشد بهتر اسست عدد یین 5000(5 ثانیه) تا 20000(20 ثانیه) باشد',
			]
		);
		$this->end_controls_section();

	}


	protected function render() {

		$settings = $this->get_settings_for_display();
		?>
		<style>
            /*start blog slider code css*/
            .blog-slider {
                width: 100%;
                float: right;
                padding-top: 20px;
                overflow: hidden;
            }

            .blog-slider h2 {
                width: 100%;
                float: right;
                text-align: center;
                padding: 20px 0;
                font-family: digikala;
            }

            .blog-slider .swiper-button-next, .blog-slider .swiper-button-prev {
                top: -33px;
                color: var(--main-color3);
            }

            .blog-slider .swiper {
                width: 100%;
                float: right;
                padding: 5px 3px !important;
                overflow: unset;
            }

            .blog-slider .swiper-slide {
                text-align: center;
                font-size: 18px;
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                align-items: center;
                /* padding: 5px 3px; */
                border: 1px solid #ddd;
                overflow: hidden;
                border-radius: 20px 20px 10px 10px;
                height: initial;
                background: #FFFFFF;
            }
            .blog-slider  .swiper-wrapper {
                padding: 10px 0;
            }


            .blog-slider .swiper-slide .image-blog-slider i {
                position: absolute;
                right: 4%;
                transition: all .5s ease-in-out;
                top: 4%;
                color: #ffffff;
                font-size: 30px;
                font-weight: 300;
                text-shadow: 0 0 5px rgba(44, 62, 80, 0.58);
            }

            .blog-slider .swiper-slide:hover .image-blog-slider i {
                transform: rotate(360deg);
            }

            .blog-slider .swiper-slide .image-blog-slider {
                width: 100%;
                float: right;
                display: flex;
                min-height:200px;
                height:fit-content;
                position: relative;
            }


            .blog-slider .swiper-slide .image-blog-slider img {
                display: block;
                width: 100%;
                height: auto;
                margin: 0 auto;
                object-fit: cover;
                border-radius: 0 0 0 0;
            }

            .blog-slider .swiper-slide:hover .name-blog-slider h3 {
                opacity: .8;
                color:  <?php echo $settings['color-text-h2-weblog-color_vera_hover']; ?>;;
            }

            .blog-slider .swiper-slide .name-blog-slider {
                width: 96%;
                padding: 1%;
                float: right;
            }

            .blog-slider .swiper-slide .name-blog-slider a {
                text-decoration: none;
                color: var(--main-color3);
            }

            .blog-slider .swiper-slide .name-blog-slider h3 {
                font-size: 13px;
                text-align: right;
                padding: 0 0;
                transition: all .3s ease-in-out;
                position: relative;
                font-weight: 500;
                line-height: 3;
                display: flex;
                /* padding: 2 0; */
                height: 35px;
                overflow: hidden;
                float: right;
                display: -webkit-box;
                -webkit-box-orient: vertical;
                -webkit-line-clamp: 1;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                color: #222222;
            }

            .blog-slider .swiper-slide .auter-cat-blog-slider {
                width: 100%;
                padding: 2%;
                float: right;
                display: flex;
                align-items: center;
                border-top: 1px solid #dddddd6e;
                justify-content: right;
                margin-top: 10px;
                align-content: center;
            }

            .blog-slider .swiper-slide .auter-cat-blog-slider a {
                text-decoration: none;
                color: var(--main-color3);
                font-family: digikala;
            }

            .blog-slider .swiper-slide .auter-cat-blog-slider a span {
                padding-left: 10px;
                font-size: 14px;
                display: flex;
                align-items: center;
                color: <?php echo $settings['color-bachground-slider-product-one-off-backcolor']; ?>;
            }

            .blog-slider .swiper-slide .auter-cat-blog-slider a span i {
                padding: 5px;
                background: <?php echo $settings['color-bachground-slider-product-one-off-backcolor-212-1'] ?>;
                color:  <?php echo $settings['color-bachground-slider-product-one-off-backcollflgor-212-1'] ?>;;
                margin-left: 7px;
                border-radius: 5px;
                font-size: 15px;
            }

            .blog-slider .swiper-slide .exeript-blog-slider {
                width: 96%;
                padding: 1%;
                float: right;
                max-height: 50px;
                overflow: hidden;
                position: relative;
            }

            .blog-slider .swiper-slide .exeript-blog-slider:before {
                content: "";
                width: 100%;
                height: 20px;
                bottom: 0;
                right: 0;
                position: absolute;
                background: rgba(255, 255, 255, 0.43);
            }

            .blog-slider .swiper-slide .exeript-blog-slider p {
                font-size: 10px;
                text-align: right;
                color: <?php echo $settings['color-text-h2-weblog-color-night_vera']; ?>;
            }

            /*end blog slider code css*/
        </style>
		<script>
            $(function () {
                /*start sliders code java script blog*/
                var swiper = new Swiper(".mySwiper-blog", {
                    <?php if ($settings['show_loop-controle-slider-pro-vera']) { ?>
                    loop: true,
                    <?php  } ?>
                    <?php if ($settings['show_autoplay-controle-slider-pro-vera']) { ?>
                    autoplay: {
                        delay: <?php echo $settings['fast-slider-pro-autoplay-Timeout-vera'] ?>,
                        disableOnInteraction: true,
                    },
                    <?php
                    }
                    ?>
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    breakpoints: {
                        "@0.00": {
                            slidesPerView: 2,
                            spaceBetween: 2,
                        },
                        "@0.75": {
                            slidesPerView: 2,
                            spaceBetween: 2,
                        },
                        "@1.00": {
                            slidesPerView: 3,
                            spaceBetween: 3,
                        },
                        "@1.50": {
                            slidesPerView: 4,
                            spaceBetween: 4,
                        },
                    },
                });
                /*end sliders code java script blog*/

            })
		</script>


        <div class="container">
            <div class="blog-slider">
                <h2><?php echo $settings['show-timer-product-sliders-theme-lkdfjsklfkdldffdfflnf321'] ?></h2>
                <div class="swiper mySwiper-blog">
                    <div class="swiper-wrapper">
                        <?php $blog_post = array(
                                'post_type' => 'post',
                        'posts_per_page' => $settings['fast-slider-pro-autoplay-count-blogs_vera'],
                        );
                        $blog_posts = new WP_Query($blog_post);
                        if ($blog_posts->have_posts()) {
                            while ($blog_posts->have_posts()) {
                                $blog_posts->the_post(); ?>
                                <div class="swiper-slide">
                                    <div class="image-blog-slider">
                                        <span class="loading_images loading_imagesss"></span>

                                        <?php
                                        $video_product = get_post_meta(get_the_ID(), 'meta-box-post-video-1', true);
                                        if (!empty($video_product)) {
                                            ?>
                                            <i class="fa-regular fa-circle-play"></i>
                                            <?php
                                        }
                                        ?>
                                        <?php if (get_the_post_thumbnail()) {
                                            ?>
                                                <img class="loading_image" style="display: none"
                                                     data-src="<?php echo get_the_post_thumbnail_url() ?>">
                                                <?php
                                        }
                                        else {
                                            ?>
                                            <img src="<?php echo get_template_directory_uri()."/img/not-img.png"; ?>"
                                            <?php
                                        }
                                        ?>
                                    </div>
                                    <div class="name-blog-slider">
                                        <a href=""></a>
                                        <a target="_blank" href="<?php echo get_the_permalink(); ?>" title="<?php the_title(); ?>"><h3><?php the_title(); ?></h3></a>
                                    </div>
                                    <div class="exeript-blog-slider">
                                        <?php the_excerpt(); ?>
                                    </div>
                                    <div class="auter-cat-blog-slider">
                                        <a><span><i class="fa-light fa-user"></i><?php the_author(); ?></span></a>
                                        <?php
                                        $categories = get_the_category();
                                        if ( ! empty( $categories ) ) {
                                            echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '"><span><i class="fa-light fa-list"></i>' . esc_html( $categories[0]->name ) . '</span></a>';
                                        }
                                        ?>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        ?>

                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </div>


		<?php
	}


	protected function content_template() {
	}

}
