<?php

class fore_img_text_diak_theme_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return '4-img-text-diak-theme';
	}

	public function get_title() {
		return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>المان تصویری و متن هاور انیمیشنی</h2>';
	}

	public function get_icon() {
		return 'eicon-photo-library';
	}

	public function get_categories() {
		return [ 'eleman-category' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'section_content-fore-img',
			[
				'label' => esc_html__( 'المان تصویری و متن هاور انیمیشنی', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'target-a-4-image',
			[
				'label' => esc_html__( 'باز شدن لینک های تصاویر در', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'_blank' => esc_html__( 'صفحه جدید', 'textdomain' ),
					'_self' => esc_html__( 'همین صفحه', 'textdomain' ),
				],

			]
		);
		$this->add_control(
			'image-item-one',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر اول', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-one',
			[
				'label' => 'لینک تصویر اول',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);
        $this->add_control(
            'text-img-one',
            [
                'label' => 'متن تصویر اول',
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'مردانه', 'textdomain' ),
            ]
        );
		$this->add_control(
			'image-item-two',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر دوم', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-two',
			[
				'label' => 'لینک تصویر دوم',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);
        $this->add_control(
            'text-img-two',
            [
                'label' => 'متن تصویر دوم',
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'زنانه', 'textdomain' ),
            ]
        );
		$this->add_control(
			'image-item-there',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر سوم', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-there',
			[
				'label' => 'لینک تصویر سوم',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);
        $this->add_control(
            'text-img-there',
            [
                'label' => 'متن تصویر سوم',
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'بچگانه', 'textdomain' ),
            ]
        );
		$this->add_control(
			'image-item-fore',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر چهارم', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-fore',
			[
				'label' => 'لینک تصویر چهارم',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);
        $this->add_control(
            'text-img-fore',
            [
                'label' => 'متن تصویر چارهم',
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'کفش اسپورت', 'textdomain' ),
            ]
        );
		$this->end_controls_section();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'استایل های تصاویر', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'number-border-radios-image',
			[
				'label' => esc_html__( 'منحنی گوشه های تصاویر', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 15,
			]
		);
        $this->add_control(
			'number-border-radios-image-561',
			[
				'label' => esc_html__( 'منحنی گوشه های بردر اضافات', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 15,
			]
		);
        $this->add_control(
            'text_background-icon-left-link-freast-hover-3521',
            [
                'label' => esc_html__( 'رنگ متن داخل تصویر مثل مردانه', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' =>'شما میتوانید رنگ متن داخل تصویر مثل مردانه را در حالت هاور تغییر و شخصی سازی کنید',
                'default' =>'#FFFFFF',
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast-hover-35215242',
            [
                'label' => esc_html__( 'رنگ اضافات کارت پستالی بالای تصویر و بردر گوشه های اضافات', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' =>'شما میتوانید رنگ متن داخل تصویر مثل مردانه را در حالت هاور تغییر و شخصی سازی کنید',
                'default' =>'#FFFFFF',
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast-hover-35215242dd',
            [
                'label' => esc_html__( 'رنگ پس زمینه اضافات وسط تصویر سفید کمرنگ ', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' =>'شما میتوانید رنگ پس زمینه اضافات وسط تصویر سفید کمرنگ را در حالت هاور تغییر و شخصی سازی کنید',
                'default' =>'rgba(255, 255, 255, 0.32)',
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		?>
		<style>
            .seactions-text-category-product-img-text .text-category-product-img-text-item figure {
                border-radius: <?php echo $settings['number-border-radios-image']."px"; ?> !important;
            }
            .seactions-text-category-product-img-text .text-category-product-img-text-item figure img {
                border-radius: <?php echo $settings['number-border-radios-image']."px"; ?> !important;
            }
            .seactions-text-category-product-img-text .text-category-product-img-text-item figure p.name-asl-cate-product-figory-img {
                color: <?php echo $settings['text_background-icon-left-link-freast-hover-3521']; ?> !important;
            }
            .seactions-text-category-product-img-text .text-category-product-img-text-item:before {
                border: 2px solid <?php echo $settings['text_background-icon-left-link-freast-hover-35215242']; ?> !important;
                background-color: <?php echo $settings['text_background-icon-left-link-freast-hover-35215242dd']; ?> !important;
                border-radius:<?php echo $settings['number-border-radios-image-561'].'px'; ?> <?php echo $settings['number-border-radios-image-561'].'px'; ?>  0 0;
            }
            .seactions-text-category-product-img-text .text-category-product-img-text-item:after {
                background-color: <?php echo $settings['text_background-icon-left-link-freast-hover-35215242']; ?> !important;
            }
            .seactions-text-category-product-img-text .text-category-product-img-text-item:hover:before {
                box-shadow: 0 0 15px  <?php echo $settings['text_background-icon-left-link-freast-hover-35215242']; ?> !important;
            }
            .seactions-text-category-product-img-text .text-category-product-img-text-item:hover:after {
                box-shadow: 0 0 15px  <?php echo $settings['text_background-icon-left-link-freast-hover-35215242']; ?> !important;
            }
		</style>



        <section class="seactions-text-category-product-img-text">
            <div class="text-category-product-img-text-item">
                <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-one']['url']; ?>">
                    <figure>
                        <img src="<?php echo $settings['image-item-one']['url']; ?>">
                        <p class="name-asl-cate-product-figory-img"><?php echo $settings['text-img-one']; ?></p>
                    </figure>
                </a>
            </div>
            <div class="text-category-product-img-text-item">
                <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-two']['url']; ?>">
                    <figure>
                        <img src="<?php echo $settings['image-item-two']['url']; ?>">
                        <p class="name-asl-cate-product-figory-img"><?php echo $settings['text-img-two']; ?></p>
                    </figure>
                </a>
            </div>
            <div class="text-category-product-img-text-item">
                <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-there']['url']; ?>">
                    <figure>
                        <img src="<?php echo $settings['image-item-there']['url']; ?>">
                        <p class="name-asl-cate-product-figory-img"><?php echo $settings['text-img-there']; ?></p>
                    </figure>
                </a>
            </div>
            <div class="text-category-product-img-text-item">
                <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-fore']['url']; ?>">
                    <figure>
                        <img src="<?php echo $settings['image-item-fore']['url']; ?>">
                        <p class="name-asl-cate-product-figory-img"><?php echo $settings['text-img-fore']; ?></p>
                    </figure>
                </a>
            </div>
        </section>


		<?php
	}


	protected function content_template() {
	}

}
