<?php
/*
Plugin Name: آیکون های فهرست ویراکس
Description: این یک پلاگین کاربردی برای به دست آوردن کلاس های فونت آیکون  برای قالب فروشگاهی ویراتم میباشد
Theme URI: https://www.zhaket.com/web/vera-theme
Author: تیم موبو پرس
Author URI: https://www.zhaket.com/store/web/mobopress/products
Version: 1.0
Text Domain: plugin-vera-theme
*/


function add_icon_menu_page() {
    add_menu_page(
        'آیکون های فهرست', // Page title
        'آیکون های منو', // Menu title
        'manage_options', // Capability
        'icon-menu', // Menu slug
        'icon_menu_page_html', // Function to display the page content
        'data:image/svg+xml;base64,' . base64_encode('<svg width="800px" height="800px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 9C12.75 8.58579 12.4142 8.25 12 8.25C11.5858 8.25 11.25 8.58579 11.25 9L11.25 11.25H9C8.58579 11.25 8.25 11.5858 8.25 12C8.25 12.4142 8.58579 12.75 9 12.75H11.25V15C11.25 15.4142 11.5858 15.75 12 15.75C12.4142 15.75 12.75 15.4142 12.75 15L12.75 12.75H15C15.4142 12.75 15.75 12.4142 15.75 12C15.75 11.5858 15.4142 11.25 15 11.25H12.75V9Z" fill="#1C274C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0574 1.25H11.9426C9.63424 1.24999 7.82519 1.24998 6.41371 1.43975C4.96897 1.63399 3.82895 2.03933 2.93414 2.93414C2.03933 3.82895 1.63399 4.96897 1.43975 6.41371C1.24998 7.82519 1.24999 9.63422 1.25 11.9426V12.0574C1.24999 14.3658 1.24998 16.1748 1.43975 17.5863C1.63399 19.031 2.03933 20.1711 2.93414 21.0659C3.82895 21.9607 4.96897 22.366 6.41371 22.5603C7.82519 22.75 9.63423 22.75 11.9426 22.75H12.0574C14.3658 22.75 16.1748 22.75 17.5863 22.5603C19.031 22.366 20.1711 21.9607 21.0659 21.0659C21.9607 20.1711 22.366 19.031 22.5603 17.5863C22.75 16.1748 22.75 14.3658 22.75 12.0574V11.9426C22.75 9.63423 22.75 7.82519 22.5603 6.41371C22.366 4.96897 21.9607 3.82895 21.0659 2.93414C20.1711 2.03933 19.031 1.63399 17.5863 1.43975C16.1748 1.24998 14.3658 1.24999 12.0574 1.25ZM3.9948 3.9948C4.56445 3.42514 5.33517 3.09825 6.61358 2.92637C7.91356 2.75159 9.62177 2.75 12 2.75C14.3782 2.75 16.0864 2.75159 17.3864 2.92637C18.6648 3.09825 19.4355 3.42514 20.0052 3.9948C20.5749 4.56445 20.9018 5.33517 21.0736 6.61358C21.2484 7.91356 21.25 9.62177 21.25 12C21.25 14.3782 21.2484 16.0864 21.0736 17.3864C20.9018 18.6648 20.5749 19.4355 20.0052 20.0052C19.4355 20.5749 18.6648 20.9018 17.3864 21.0736C16.0864 21.2484 14.3782 21.25 12 21.25C9.62177 21.25 7.91356 21.2484 6.61358 21.0736C5.33517 20.9018 4.56445 20.5749 3.9948 20.0052C3.42514 19.4355 3.09825 18.6648 2.92637 17.3864C2.75159 16.0864 2.75 14.3782 2.75 12C2.75 9.62177 2.75159 7.91356 2.92637 6.61358C3.09825 5.33517 3.42514 4.56445 3.9948 3.9948Z" fill="#1C274C"/>
</svg>'), // Icon URL
        60 // Position
    );
}
add_action( 'admin_menu', 'add_icon_menu_page' );

// Display the icon menu page
function icon_menu_page_html() {
    // Check user capabilities
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    // Array of Font Awesome icons
    $icons = array(
        'fas fa-shop',
        'fas fa-bag-shopping',
        'fas fa-basket-shopping',
        'fas fa-blog',
        'fas fa-block-question',
        'fas fa-block-quote',
        'fas fa-trillium',
        'fas fa-hexagon-image',
        'fas fa-phone',
        'fas fa-phone-office',
        'fas fa-square-phone',
        'fas fa-circle-phone',
        'fas fa-mobile',
        'fas fa-laptop-mobile',
        'fas fa-headphones',
        'fas fa-microphone-stand',
        'fas fa-star',
        'fas fa-heart',
        'fas fa-truck-fast',
        'fas fa-gift',
        'fas fa-camera',
        'fas fa-balloons',
        'fas fa-badge-check',
        'fas fa-badge-check',
        'fas fa-shirt',
        'fas fa-moped',
        'fas fa-trophy',
        'fas fa-gift-card',
        'fas fa-badge-percent',
        'fas fa-gem',
        'fas fa-bomb',
        'fas fa-bell',
        'fas fa-question',
        'fas fa-rocket',
        'fas fa-watch',
        'fas fa-award',
        'fas fa-flower',
        'fa-brands fa-google-play',
        'fas fa-percent',
        'fas fa-headset',
        'fas fa-tablet',
        'fas fa-sunglasses',
        'fas fa-spa',
        'fas fa-shelves',
        'fas fa-lamp-floor',
        'fas fa-lamp-street',
        'fas fa-hard-drive',
        'fas fa-hand-back-point-left',
        'fas fa-flashlight',
        'fas fa-fire-flame-curved',
        'fas fa-fire-flame-curved',
        'fa-brands fa-instagram',
        'fa-brands fa-whatsapp',
        'fa-brands fa-telegram',
        'fas fa-snowflake',
        'fas fa-computer-speaker',
        'fas fa-lamp',
        'fas fa-tablet-button',
        'fas fa-square-quote',
        'fas fa-snowflakes',
        'fas fa-router',
        'fas fa-ribbon',
        'fas fa-plane-engines',
        'fas fa-pencil-mechanical',
        'fas fa-paper-plane-top',
        'fas fa-face-awesome',
        'fas fa-face-smile',
        'fas fa-face-zany',
        'fas fa-face-laugh-wink',
        'fas fa-face-glasses',
        'fas fas fa-mug-hot',
        'fas fa-stocking',
        'fas fa-cookie-bite',
        'fas fa-jack-o-lantern',
        'fas fa-party-horn',
        'fas fa-house-blank',
        'fas fa-house-fire',
        'fas fa-donut',
        'fas fa-bed',
        'fas fa-briefcase',
        'fas fa-shower',
        'fas fa-dice',
        'fas fa-dumbbell',
        'fas fa-vacuum',

        'fas fa-shopping-cart',
        'fas fa-store',
        'fas fa-tags',
        'fas fa-receipt',
        'fas fa-cash-register',
        'fas fa-credit-card',
        'fas fa-barcode',
        'fas fa-percent',
        'fas fa-gift',
        'fas fa-truck',
        'fas fa-box-open',
        'fas fa-shipping-fast',
        'fas fa-money-check',
        'fas fa-wallet',
        'fas fa-piggy-bank',
        'fas fa-donate',
        'fas fa-hand-holding-usd',
        'fas fa-dollar-sign',
        'fas fa-coins',
        'fas fa-file-invoice-dollar',
        'fas fa-file-invoice',
        'fas fa-user-tag',
        'fas fa-shopping-basket',
        'fas fa-store-alt',
        'fas fa-cart-arrow-down',
        'fas fa-cart-plus',
        'fas fa-user-shield',

        'fas fa-truck-container',
        'fas fa-truck-couch',
        'fas fa-truck-ramp',
        'fas fa-truck',
        'fas fa-warehouse-alt',
        'fas fa-warehouse',
        'fas fa-weight-hanging',
        'fas fa-weight',
        'fas fa-x-ray',
        'fas fa-yen-sign',
        'fas fa-won-sign',
        'fas fa-vote-yea',
        'fas fa-vote-nay',
        'fas fa-vote-yea',
        'fas fa-vote-nay',
        'fas fa-universal-access',
        'fas fa-tty',
        'fas fa-traffic-light',
        'fas fa-traffic-light-go',
        'fas fa-traffic-light-slow',
        'fas fa-traffic-light-stop',
        'fas fa-train',
        'fas fa-subway',
        'fas fa-shuttle-van',
        'fas fa-ship',
        'fas fa-plane',
        'fas fa-helicopter',
        'fas fa-drafting-compass',
        'fas fa-dharmachakra',

        'fas fa-cart-plus',
        'fas fa-user-shield',
        'fas fa-parachute-box',
        'fas fa-dolly',
        'fas fa-dolly-flatbed',
        'fas fa-warehouse',
        'fas fa-shipping-timed',
        'fas fa-pallet',
        'fas fa-funnel-dollar',
        'fas fa-cash-register',
        'fas fa-store-alt-slash',
        'fas fa-store-slash',
        'fas fa-hand-holding-water',
        'fas fa-hand-holding-heart',
        'fas fa-hands-helping',
        'fas fa-hands-usd',
        'fas fa-comment-dollar',
        'fas fa-comments-dollar',
        'fas fa-credit-card-front',
        'fas fa-credit-card-blank',
        'fas fa-barcode-read'
    );



    echo '<div class="wrap">';
    echo '<h1 style="font-family:IRANYekanX">' . esc_html( get_admin_page_title() ) . '</h1>';
    echo '<p style="font-family: IRANYekanX">این پلاگین جهت اضافه کردن آیکون به منو سایت طراحی گردیده است و فقط در قالب فروشگاهی ویراتم کاربرد دارد آیکون ها را با کلیک روی آنها کپی و در قسمت فهرست ها در ویرایش هر بخش در ساختار فهرست به منو آیتم خود آیکون دلخواه را اضافه کنید</p>';
    echo '<ul style="list-style: none; display: flex;justify-content: space-between; flex-wrap: wrap;">';
    foreach ( $icons as $icon ) {
        echo '<li style="width: 12.5%;background:#fff; padding: 10px;border-radius:10px; text-align: center; cursor: pointer;" onclick="copyToClipboard(\'' . $icon . '\')">';
        echo '<i class="' . $icon . '" style="font-size: 24px;"></i>';
        echo '<p>' . $icon . '</p>';
        echo '</li>';
    }
    echo '</ul>';
    echo '</div>';
    echo '<p style="font-family: IRANYekanX;">شما میتوانید برای آیکون های بیشتر به صفحه آیکون فونت آسم مراجعه کرده و در قسمت آیکون - آیکون مورد نظر را جستجو و کلاس را به بخش فهرست منتقل کنید</p>';
    echo '<p style="font-family: IRANYekanX;padding-bottom: 10px;color: #dc163e">توصیه توسعه دهنده : لطفا در هنگام مراجعه به لینک پایین از سرویس vpn استفاده نمایید</p>';
    echo '<a target="_blank" href="https://fontawesome.com/icons" style="background: #00adb5;color:#fff;padding: 10px;border-radius: 5px;text-decoration: none;font-family: IRANYekanX">انتقال به صفحه آیکون ها</a>';
    echo '<script>
    function copyToClipboard(text) {
        var textarea = document.createElement("textarea");
        textarea.textContent = text;
        textarea.style.position = "fixed";
        document.body.appendChild(textarea);
        textarea.select();
        try {
            document.execCommand("copy");
            alert("کلاس آیکون کپی شد: " + text);
        } catch (ex) {
            console.warn("Copy to clipboard failed.", ex);
            return false;
        } finally {
            document.body.removeChild(textarea);
        }
    }
    </script>';
}
?>
