<?php


function get_crawler_state() {
    $state = get_option('berozkala_crawler_state', []);
    return $state ?: ['category_index' => 0, 'page' => 1];
}
function save_crawler_state($state) {
    update_option('berozkala_crawler_state', $state);
}


add_filter('cron_schedules', 'add_one_minute_interval');
function add_one_minute_interval($schedules) {
    $schedules['one_minute'] = [
        'interval' => 60, // 60 ثانیه
        'display'  => __('Every One Minute'),
    ];
    return $schedules;
}

function berozkala_register_cron_event() {
    if (!wp_next_scheduled('berozkala_crawler_cron_event')) {
        wp_schedule_event(time(), 'one_minute', 'berozkala_crawler_cron_event');
    }
}
add_action('wp', 'berozkala_register_cron_event');

add_action('berozkala_crawler_cron_event', 'berozkala_crawler_cron');


function debug_plugin_log($message) {
    $log_file = __DIR__ . '/debug_plugin1.log'; // مسیر فایل لاگ
    $timestamp = date('Y-m-d H:i:s');
    $formatted_message = "[$timestamp] $message" . PHP_EOL;
    file_put_contents($log_file, $formatted_message, FILE_APPEND);
}


function berozkala_mark_unfetched_products_in_category($category_id) {
    if (!$category_id ) return;


    // گرفتن همه محصولات این دسته‌بندی که در لیست نیستن
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'fields'         => 'ids',
        'tax_query'      => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => [$category_id],
            ),
        ),
//        'post__not_in'   => $existing_ids,
    );

    $posts_to_mark = get_posts($args);
    foreach ($posts_to_mark as $product_id) {
        update_post_meta($product_id, 'b_price_update_stock_checker_circle', 0);
        berozkala_log("🟥 محصول ID $product_id به دلیل نبودن در لیست جدید، ناموجود شد (b_price_update = 0)");
    }
}


function berozkala_crawler_cron() {
    $category_list = get_field('category_list', 'option'); // لیست دسته‌بندی‌ها از تنظیمات ACF
    if (empty($category_list)) {
        berozkala_log("هیچ دسته‌بندی‌ای پیدا نشد.");
        return;
    }

    $current_state = get_option('berozkala_crawler_state', [
        'current_category_index' => 0,
        'current_page'           => 1,
        'logs'                   => [],
    ]);

    $current_index = $current_state['current_category_index'];
    $current_page  = $current_state['current_page'];

    if (!isset($category_list[$current_index])) {
        berozkala_log("تمام دسته‌بندی‌ها پردازش شده‌اند. ریست به وضعیت اولیه.");
        update_option('berozkala_crawler_state', [
            'current_category_index' => 0,
            'current_page'           => 1,
            'logs'                   => [],
        ]);
        return;
    }

    $category = $category_list[$current_index];
    if($current_page > 1){}else{
        $unset_price = berozkala_mark_unfetched_products_in_category($category['categor_item']);
    }
    $category_name = !empty($category['categor_item']) ? $category['categor_item'] : "نامشخص";
    $category_url = 'https://berozkala.com' . ($category['link'] ?? '');
    if ($current_page > 1) {
        $category_url .= '?page=' . $current_page;
    }

    berozkala_log("شروع کرال دسته‌بندی: $category_name | صفحه: $current_page | آدرس: $category_url");


    $crawler = new Berozkala_Crawler();
    $result = $crawler->fetch_category_products($category_url);

    debug_plugin_log('دسته بندی  جدید');
    debug_plugin_log($category_name);
    debug_plugin_log(count($result));

    $product_exist_in_shop = array();


    if (empty($result['products'])) {
        debug_plugin_log("محصول خالی هستش");
        berozkala_log("هیچ محصولی در صفحه $current_page پیدا نشد.");
    } else {
        $wp_integration = new Berozkala_WP_Integration();
        foreach ($result['products'] as $product) {
            debug_plugin_log('فرستادن محصول برای اکشن');
            $id = $wp_integration->save_product_to_wp($product, $category);
            berozkala_log("محصول ذخیره شد: " . $product['title']);
            if($id){
                array_push($product_exist_in_shop,$id);
            }

        }

    }

    if (!empty($result['skip_category'])) {
        berozkala_log("دسته‌بندی $category_name به دلیل داشتن حداقل یک محصول بدون قیمت، رد شد.");
        $current_state['current_category_index']++;
        $current_state['current_page'] = 1;
        update_option('berozkala_crawler_state', $current_state);
        return;
    }


// بررسی وجود صفحه بعد
    if ($result['has_next_page']) {
        $current_state['current_page']++;
    } else {
        // رفتن به دسته‌بندی بعدی
        $current_state['current_category_index']++;
        $current_state['current_page'] = 1;
    }

    update_option('berozkala_crawler_state', $current_state);
    berozkala_log("پایان پردازش دسته‌بندی: $category_name | صفحه: $current_page");
}

function berozkala_crawler_status() {
    $category_list = get_field('category_list', 'option');
    $current_state = get_option('berozkala_crawler_state', [
        'current_category_index' => 0,
        'current_page'           => 1,
        'logs'                   => [],
    ]);

    $current_index = $current_state['current_category_index'];
    $current_page = $current_state['current_page'];

    if (!isset($category_list[$current_index])) {
        return "تمام دسته‌بندی‌ها پردازش شده‌اند.";
    }

    $category_name = get_term($category_list[$current_index]['categor_item'])->name ?? "نامشخص";
    $category_link = 'https://berozkala.com' . ($category_list[$current_index]['link'] ?? "#");

    $remaining = [];
    for ($i = $current_index + 1; $i < count($category_list); $i++) {
        $remaining[] = get_term($category_list[$i]['categor_item'])->name ?? "نامشخص";
    }

    ob_start();
    echo "<h3>وضعیت کرالر</h3>";
    echo "<p>دسته‌بندی فعلی: $category_name</p>";
    echo "<p>صفحه فعلی: $current_page</p>";
    echo "<p>آدرس دسته‌بندی: <a href='$category_link' target='_blank'>$category_link</a></p>";
    echo "<p>دسته بندی های بعدی در صف کرال</p>";
    echo "<ul style='display: flex;flex-direction: row;flex-wrap: wrap;'>";
    foreach($remaining as $item){
        echo "<li style='background: #fff;padding: 2px 10px;border-radius: 6px;border: 1px solid #e9e9e9;margin: 0 0 6px 7px;'>$item</li>";
    }
    echo "</ul>";
    return ob_get_clean();
}




?>