<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$allowed_html = array(
    'a' => array(
        'href' => array(),
    ),
);
?>

    <div class="dashbord-vera_theme">
        <div class="dashbord-vera_theme-2">
            <div class="dashbord-vera_theme-2-1">
                <div class="gred_stutos_shop_order_account">
                    <a href="<?php echo wc_get_account_endpoint_url('orders')."/?status=wc-on-hold"; ?>" class="gred_stutos_shop_order_accounts">
                        <img src="<?php echo get_template_directory_uri() . "/img/dashbord-6.png"; ?>">
                        <p>در حال برسی</p>
                        <?php
                        if (on_hold_count() !== 0 ) {
                        ?>
                        <span><?php  echo on_hold_count();  ?></span>
                            <?php
                        }
                            ?>
                    </a>
                    <a href="<?php echo wc_get_account_endpoint_url('orders')."/?status=wc-processing"; ?>" class="gred_stutos_shop_order_accounts">
                        <img src="<?php echo get_template_directory_uri() . "/img/dashbord-7.png"; ?>">
                        <p>در حال پردازش</p>
                        <?php
if (proccessing_count() !== 0 ) {
                        ?>
                        <span><?php echo proccessing_count();  ?></span>
    <?php
}
    ?>
                    </a>
                    <a href="<?php echo wc_get_account_endpoint_url('orders')."/?status=wc-delivered"; ?>" class="gred_stutos_shop_order_accounts">
                        <img src="<?php echo get_template_directory_uri() . "/img/dashbord-8.png"; ?>">
                        <p>ارسال شده</p>
<?php
if (sending_count() !== 0 ) {
    ?>
                        <span><?php  echo  sending_count();   ?></span>
    <?php
}
    ?>
    </a>
                    <a href="<?php echo wc_get_account_endpoint_url('orders')."/?status=wc-completed"; ?>" class="gred_stutos_shop_order_accounts">
                        <img src="<?php echo get_template_directory_uri() . "/img/dashbord-9.png"; ?>">
                        <p>تکمیل شده</p>
<?php
if (compilet_count() !== 0 ) {
    ?>
                        <span><?php if (compilet_count() !== "0") { echo compilet_count(); } ?></span>
    <?php
}
    ?>
    </a>
                </div>
            </div>
            <div class="dashbord-vera_theme-2-2">
                <canvas id="myChart"></canvas>
                <script>

                    $(document).ready(function () {
                        const ctx = document.getElementById('myChart');
                        Chart.defaults.font.family = "iranyekanx";

                        new Chart(ctx, {
                            type: 'line',
                            data: {
                                labels: ['فروردین', 'اردیبهشت', 'خرداد', 'تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند'],
                                datasets: [{
                                    label: 'تعداد کل سفارشات',
                                    data: [<?php echo get_cont_total_order() ?> ,<?php echo get_cont_total_order_2() ?>,<?php echo get_cont_total_order_3() ?> ,<?php echo get_cont_total_order_4() ?>,<?php echo get_cont_total_order_5() ?>,<?php echo get_cont_total_order_6() ?>,<?php echo get_cont_total_order_7() ?>,<?php echo get_cont_total_order_8() ?>,<?php echo get_cont_total_order_9() ?>,<?php echo get_cont_total_order_10() ?>,<?php echo get_cont_total_order_11() ?>,<?php echo get_cont_total_order_12() ?>],
                                    borderWidth: 3,
                                    yAxisID: 'y1'
                                },
                                {
                                    label: 'مبلغ کل سفارشات',
                                    data: [<?php echo get_customer_total_order() ?> , <?php echo get_customer_total_order_2() ?>,<?php echo get_customer_total_order_3() ?>,<?php echo get_customer_total_order_4() ?>,<?php echo get_customer_total_order_5() ?> ,<?php echo get_customer_total_order_6() ?> ,<?php echo get_customer_total_order_7() ?> ,<?php echo get_customer_total_order_8() ?> ,<?php echo get_customer_total_order_9() ?> ,<?php echo get_customer_total_order_10() ?>,<?php echo get_customer_total_order_11() ?>,<?php echo get_customer_total_order_12() ?>],
                                    borderWidth: 3,
                                    yAxisID: 'y2'
                                }]
                            },
                            options: {
                                responsive: true,
                                interaction: {
                                    mode: 'index',
                                    intersect: false,
                                },
                                stacked: false,
                                plugins: {
                                        title: {
                                        display: true,
                                        text: 'نمودار سفارشات شما در فروشگاه',
                                        },

                                },
                                scales: {
                                    y1: {
                                        type: 'linear',
                                        display: true,
                                        position: 'left'

                                    },
                                    y2: {
                                        type: 'linear',
                                        display: true,
                                        position: 'right'
                                    }
                                }
                            }
                        });
                    });

                </script>
                <div class="headline load-hidden blog-slider">
                    <div class="swiper mySwiper-blog-account">
                        <div class="swiper-wrapper">
                            <?php $blog_post = array('post_type' => 'post', 'posts_per_page' => 3);
                            $blog_posts = new WP_Query($blog_post);
                            if ($blog_posts->have_posts()) {
                                while ($blog_posts->have_posts()) {
                                    $blog_posts->the_post(); ?>
                                    <div style="background: #f3f3f3 !important;" class="swiper-slide">
                                        <a target="_blank" href="<?php echo get_the_permalink(); ?>" title="<?php the_title(); ?>" class="image-blog-slider">
                                            <?php
                                            $video_product = get_post_meta(get_the_ID(), 'meta-box-post-video-1', true);
                                            if (!empty($video_product)) {
                                                ?>
                                                <i class="fa-regular fa-circle-play"></i>
                                                <?php
                                            }
                                            ?>
                                            <?php if (get_the_post_thumbnail()) {
                                                the_post_thumbnail();
                                            }
                                            else {
                                                ?>
                                                <img src="<?php echo get_template_directory_uri()."/img/not-img.png"; ?>"
                                                <?php
                                            }
                                            ?>
                                        </a>
                                        <div class="name-blog-slider">
                                            <a target="_blank" href="<?php echo get_the_permalink(); ?>" title="<?php the_title(); ?>"><h3><?php the_title(); ?></h3></a>
                                        </div>

                                    </div>
                                    <?php
                                }
                            }
                            ?>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */
do_action('woocommerce_account_dashboard');

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_before_my_account');

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_after_my_account');

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
