<?php
/**
 * "Order received" message.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order|false $order
 */

defined( 'ABSPATH' ) || exit;
?>
<style>
    .woocommerce-notice {
        padding: 15px;
        border: 2px dashed #ddd;
        text-align: center;
        font-weight: 500;
        display: flex;
        justify-content: center;
        align-items: center;
        margin-bottom: 15px;
    }

    .woocommerce-notice--success:before {
        content: "\f058";
        font-family: "Font Awesome 5 Pro";
        padding-left: 7px;
        font-size: 20px;
        color: #00b894;
    }
    .woocommerce-form-login {
        border: 0 !important;
        display: flex;
        width: 450px;
        max-width: 100%;
        justify-content: center;
        margin: 0 auto !important;
        flex-wrap: wrap;
        padding:20px 0 !important;
    }

    .woocommerce-form-login > p {
        font-size: 13px;
        font-weight: 400;
        color: #939393;
        padding: 0 0 15px;
        width: 100% !important;
    }

    .woocommerce-form-login input[type="text"] {
        padding: 15px 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 3px;
        border: 1px solid rgba(169, 169, 169, 0.77);
    }
    .woocommerce-form-login input[type="password"] {
        padding: 15px 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 3px;
        border: 1px solid rgba(169, 169, 169, 0.77);
    }

    .woocommerce-form-login button {
        font-size: 14px;
        font-family: 'IRANYekanX';
        padding: 15px 10px !important;
        border: 0;
        color: #FFFFFF !important;
        background: var(--main-color) !important;
        font-weight: 400;
        width: 100%;
        transition: all .3s ease-in-out;
    }
    .woocommerce-form-login input[type="checkbox"] {
        display: grid;
        place-content: center;
        margin-left: 10px;
        float: right;
        width: 30px;
        height: 15px;
        -webkit-appearance: none;
        appearance: none;
        background-color: #fff;
        border: 1px solid rgba(204, 204, 204, 0.62);
        border-radius: 15px;
        position: relative;
    }

    .woocommerce-form-login input[type="checkbox"]::before {
        content: "";
        width: 14px;
        transition: all 1s ease-in-out !important;
        height: 14px;
        position: absolute;
        transform: scale(1);
        box-shadow: none !important;
        background: #0073aa;
        border-radius: 15px;
        left: 0;
    }

    .woocommerce-form-login input[type="checkbox"]:checked {
        background: rgba(0, 122, 255, 0.44);
    }
    .woocommerce-form-login input[type="checkbox"]:checked::before {
        right: 0;
        transition: all 1s ease-in-out !important;
    }
    .woocommerce-form-login .woocommerce-form__label {
        display: flex !important;
        align-items: center;
        padding-bottom:1rem;
    }
    .woocommerce-form-login a {
        opacity: .7;
        color: #222222;
        text-decoration: none;
        transition: all .3s ease-in-out;
    }
    .woocommerce-form-login a:hover {
        opacity:1;
    }
    .woocommerce-form-login a:hover {
        opacity:1;
    }

    .woocommerce-form-login  .show-password-input {
        top: 18px !important;
    }
    .woocommerce-form-login  .show-password-input:after {
        content: "\f06e" !important;
        font-family: "Font Awesome 5 Pro" !important;
    }
    .woocommerce-form-login  .display-password:after {
        content: "\f070" !important;
        font-family: "Font Awesome 5 Pro" !important;
    }
</style>
<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received">
	<?php
	/**
	 * Filter the message shown after a checkout is complete.
	 *
	 * @since 2.2.0
	 *
	 * @param string         $message The message.
	 * @param WC_Order|false $order   The order created during checkout, or false if order data is not available.
	 */
	$message = apply_filters(
		'woocommerce_thankyou_order_received_text',
		__( 'Thank you. Your order has been received.', 'woocommerce' ),
		$order
	);

	echo esc_html( $message );
	?>
</p>
