<style>
    <?php
    include_once "style-woo.css";
    ?>
</style>
<script>
    <?php
    include_once "js-woo.js";
    ?>
</script>
<?php


// Add breadcrumb in product page
add_action('woocommerce_before_main_content', 'add_product_breadcrumb', 20);
function add_product_breadcrumb()
{
    $terms = get_the_terms(get_the_ID(), 'product_cat');
    $home_url = get_home_url();
    $breadcrumb = '<div class="breadcrumb">';
    $breadcrumb .= '<a href="' . $home_url . '">خانه</a>';
    $breadcrumb .= '<span><i class="fa-light fa-chevron-left"></i></span>';
    $breadcrumb .= '<a href="' . get_permalink(wc_get_page_id('shop')) . '">فروشگاه</a>';
    if ($terms) {
        $breadcrumb .= '<span><i class="fa-light fa-chevron-left"></i></span><a href="' . get_term_link($terms[0]->term_id, 'product_cat') . '">' . $terms[0]->name . '</a>';
    }
    $breadcrumb .= '<span><i class="fa-light fa-chevron-left"></i></span>';
    $breadcrumb .= '<span style="float: left" class="current">' . get_the_title() . '</span>';
    $breadcrumb .= '<span class="before_vread-crumd">...</span>';
    $breadcrumb .= '</div>';
    echo $breadcrumb;

}

function get_woocommerce_ratings()
{

    global $product;

    if (!$product->get_rating_count()) {
        return;
    }

    $rating = $product->get_average_rating();
    $count = $product->get_rating_count();

    $full_stars = floor($rating);

    $html = '';
    for ($i = 1; $i <= 5; $i++) {
        if ($i <= $full_stars) {
            $html .= '<i class="fa-solid fa-star"></i>';
        } else {
            if (strpos($rating, ".") !== false) {
                $html .= '<i style="transform: rotateY(180deg);" class="fa-duotone fa-star-sharp-half"></i>';
                $rating = (int)$rating;
            } else {
                $html .= '<i class="fa-duotone fa-star"></i>';
            }
        }
    }
    $html .= '<span><i class="fa-solid fa-bracket-round"></i>' . $count . " " . "نظر مشتری" . '<i class="fa-solid fa-bracket-round-right"></i></span>';

    return $html;

}

if (!function_exists('wc_get_product_availability')) {

    function wc_get_product_availability()
    {

        global $product;

        if ($product->is_in_stock()) {

            echo '<p class="stock in-stock">موجودی : <span style="color: #388e3c">موجود است</span></p>';

        } else {

            echo '<p class="stock out-of-stock">موجودی : <span style="color: #ff6161">موجود نیست</span></p>';

        }

    }

}


function woocommerce_custom_add_to_cart()
{
    global $product;

    $product_type = $product->get_type();
    $cantional_cart_button = get_post_meta(get_the_ID(), 'metaboxe_product-linkss', true);
    $cantional_cart_buttons = get_post_meta(get_the_ID(), 'vera-theme-linssss', true);
    $cantional_cart_buttonss = get_post_meta(get_the_ID(), 'vera-theme-linsssss', true);
    $cantional_cart_buttonsss = get_post_meta(get_the_ID(), 'metaboxe_product-linkss-blank', true);
    if ($cantional_cart_button == "on") {
        ?>
        <form class="carts">
            <a class="buttons" target="<?php if ($cantional_cart_buttonsss == "on") {
                echo "_blank";
            } else {
                echo "_self";
            } ?>" href="<?php echo $cantional_cart_buttonss; ?>">
                <?php
                if ($cantional_cart_buttons !== "") {
                    echo $cantional_cart_buttons;
                } else {
                    echo "هدایت به برگه فروشگاه";
                }
                ?>
            </a>
        </form>
        <?php
    } else {
        if ($product_type === 'variable') {
            global $product;
            if ($product->is_in_stock()) {
                $button = do_action('woocommerce_variable_add_to_cart');
            } else {
                $button = add_email_form();
            }
        } else {
            if ($product->is_purchasable() && $product->is_in_stock()) {
                $button = woocommerce_template_single_add_to_cart();
            } else {
                $button = add_email_form();
            }

        }
        return $button;
    }
}


add_action('woocommerce_after_quantity_input_field', 'arendelle_quantity_plus_sign');
function arendelle_quantity_plus_sign()
{
    echo '<span class="quantity__button quantity__plus"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                             viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                             stroke-width="2" stroke-linecap="round"
                                                             stroke-linejoin="round" class="feather feather-plus"><line
                    x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg></span>';
}

add_action('woocommerce_before_quantity_input_field', 'arendelle_quantity_minus_sign');
function arendelle_quantity_minus_sign()
{
    echo '<span class="quantity__button quantity__minus"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                              viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                              stroke-width="2" stroke-linecap="round"
                                                              stroke-linejoin="round" class="feather feather-minus"><line
                    x1="5" y1="12" x2="19" y2="12"></line></svg></span>';
}

add_action('wp_footer', 'arendelle_quantity_plus_minus');
function arendelle_quantity_plus_minus()
{

    ?>
    <script type="text/javascript">

        jQuery(document).ready(function ($) {

            var forms = jQuery('.woocommerce-cart-form, form.cart');
            forms.find('.quantity.hidden').prev('.quantity__button').hide();
            forms.find('.quantity.hidden').next('.quantity__button').hide();

            $(document).on('click', 'form.cart .quantity__button, .woocommerce-cart-form .quantity__button', function () {

                var $this = $(this);

                // Get current quantity values
                var qty = $this.closest('.quantity').find('.qty');
                var val = (qty.val() == '') ? 0 : parseFloat(qty.val());
                var max = parseFloat(qty.attr('max'));
                var min = parseFloat(qty.attr('min'));
                var step = parseFloat(qty.attr('step'));

                // Change the value if plus or minus
                if ($this.is('.quantity__plus')) {
                    if (max && (max <= val)) {
                        qty.val(max).change();
                    } else {
                        qty.val(val + step).change();
                    }
                } else {
                    if (min && (min >= val)) {
                        qty.val(min).change();
                    } else if (val >= 1) {
                        qty.val(val - step).change();
                    }
                }
            });
        });

    </script>
    <?php
}


add_filter('woocommerce_dropdown_variation_attribute_options_html', static function ($html, $args) {
    $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), [
        'options' => false,
        'attribute' => false,
        'product' => false,
        'selected' => false,
        'name' => '',
        'id' => '',
        'class' => '',
        'show_option_none' => __('Choose an option', 'woocommerce'),
    ]);
    $options = $args['options'];
    $product = $args['product'];
    $attribute = $args['attribute'];
    $name = $args['name'] ?: 'attribute_' . sanitize_title($attribute);
    $id = $args['id'] ?: sanitize_title($attribute);
    $class = $args['class'];
    $show_option_none = (bool)$args['show_option_none'];

    $show_option_none_text = $args['show_option_none'] ?: __('Choose an option', 'woocommerce');

    if ($attribute && $product instanceof WC_Product && $args['selected'] === false) {
        $selected_key = 'attribute_' . sanitize_title($attribute);
        $args['selected'] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key]))
            : $product->get_variation_default_attribute($attribute); // WPCS: input var ok, CSRF ok, sanitization ok.
    }

    if (empty($options) && !empty($product) && !empty($attribute)) {
        $attributes = $product->get_variation_attributes();
        $options = $attributes[$attribute];
    }
    $radios = '<div class="custom-wc-variations">';

    if (!empty($options)) {
        if ($product && taxonomy_exists($attribute)) {
            $terms = wc_get_product_terms($product->get_id(), $attribute, ['fields' => 'all']);
            $product_variations = $product->get_available_variations();
            foreach ($terms as $term) {
                if (in_array($term->slug, $options, true)) {

                    $isVariationAvailable = false;
                    foreach ($product_variations as $variation) {
                        $variation_attributes = $variation['attributes'];
                        if (isset($variation_attributes['attribute_' . sanitize_title($attribute)]) && $variation_attributes['attribute_' . sanitize_title($attribute)] === $term->slug) {
                            $isVariationAvailables = $variation;
                            $isVariationAvailable = $variation["is_in_stock"];
                            break;
                        }
                    }

                    $colors = $term->term_id;
                    $color = get_term_meta($colors, 'color', true);
                    if (!empty($color)) {
                        $radios .= "<div class='item-attribute-products'>";
                    } else {
                        $radios .= "<div class='item-attribute-product'>";
                    }

                    $radios .= '<input  type="radio" name="custom_' . esc_attr($name) . '" data-value="' . esc_attr($term->slug) . '" id="'
                        . esc_attr($name) . '_' . esc_attr($term->slug) . '" data-variation-name="' . esc_attr($name) . '" '
                        . checked(sanitize_title($args['selected']), $term->slug, false) . '>';
                    if (!empty($color)) {
                        $radios .= '<div style="border:2px solid #FFF;height: 25px;width: 25px;border-radius: 50%;background: ' . $color . ';"></div>';
                    }
                    $radios .= '<label for="' . esc_attr($name) . '_' . esc_attr($term->slug) . '">';
                    $radios .= esc_html(apply_filters('woocommerce_variation_option_name', $term->name));
                    $radios .= '</label>';
                    $radios .= '</div>';
                }
            }
        } else {

            foreach ($options as $option) {
                    $colors = $option->term_id;
                    $color = get_term_meta($colors, 'color', true);

                if (!empty($color)) {
                    $radios .= "<div class='item-attribute-products'>";
                } else {
                    $radios .= "<div class='item-attribute-product'>";
                }

                $checked = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'],

                    sanitize_title($option), false) : checked($args['selected'], $option, false);
                $radios .= '<input type="radio" name="custom_' . esc_attr($name) . '" data-value="' . esc_attr($option) . '" id="'
                    . esc_attr($name) . '_' . esc_attr($option) . '" data-variation-name="' . esc_attr($name) . '" ' . $checked . '>';
                if (!empty($color)) {
                    $radios .= '<div style="border:2px solid #FFF;height: 25px;width: 25px;border-radius: 50%;background: ' . $color . ';"></div>';
                }
                $radios .= '<label for="' . esc_attr($name) . '_' . esc_attr($option) . '">';
                $radios .= esc_html(apply_filters('woocommerce_variation_option_name', $option));
                $radios .= '</label>';
                $radios .= '</div>';
            }
        }
    }


    $radios .= '</div>';

    return $html . $radios;

}, 20, 2);
add_action('wp_ajax_update_variations', 'update_variations_callback');
add_action('wp_ajax_nopriv_update_variations', 'update_variations_callback');

function update_variations_callback() {
    // Get the product ID and variation data
    $product_id = intval($_POST['product_id']);
    $variation_data = wc_clean($_POST['variation_data']);

    // Get the product object
    $product = wc_get_product($product_id);

    // Check if the product is a variable product
    if ($product->is_type('variable')) {
        // Get the available variations
        $available_variations = $product->get_available_variations();

        // Filter out unavailable variations
        $filtered_variations = array_filter($available_variations, function($variation) use ($variation_data) {
            return array_intersect_assoc($variation['attributes'], $variation_data) === $variation_data;
        });

        // Get the variation HTML
        ob_start();
        wc_get_template('single-product/add-to-cart/variation.php', array(
            'available_variations' => $filtered_variations,
            'attributes' => $product->get_variation_attributes(),
            'selected_attributes' => $variation_data
        ));
        $variation_html = ob_get_clean();

        // Return the variation HTML as the response
        wp_send_json_success($variation_html);
    } else {
        wp_send_json_error('This is not a variable product.');
    }

    wp_die();
}
?>

<style>
    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo select {
        display: none !important;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations {
        width: 100%;
        float: right;
        padding: 5px 0;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-product {
        padding: 5px 10px;
        float: right;
        width: fit-content;
        margin-left: 8px;
        display: flex;
        align-content: center;
        justify-content: space-between;
        position: relative;
        color: #090909;
        font-size: 13px;
        border-radius: 0.5em;
        background: #fdfdfd;
        transition: all .3s;
        box-shadow: 3px 3px 3px #d4d6d76e, -3px -3px 3px rgb(236 236 236 / 63%);
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-products {
        border-radius: 50%;
        float: right;
        width: fit-content;
        margin-left: 8px;
        display: flex;
        align-content: center;
        justify-content: space-between;
        position: relative;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-products input[type="radio"] {
        border-radius: 50% !important;
        transition: all .3s ease-in-out;
        border: 2px solid rgba(221, 221, 221, 0.53)
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-products input[type="radio"]:checked {
        box-shadow: 0 0 0 2px #dddddd;
        transition: all .3s ease-in-out;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-products input[type="radio"]:checked:before {
        content: "\f00c";
        color: #222222;
        font-family: "Font Awesome 5 Pro";
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-products label {
        position: absolute;
        right: 0;
        top: -130%;
        background: #ffffff;
        border: 1px solid #ddd;
        padding: 7px 7px;
        color: #222;
        border-radius: 5px;
        font-weight: 500;
        font-size: 12px;
        width: max-content;
        opacity: 0;
        visibility: hidden;
        transition: all .2s ease-in-out;
    }


    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-products:hover label {
        opacity: 1;
        visibility: visible;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations input[type="radio"] {
        display: grid;
        place-content: center;
        margin-left: 10px;
        float: right;
        -webkit-appearance: none;
        position: absolute;
        appearance: none;
        top: 0;
        right: 0;
        left: 0;
        bottom: 0;
        width: 100%;
        height: 100%;
        padding: 10px;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .reset_variations {
        float: right;
        padding: 10px 0;
        text-decoration: none;
        color: #222222;
        font-size: 13px;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations .item-attribute-product input[type="radio"]:checked {
        border: 2px solid #1874ec;
        border-radius: .3em;
    }

    .woocommerce-vera .woocommerce-the-product .add-cart-product-woo .custom-wc-variations input[type="radio"]:focus {
        box-shadow: unset;
    }

</style>

<?php

// functions.php

function get_related_products()
{

    global $product;

    $related_products = array();

    $cat_ids = array();

    $terms = get_the_terms($product->get_id(), 'product_cat');

    foreach ($terms as $term) {
        $cat_ids[] = $term->term_id;
    }

    $args = array(
        'posts_per_page' => 4,
        'columns' => 4,
        'orderby' => 'rand',
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'id',
                'terms' => $cat_ids
            )
        )
    );

    $related_products = wc_get_products($args);

    if ($related_products) {

        echo '<div class="related-products">';

        echo '<h3>' . __('محصولات مشابه', 'textdomain') . '</h3>';

        woocommerce_product_loop_start();

        foreach ($related_products as $related_product) {
            echo '<div class="product">';

            $post_object = get_post($related_product->get_id());

            setup_postdata($GLOBALS['post'] =& $post_object);

            $product_id = $related_product->get_id();

            $gallery_image_ids = $related_product->get_gallery_image_ids();
            ?>
            <div class="image-product-related">
                <div id="productModal"></div>

                <?php global $product;
                $product_id = $product->get_id(); ?>
                <div class="like-containers">
                    <a class="like-buttons" data-product-id="<?php echo $product_id; ?>"><i
                                class="fa-light fa-heart"></i></a>
                </div>
                <?php
                if (count($gallery_image_ids) > 0) {
                    $first_image_id = $gallery_image_ids[0];
                    ?>
                    <div class="image-1-related-product">
                        <?php
                        echo get_the_post_thumbnail();
                        ?>
                    </div>
                    <?php
                    ?>
                    <div class="image-2-related-product">
                        <?php
                        echo wp_get_attachment_image($first_image_id, 'full');
                        ?>
                    </div>
                    <?php
                } else {
                    ?>
                    <div class="image_tak-related-product">
                        <?php
                    if (!empty(get_the_post_thumbnail())) {
                        echo get_the_post_thumbnail();
                    }
                    else {
                        ?>
                        <img src="<?php echo get_template_directory_uri()."/img/not_found.jpg"; ?>">
                        <?php
                    }
                    ?>
                    </div>
                    <?php
                }
                ?>
            </div>
            <?php
            wc_get_template_part('content', 'product');
            echo '</div>';
        }
        woocommerce_product_loop_end();

        echo '</div>';
    }

    wp_reset_postdata();

}


add_action('woocommerce_after_single_product', 'show_upsell_products');

function show_upsell_products()
{

    global $product;
    $current_product_id = $product->get_id();

    $upsell_ids = $product->get_upsell_ids();
    if ($upsell_ids) {
        echo '<div class="related-products">';

        echo '<h3>' . __('محصولاتی که شاید بپسندید', 'textdomain') . '</h3>';
        woocommerce_product_loop_start();

        foreach ($upsell_ids as $upsell_id) {


            $upsell_product = wc_get_product($upsell_id);

            echo '<div class="product">';


            $post_object = get_post($upsell_product->get_id());

            setup_postdata($GLOBALS['post'] =& $post_object);
            $gallery_image_ids = $upsell_product->get_gallery_image_ids(); ?>
            <div class="image-product-related">
                <div id="productModal"></div>

                <?php global $product;
                $product_id = $product->get_id(); ?>
                <div class="like-containers">
                    <a class="like-buttons" data-product-id="<?php echo $product_id; ?>"><i
                                class="fa-light fa-heart"></i></a>
                </div>
                <?php
                if (count($gallery_image_ids) > 0) {
                    $first_image_id = $gallery_image_ids[0];
                    $first_image_ida = $gallery_image_ids[1];
                    ?>
                    <div class="image-1-related-product">
                        <?php
                        echo get_the_post_thumbnail();
                        ?>
                    </div>
                    <?php
                    ?>
                    <div class="image-2-related-product">
                        <?php
                        echo wp_get_attachment_image($first_image_id, 'full');
                        ?>
                    </div>
                    <?php
                } else {
                    ?>
                    <div class="image_tak-related-product">
                        <?php
                        if (!empty(get_the_post_thumbnail())) {
                            echo get_the_post_thumbnail();
                        }
                        else {
                            ?>
                            <img src="<?php echo get_template_directory_uri()."/img/not_found.jpg"; ?>">
                            <?php
                        }
                        ?>
                    </div>
                    <?php
                }
                ?>
            </div>
            <?php
            wc_get_template_part('content', 'product');

            echo '</div>';

        }
        woocommerce_product_loop_end();

        echo '</div>';

    }
    wp_reset_postdata();


}


$cantional_gift = get_post_meta(get_the_ID(), 'metaboxe_product-giftss', true);
if ($cantional_gift == "on") {
    ?>
    <style>
        .ecommercehints_custom_product_checkbox_field {
            display: flex !important;
        }
    </style>
    <?php
}



    $course = get_post_meta(get_the_ID(), 'metaboxe_product-questions', true);
    if (!empty($course)) {
add_filter('woocommerce_product_tabs', 'woocommerce_tabs_list');

function woocommerce_tabs_list($tabs)
{

    $tabs['test_tab'] = array(
        'title' => __('سوالات متداول', 'woocommerce'),
        'priority' => 10,
        'callback' => 'woocommerce_tabs_list_product'
    );
    return $tabs;
}
function woocommerce_tabs_list_product()
{
?>

    <?php
    $course = get_post_meta(get_the_ID(), 'metaboxe_product-questions', true);
    if (!empty($course)) {
        ?>
        <section class="questions-product">

            <?php foreach ($course as $item) : ?>
                <div class="questions-product-item">
                    <div class="label-questions-product-item">
                        <p><?php echo $item['questions_1_product']; ?></p>
                        <i class="fas fi-rr-angle-square-down"></i>
                        <div class="value-questions-product-item">
                            <p><?php echo $item['questions_2_product']; ?></p>
                        </div>
                    </div>

                </div>
            <?php endforeach; ?>

        </section>

    <?php } ?>

<?php
}
    }


add_action( 'comment_form_before', 'custom_woo_reviews_summary', 10 , 1 );

function custom_woo_reviews_summary() {
    global $product;
    $id = $product->get_id();

    $get_rating_count = get_post_meta( $id, '_wc_rating_count', true );
    $get_review_count   = get_post_meta( $id, '_wc_review_count', true );
    $get_rating_text = array(
        '5' => 'Perfect',
        '4' => 'Good',
        '3' => 'Average',
        '2' => 'Not that bad',
        '1' => 'Very poor',
    ); ?>

    <div class="product-summary">
        <h2 class="woocommerce-Tabs-panel_reweve_h2_top_col">امتیازات محصول در یک نگاه</h2>
        <?php
        for ( $i = 5; $i > 0 ; $i-- ) {
            if ( !isset( $get_rating_count[$i] ) ) {
                $get_rating_count[$i] = 0;
            }
            $percentage = 0 ;
            if ( $get_rating_count[$i] > 0 ) {
                $percentage = round( ( $get_rating_count[$i] / $get_review_count ) * 100 );
            }
            ?>
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div class="rating_stars_count">
                <div class="rating-stars">
                    <div class="stars" title="<?php echo $get_rating_text[$i]; ?>"><?php echo wc_get_rating_html( $i ); ?></div>
                </div>
                <div class="rating-count">
                    <div class="count"><?php echo '(' . $get_rating_count[$i] . ')' ?></div>
                </div>
                </div>
                <div class="rating-graph" title="<?php printf( '%s%%', $percentage ); ?>">
                    <div class="percentage" style="width: <?php echo $percentage; ?>%" class="bar"></div>
                </div>
            </div> <?php
        } ?>
    </div> <?php
}