$(document).ready(function () {

    $('.like-buttons').click(function() {
        $(this).find("i.fa-heart").toggleClass('fa-spinner-third fa-spin');
    });

    function check_like_status() {
        $('.like-buttons').each(function() {
            var product_id = $(this).data('product-id');
            var like_button = $(this);
            $.ajax({
                url: ajax_object.ajax_url,
                type: 'POST',
                data: {
                    action: 'check_product_like',
                    product_id: product_id
                },
                success: function(response) {
                    if (response.success) {
                        if (response.liked) {
                            like_button.addClass('liked');

                        } else {
                            like_button.removeClass('liked');
                        }
                    }
                }
            });
        });
    }

    check_like_status();

    $('.like-buttons').on('click', function() {
        var product_id = $(this).data('product-id');
        var like_count = $(this).siblings('.like-counts');
        var like_button = $(this);
        var like_action = 'add';
        if (like_button.hasClass('liked')) {
            like_action = 'remove';
        }
        $.ajax({
            url: ajax_object.ajax_url,
            type: 'POST',
            data:  {
                    action: 'handle_product_like',
                    product_id: product_id,
                    like_action: like_action
            },
            success: function(response) {
                if (response.success) {
                    like_count.text(response.likess);
                    if (like_action == 'add') {
                        like_button.addClass('liked');

                        iziToast.success({
                            title: 'این محصول به لیست علاقه مندی شما اضافه شد',
                            position: 'center',
                            timeout: 2000,
                            borderRadius: 10,
                            progressBar: false,
                            backgroundColor: 'rgb(255 255 255)',
                        });
                        $(".like-buttons i").removeClass('fa-spinner-third');
                        $(".like-buttons i").removeClass('fa-spin');
                        $(".like-buttons i").addClass('fa-heart');
                    } else {
                        like_button.removeClass('liked');

                        iziToast.success({
                            title: 'این محصول از لیست علاقه مندی شما حذف گردید',
                            position: 'center',
                            timeout: 2000,
                            borderRadius: 10,
                            progressBar: false,
                            backgroundColor: 'rgb(255 255 255)',
                        });
                        $(".like-buttons i").removeClass('fa-spinner-third');
                        $(".like-buttons i").removeClass('fa-spin');
                        $(".like-buttons i").addClass('fa-heart');
                    }
                } else {

                }
            }
        });
    });

});
