$(document).ready(function () {
    $('.like-button').click(function() {
        $(this).find("i.fa-heart").toggleClass('fa-spinner-third fa-spin');
    });
    $('.like-button').on('click', function() {
        var post_id = $(this).data('post-id');
        var like_count = $(this).siblings('.like-count');
        $.ajax({
            url: ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'handle_post_like',
                post_id: post_id
            },
            success: function(response) {
                if (response.success) {
                    like_count.text(response.likes);
                    iziToast.success({
                        title: 'سپاسگذاریم نوشته توسط شما لایک گردید',
                        position: 'center',
                        timeout: 2000,
                        borderRadius: 10,
                        progressBar: false,
                        backgroundColor: 'rgb(255 255 255)',
                    });
                    $(".like-button i").removeClass('fa-spinner-third');
                    $(".like-button i").removeClass('fa-spin');
                    $(".like-button i").addClass('fa-heart');
                    $('.like-button i ').addClass('font-width-900');

                } else {
                    iziToast.info({
                        title: 'سپاسگذاریم نوشته قبلا توسط شما لایک گردیده است',
                        position: 'center',
                        timeout: 2000,
                        borderRadius: 10,
                        progressBar: false,
                        backgroundColor: 'rgb(255 255 255)',
                    });
                    $(".like-button i").removeClass('fa-spinner-third');
                    $(".like-button i").removeClass('fa-spin');
                    $(".like-button i").addClass('fa-heart');
                    $('.like-button i ').addClass('font-width-900');
                }
            }
        });
    });

});

