<?php

class one_img_product_diak_theme_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return '1-img-diak_theme';
	}

	public function get_title() {
		return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>شبکه تصویر (1)</h2>';
	}

	public function get_icon() {
		return 'eicon-photo-library';
	}

	public function get_categories() {
		return [ 'eleman-category' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'section_content-two-img',
			[
				'label' => esc_html__( 'شبکه تصویر 1 عضوی', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'target-a-1-image',
			[
				'label' => esc_html__( 'باز شدن لینک  تصاویر در', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'_blank' => esc_html__( 'صفحه جدید', 'textdomain' ),
					'_self' => esc_html__( 'همین صفحه', 'textdomain' ),
				],

			]
		);
		$this->add_control(
			'image-item-one',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر ', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-one',
			[
				'label' => 'لینک تصویر ',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'استایل های تصاویر', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'number-border-radios-image',
			[
				'label' => esc_html__( 'منحنی گوشه های تصاویر', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 10,
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		?>
		<style>
            /*start image 1 divesion flex box*/
            .image-1-plan-img-item {
                width: 100%;
                float: right;
                padding: 20px 0;
            }

            .image-1-plan-img-item figure img {
                width: 100%;
                max-width: 100%;
                border-radius: <?php echo $settings['number-border-radios-image']."px"; ?> !important;
                height: auto;
            }

            /*end image 1 divesion flex box*/

        </style>

        <div class="container">
            <div class="image-1-plan-img-item">
                <figure>
                    <a target="<?php echo $settings['target-a-1-image']; ?>" href="<?php echo $settings['link-img-one']['url']; ?>"><figure><img src="<?php echo $settings['image-item-one']['url']; ?>"></figure></a>
                </figure>
            </div>
        </div>



		<?php
	}


	protected function content_template() {
	}

}
