<?php

ob_start();
function add_theme_styles() {
    wp_enqueue_style("style-all",get_template_directory_uri()."/css/all.css");
    wp_enqueue_style("style-swiper",get_template_directory_uri()."/css/swiper.min.css");
    wp_enqueue_style("style-responsive",get_template_directory_uri()."/css/responsive/css.responsive.css");
    wp_enqueue_style("style-pop-op-open",get_template_directory_uri()."/inc/vera-theme/woocommerce-template/dimbox.min.css");
    wp_enqueue_style("style-alert",get_template_directory_uri()."/css/iziToast.min.css");
    wp_enqueue_style('style', get_stylesheet_uri());
}
function add_theme_scripts() {
    wp_enqueue_script('js', get_template_directory_uri() . '/js/jquery-3.7.1.min.js', array(), false, true);
    wp_enqueue_script('head-room-js', get_template_directory_uri() . '/js/headroom.js',array('jquery'), false, true);
    wp_enqueue_script('swiper-js', get_template_directory_uri() . '/js/swiper-element-bundle.min.js',array('jquery'), false, true);
    wp_enqueue_script('main-js', get_template_directory_uri() . '/js/main.js',array('jquery'), false, true);
    wp_enqueue_script('script-js', get_template_directory_uri() . '/js/script.js',array('jquery'), false, true);
    wp_enqueue_script('js-form', get_template_directory_uri() . '/vera_option/js-form-vera.js',array('jquery'), false, true);
    wp_enqueue_script('alert-js', get_template_directory_uri() . '/js/iziToast.min.js',array('jquery'), false, true);
    if( is_account_page() ) {
        wp_enqueue_script('chart', get_template_directory_uri() . '/js/chart.min.js', array('jquery'), false, true);
    }
    wp_enqueue_script('ex-like-js', get_template_directory_uri() . '/inc/vera-theme/ex-like-post/ex-like.js',array('jquery'), false, true);
    wp_enqueue_script('ex-likes-js', get_template_directory_uri() . '/inc/vera-theme/ex-like-product/ex-like.js',array('jquery'), false, true);
    if (is_singular('product')) {
        wp_enqueue_script('js-pop-op-open', get_template_directory_uri() . '/inc/vera-theme/woocommerce-template/dimbox.min.js',array('jquery'), false, true);
        wp_enqueue_script('js-3d-image', get_template_directory_uri() . '/js/js-cloudimage-360-view.min.js', array('jquery'), false, true);
    }
}
add_action('wp_enqueue_scripts','add_theme_styles');
add_action('wp_enqueue_scripts','add_theme_scripts');

function admin_theme_scripts()
{
    wp_enqueue_style("style-allss",get_template_directory_uri()."/css/all.css");
    wp_enqueue_script('conditional-cmb2', get_template_directory_uri() . '/js/cmb2-conditional-logic.js', array('jquery'), false, 'true');
}
add_action('admin_enqueue_scripts', 'admin_theme_scripts');
function custom_admin_open_sans_font() {
    echo '<link href='. get_template_directory_uri()."/font/fontiran.css" .' rel="stylesheet">' . PHP_EOL;
    include_once __DIR__."/inc/admin/admin-init.php";
}
add_action( 'admin_head', 'custom_admin_open_sans_font' );

/*فانکشن ایجاد ویجت | ابزارک قالب*/
function vera_theme_slug_widgets_init()
{
    register_sidebar(array(
        'name' => __('سایدبار کنار صفحه فروشگاه'),
        'id' => 'sidebar-product',
        'description' => __('برای شخشی سازی قسمت کناری ساید بار صفحه آرشیو و یا دسته بندی  فروشگاه خود از این قسمت میتوانید استفاده کنید'),
        'before_widget' => '<div class="sidebars-single">',
        'after_widget' => '</div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
    ));

}
add_action('widgets_init', 'vera_theme_slug_widgets_init');


/*add theme request*/
function vera_theme_setup_theme()
{
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');
    add_theme_support('dokan');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('ajax');
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 20 );

    add_image_size("size_product","","350");
    register_nav_menus(array(
            'main-menu' => __('جایگاه منو هدر اصلی'),
            'footer-menu' => __('جایگاه منو دسترسی سریع فوتر')
        )
    );

}
add_action('after_setup_theme', 'vera_theme_setup_theme');
/*add ex file jalale php*/
require_once "inc/elementor/widget-workut-elenemt.php";
/*add ex file jalale php*/
require_once "inc/jdf.php";
/*add ex wishlist single product*/
require_once "inc/vera-theme/ex-like-product/ex-like.php";
/*add ex like single post*/
require_once "inc/vera-theme/ex-like-post/ex-like.php";
/*add ex view single post*/
require_once "inc/vera-theme/ex-view-post/ex-view.php";
/*add icon nav code*/
require_once "inc/vera-theme/add-icon-nav/add-icon-nav.php";
/*add cmb2 plugin*/
require_once 'inc/vera-theme/CMB2-develop/example-functions.php';
/*add cmb2 post meta box custom*/
require_once 'inc/vera-theme/add-post-meta-box/add-post-meta-box.php';
/*add cmb2 product meta box custom*/
require_once 'inc/vera-theme/add-product-meta-box/add-product-meta-box.php';
/*add option theme*/
require_once 'inc/vera-theme/add-option/add-option.php';
/*add notification account woo*/
require_once 'inc/vera-theme/add-option/notification-panel.php';
/*add template_head*/
require_once 'inc/template/head_template.php';
/*add themeplate_footer*/
require_once 'inc/template/footer_template.php';

/*starts widgets verax*/
require_once 'inc/widget/price_widget.php';

/*add TGM-plugin*/
require_once 'inc/TGM-plugin/class-tgm-plugin-activation.php';
require_once 'inc/TGM-plugin/tgm-plugin-activation.php';
if ( ! class_exists( 'Guard_vera_theme' ) ) {
    require_once get_template_directory().'/inc/settings_theme/redux-framework-4.4.1/ReduxCore/inc/vera_lc.php';
}
/*add setting theme*/
/**********Add Redux************/
if (!class_exists('ReduxFramework') && file_exists(dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/redux-core/framework.php')) {
    require_once dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/redux-core/framework.php';
}
if (!isset($redux_remo) && file_exists(dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/sample/sample-config.php')) {
    require_once dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/sample/sample-config.php';
}

add_filter( 'woocommerce_product_tabs', 'wcs_woo_remove_more_seller_product_tab', 98 );
function wcs_woo_remove_more_seller_product_tab($tabs) {
    unset($tabs['more_seller_product']);
    return $tabs;
}

