<?php

//if (!function_exists('wc_get_product')) {
//    include_once ABSPATH . 'wp-content/plugins/woocommerce/includes/wc-product-functions.php';
//}
//if (!function_exists('wc_doing_it_wrong')) {
//    include_once ABSPATH . 'wp-content/plugins/woocommerce/includes/wc-product-functions.php';
//}


class Berozkala_WP_Integration {

    /**
     * ذخیره اطلاعات محصول در وردپرس
     * @param array $product_data اطلاعات محصول (لینک، ID، عنوان، قیمت، و غیره)
     * @return int|WP_Error شناسه پست یا خطا
     */
    private function create_new_product($product_data) {
        $price = preg_replace('/[^\d.]/', '', $product_data['price']);

        $post_id = wp_insert_post([
            'post_title' => $product_data['title'],
            'post_status' => 'publish',
            'post_type' => 'product',
            'meta_input' => [
                'b_product_url'        => $product_data['link'],
                'b_product_id'         => $product_data['id'],
                'b_product_thumbnail'  => $product_data['image'],
                '_price'               => $price,
                '_regular_price'       => $price,
                '_stock_status'        => 'instock', // اضافه کردن وضعیت موجودی
                '_manage_stock'        => 'no',      // غیرفعال کردن مدیریت موجودی
                'b_product_single_sync'=> 0,
            ],

        ]);
        do_action('woocommerce_update_product', $post_id);

        return $post_id;
    }


    private function update_product($post_id, $product_data) {
        // پاک‌سازی قیمت
        $price = preg_replace('/[^\d.]/', '', $product_data['price']);

        // بروزرسانی متاهای محصول
        update_post_meta($post_id, 'b_product_url', $product_data['link']);
        update_post_meta($post_id, 'b_product_id', $product_data['id']);
        update_post_meta($post_id, 'b_product_thumbnail', $product_data['image']); // ذخیره آدرس تصویر
        update_post_meta($post_id, '_price', $price);
        update_post_meta($post_id, '_regular_price', $price);
        update_post_meta($post_id, 'b_product_single_sync', 0);
        do_action('woocommerce_update_product', $post_id);
        berozkala_log("Product updated: " . $product_data['title'] . " (Post ID: $post_id)");

        return $post_id;
    }

    public function save_product_to_wp($product_data) {
        berozkala_log("Processing product: " . $product_data['title']);

        // بررسی وجود محصول
        $existing_post = $this->get_post_by_meta('b_product_id', $product_data['id']);
        if ($existing_post) {
            berozkala_log("Updating existing product: " . $product_data['title']);
            return $this->update_product($existing_post->ID, $product_data);
        }

        // ایجاد محصول جدید
        berozkala_log("Adding new product: " . $product_data['title']);
        return $this->create_new_product($product_data);
    }

    function add_product_attributes_to_woocommerce($product_id, $attributes) {
        if (!empty($attributes)) {
            $product_attributes = wc_get_product($product_id)->get_attributes();

            foreach ($attributes as $index => $attribute) {
                $attribute_name = sanitize_title($attribute['name']);
                $attribute_label = $attribute['name'];
                $attribute_value = $attribute['value'];

                $product_attributes[$attribute_name] = new WC_Product_Attribute([
                    'name'         => $attribute_label,
                    'value'        => $attribute_value,
                    'position'     => $index,
                    'is_visible'   => 1,
                    'is_variation' => 0,
                    'is_taxonomy'  => 0,
                ]);
            }

            $product = wc_get_product($product_id);
            $product->set_attributes($product_attributes);
            $product->save();
        }
    }



    function add_product_gallery_to_woocommerce($product_id, $gallery_urls) {
        if (!empty($gallery_urls)) {
            $attachment_ids = [];

            foreach ($gallery_urls as $url) {
                $attachment_id = attachment_url_to_postid($url);

                if (!$attachment_id) {
                    $attachment_id = wp_insert_attachment([
                        'guid'           => $url,
                        'post_mime_type' => 'image/jpeg',
                        'post_title'     => basename($url),
                        'post_content'   => '',
                        'post_status'    => 'inherit',
                    ], $url);

                    if (!is_wp_error($attachment_id)) {
                        require_once(ABSPATH . 'wp-admin/includes/image.php');
                        wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $url));
                    }
                }

                $attachment_ids[] = $attachment_id;
            }

            update_post_meta($product_id, '_product_image_gallery', implode(',', $attachment_ids));
        }
    }




    public static function add_product_variations_to_woocommerce($product_id, $variations) {
        berozkala_log("Adding variations to Product ID: $product_id");
        berozkala_log("Variations data: " . json_encode($variations));

        if (!empty($variations)) {
            $product = wc_get_product($product_id);

            foreach ($variations as $variation_type => $variation_data) {
                if (!empty($variation_data)) {
                    foreach ($variation_data as $variation) {
                        berozkala_log("Processing variation: " . json_encode($variation));
                        $variation_id = wp_insert_post([
                            'post_title'  => $product->get_name() . ' - ' . $variation['name'],
                            'post_status' => 'publish',
                            'post_parent' => $product_id,
                            'post_type'   => 'product_variation',
                            'meta_input'  => [
                                'attribute_' . sanitize_title($variation_type) => $variation['name'],
                                '_regular_price'                                => $variation['price'],
                                '_price'                                       => $variation['price'],
                            ],
                        ]);

                        if (!is_wp_error($variation_id)) {
                            berozkala_log("Variation added successfully: $variation_id");
                        } else {
                            berozkala_log("Failed to add variation: " . $variation_id->get_error_message());
                        }
                    }
                }
            }
        } else {
            berozkala_log("No variations to add for Product ID: $product_id");
        }
    }




//    public static function update_product_details($post_id, $details) {
//        berozkala_log("Updating product details for Post ID: $post_id");
//
//        // 1. ذخیره متغیرها
//        if (!empty($details['variations'])) {
//            try {
//                self::add_product_variations_to_woocommerce($post_id, $details['variations']);
//                update_post_meta($post_id, 'b_product_variations', $details['variations']);
//                berozkala_log("Variations saved: " . json_encode($details['variations']));
//            } catch (Exception $e) {
//                berozkala_log("Error saving variations: " . $e->getMessage());
//            }
//        } else {
//            berozkala_log("No variations to save.");
//        }
//
//        // 2. ذخیره گالری
//        if (!empty($details['gallery'])) {
//            try {
//                self::add_product_gallery_to_woocommerce($post_id, $details['gallery']);
//                update_post_meta($post_id, 'b_product_gallery', $details['gallery']);
//                berozkala_log("Gallery saved: " . json_encode($details['gallery']));
//            } catch (Exception $e) {
//                berozkala_log("Error saving gallery: " . $e->getMessage());
//            }
//        } else {
//            berozkala_log("No gallery images to save.");
//        }
//
//        // 3. ذخیره ویژگی‌ها
//        if (!empty($details['attributes'])) {
//            try {
//                self::add_product_attributes_to_woocommerce($post_id, $details['attributes']);
//                update_post_meta($post_id, 'b_product_attributes', $details['attributes']);
//                berozkala_log("Attributes saved: " . json_encode($details['attributes']));
//            } catch (Exception $e) {
//                berozkala_log("Error saving attributes: " . $e->getMessage());
//            }
//        } else {
//            berozkala_log("No attributes to save.");
//        }
//
//        berozkala_log("Product details updated successfully for Post ID: $post_id");
//    }
    public static function update_product_details($post_id, $details) {
        berozkala_log("Updating product details for Post ID: $post_id");

        if (!empty($details['variations'])) {
            self::add_product_variations_to_woocommerce($post_id, $details['variations']);
        }

        if (!empty($details['gallery'])) {
            self::add_product_gallery_to_woocommerce($post_id, $details['gallery']);
        }

        if (!empty($details['attributes'])) {
            self::add_product_attributes_to_woocommerce($post_id, $details['attributes']);
        }
    }






//    function process_product_details() {
//        $products = get_posts([
//            'post_type'  => 'product',
//            'meta_key'   => 'b_product_single_sync',
//            'meta_value' => 0,
//            'numberposts' => 5,
//        ]);
//
//        foreach ($products as $product) {
//            $product_id = $product->ID;
//            $product_url = get_post_meta($product_id, 'b_product_url', true);
//
//            // استخراج اطلاعات صفحه داخلی محصول
//            $details = Berozkala_Crawler::fetch_product_details($product_url);
//
//            if ($details) {
//                // ذخیره اطلاعات جزئی محصول
//                berozkala_log("Fetched details for Product ID: $product_id: " . json_encode($details));
//                return $this->update_product_details($product_id, $details);
//
//                // نشان دادن پردازش شده
//                update_post_meta($product_id, 'b_product_single_sync', 1);
//            }else{
//                berozkala_log("No details fetched for Product ID: $product_id.");
//            }
//        }
//    }

    /**
     * بررسی وجود پست با متای خاص
     * @param string $meta_key کلید متا
     * @param mixed $meta_value مقدار متا
     * @return WP_Post|null پست پیدا شده یا null
     */
    private function get_post_by_meta($meta_key, $meta_value) {
        $query = new WP_Query([
            'post_type'  => 'product',
            'meta_key'   => $meta_key,
            'meta_value' => $meta_value,
            'fields'     => 'ids',
        ]);

        return $query->have_posts() ? get_post($query->posts[0]) : null;
    }

    /**
     * تنظیم تصویر شاخص برای محصول
     * @param int $post_id شناسه پست
     * @param string $image_url آدرس تصویر
     * @return void
     */
    private function set_product_image($post_id, $image_url) {
        if (!$image_url) {
            return; // اگر تصویر وجود ندارد، متوقف شود
        }

        // دانلود و آپلود تصویر
        $upload_dir = wp_upload_dir();
        $image_data = file_get_contents($image_url);
        $filename = basename($image_url);
        $file_path = $upload_dir['path'] . '/' . $filename;

        if (file_put_contents($file_path, $image_data)) {
            $wp_filetype = wp_check_filetype($filename, null);
            $attachment = [
                'post_mime_type' => $wp_filetype['type'],
                'post_title'     => sanitize_file_name($filename),
                'post_content'   => '',
                'post_status'    => 'inherit',
            ];

            $attach_id = wp_insert_attachment($attachment, $file_path, $post_id);
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
            wp_update_attachment_metadata($attach_id, $attach_data);

            // تنظیم تصویر شاخص
            update_post_meta($post_id, '_thumbnail_id', $attach_id);
        }
    }
}


