<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

do_action( 'woocommerce_before_customer_login_form' ); ?>

<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

<style>
.vera-theme_login_form label {
    font-size: 14px;
    font-weight: 500;
    padding-bottom: 10px;
}
.vera-theme_login_form button {
    font-size: 14px;
    font-family: 'IRANYekanX';
    padding: 10px 10px !important;
    border: 0;
    color: #FFFFFF !important;
    background: var(--main-color) !important;
    font-weight: 400;
    width: 100%;
    transition: all .3s ease-in-out;
}

.vera-theme_login_form input[type="text"] {
        padding: 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 5px;
        border: 1px solid rgba(169, 169, 169, 0.6);
        text-align: right;
        font-weight: 400;
}
.vera-theme_login_form br {
        line-height: 0;
}
.vera-theme_login_form input[type="tel"] {
        padding: 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 5px;
        border: 1px solid rgba(169, 169, 169, 0.6);
        text-align: right;
        font-weight: 400;
}
.vera-theme_login_form input[type="password"] {
    padding: 10px;
    width: 100% !important;
    font-family: IRANYekanX;
    -moz-font-feature-settings: "ss02" !important;
    -webkit-font-feature-settings: "ss02" !important;
    font-feature-settings: "ss02" !important;
    border-radius: 5px;
    border: 1px solid rgba(169, 169, 169, 0.6);
    text-align: right;
    font-weight: 400;
}
.vera-theme_login_form input[type="email"] {
    padding: 10px;
    width: 100% !important;
    font-family: IRANYekanX;
    -moz-font-feature-settings: "ss02" !important;
    -webkit-font-feature-settings: "ss02" !important;
    font-feature-settings: "ss02" !important;
    border-radius: 5px;
    border: 1px solid rgba(169, 169, 169, 0.6);
    text-align: right;
    font-weight: 400;
}

.vera-theme_login_form  a {
    opacity: .5;
    color: #222222;
    text-decoration: none;
    transition: all .3s ease-in-out;
    padding: 0 5px;
}
.vera-theme_login_form  .woocommerce-privacy-policy-text {
    font-weight: 400;
    font-size: 14px;
}
.vera-theme_login_form  a:hover {
    opacity:1;
}
.vera-theme_login_form  a:hover {
    opacity:1;
}

.vera-theme_login_form  .show-password-input {
    top: 12px !important;
}
.vera-theme_login_form  .show-password-input:after {
    content: "\f06e" !important;
    font-family: "Font Awesome 5 Pro" !important;
}
.vera-theme_login_form  .display-password:after {
    content: "\f070" !important;
    font-family: "Font Awesome 5 Pro" !important;
}
.vera-theme_login_form input[type="checkbox"] {
    display: grid;
    place-content: center;
    margin-left: 10px;
    float: right;
    width: 30px;
    height: 15px;
    -webkit-appearance: none;
    appearance: none;
    background-color: #fff;
    border: 1px solid rgba(204, 204, 204, 0.62);
    border-radius: 15px;
    position: relative;
}

.vera-theme_login_form input[type="checkbox"]::before {
    content: "";
    width: 14px;
    transition: all 1s ease-in-out !important;
    height: 14px;
    position: absolute;
    transform: scale(1);
    box-shadow: none !important;
    background: #0073aa;
    border-radius: 15px;
    left: 0;
}

.vera-theme_login_form input[type="checkbox"]:checked {
    background: rgba(0, 122, 255, 0.44);
}
.vera-theme_login_form input[type="checkbox"]:checked::before {
    right: 0;
    transition: all 1s ease-in-out !important;
}

</style>


<div class="u-columns col2-set vera-theme_login_form" id="customer_login">

	<div class="u-column1 col-1">

<?php endif; ?>

		<h2><?php esc_html_e( 'Login', 'woocommerce' ); ?></h2>

		<form class="woocommerce-form woocommerce-form-login login" method="post">

			<?php do_action( 'woocommerce_login_form_start' ); ?>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="username"><?php esc_html_e( 'Username or email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</p>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
				<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" />
			</p>

			<?php do_action( 'woocommerce_login_form' ); ?>

			<p class="form-row">
				<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
					<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'woocommerce' ); ?></span>
				</label>
				<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
				<button type="submit" class="woocommerce-button button woocommerce-form-login__submit<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="login" value="<?php esc_attr_e( 'Log in', 'woocommerce' ); ?>"><?php esc_html_e( 'Log in', 'woocommerce' ); ?></button>
			</p>
			<p class="woocommerce-LostPassword lost_password">
				<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'woocommerce' ); ?></a>
			</p>

			<?php do_action( 'woocommerce_login_form_end' ); ?>

		</form>

<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

	</div>

	<div class="u-column2 col-2">

		<h2><?php esc_html_e( 'Register', 'woocommerce' ); ?></h2>

		<form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); ?> >

			<?php do_action( 'woocommerce_register_form_start' ); ?>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="reg_username"><?php esc_html_e( 'Username', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</p>

			<?php endif; ?>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="reg_email"><?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</p>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" />
				</p>

			<?php else : ?>

				<p><?php esc_html_e( 'A link to set a new password will be sent to your email address.', 'woocommerce' ); ?></p>

			<?php endif; ?>

			<?php do_action( 'woocommerce_register_form' ); ?>

			<p class="woocommerce-form-row form-row">
				<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
				<button type="submit" class="woocommerce-Button woocommerce-button button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?> woocommerce-form-register__submit" name="register" value="<?php esc_attr_e( 'Register', 'woocommerce' ); ?>"><?php esc_html_e( 'Register', 'woocommerce' ); ?></button>
			</p>

			<?php do_action( 'woocommerce_register_form_end' ); ?>

		</form>

	</div>

</div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
