<?php

// افزودن تکست باکس آیکون
function add_nav_menu_icon_field( $item_id, $item ){

    $value = get_post_meta( $item->ID, '_menu_item_icon', true );

    echo '<p>
          <label for="edit-menu-item-icon-' . $item_id . '">آیکون</label>
          <input type="text" id="edit-menu-item-icon-' . $item_id . '" class="widefat code" name="menu_item_icon[' . $item_id . ']" value="' . esc_attr( $value ) . '">
        </p>';

}

add_action( 'wp_nav_menu_item_custom_fields', 'add_nav_menu_icon_field', 10, 2 );


// ذخیره آیکون
function save_nav_menu_icon( $menu_id, $menu_item_db_id ) {

    if( isset( $_REQUEST['menu_item_icon'][$menu_item_db_id] ) ) {
        $sanitized_data = sanitize_text_field( $_REQUEST['menu_item_icon'][$menu_item_db_id] );
        update_post_meta( $menu_item_db_id, '_menu_item_icon', $sanitized_data );
    }

}

add_action( 'wp_update_nav_menu_item', 'save_nav_menu_icon', 10, 2 );
