<?php

ob_start();
function add_theme_styles() {
    wp_enqueue_style("style-all",get_template_directory_uri()."/css/all.css");
    wp_enqueue_style("style-swiper",get_template_directory_uri()."/css/swiper.min.css");
    wp_enqueue_style("style-responsive",get_template_directory_uri()."/css/responsive/css.responsive.css");
    wp_enqueue_style("style-pop-op-open",get_template_directory_uri()."/inc/vera-theme/woocommerce-template/dimbox.min.css");
    wp_enqueue_style("style-alert",get_template_directory_uri()."/css/iziToast.min.css");
    wp_enqueue_style('style', get_stylesheet_uri());
}
function add_theme_scripts() {
    wp_enqueue_script('js', get_template_directory_uri() . '/js/jquery-3.7.1.min.js', array(), false, true);
    wp_enqueue_script('head-room-js', get_template_directory_uri() . '/js/headroom.js',array('jquery'), false, true);
    wp_enqueue_script('swiper-js', get_template_directory_uri() . '/js/swiper-element-bundle.min.js',array('jquery'), false, true);
    wp_enqueue_script('main-js', get_template_directory_uri() . '/js/main.js',array('jquery'), false, true);
    wp_enqueue_script('script-js', get_template_directory_uri() . '/js/script.js',array('jquery'), false, true);
    wp_enqueue_script('js-form', get_template_directory_uri() . '/vera_option/js-form-vera.js',array('jquery'), false, true);
    wp_enqueue_script('alert-js', get_template_directory_uri() . '/js/iziToast.min.js',array('jquery'), false, true);
    if( is_account_page() ) {
        wp_enqueue_script('chart', get_template_directory_uri() . '/js/chart.min.js', array('jquery'), false, true);
    }
    wp_enqueue_script('ex-like-js', get_template_directory_uri() . '/inc/vera-theme/ex-like-post/ex-like.js',array('jquery'), false, true);
    wp_enqueue_script('ex-likes-js', get_template_directory_uri() . '/inc/vera-theme/ex-like-product/ex-like.js',array('jquery'), false, true);
    if (is_singular('product')) {
        wp_enqueue_script('js-pop-op-open', get_template_directory_uri() . '/inc/vera-theme/woocommerce-template/dimbox.min.js',array('jquery'), false, true);
        wp_enqueue_script('js-3d-image', get_template_directory_uri() . '/js/js-cloudimage-360-view.min.js', array('jquery'), false, true);
    }
}
add_action('wp_enqueue_scripts','add_theme_styles');
add_action('wp_enqueue_scripts','add_theme_scripts');

function admin_theme_scripts()
{
    wp_enqueue_style("style-allss",get_template_directory_uri()."/css/all.css");
    wp_enqueue_script('conditional-cmb2', get_template_directory_uri() . '/js/cmb2-conditional-logic.js', array('jquery'), false, 'true');
}
add_action('admin_enqueue_scripts', 'admin_theme_scripts');
function custom_admin_open_sans_font() {
    echo '<link href='. get_template_directory_uri()."/font/fontiran.css" .' rel="stylesheet">' . PHP_EOL;
    include_once __DIR__."/inc/admin/admin-init.php";
}
add_action( 'admin_head', 'custom_admin_open_sans_font' );

/*فانکشن ایجاد ویجت | ابزارک قالب*/
function vera_theme_slug_widgets_init()
{
    register_sidebar(array(
        'name' => __('سایدبار کنار صفحه فروشگاه'),
        'id' => 'sidebar-product',
        'description' => __('برای شخشی سازی قسمت کناری ساید بار صفحه آرشیو و یا دسته بندی  فروشگاه خود از این قسمت میتوانید استفاده کنید'),
        'before_widget' => '<div class="sidebars-single">',
        'after_widget' => '</div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
    ));

}
add_action('widgets_init', 'vera_theme_slug_widgets_init');


/*add theme request*/
function vera_theme_setup_theme()
{
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');
    add_theme_support('dokan');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('ajax');
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 20 );

    add_image_size("size_product","","350");
    register_nav_menus(array(
            'main-menu' => __('جایگاه منو هدر اصلی'),
            'footer-menu' => __('جایگاه منو دسترسی سریع فوتر')
        )
    );

}
add_action('after_setup_theme', 'vera_theme_setup_theme');
/*add ex file jalale php*/
require_once "inc/elementor/widget-workut-elenemt.php";
/*add ex file jalale php*/
require_once "inc/jdf.php";
/*add ex wishlist single product*/
require_once "inc/vera-theme/ex-like-product/ex-like.php";
/*add ex like single post*/
require_once "inc/vera-theme/ex-like-post/ex-like.php";
/*add ex view single post*/
require_once "inc/vera-theme/ex-view-post/ex-view.php";
/*add icon nav code*/
require_once "inc/vera-theme/add-icon-nav/add-icon-nav.php";
/*add cmb2 plugin*/
require_once 'inc/vera-theme/CMB2-develop/example-functions.php';
/*add cmb2 post meta box custom*/
require_once 'inc/vera-theme/add-post-meta-box/add-post-meta-box.php';
/*add cmb2 product meta box custom*/
require_once 'inc/vera-theme/add-product-meta-box/add-product-meta-box.php';
/*add option theme*/
require_once 'inc/vera-theme/add-option/add-option.php';
/*add notification account woo*/
require_once 'inc/vera-theme/add-option/notification-panel.php';
/*add template_head*/
require_once 'inc/template/head_template.php';
/*add themeplate_footer*/
require_once 'inc/template/footer_template.php';

/*starts widgets verax*/
require_once 'inc/widget/price_widget.php';

/*add TGM-plugin*/
require_once 'inc/TGM-plugin/class-tgm-plugin-activation.php';
require_once 'inc/TGM-plugin/tgm-plugin-activation.php';
if ( ! class_exists( 'Guard_vera_theme' ) ) {
    require_once get_template_directory().'/inc/settings_theme/redux-framework-4.4.1/ReduxCore/inc/vera_lc.php';
}
/*add setting theme*/
/**********Add Redux************/
if (!class_exists('ReduxFramework') && file_exists(dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/redux-core/framework.php')) {
    require_once dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/redux-core/framework.php';
}
if (!isset($redux_remo) && file_exists(dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/sample/sample-config.php')) {
    require_once dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/sample/sample-config.php';
}

add_filter( 'woocommerce_product_tabs', 'wcs_woo_remove_more_seller_product_tab', 98 );
function wcs_woo_remove_more_seller_product_tab($tabs) {
    unset($tabs['more_seller_product']);
    return $tabs;
}






// افزودن گزینه مرتب‌سازی جدید به منوی مرتب‌سازی
function custom_woocommerce_catalog_orderby( $orderby ) {
    // اضافه کردن گزینه مرتب‌سازی براساس قیمت تخفیف خورده
    $orderby['discount'] = 'مرتب‌سازی بر اساس تخفیف';
    return $orderby;
}
add_filter( 'woocommerce_catalog_orderby', 'custom_woocommerce_catalog_orderby' );

// تغییرات در کوئری محصولات برای مرتب‌سازی بر اساس تخفیف
function custom_woocommerce_product_query( $q ) {
    if ( isset( $_GET['orderby'] ) && $_GET['orderby'] == 'discount' ) {
        // مرتب‌سازی بر اساس قیمت تخفیف خورده
        $q->set( 'meta_key', '_sale_price' ); // متا فیلد قیمت تخفیف خورده
        $q->set( 'orderby', 'meta_value_num' ); // مرتب‌سازی بر اساس مقدار عددی
        $q->set( 'order', 'desc' ); // ترتیب نزولی (از بالاترین تخفیف به پایین‌ترین)
    }
}
add_action( 'pre_get_posts', 'custom_woocommerce_product_query' );

// تغییر ترتیب پیش‌فرض فروشگاه برای مرتب‌سازی بر اساس تخفیف فقط در صفحه فروشگاه یا دسته‌بندی
function custom_woocommerce_default_catalog_orderby( $orderby ) {
    // فقط در صفحه فروشگاه یا دسته‌بندی محصولات این تغییرات را اعمال می‌کنیم
    if ( is_shop() || is_product_category() ) {
        if ( isset( $_GET['orderby'] ) && $_GET['orderby'] == 'discount' ) {
            $orderby = 'meta_value_num'; // مرتب‌سازی بر اساس مقدار عددی (برای قیمت تخفیف خورده)
        }
    }
    return $orderby;
}
add_filter( 'woocommerce_default_catalog_orderby', 'custom_woocommerce_default_catalog_orderby' );



function CustomFilterWidget() {
    if ( is_product_category() ) {
        $category = get_queried_object();
        $category_id = $category->term_id;

        // گرفتن محصولات از دسته‌بندی فعلی
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'product_cat',
                    'field'    => 'term_id',
                    'terms'    => $category_id,
                ),
            ),
        );

        $prices = get_min_max_price_in_category($category_id);
        $min_price = $prices->min_price ? $prices->min_price : 0;
        $max_price = $prices->max_price ? $prices->max_price : 50000000;

        // دریافت مقادیر فیلتر شده از URL (در صورت وجود)
        $current_min_price = isset($_GET['min_price']) ? intval($_GET['min_price']) : $min_price;
        $current_max_price = isset($_GET['max_price']) ? intval($_GET['max_price']) : $max_price;

        $products = get_posts( $args );
        $total_products = count($products);

        if ($total_products === 0) {
            return '<p>هیچ محصولی در این دسته‌بندی وجود ندارد.</p>';
        }

        // آرایه‌ای برای شمارش ویژگی‌ها
        $attribute_count = array();
        $attribute_values = array();

        foreach ( $products as $product ) {
            $product_obj = wc_get_product( $product->ID );
            $attributes = $product_obj->get_attributes();

            foreach ( $attributes as $attribute ) {
                $attribute_name = $attribute->get_name();

                if (!isset($attribute_count[$attribute_name])) {
                    $attribute_count[$attribute_name] = 0;
                    $attribute_values[$attribute_name] = array();
                }

                $attribute_count[$attribute_name]++;

                $options = $attribute->get_options();
                foreach ($options as $option) {
                    $cleaned_option = preg_replace('/[^\p{L}\p{N}\s]/u', '', $option);

                    if (!empty($cleaned_option) && strtolower($cleaned_option) !== 'نامشخص') {
                        $attribute_values[$attribute_name][] = $cleaned_option;
                    }
                }
            }
        }

        $final_attributes = array();
        foreach ($attribute_count as $attribute_name => $count) {
            $percentage = ($count / $total_products) * 100;
            if ($percentage >= 50 && count(array_unique($attribute_values[$attribute_name])) > 1) {
                $final_attributes[] = $attribute_name;
            }
        }

        if ( empty( $final_attributes ) ) {
            return '<p>هیچ ویژگی مشترکی برای فیلتر کردن وجود ندارد.</p>';
        }

        // ساخت فرم فیلتر
        $output = '<form method="GET" id="filterForm" class="custom-filter-form">';
        $output .= '<h3>فیلتر محصولات:</h3><input type="hidden" id="category_id" value="'.get_queried_object()->term_id.'">
        <a href="'.get_term_link($category_id).'" style="display: none" id="resetFilters">حذف فیلترها</a>
        ';

        $output.='
        <input type="hidden" id="originalMinPrice" value="' . esc_js($min_price) . '">
                <input type="hidden" id="originalMaxPrice" value="' . esc_js($max_price) . '">
                <div class="price-filter">
                    <label for="price-range">فیلتر بر اساس قیمت:</label>
                    <div id="slider-range"></div>
                    <p>قیمت: <span id="amount"></span></p>
                    <input type="hidden" id="min_price" name="min_price" value="'.esc_attr($current_min_price).'">
                    <input type="hidden" id="max_price" name="max_price" value="'.esc_attr($current_max_price).'">
                </div>
                
                
                 <script>
                jQuery(document).ready(function($) {
                var originalMinPrice = ' . esc_js($min_price) . ';
                var originalMaxPrice = ' . esc_js($max_price) . ';
        
                // تابع برای جدا کردن قیمت به صورت سه‌رقم‌سه‌رقم
                function formatPrice(price) {
                    return price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                }
        
                // تنظیم اسلایدر قیمت
                $("#slider-range").slider({
                    range: true,
                    min: originalMinPrice,
                    max: originalMaxPrice,
                    values: [$("#min_price").val() || originalMinPrice, $("#max_price").val() || originalMaxPrice],
                    slide: function(event, ui) {
                        $("#amount").text(formatPrice(ui.values[0]) + " تومان - " + formatPrice(ui.values[1]) + " تومان");
                        $("#min_price").val(ui.values[0]);
                        $("#max_price").val(ui.values[1]);
                        
                    },
                    change: function(event, ui) {
                       
                       
                    }
                });
        
                // مقدار اولیه برای نمایش قیمت‌ها پس از بارگذاری صفحه
                $("#amount").text(formatPrice($("#slider-range").slider("values", 0)) + " تومان - " + formatPrice($("#slider-range").slider("values", 1)) + " تومان");
                });
            </script>
            
        ';

        foreach ( $final_attributes as $attribute ) {
            $output .= '<label for="filter-' . esc_attr($attribute) . '">' . esc_html($attribute) . '</label>';
            $output .= '<select name="' . esc_attr($attribute) . '" id="filter-' . esc_attr($attribute) . '">';
            $output .= '<option value="">انتخاب کنید</option>';

            if ( isset($attribute_values[$attribute]) ) {
                $unique_values = array_unique($attribute_values[$attribute]);

                foreach ( $unique_values as $value ) {
                    $output .= '<option value="' . esc_attr($value) . '">' . esc_html($value) . '</option>';
                }
            }

            $output .= '</select><br>';
        }
        
        $output .= '<button type="submit">اعمال فیلترها</button>';
        $output .= '</form>';
        $output .= '<div id="show-more-btn">مشاهده بیشتر</div>';
        $output .= '<div id="filterResults"></div>';

        return $output;
    }
}
add_shortcode("CustomFilterWidget", "CustomFilterWidget");



function ReplaceDashTOSpace($char){
    $char = str_replace(array('-', '_'), ' ', $char);
    return $char;
}

function ajax_filter_products1() {

    // دریافت دسته‌بندی از درخواست
    $category_id = $_POST['cat_id'];
    $min_price = $_POST['min_price'];
    $max_price = $_POST['max_price'];

    // آماده کردن کوئری برای دریافت محصولات از دسته‌بندی
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $category_id,
            ),
            'meta_query' => array(
            array(
                'key' => '_price',
                'value' => array($min_price[1], $max_price[1]),
                'compare' => 'BETWEEN',
                'type' => 'NUMERIC',
            ),
        ),
        ),
        'meta_query' => array('relation' => 'AND'), // فیلترهای ویژگی‌ها
    );

//    print_r($_POST);
    // بررسی و افزودن فیلترهای انتخابی به کوئری
    foreach ($_POST as $key => $value) {
        if ($value == '' || $key == 'cat_id' || $key == 'action') {
            continue; // اگر فیلتر انتخاب نشده یا فیلترهای غیرمرتبط
        }

        // افزودن فیلتر ویژگی‌ها به meta_query
        $args['meta_query'][] = array(
            'key'     => 'pa_' . sanitize_text_field($key), // فیلتر بر اساس ویژگی
            'value'   => sanitize_text_field($value), // مقدار انتخاب‌شده
            'compare' => 'LIKE',
        );
    }
    // اجرای کوئری محصولات
    $products = new WP_Query($args);

    // بررسی وجود محصولات و نمایش نتایج
    if ($products->have_posts()) {
        while ($products->have_posts()) {
            $products->the_post();
            wc_get_template_part('content', 'product'); // نمایش قالب محصول ووکامرس
        }
    } else {
        echo '<p>هیچ محصولی یافت نشد.</p>';
    }

    wp_die(); // پایان درخواست AJAX
}

function ajax_filter_products() {
    // دریافت دسته‌بندی از درخواست
    $category_id = $_POST['cat_id'];

    // آماده کردن کوئری برای دریافت محصولات از دسته‌بندی
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $category_id,
            ),
        ),
    );

    // اجرای کوئری برای دریافت محصولات از دسته‌بندی
    $products = new WP_Query($args);

    // بررسی وجود محصولات
    if ($products->have_posts()) {
        $filtered_products = array(); // آرایه برای نگهداری محصولات فیلتر شده

        // حلقه برای بررسی هر محصول
        while ($products->have_posts()) {
            $products->the_post();
            $product_id = get_the_ID();

            // دریافت ویژگی‌های سریالایز شده محصول
            $attributes = get_post_meta($product_id, '_product_attributes', true);

            // متغیر برای اینکه بررسی کنیم آیا محصول با همه فیلترها تطابق دارد یا خیر
            $product_matches = true;

            // بررسی هر ویژگی در درخواست (AND)
            foreach ($_POST as $key => $value) {
                $found_match = false; // فرض کنیم که ویژگی پیدا نشده است
                if($value == '' || $key == 'cat_id' || $key == 'action' || $key == 'min_price' || $key == 'max_price' ){}else{

                    $key = ReplaceDashTOSpace($key);
                    // بررسی اینکه آیا ویژگی در ویژگی‌های محصول وجود دارد
                    foreach ($attributes as $encoded_key => $attribute) {
                        $decoded_key = ReplaceDashTOSpace(urldecode($encoded_key)); // دیکد کردن کلید از حالت URL-encoded
//                        echo $decoded_key.':'.$key.'</br>';
                        if ($decoded_key == $key) {
                            $attribute_value = $attribute['value'];

                            // بررسی تطابق ویژگی
                            if (strpos($attribute_value, $value) !== false) {
                                $found_match = true; // ویژگی پیدا شده و تطابق دارد
                                break; // به دلیل پیدا کردن تطابق، از حلقه خارج می‌شویم
                            }
                        }
                    }


                    // اگر هیچ تطابقی پیدا نشد، محصول حذف می‌شود
                    if (!$found_match) {
                        $product_matches = false;
                        break; // از حلقه خارج می‌شویم چون محصول نباید نمایش داده شود
                    }


                }
            }
            // اگر محصول با همه فیلترها تطابق داشت، به آرایه محصولات فیلتر شده اضافه می‌شود
            if ($product_matches == true) {
//                        echo $product_id.'</br>';
                $filtered_products[] = $product_id;
            }
        }
        // نمایش محصولات فیلتر شده
        if ($products->have_posts()) {
            // حلقه برای بررسی هر محصول
            while ($products->have_posts()) {
                $products->the_post();
                $product_id = get_the_ID();
                if(in_array($product_id ,$filtered_products )){
                    // دریافت اطلاعات محصول
                    $product = wc_get_product($product_id);
                    $product_link = get_permalink($product_id);
                    $product_title = get_the_title($product_id);
                    $product_price = $product->get_price_html(); // دریافت قیمت به فرمت HTML
                    $product_thumbnail = get_the_post_thumbnail_url($product_id, 'full'); // تصویر محصول

                    // فرض می‌کنیم محصول چند تصویر دارد و به آنها دسترسی داریم
                    $gallery_image_ids = $product->get_gallery_image_ids(); // دریافت گالری تصاویر
                    $gallery_image_2 = !empty($gallery_image_ids) ? wp_get_attachment_image_url($gallery_image_ids[0], 'full') : '';

                    // HTML سفارشی برای نمایش محصول
                    echo '<li class="product type-product post-' . esc_attr($product_id) . ' status-publish instock product_cat-'. esc_attr($category_id) .' has-post-thumbnail shipping-taxable purchasable product-type-variable">';
                    echo '  <a href="' . esc_url($product_link) . '" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">';
                    echo '    <div class="image-product">';
                    echo '      <figure>';
                    echo '        <span class="loading_imagesss"></span>';
                    echo '        <img class="img-product-sliders-1" src="' . esc_url($product_thumbnail) . '" />';
                    if (!empty($gallery_image_2)) {
                        echo '        <img class="img-product-sliders-2" src="' . esc_url($gallery_image_2) . '" />';
                    }
                    echo '      </figure>';
                    echo '    </div>';
                    echo '  </a>';
                    echo '  <div class="columnd-1-set">';
                    echo '    <a href="' . esc_url($product_link) . '" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">';
                    echo '    </a>';
                    echo '    <div class="category-one-list">';
                    echo '    </div>';
                    echo '    <a href="' . esc_url($product_link) . '">';
                    echo '      <h2 class="woocommerce-loop-product__title">' . esc_html($product_title) . '</h2>';
                    echo '    </a>';
                    echo '    <div class="price-product-woo">' . $product_price . '</div>';
                    echo '    <div class="button-add_cart_ex">';
                    echo '      <a href="' . esc_url($product_link) . '" class="button product_type_variable add_to_cart_button">انتخاب گزینه‌ها</a>';
                    echo '      <div class="like-containers">';
                    echo '        <a class="like-buttons" data-product-id="' . esc_attr($product_id) . '"><i class="fa-light fa-heart"></i></a>';
                    echo '      </div>';
                    echo '    </div>';
                    echo '  </div>';
                    echo '</li>';
                }
            }

            wp_reset_postdata(); // ریست کردن داده‌ها پس از حلقه
        } else {
            echo '<p>هیچ محصولی یافت نشد.</p>';
        }


        wp_reset_postdata(); // ریست کردن داده‌ها پس از حلقه
    } else {
        echo '<p>هیچ محصولی یافت نشد.</p>';
    }

    wp_die();
}




// ثبت اکشن‌های ایجکس
add_action('wp_ajax_ajax_filter_products', 'ajax_filter_products');
add_action('wp_ajax_nopriv_ajax_filter_products', 'ajax_filter_products');


function get_min_max_price_in_category($category_id) {
    global $wpdb;

    // کوئری برای دریافت کمترین و بیشترین قیمت محصولات در یک دسته‌بندی خاص
    $prices = $wpdb->get_row("
        SELECT MIN(CAST(meta_value AS UNSIGNED)) AS min_price, MAX(CAST(meta_value AS UNSIGNED)) AS max_price
        FROM {$wpdb->postmeta} pm
        INNER JOIN {$wpdb->term_relationships} tr ON pm.post_id = tr.object_id
        INNER JOIN {$wpdb->term_taxonomy} tt ON tr.term_taxonomy_id = tt.term_taxonomy_id
        WHERE tt.term_id = {$category_id}
        AND tt.taxonomy = 'product_cat'
        AND pm.meta_key = '_price'
        AND pm.meta_value > 0
    ");

    return $prices;
}

function price_filter_shortcode() {
    if (is_product_category()) {
        $category = get_queried_object();
        $category_id = $category->term_id;
    } else {
        return '<p>دسته‌بندی مشخص نشده است.</p>';
    }

    // دریافت کمترین و بیشترین قیمت از محصولات دسته‌بندی
    $prices = get_min_max_price_in_category($category_id);
    $min_price = $prices->min_price ? $prices->min_price : 0;
    $max_price = $prices->max_price ? $prices->max_price : 50000000;

    // دریافت مقادیر فیلتر شده از URL (در صورت وجود)
    $current_min_price = isset($_GET['min_price']) ? intval($_GET['min_price']) : $min_price;
    $current_max_price = isset($_GET['max_price']) ? intval($_GET['max_price']) : $max_price;

    // HTML اسلایدر

        $return= '
           <form method="GET" id="filterForm" class="custom-filter-form">
                <input type="hidden" id="originalMinPrice" value="' . esc_js($min_price) . '">
                <input type="hidden" id="originalMaxPrice" value="' . esc_js($max_price) . '">
                <div class="price-filter">
                    <label for="price-range">فیلتر بر اساس قیمت:</label>
                    <div id="slider-range"></div>
                    <p>قیمت: <span id="amount"></span></p>
                    <input type="hidden" id="min_price" name="min_price" value="'.esc_attr($current_min_price).'">
                    <input type="hidden" id="max_price" name="max_price" value="'.esc_attr($current_max_price).'">
                </div>
                <!-- دکمه ریست فیلترها -->
                <button id="resetFilters">حذف فیلترها</button>
            </form>
        
            <div id="filterResults"></div>
            
            <script>
                jQuery(document).ready(function($) {
                var originalMinPrice = ' . esc_js($min_price) . ';
                var originalMaxPrice = ' . esc_js($max_price) . ';
        
                // تابع برای جدا کردن قیمت به صورت سه‌رقم‌سه‌رقم
                function formatPrice(price) {
                    return price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                }
        
                // تنظیم اسلایدر قیمت
                $("#slider-range").slider({
                    range: true,
                    min: originalMinPrice,
                    max: originalMaxPrice,
                    values: [$("#min_price").val() || originalMinPrice, $("#max_price").val() || originalMaxPrice],
                    slide: function(event, ui) {
                        $("#amount").text(formatPrice(ui.values[0]) + " تومان - " + formatPrice(ui.values[1]) + " تومان");
                        $("#min_price").val(ui.values[0]);
                        $("#max_price").val(ui.values[1]);
                    },
                    change: function(event, ui) {
//                        applyFilters(); // اعمال فیلترها بعد از تغییر بازه قیمت
                    }
                });
        
                // مقدار اولیه برای نمایش قیمت‌ها پس از بارگذاری صفحه
                $("#amount").text(formatPrice($("#slider-range").slider("values", 0)) + " تومان - " + formatPrice($("#slider-range").slider("values", 1)) + " تومان");
                });
            </script>
            
        ';
    return $return;
    }
//add_shortcode('price_filter', 'price_filter_shortcode');





//function filter_products_by_price_ajax() {
//    if (isset($_GET['min_price']) && isset($_GET['max_price']) && isset($_GET['category_id'])) {
//        $min_price = intval($_GET['min_price']);
//        $max_price = intval($_GET['max_price']);
//        $category_id = intval($_GET['category_id']);
//    } else {
//        return;
//    }
//
//    // کوئری برای فیلتر محصولات بر اساس قیمت و دسته‌بندی
//    $args = array(
//        'post_type' => 'product',
//        'posts_per_page' => -1,
//        'tax_query' => array(
//            array(
//                'taxonomy' => 'product_cat',
//                'field'    => 'term_id',
//                'terms'    => $category_id,
//            ),
//        ),
//        'meta_query' => array(
//            array(
//                'key' => '_price',
//                'value' => array($min_price, $max_price),
//                'compare' => 'BETWEEN',
//                'type' => 'NUMERIC',
//            ),
//        ),
//    );
//
//    $products = new WP_Query($args);
//
//    // بررسی وجود محصولات و نمایش نتایج
//    if ($products->have_posts()) {
//        while ($products->have_posts()) {
//            $products->the_post();
//            wc_get_template_part('content', 'product');
//        }
//    } else {
//        echo '<p>هیچ محصولی یافت نشد.</p>';
//    }
//
//    wp_die(); // پایان درخواست AJAX
//}
//
//add_action('wp_ajax_filter_products', 'filter_products_by_price_ajax');
//add_action('wp_ajax_nopriv_filter_products', 'filter_products_by_price_ajax');


function enqueue_local_jquery_ui() {
    // بارگذاری CSS
    wp_enqueue_style('jquery-ui-css', get_template_directory_uri() . '/css/jquery-ui.min.css'); // مسیر CSS بسته به جایی که آپلود کرده‌اید

    // بارگذاری اسکریپت‌های jQuery UI
    wp_enqueue_script('jquery-ui-js' ,  get_template_directory_uri() . '/js/jquery-ui.min.js'); // مسیر CSS بسته به جایی که آپلود کرده‌اید

    wp_localize_script('ajax-filter', 'ajaxfilter', array(
        'ajaxurl' => admin_url('admin-ajax.php')
    ));
   
}
add_action('wp_enqueue_scripts', 'enqueue_local_jquery_ui');







// افزودن اسکریپت‌ها و استایل‌های Owl Carousel
function enqueue_owl_carousel() {
    // بارگذاری فایل‌های CSS برای Owl Carousel
    wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/css/owl.carousel.min.css');
    wp_enqueue_style('owl-theme', get_template_directory_uri() . '/css/owl.theme.default.min.css');
    
    // بارگذاری فایل‌های JS برای Owl Carousel
    wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), '2.3.4', true);
}
add_action('wp_enqueue_scripts', 'enqueue_owl_carousel');

// فعال‌سازی Owl Carousel
function owl_carousel_init() {
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function(){
            jQuery('.owl-carousel').owlCarousel({
                loop: true,
                nav: true,
                autoplay: true,
                autoplayTimeout: 3000,
                autoplayHoverPause: true,
                rtl:true,
                responsive:{
                    0:{
                        items: 1
                    },
                    600:{
                        items: 2
                    },
                    1000:{
                        items: 5
                    }
                }
            });
        });
    </script>
    <?php
}
add_action('wp_footer', 'owl_carousel_init');


add_filter('woocommerce_product_get_image', 'remove_prefix_from_product_images', 10, 2);
add_filter('woocommerce_gallery_image_html_attachment_image_params', 'remove_prefix_from_gallery_images', 10, 3);

function remove_prefix_from_product_images($image, $product) {
    $prefix = 'https://kharidstore.com/wp-content/uploads/';
    if (strpos($image, $prefix) === 0) {
        $image = str_replace($prefix, '', $image);
    }
    return $image;
}


//add_action('init', function () {
//    if (defined('DOING_AJAX') && DOING_AJAX) {
//        if (isset($_POST['action']) && $_POST['action'] === 'check_product_like') {
//            wp_die('Blocked: This request is not allowed.', '', 403);
//        }
//    }
//});

// حذف پارامترهای URL از آدرس تصاویر
function hdm_remove_image_query_string( $url ) {
    // فقط بخش اصلی آدرس را نگه می‌داریم و کوئری را حذف می‌کنیم
    $parsed_url = explode('?', $url);
    return $parsed_url[0];
}

// فیلتر برای URL تصویر شاخص، گالری و غیره
add_filter( 'wp_get_attachment_image_src', function( $image ) {
    if ( is_array( $image ) && isset( $image[0] ) ) {
        $image[0] = hdm_remove_image_query_string( $image[0] );
    }
    return $image;
});

// فیلتر برای محتوای پست‌ها (تصاویر داخل محتوا)
add_filter( 'the_content', function( $content ) {
    return preg_replace_callback( '/<img[^>]+src="([^"]+)"[^>]*>/i', function( $matches ) {
        $clean_src = preg_replace('/\?.*/', '', $matches[1]);
        return str_replace($matches[1], $clean_src, $matches[0]);
    }, $content );
});


add_action('pre_get_posts', 'hdm_sort_products_by_high_price');

function hdm_sort_products_by_high_price($query) {
    // فقط در صفحات بایگانی ووکامرس و کوئری اصلی اجرا شود
    if (!is_admin() && $query->is_main_query() && is_product_category()) {
        // ست کردن سورت بر اساس قیمت به صورت نزولی (از بیشترین به کمترین)
        $query->set('meta_key', '_price');
        $query->set('orderby', 'meta_value_num');
        $query->set('order', 'DESC');
    }
}

