<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined('ABSPATH') || exit;
?>
<style>
    .woocommerce-order {
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
    }

    .woocommerce-order .woocommerce-notice {
        padding: 15px;
        border: 2px dashed #ddd;
        text-align: center;
        font-weight: 500;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .woocommerce-order .woocommerce-notice--success {

    }

    .woocommerce-order .woocommerce-notice--success:before {
        content: "\f058";
        font-family: "Font Awesome 5 Pro";
        padding-left: 7px;
        font-size: 20px;
        color: #00b894;
    }

    .woocommerce-order .woocommerce-notice--error:before {
        content: "\e242";
        font-family: "Font Awesome 5 Pro";
        padding-left: 7px;
        font-size: 20px;
        color: #dc163e;
    }

    .woocommerce-order ul {
        background: none !important;
        padding: 0 !important;
        margin: 0 !important;

    }

    .woocommerce-order ul li {
        background: none !important;
        padding: 0 !important;
        margin: 0 !important;
    }

    .woocommerce-order ul.woocommerce-order-overview {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 0 !important;
        margin: 0 !important;
    }


    .woocommerce-order ul.woocommerce-order-overview li {
        display: grid;
        justify-items: center;
        width: 100% !important;
        align-items: start;
        border-left: 0 !important;
        border: 2px dashed #ddd !important;
        font-weight: 500;
        padding: 14px !important;
        border-left: none !important;
    }

    .woocommerce-order ul.woocommerce-order-overview li:last-child {
        border-left: 2px dashed #ddd !important;
    }
    @media screen and (max-width: 1000px) {
        .woocommerce-order ul.woocommerce-order-overview {
            flex-wrap: wrap;
        }
        .woocommerce-order ul.woocommerce-order-overview li {
            border: none !important;
            border-bottom: 1px dashed #dddddd !important;
        }
        .woocommerce-order ul.woocommerce-order-overview li:last-child {
            border-left: none !important;
        }
    }
    .woocommerce-order ul.woocommerce-order-overview li strong {
        padding: 15px 0 0;
        font-weight: 500;
    }

    .woocommerce-order bdi {
        display: flex;
        align-items: center;
    }

    .woocommerce-order bdi span.woocommerce-Price-currencySymbol {
        order: 1;
        padding-right: 4px
    }

    .woocommerce-order bdi span.woocommerce-Price-currencySymbol:after {
        content: var(--main-content);
    }

    .woocommerce-order h2.woocommerce-order-details__title {
        font-size: 25px;
        line-height: 50px;
        margin: 5px 0 20px;
        font-weight: 400;
        position: relative;
        display: flex;
        justify-content: center;
    }

    .woocommerce-order h2.woocommerce-order-details__title:before {
        position: absolute;
        bottom: -5px;
        content: "";
        background-color: #303841;
        width: 100px;
        height: 5px;
        border-radius: 10px;
        opacity: .1;
    }

    .woocommerce-order h2.woocommerce-column__title {
        font-size: 25px;
        line-height: 50px;
        margin: 5px 0 20px;
        font-weight: 400;
        position: relative;
        display: flex;
        justify-content: center;
    }

    .woocommerce-order h2.woocommerce-column__title:before {
        position: absolute;
        bottom: -5px;
        content: "";
        background-color: #303841;
        width: 100px;
        height: 5px;
        border-radius: 10px;
        opacity: .1;
    }

    .woocommerce-order address {
        font-weight: 400 !important;
        border: 1px solid #dddddd !important;
        font-size: 13px;
    }

    .woocommerce-order .woocommerce-order-details table {
        border: none !important;
    }

    .woocommerce-order .woocommerce-order-details table thead tr th {
        font-weight: 400 !important;

    }

    .woocommerce td.product-name .wc-item-meta li {
        margin: 10px 0 !important;
        font-weight: 400 !important;
        float: right;
        display: flex;
        border: 2px dashed #ddd;
        padding: 2px 10px !important;
    }

    .woocommerce td.product-name .wc-item-meta li .wc-item-meta-label {
        font-weight: 400 !important;
    }

    .woocommerce table.shop_table th {
        font-weight: 400 !important;
    }

    .woocommerce table.shop_table tfoot td, .woocommerce table.shop_table tfoot th {
        font-weight: 400 !important;
    }

    .woocommerce-order .woocommerce-order-details table tbody td {
        font-weight: 400 !important;
    }

    .woocommerce-order .woocommerce-order-details table tbody td .product-quantity {
        font-weight: 400 !important;
    }

    .woocommerce-order .woocommerce-order-details table tbody td a {
        text-decoration: none;
        color: #222222;
        opacity: .8;
    }

    .woocommerce-order .woocommerce-order-details table tbody td a:hover {
        opacity: 1;
    }

    .woocommerce-order td .woocommerce-Price-amount {
        display: flex;
        align-items: center;
        font-weight: 400 !important;
    }

    .woocommerce-order td .woocommerce-Price-amount .woocommerce-Price-currencySymbol {
        order: 1;
        padding-right: 4px
    }

    .woocommerce-order td .woocommerce-Price-amount .woocommerce-Price-currencySymbol:after {
        content: var(--main-content);
    }

    .woocommerce-order td .shipped_via {
        border: 2px dashed #ddd;
        padding: 2px 10px;
        margin: 10px 0;
        float: right;
        display: block;
    }
</style>
<div class="woocommerce-order">

    <?php


    if ($order) :

        do_action('woocommerce_before_thankyou', $order->get_id());
        ?>

        <?php if ($order->has_status('failed')) : ?>

        <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e('Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce'); ?></p>

        <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
            <a href="<?php echo esc_url($order->get_checkout_payment_url()); ?>"
               class="button pay"><?php esc_html_e('Pay', 'woocommerce'); ?></a>
            <?php if (is_user_logged_in()) : ?>
                <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>"
                   class="button pay"><?php esc_html_e('My account', 'woocommerce'); ?></a>
            <?php endif; ?>
        </p>

    <?php else : ?>

        <?php wc_get_template('checkout/order-received.php', array('order' => $order)); ?>

        <ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

            <li class="woocommerce-order-overview__order order">
                <?php esc_html_e('Order number:', 'woocommerce'); ?>
                <strong><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
            </li>

            <li class="woocommerce-order-overview__date date">
                <?php esc_html_e('Date:', 'woocommerce'); ?>
                <strong>
                    <?php
                    $order_date = $order->get_date_created()->getTimestamp();
                    $jalali_date = jdate('Y/m/d', $order_date);
                    echo $jalali_date;
                    ?>
                </strong>


            </li>

            <?php if (is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email()) : ?>
                <li class="woocommerce-order-overview__email email">
                    <?php esc_html_e('Email:', 'woocommerce'); ?>
                    <strong><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
                </li>
            <?php endif; ?>

            <li class="woocommerce-order-overview__total total">
                <?php esc_html_e('Total:', 'woocommerce'); ?>
                <strong><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
            </li>

            <?php if ($order->get_payment_method_title()) : ?>
                <li class="woocommerce-order-overview__payment-method method">
                    <?php esc_html_e('Payment method:', 'woocommerce'); ?>
                    <strong><?php echo wp_kses_post($order->get_payment_method_title()); ?></strong>
                </li>
            <?php endif; ?>

        </ul>

    <?php endif; ?>

        <?php do_action('woocommerce_thankyou', $order->get_id()); ?>

    <?php else : ?>

        <?php wc_get_template('checkout/order-received.php', array('order' => false)); ?>

    <?php endif; ?>

</div>
