<?php
/*add theme like post*/
// ثبت نام فرم مورد نیاز برای استفاده از AJAX
add_action('wp_ajax_handle_post_like', 'handle_post_like');
add_action('wp_ajax_nopriv_handle_post_like', 'handle_post_like');
function handle_post_like() {
    $post_id = $_POST['post_id'];
    $user_ip = $_SERVER['REMOTE_ADDR'];

    // بررسی آیا آیپی کاربر قبلاً لایک کرده یا خیر
    $liked_ips = get_post_meta($post_id, 'liked_ips', true);
    if (!$liked_ips) {
        $liked_ips = array();
    }

    if (in_array($user_ip, $liked_ips)) {
        $response = array(
            'success' => false,
            'message' => 'شما قبلاً این پست را لایک کرده‌اید.'
        );
        wp_send_json($response);
    }

    // ثبت لایک و بروزرسانی تعداد لایک‌ها
    $likes = get_post_meta($post_id, 'likes', true);
    $likes = (empty($likes)) ? 1 : $likes + 1;
    update_post_meta($post_id, 'likes', $likes);

    // ثبت آیپی لایک کننده
    $liked_ips[] = $user_ip;
    update_post_meta($post_id, 'liked_ips', $liked_ips);

    $response = array(
        'success' => true,
        'likes' => $likes,
        'message' => 'پست با موفقیت لایک شد!'
    );
    wp_send_json($response);
}
add_action('wp_enqueue_scripts', 'add_my_script');
function add_my_script() {
    wp_enqueue_script(
        'your-js-file',
        get_template_directory_uri() . '/js/empty.js',
        array('jquery'),
        '1.0',
        true
    );
    wp_localize_script( 'your-js-file', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
}



