<?php

class slider_product_diak_theme_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'slider-product-pro-diak_thems';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>اسلایدر محصول پیشرفته</h2>';
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['slider-product'];
    }

    function get_product_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options [$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('تنظیمات و محتوای کلی اسایدر محصول', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'list_id_category_product',
            [
                'label' => esc_html__('انتخاب دسته بندی محصولات', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'description' => 'در این قسمت شما باید حداقل یک دسته بندی از محصولات را انتخاب کنید تا محصولات مربوط به دسته بندی انتخاب شده نمایش گردد مثال (اگر اسلایدر مربوط به دسته بندی روز مادر باشد محصولاتی که تخفیف و قیمت مربوط به روز مادر را دارد را از لیست انتخاب کنید)',
                'multiple' => true,
                'options' => $this->get_product_cat(),
                'default' => ['title', 'description'],
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme-lkdfjsklfkdlnf321',
            [
                'label' => esc_html__('نام اسلایدر محصول کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'return_value' => 'yes',
                'default' => 'محصولات دیجیتال',
                'description' => 'میتوانید از طریق این قسمت نام اسلایدر خود را تغییر دهید',
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme',
            [
                'label' => esc_html__('وضعیت نمایش تایمر تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت فعال و یا غیر فعالسازی تایمر تخفیف را عوض کنید',
            ]
        );
        $this->add_control(
            'show-add-to-cart-product-sliders-theme',
            [
                'label' => esc_html__('وضعیت نمایش اضافه کردن به سبد خرید آجاکس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اضافه کردن به سبد خرید آجاکس | زنده را عوض کنید',
            ]
        );
        $this->add_control(
            'show-add-to-wishlist-product-sliders-theme',
            [
                'label' => esc_html__('وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس | زنده را عوض کنید',
            ]
        );
        $this->add_control(
            'number-per-page-slider-pro-one',
            [
                'label' => esc_html__('تعداد حداکثر محصولات نمایش داده شده', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 10,
                'description' => 'میتوانید از طریق این قسسمت مشخص کنید حد اکثر محصولاتی که از ووکامرس دریافت میکند چند عدد باشد',

            ]
        );
        $this->add_control(
            'enable_sale-price-product',
            [
                'label' => esc_html__('محصولات دارای تخفیف یا همه', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '_sale_price' => esc_html__('فقط محصولات تخفیف خورده', 'textdomain'),
                    '' => esc_html__('همه', 'textdomain'),
                ],
                'description' => 'میتوانید با انتخاب دو گذینه بالا مشخص کنید محصولاتی که از دسته بندی ها میگیرد به صورت تخفیفی باشد یا عادی که همه را در بر بگیرد',

            ]
        );
        $this->add_control(
            'enable_sale-price-prfgddfkgfdfdduct',
            [
                'label' => esc_html__('جایگاه مقدار تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => "bottom_left",
                'options' => [
                    'top_left' => esc_html__('بالا سمت چپ', 'textdomain'),
                    'bottom_left' => esc_html__('پایین سمت چپ', 'textdomain'),
                ],
                'description' => 'شما میتوانید جایگاه نمایش مقدار تخفیف را در 2 حالت در سمت پچ بالا پایین به شخصی سازی خودتان انجام دهید',

            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل های اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one1',
            [
                'label' => esc_html__('  رنگ پس زمینه کلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه کلی هر آیتم محصول که به صورت پیشفرض سفید است را تغییر و شخصی سازی نمایید',
                'default' => '#ffffff',
            ]
        );
        $this->add_control(
            'color-bachground-slider-name-products-slider',
            [
                'label' => esc_html__(' رنگ اصلی نام محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از طیرق این قسمت رنگ نام محصول را تغییر و شخصی سازی کنید',
                'default' => '#222222',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-del1-bdi-price',
            [
                'label' => esc_html__(' رنگ قیمت تک ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ قیمت نک که محصولی اگر دارای یک قیسمت منحصر به فرد باشد  را شخصی سازی و تنظیم کنید',
                'default' => '#007aff',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-del1',
            [
                'label' => esc_html__(' رنگ قیمت  منسوخ شده تخفیف خورده (del) ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ قیمت تخفیفی که منسوخ شده و به صورت خاکستری پیش فرض نشان میدهد را تنظیم کنید',
                'default' => '#6b6969',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1',
            [
                'label' => esc_html__(' رنگ قیمت تخفیف خورده (ins) ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ قیمت تخفیف خورده تمام شده را تنظیم کنید (قرمز)',
                'default' => '#007aff',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-border-radios-box-21',
            [
                'label' => esc_html__('منحنی باکس سفید محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'description' => 'شما میتوانید از طریق این قسمت بردر ردیوز یا منحنی باکس آیتم اصلی محصول را تنظیم و سفارش سازی کنید',
                'min' => 5,
                'max' => 30,
                'step' => 1,
                'default' => 15,
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1-115212',
            [
                'label' => esc_html__(' رنگ پس زمینه بخش اضافه کردن به سبد خرید ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ پس زمینه بخش اضافه کردن به سبد خرید را شخصی سازی و تنظیم کنید',
                'default' => '#007aff',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-ins1-115212-1',
            [
                'label' => esc_html__(' رنگ آیکون بخش اضافه کردن به سبد خرید ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'میتوانید از این قسمت رنگ آیگون بخش اضافه کردن به سبد خرید را شخصی سازی و تنظیم کنید',
                'default' => '#ffffff',
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'style_sections',
            [
                'label' => esc_html__('تنظیمات اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'show_autoplay-controle-slider-pro1',
            [
                'label' => esc_html__('حرکت خودکار اسلایدر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدر خودکار حرکت کنید یا نه',
            ]
        );
        $this->add_control(
            'show_loop-controle-slider-pro1',
            [
                'label' => esc_html__('برگرداندن اسلایدر بعد از اتمام', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدربعد از اینکه کل تصاویر موجود را یک بار نشان داد دوباره به اول برگردد و دوباره مراتب را تکرار کنید',
            ]
        );
        $this->add_control(
            'fast-slider-pro-autoplay-Timeout1',
            [
                'label' => esc_html__('سرعت عوض شدن اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2000,
                'max' => 100000,
                'step' => 1000,
                'default' => 5000,
                'description' => 'میتوانید از این قسمت مشخص کنید اسلایدر های در چند ثانبه یک بار تعویض شوند هر 1000 عدد نشانگر 1 ثانیه میباشد بهتر اسست عدد یین 5000(5 ثانیه) تا 20000(20 ثانیه) باشد',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>

<style>
    .slider-product {
        width: 100%;
        float: right;
    }

    .slider-product .mySwiper-product {
        padding-top: 50px;
    }

    .slider-product h2 {
        width: 100%;
        float: right;
        text-align: center;
        position: absolute;
        top: 5%;
        font-family: digikala;
    }

    .slider-product .swiper-wrapper {
        width: 100%;
        margin: 30px auto 10px;
        display: flex;
        justify-content: right;
        align-items: start;
    }

    .slider-product .swiper-wrapper .swiper-slide {
        text-align: center;
        float: right;
        overflow: hidden;
        position: relative;
        padding: 0 0 5px;
        background: <?php echo $settings['color-bachground-slider-product-one-one1']; ?>;
        margin-bottom: 0;
        border-radius: <?php echo $settings['color-bachground-slider-product-one-border-radios-box-21']."px"; ?>;
        border: 1px solid #ddd;
    }

    .slider-product .swiper-wrapper .swiper-slide:hover .like-containers {
        transform: translateX(0);
    }
    .slider-product .swiper-wrapper .swiper-slide .like-containers:before {
        content: "افزودن به علاقه مندی";
        position: absolute;
        right: 100%;
        top: 3px;
        background: #ffffff;
        border-radius: 3px;
        width: max-content;
        font-size: 11px;
        border: 1px solid #ddd;
        padding: 0 5px;
        opacity: 0;
        visibility: hidden;
        transition: all .3s ease-in-out;
    }
    .slider-product .swiper-wrapper .swiper-slide .like-containers:hover:before {
        opacity: 1;
        visibility: visible;
        right: 120%;
    }
    .slider-product .swiper-wrapper .swiper-slide .like-containers {
        position: absolute;
        top: 10px;
        transition: all .3s ease-in-out;
        transform: translateX(150%);
        width: 35px;
        height: 35px;
        right: 10px;
        font-size: 13px !important;
        background: #FFFFFF;
        border-radius: 50%;
        border: 1px solid #ddd;
        z-index: 2;
    }
    .slider-product .swiper-wrapper .swiper-slide .like-containers span {
        width: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100%;
        text-align: center;
    }
    .slider-product .swiper-wrapper .swiper-slide .like-containers span i {
        font-size: 17px;
        padding: 0;
        margin:0;
    }

    .slider-product .swiper-wrapper .swiper-slide .icon-shop-item-slider {
        display: flex;
        transition: all .3s ease-in-out;
        z-index: 1;
        float: left;
        justify-content: left;
        width: 49%;
    }

    .slider-product .swiper-wrapper .swiper-slide .icon-shop-item-slider a {
        position: relative;
        background: #fff;
        padding: 10px;
        border: 1px solid #e9e9e9;
        color: var(--main-color5);
        margin: 0 3px;
        border-radius: 14px;
        font-size: 17px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        font-weight: 200;
        transition: all .3s ease-in-out;
    }

    .slider-product .swiper-wrapper .swiper-slide .icon-shop-item-slider a:hover {
        box-shadow: inset 0 0 0 30px var(--main-color5);
        color: #ffffff;
    }

    .slider-product .swiper-wrapper .swiper-slide .icon-shop-item-slider a i {

    }

    .slider-product .swiper-wrapper .swiper-slide .icon-shop-item-slider a span {
        position: absolute;
        left: 0;
        bottom: 100%;
        opacity: 0;
        visibility: hidden;
    }

    .slider-product .swiper-wrapper .swiper-slide .iconic-available-attributes {
        position: absolute;
        left: 10px;
        top: 10px;
        display: grid;
    }

    .slider-product .swiper-wrapper .swiper-slide  .iconic-available-attributes .item-color-shop-loop-tootal {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        margin-bottom: 5px;
        border: .5px solid #ddd;
        position: relative;
        z-index: 2;
    }

    .slider-product .swiper-wrapper .swiper-slide .iconic-available-attributes .item-color-shop-loop-tootal:hover span {
        opacity: 1;
        visibility: visible;
        top: -3px;
    }

    .slider-product .swiper-wrapper .swiper-slide .iconic-available-attributes .item-color-shop-loop-tootal span {
        position: absolute;
        left: 170%;
        top: 0;
        background: #ffffff;
        color: #303841;
        padding: 4px 10px 5px;
        line-height: 1;
        font-size: 11px;
        width: max-content;
        border: 1px solid #ddd;
        float: right;
        z-index: 2;
        border-radius: 3px;
        transition: all .3s ease-in-out;
        opacity: 0;
        font-weight: 500;
        visibility: hidden;
    }


    .slider-product .swiper-wrapper .swiper-slide figure {
        width: 98%;
        max-width: 98%;
        position: relative;
        margin: 10px 1% !important;
        float: right;
        padding: 0;
        overflow: unset !important;
        height: 250px;
        display: flex;
        justify-content: center;
        position: relative;
    }

    .slider-product .swiper-wrapper .swiper-slide figure .stock {
        position: absolute;
        right: 10px;
        bottom: 10px;
        background: #494846;
        z-index: 1;
        color: #ffffff;
        font-size: 10px;
        width: fit-content;
        padding: 0 10px;
        line-height: 2;
        border-radius: 20px;
        box-shadow: 0 0 0 3px #04030338;
        margin-bottom: 6px;

    }
    .slider-product .swiper-wrapper .swiper-slide figure img {
        max-width:100% !important;
        max-height: 100%;
        height: fit-content !important;
        border-radius: 0;
        margin: auto;
        width: auto !important;
    }


    .slider-product .swiper-wrapper .swiper-slide:hover figure img.image-item-1-slider-product {
        opacity: 0;
        visibility: hidden;
    }

    .slider-product .swiper-wrapper .swiper-slide:hover figure img.image-item-2-slider-product {
        opacity: 1;
        visibility: visible;
    }

    .slider-product .swiper-wrapper .swiper-slide figure img.image-item-2-slider-product {
        opacity: 0;
        visibility: hidden;
        top: auto;
        right: auto;
        width: 100%;
        position: absolute;
        transition: all .4s linear 0s;
    }
    .slider-product .swiper-wrapper .swiper-slide figure img {
        max-width: 100%;
        height: auto;
        transition: all .3s ease-in-out;
    }

    .slider-product .swiper-wrapper .swiper-slide .name-product {
        padding: 0 10px 5px;
        text-align: right;
        width: auto;
    }

    .slider-product .swiper-wrapper .swiper-slide .name-product .cat_one_parent_slider_producty a {
        font-size: 12px;
        text-decoration: none;
        color: #222;
        opacity: .6;
        transition: all .3s ease-in-out;
        font-weight: 400;
    }
    .slider-product .swiper-wrapper .swiper-slide .name-product .cat_one_parent_slider_producty a:hover {
        opacity: 1;
    }
    .slider-product .swiper-wrapper .swiper-slide .name-product a {

    }
    .slider-product .swiper-wrapper .swiper-slide .name-product h2 {
        font-size: 14px !important;
        font-weight: 500;
        padding: 0 0 5px !important;
        line-height: 25px;
        display: flex;
        position:unset;
        font-family: iranyekanX;
        height: 50px;
        text-align: right;
        overflow: hidden;
        width: 100%;
        text-decoration: none;
        color: <?php echo $settings['color-bachground-slider-name-products-slider']; ?>;
        float: right;
        display: -webkit-box;
        -webkit-box-orient: vertical;
        -webkit-line-clamp: 2;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
    }

    .slider-product .swiper-wrapper .swiper-slide .dettle-product {
        display: flex;
        justify-content: space-between;
        align-items: center;
        width: 100%;
        margin: auto;
        border-radius: 15px;
    }

    .slider-product .swiper-wrapper .swiper-slide .price-product {
        width: 100%;
        float: right;
        text-align: right;
        padding: 5px 10px;
    }

    .slider-product .swiper-wrapper .swiper-slide figure #saving_total_price {
        float: right;
        margin-left: 10px;
        background: rgba(255, 255, 255, 0.24);
        color: var(--main-color);
        position: absolute;
        font-family: 'IRANYekanX';
        font-weight: 900;
        font-size: 12px;
        padding: 4px 8px 2px;
        line-height: 1;
        border-radius: 7px;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border: 2px solid var(--main-color);
        z-index: 2;
    }
    .slider-product .swiper-wrapper .swiper-slide .price-product > .amount > bdi {
        font-size: 17px;
        font-weight: 600;
        color: <?php echo $settings['color-bachground-slider-product-one-del1-bdi-price']; ?>;
    }

    .slider-product .swiper-wrapper .swiper-slide .price-product  {
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
    }
    .slider-product .swiper-wrapper .swiper-slide .price-product del {
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        font-size: 13px;
        text-decoration: none;
        color: <?php echo $settings['color-bachground-slider-product-one-del1'] ?>;
        position: relative;
        width: fit-content;
    }
    .slider-product .swiper-wrapper .swiper-slide .price-product del:before {
        content: "";
        position: absolute;
        height: 1px;
        width: 100%;
        top: 50%;
        transform: rotate(-8deg);
        background: #222222a6;
    }

    .slider-product .swiper-wrapper .swiper-slide .price-product .woocommerce-Price-currencySymbol {
        padding-right:3px;
    }
    .slider-product .swiper-wrapper .swiper-slide .price-product .woocommerce-Price-currencySymbol:after {
        content: var(--main-content);
    }
    .slider-product .swiper-wrapper .swiper-slide .price-product .price-vera_start_p {
        display: grid;
        color: #6b6969;
        font-size: 12px;
    }
    .slider-product .swiper-wrapper .swiper-slide .price-product .price-vera_start_p bdi {
        font-size: 17px;
        font-weight: 600;
        color: <?php echo $settings['color-bachground-slider-product-one-del1-bdi-price']; ?>;
    }
    .slider-product .swiper-wrapper .swiper-slide .price-product ins {
        text-decoration: none;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        font-size: 17px;
        font-weight: 600;
        color: <?php echo $settings['color-bachground-slider-product-one-ins1'] ?>;
        display: block;
    }

    .slider-product .swiper-button-next, .slider-product .swiper-button-prev {
        top: 6%;
    }

    .slider-product .swiper-button-next,
    .slider-product .swiper-button-prev {
        color: var(--main-color3) !important;
        fill: var(--main-color3) !important;
        stroke: var(--main-color3) !important;
        border-radius: 10px;
    }

    .slider-product .swiper-wrapper .swiper-slide .dettle-product .add-cart-product {
        margin: 10px;
        float: left;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .slider-product .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a {
        text-decoration: none !important;
    }
    .slider-product .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a.added_to_cart {
        text-decoration: none !important;
        position: absolute;
        width: max-content;
        left: 0;
        background: hsl(345deg 100% 47%);
        content: "";
        margin: 0 2%;
        border-radius: 7px;
        padding: 2px 5px;
        font-size: 12px;
        color: #ffffff;
        top: -95%;
        border: 1px solid #e1e0e0;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .slider-product .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a.loading i:before  {
        content:"\f3f4";
        font-family: "Font Awesome 5 Pro";
        animation-name: animate-lider-block !important;
        animation-duration: 1s;
        animation-iteration-count: infinite;
    }
    .slider-product .swiper-wrapper .swiper-slide .dettle-product .add-cart-product a.added i:before  {
        content:"\e3f1";
        font-family: "Font Awesome 5 Pro";
    }

    .slider-product .swiper-wrapper .swiper-slide .dettle-product .add-cart-product i {
        padding: 20px;
        background: <?php echo $settings['color-bachground-slider-product-one-ins1-115212']; ?>;
        color: <?php echo $settings['color-bachground-slider-product-one-ins1-115212-1']; ?>;
        font-size: 17px;
        border: 1px solid #ddd;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 0 0 3px #2ea2cc4d;
        transition: all .3s ease-in-out;
    }

    .slider-product .swiper-wrapper .swiper-slide .dettle-product .add-cart-product i:hover {
        box-shadow: 0 0 0 0 #2ea2cc4d;

    }



    .slider-product .swiper-wrapper .swiper-slide .timer-isent-product {
        width: 96%;
        margin: 0 2%;
        float: right;
        background: var(--main-color);
        display: flex;
        border-radius: 10px;
        color: #fff;
        justify-content: center;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        align-items: center;
    }

    .slider-product .swiper-wrapper .swiper-slide .timer-isent-product .countdown-timer {
        font-size: 20px;
        float: right;
        -moz-font-feature-settings: "ss04" !important;
        -webkit-font-feature-settings: "ss04" !important;
        font-feature-settings: "ss04" !important;
        width: 55%;
    }

    .slider-product .swiper-wrapper .swiper-slide .timer-isent-product .timer-section {
        float: right;
        display: grid;
        text-align: center;
        font-size: 12px;
        padding: 6px 8px;
        margin: 0 3px;
        border-radius: 10px;
        font-family: digikala;
        width: 20px;
    }

    .slider-product .swiper-wrapper .swiper-slide .timer-isent-product .timer-value {
        font-weight: bold;
        font-size: 15px;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
    }
    @media screen and (max-width: 1000px) {
        .slider-product .swiper-wrapper .swiper-slide figure {
            height: 150px;
        }
        .slider-product .swiper-wrapper .swiper-slide .like-containers {
            transform: unset !important;
        }
        .slider-product .swiper-wrapper .swiper-slide .price-product > .amount > bdi {
            font-size: 14px;
        }
        .slider-product .swiper-wrapper .swiper-slide .price-product .price-vera_start_p bdi {
            font-size: 14px;
        }
        .slider-product .swiper-wrapper .swiper-slide .price-product ins {
            font-size: 14px !important;
        }
        .slider-product .swiper-wrapper .swiper-slide .timer-isent-product {
            width: 94%;
            margin: 0 3%;
        }
    }

    /*end coder slider product woocommerce*/

</style>
        <script>
            $(function () {
                var swiper = new Swiper(".mySwiper-product", {
                    <?php if ($settings['show_loop-controle-slider-pro1']) { ?>
                    loop: true,
                    <?php
                    }
                    ?>
                    <?php if ($settings['show_autoplay-controle-slider-pro1']) { ?>
                    autoplay: {
                        delay: <?php echo $settings['fast-slider-pro-autoplay-Timeout1'] ?>,
                        disableOnInteraction: true,
                    },
                    <?php
                    }
                    ?>
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    breakpoints: {
                        "@0.00": {
                            slidesPerView: 2,
                            spaceBetween: 10,
                        },
                        "@0.75": {
                            slidesPerView: 3,
                            spaceBetween: 10,
                        },
                        "@1.00": {
                            slidesPerView: 4,
                            spaceBetween: 10,
                        },
                        "@1.50": {
                            slidesPerView: 5,
                            spaceBetween: 10,
                        },
                    },
                });
            })
        </script>

        <div class="container">
            <div class="slider-product">
                <?php
                $rand_class = rand(11111,99999)
                ?>
                <div class="swiper mySwiper-product ">
                    <h2><?php echo $settings['show-timer-product-sliders-theme-lkdfjsklfkdlnf321'];  ?></h2>
<style>
    .slider-product .<?php echo "class".$rand_class; ?> .swiper-slide figure #saving_total_price {
    <?php
if($settings['enable_sale-price-prfgddfkgfdfdduct'] == "top_left") {
?>
        left: 0 !important;
        top: 0 !important;
    <?php
}
else {
      ?>
        left: 0 !important;
        bottom: 17px !important;
    <?php
}
?>
    }
</style>
                    <div class="swiper-wrapper <?php echo "class".$rand_class; ?>">
                        <?php
                        $pro = new WP_Query(array(
                            'post_type' => 'product',
                            'posts_per_page' => $settings['number-per-page-slider-pro-one'],
                            'meta_key' => $settings['enable_sale-price-product'],
                            'tax_query' => [[
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $settings['list_id_category_product'],
                            ]],
                        ));

                        if ($pro->have_posts()) {
                            while ($pro->have_posts()) : $pro->the_post(); ?>
                                <div class="swiper-slide">
                                    <?php global $product;
                                    $product_id = $product->get_id(); ?>
                                    <?php
                                    if ($settings['show-add-to-wishlist-product-sliders-theme'] == true) {
                                        ?>
                                        <a class="like-containers">
                                            <span class=" like-buttons" data-product-id="<?php echo $product_id; ?>"><i
                                                        class="fa-light fa-heart"></i></span>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                    <a href="<?php echo get_permalink(); ?>">
                                        <figure>
                                            <span class="loading_images loading_imagesss"></span>
                                            <?php
                                            echo simple_product_saving_percentage("تخفیف");
                                            ?>
                                            <?php
                                            global $product;
                                            if (!$product->is_in_stock()) {
                                                echo '<p class="stock">ناموجود</p>';
                                            } ?>
                                            <?php
                                            global $product;
                                            if (!empty($product->get_gallery_image_ids())) {
                                                $attachment_ids = $product->get_gallery_image_ids();
                                                $product_plan_two_img = wp_get_attachment_url($attachment_ids[0], 'large');
                                                $image_id = get_post_thumbnail_id();

                                                ?>
                                                <img alt="<?php  wp_get_attachment_image_src("$image_id");  ?>" style="display: none" class="image-item-1-slider-product loading_image"
                                                     data-src="<?php echo get_the_post_thumbnail_url() ?>">
                                                <img class="image-item-2-slider-product"
                                                     src="<?php echo $product_plan_two_img; ?>" loading="lazy">
                                                <?php
                                            } else {
                                                ?>
                                                <img style="display: none" class="loading_image"
                                                     data-src="<?php echo get_the_post_thumbnail_url() ?>">
                                                <?php
                                            }
                                            ?>

                                        </figure>
                                    </a>

                                    <div class="name-product"><h3>
                                            <span class="cat_one_parent_slider_producty"><?php echo get_primary_product_category($product->id); ?></span>
                                            <a href="<?php echo get_permalink(); ?>">
                                                <?php do_action('woocommerce_shop_loop_item_title'); ?>
                                            </a>
                                    </div>
                                    <div class="dettle-product">
                                        <div class="price-product">

                                            <?php
                                            global $product;
                                            echo $product->get_price_html();
                                            ?>
                                        </div>
                                        <?php
                                        if ($settings['show-add-to-cart-product-sliders-theme'] == true) {
                                            ?>
                                            <div class="add-cart-product">
                                                <?php
                                                if ($product->is_type('simple')) { ?>
                                                    <?php
                                                    if ($product->is_in_stock() || $product->get_stock_quantity() > 0) {
                                                        ?>
                                                        <a href="<?php echo $product->add_to_cart_url() ?>"
                                                           value="<?php echo esc_attr($product->get_id()); ?>"
                                                           class="ajax_add_to_cart add_to_cart_button"
                                                           data-product_id="<?php echo get_the_ID(); ?>"
                                                           data-product_sku="<?php //echo esc_attr($sku) 
                                                           echo esc_attr(isset($sku) ? $sku : ''); ?>"
                                                           aria-label="Add “<?php the_title_attribute() ?>” to your cart">
                                                            <i class="fa-light fa-cart-circle-plus"></i>
                                                        </a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <a href="<?php echo get_post_permalink(); ?>"
                                                           class="namojod-product">
                                                            <i class="fa-light fa-cart-shopping"></i>
                                                        </a>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                } elseif ($product->is_type('variable')) {
                                                    ?>

                                                    <?php
                                                    if ($product->is_in_stock() && $product->get_stock_quantity() > 0) {
                                                        ?>
                                                        <a href="<?php echo get_post_permalink(); ?>"
                                                           class="namojod-productss">
                                                            <i class="fa-light fa-cart-shopping"></i>
                                                        </a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <a href="<?php echo get_post_permalink(); ?>"
                                                           class="namojod-products">
                                                            <i class="fa-light fa-cart-circle-plus"></i>
                                                        </a>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>

                                    <?php
                                    if ($settings['show-timer-product-sliders-theme'] == true) {
                                        $off_on_timer = get_post_meta(get_the_id(), 'metaboxe_product-offers', true);
                                        if ($off_on_timer == "on") {
                                            $year = get_post_meta(get_the_id(), 'month-years-select-zero', true);
                                            $month = get_post_meta(get_the_id(), 'month-years-select-one', true);
                                            $day = get_post_meta(get_the_id(), 'month-years-select-two', true);
                                            $hour = get_post_meta(get_the_id(), 'month-years-select-there', true);
                                            ?>

                                            <div class="timer-isent-product">
                                                <div class="countdown-timer" data-target-year="<?php echo $year ?>"
                                                     data-target-month="<?php echo $month ?>"
                                                     data-target-day="<?php echo $day ?>"
                                                     data-target-hour="<?php echo $hour ?>" data-target-minute="00"
                                                     data-target-second="00">
                                                    <div style="display: flex;align-items: center;width: 100%;justify-content: space-evenly"
                                                         class="massages-heddin">
                                                        <div class="timer-section days-section"><span
                                                                    class="timer-value days-value"></span> روز
                                                        </div>
                                                        <div class="timer-section hours-section"><span
                                                                    class="timer-value hours-value"></span> ساعت
                                                        </div>
                                                        <div class="timer-section minutes-section"><span
                                                                    class="timer-value minutes-value"></span> دقیقه
                                                        </div>
                                                        <div class="timer-section seconds-section"><span
                                                                    class="timer-value seconds-value"></span> ثانیه
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>

                                </div>
                            <?php
                            endwhile;
                        }
                        ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </div>



        <?php
    }


    protected function content_template()
    {
    }

}