<?php

class slider_product_2_diak_theme_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'slider-product-pro-2-diak_thems';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>اسلایدر محصول پیشرفته (desk)</h2>';
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['slider-product'];
    }

    function get_product_cat() {
        $products = get_posts(array(
            'post_type' => 'product',
            'numberposts' => -1
        ));
        $options = array();
        foreach($products as $product) {
            $options[$product->ID] = $product->post_title;
        }
        return $options;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('تنظیمات و محتوای کلی اسایدر محصول', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'text-img-one6566526465165',
            [
                'label' => 'متن عنوان اسلایدر کلی هدر',
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'محصولات شگفت انگیز ما برای تو', 'textdomain' ),
                'default' => 'محصولات شگفت انگیز ما برای تو',
            ]
        );
        $this->add_control(
            'list_id_category_product',
            [
                'label' => esc_html__('انتخاب محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'description' => 'در این قسمت شما باید حداقل یک محصول را از محصولات را انتخاب کنید',
                'multiple' => true,
                'options' => $this->get_product_cat(),
                'default' => ['title', 'description'],
            ]
        );
        $this->add_control(
            'show-timer-product-sliders-theme',
            [
                'label' => esc_html__('وضعیت نمایش تایمر تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت فعال و یا غیر فعالسازی تایمر تخفیف را عوض کنید',
            ]
        );
        $this->add_control(
            'show-add-to-wishlist-product-sliders-theme',
            [
                'label' => esc_html__('وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از طریق این قسمت وضعیت نمایش اضافه کردن به لیست علاقه مندی آجاکس | زنده را عوض کنید',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل های اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-111',
            [
                'label' => esc_html__(' رنگ پس زمینه بخش اضافات شکلی پشت اسلایدر (1)', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه بخش اضافات شکلی پشت اسلایدر (1) را تغییر و شخصی سازی نمایید',
                'default' => 'rgb(240 0 60)',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-112',
            [
                'label' => esc_html__(' رنگ پس زمینه بخش اضافات شکلی پشت اسلایدر (2)', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه بخش اضافات شکلی پشت اسلایدر (2) را تغییر و شخصی سازی نمایید',
                'default' => 'rgba(240, 0, 60, 0.44)',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-113',
            [
                'label' => esc_html__('  رنگ متن عنوان کلی اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ متن عنوان کلی اسلایدر را تغییر و شخصی سازی نمایید',
                'default' => '#FFFFFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-1',
            [
                'label' => esc_html__('  رنگ متن عنوان نام محصول سمت راست', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ متن عنوان نام محصول سمت راست را تغییر و شخصی سازی نمایید',
                'default' => '#222222',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-2',
            [
                'label' => esc_html__('  رنگ متن عنوان نام محصول سمت چپ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ متن عنوان نام محصول سمت چپ را تغییر و شخصی سازی نمایید',
                'default' => '#222222',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-3',
            [
                'label' => esc_html__('active  رنگ آیتم سمت چپ در حالت ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید active رنگ آیتم سمت چپ در حالت  را تغییر و شخصی سازی نمایید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-4',
            [
                'label' => esc_html__('رنگ قیمت ins تخفیف ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ قیمت ins تخفیف را تغییر و شخصی سازی نمایید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-5',
            [
                'label' => esc_html__('رنگ قیمت تک', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ قیمت تک را تغییر و شخصی سازی نمایید',
                'default' => '#222222',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-6',
            [
                'label' => esc_html__('رنگ پس زمینه درصد تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه درصد تخفیف را تغییر و شخصی سازی نمایید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-7',
            [
                'label' => esc_html__('رنگ عدد درصد تخفیف', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ عدد درصد تخفیف را تغییر و شخصی سازی نمایید',
                'default' => '#FFFFFF',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-8',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه هدایت به صفحه محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه دکمه هدایت به صفحه محصول را تغییر و شخصی سازی نمایید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-9',
            [
                'label' => esc_html__('رنگ پس زمینه دوم کناره دکمه هدایت به صفحه محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه دوم کناره دکمه هدایت به صفحه محصول را تغییر و شخصی سازی نمایید',
                'default' => 'hsl(340deg 100% 32%)',
            ]
        );
        $this->add_control(
            'color-bachground-slider-product-one-one-veras-10',
            [
                'label' => esc_html__('رنگ متن دکمه هدایت به صفحه محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ متن دکمه هدایت به صفحه محصول را تغییر و شخصی سازی نمایید',
                'default' => '#FFFFFF',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_sections',
            [
                'label' => esc_html__('تنظیمات اسلایدر ', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'show_autoplay-controle-slider-pro1',
            [
                'label' => esc_html__('حرکت خودکار اسلایدر ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدر خودکار حرکت کنید یا نه',
            ]
        );
        $this->add_control(
            'show_loop-controle-slider-pro1',
            [
                'label' => esc_html__('برگرداندن اسلایدر بعد از اتمام', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => 'میتوانید از این قسمت مشخص کنید که آیا اسلایدربعد از اینکه کل تصاویر موجود را یک بار نشان داد دوباره به اول برگردد و دوباره مراتب را تکرار کنید',
            ]
        );
        $this->add_control(
            'fast-slider-pro-autoplay-Timeout1',
            [
                'label' => esc_html__('سرعت عوض شدن اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2000,
                'max' => 100000,
                'step' => 1000,
                'default' => 5000,
                'description' => 'میتوانید از این قسمت مشخص کنید اسلایدر های در چند ثانبه یک بار تعویض شوند هر 1000 عدد نشانگر 1 ثانیه میباشد بهتر اسست عدد یین 5000(5 ثانیه) تا 20000(20 ثانیه) باشد',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>
        <style>
            /*start code slider hash product*/
            .hush-product-sliders {
                position: relative;
                width: 100%;
                float: right;
            }

            .hush-product-slider {
                float: right;
                width: 100%;
                display: flex;
                justify-content: space-between;
                align-items: start;
                padding: 20px 0;
                height: 500px;
            }

            .hush-product-sliders .name-sections-slider-hush {
                width: 100%;
                float: right;
                padding: 20px 0 0;
            }

            .hush-product-sliders:before {
                position: absolute;
                content: "";
                border-style: solid;
                border-width: 0 800px 500px 0;
                border-color: transparent <?php echo $settings['color-bachground-slider-product-one-one-111']; ?> transparent transparent;
                left: 0;
                right: -15px;
                border-radius: 0 20px 0 0;
                top: 0;
                transform: rotate(360deg);
                z-index: 0;
                width: fit-content;
            }

            .hush-product-sliders:after {
                position: absolute;
                content: "";
                border-style: solid;
                border-width: 0 800px 500px 0;
                border-color: transparent <?php echo $settings['color-bachground-slider-product-one-one-112']; ?> transparent transparent;
                left: 0;
                right: 0;
                border-radius: 0 20px 0 0;
                top: 1%;
                transform: rotate(360deg);
                z-index: -1;
                width: fit-content;
            }


            .hush-product-sliders .name-sections-slider-hush h3 {
                color: <?php echo $settings['color-bachground-slider-product-one-one-113']; ?>;
                font-size: 18px;
                font-family: digikala;
                z-index: 5;
                float: right;
                position: relative;
            }

            .hush-product-slider .swiper-slide {
                text-align: center;
                font-size: 18px;
                background: #fff;
                display: flex;
                justify-content: center;
                align-items: center;
            }

            .hush-product-slider .mySwiper-product-2 .swiper-slide {
                justify-content: right;
                align-items: center;
                height: 100%;
            }

            .hush-product-slider .swiper-slide img {
                display: block;
                width: 100%;
                height: 100%;
                object-fit: cover;
            }

            .hush-product-slider .swiper {
                width: 100%;
                height: 300px;
                margin-left: auto;
                margin-right: auto;
            }

            .hush-product-slider .swiper-slide {
                background-size: cover;
                background-position: center;
            }

            .hush-product-slider .mySwiper2 {
                height: 80%;
                width: 100%;
            }

            .hush-product-slider .mySwiper {
                height: 20%;
                box-sizing: border-box;
                padding: 10px 0;
            }

            .hush-product-slider .mySwiper .swiper-slide {
                width: 25%;
                height: 100%;
                opacity: 0.4;
            }

            .hush-product-slider .mySwiper .swiper-slide-thumb-active {
                opacity: 1;
            }

            .hush-product-slider .swiper-slide img {
                display: block;
                width: 100%;
                height: 100%;
                object-fit: cover;
            }

            .hush-product-slider .mySwiper-product-1 {
                width: 30% !important;
                height: 100% !important;
                margin-right: 16px;
                display: grid;
                overflow: hidden;
                align-content: center;
                justify-items: center;
            }

            .hush-product-slider .mySwiper-product-2 {
                width: 70% !important;
                height: 100% !important;
                border-radius: 20px;
                display: flex;
                background: #fff;
                justify-content: space-between;
                box-shadow: rgb(0 0 0 / 13%) 0px 15px 25px, rgb(0 0 0 / 0%) 0px 5px 10px;
                align-content: center;
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper {
                display: grid;
                height: 100%;
                align-items: flex-end;
                width: 100%;
                max-width: 100%;
                justify-items: end;
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide {
                width: 90%;
                float: right;
                height: 70px !important;
                display: flex;
                border: 1px solid rgba(221, 221, 221, 0.74);
                padding: 5px 10px;
                overflow: hidden;
                border-radius: 15px;
                box-shadow: 5px 3px 0 1px #dddddd94;
                margin-bottom: 10px;
                cursor: pointer;
                justify-content: space-between;
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide .image-product-hush {
                width: 15%;
                background: #fff;
                padding: 5px 4px;
                max-height: 50px;
                display: flex;
                overflow: hidden;
                border-radius: 10px;
                align-items: center;
                justify-content: center;
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide .image-product-hush img {
                width: auto;
                height: 50px;
                float: right;
                transform: scale(.8);
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide .name-product-hush {
                width: 58%;
                font-size: 14px !important;
                font-weight: 500;
                line-height: 25px;
                display: flex;
                position: unset;
                font-family: iranyekanX;
                height: 25px;
                text-align: right;
                overflow: hidden;
                float: right;
                display: -webkit-box;
                -webkit-box-orient: vertical;
                -webkit-line-clamp: 1;
                colro:<?php echo $settings['color-bachground-slider-product-one-one-veras-2']; ?>;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                padding-right: 2%;
            }


            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide .name-product-hush h4 {
                font-size: 13px;
                line-height: 25px;
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide .sale-product-hush {
                width: 10%;
                float: left;
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide .sale-product-hush span {
                float: right;
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide .sale-product-hush span #saving_total_price {
                padding: 3px 7px 1px;
                display: flex;
                align-items: center;
                justify-content: center;
                color: #222;
                text-align: center;
                font-size: 15px;
                line-height: 23px;
                border: 2px dashed #222;
                box-shadow: 0 0 0 4px #ffffff47;
                border-radius: 8px 8px 8px 3px;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }

            .hush-product-slider .mySwiper-product-2 .swiper-button-next {
                color: var(--main-color3);
            }

            .hush-product-slider .mySwiper-product-2 .swiper-button-prev {
                color: var(--main-color3);
            }

            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide-thumb-active {
                background-color: <?php echo $settings['color-bachground-slider-product-one-one-veras-3']; ?> !important;
                color: #fff !important;
                transition: all .3s ease-in-out;
                box-shadow: none;
                transform: translatex(9px);
            }
            .hush-product-slider .mySwiper-product-1 .swiper-wrapper .swiper-slide-thumb-active  #saving_total_price {
                color: #FFFFFF !important;
                border-color: #FFFFFF !important;
                box-shadow: 0 0 0 4px #ffffff47 !important;
            }

            .hush-product-slider .mySwiper-product-2 .pushable {
                background: <?php echo $settings['color-bachground-slider-product-one-one-veras-9']; ?>;
                border-radius: 12px;
                border: none;
                padding: 0;
                cursor: pointer;
                outline-offset: 4px;
            }

            .hush-product-slider .mySwiper-product-2 .front {
                display: block;
                padding: 12px 12px;
                border-radius: 12px;
                font-size: 14px;
                background:  <?php echo $settings['color-bachground-slider-product-one-one-veras-8']; ?>;
                width: max-content;
                color:  <?php echo $settings['color-bachground-slider-product-one-one-veras-10']; ?>;;
                transform: translateY(-6px);
                font-family: digikala;
                text-decoration: none !important;
            }
            .hush-product-slider .mySwiper-product-2 .pushable:active .front {
                transform: translateY(-2px);
            }

            .hush-product-slider .mySwiper-product-2 .swiper-slide-item-1 {
                width: 40%;
                float: right;
            }

            .hush-product-slider .mySwiper-product-2 .swiper-slide-item-2 {
                width: 60%;
                float: right;
                text-align: right;
            }

            .hush-product-slider .mySwiper-product-2 .image-product-hush-2 {
                width: 100%;
                float: right;
                padding-right: 15px;
                max-width: 100%;
                height: 400px;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .hush-product-slider .mySwiper-product-2 .image-product-hush-2 img {
                max-width: 90%;
                height: auto;
                width: auto;
                max-height: 100%;
                border-radius: 10px;
            }

            .hush-product-slider .mySwiper-product-2 .name-product-hush-2 {
                width: 100%;
                padding: 15px 0;
                color: <?php echo $settings['color-bachground-slider-product-one-one-veras-1']; ?>;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }
            .hush-product-slider .mySwiper-product-2 .name-product-hush-2 .stock {
                /* position: absolute; */
                right: 5px;
                top: 5px;
                background: #494846;
                z-index: 1;
                color: #ffffff;
                font-size: 10px;
                width: fit-content;
                padding: 0 10px;
                line-height: 2;
                border-radius: 20px;
                box-shadow: 0 0 0 3px #04030338;
                margin-bottom: 6px;
            }

            .hush-product-slider .mySwiper-product-2 .name-product-hush-2 h3 {
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }

            .hush-product-slider .mySwiper-product-2 .rating-product-hush-2 {
                padding-bottom: 10px;
            }
            .hush-product-slider .mySwiper-product-2 .rating-product-hush-2 table tr{
                display: flex;
                width: 100%;
                align-items: center;
                justify-content: right;
                padding: 5px 0;
                font-weight: 500;
                font-size: 12px;
            }
            .hush-product-slider .mySwiper-product-2 .rating-product-hush-2 table tr th {
                padding-left: 5px;
                font-weight: 500;
            }
            .hush-product-slider .mySwiper-product-2 .rating-product-hush-2 table tr th:after {
                content: ":";
                padding: 0 2px;
            }
            .hush-product-slider .mySwiper-product-2 .rating-product-hush-2 table tr td {

            }

            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 {
                padding: 10px 0 20px;
                float: right;
                width: 100%;
                display: flex;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                flex-wrap: wrap;
            }
            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 #saving_total_price {
                background: <?php echo $settings['color-bachground-slider-product-one-one-veras-6']; ?>;
                width: fit-content;
                padding: 6px 7px 5px;
                color:  <?php echo $settings['color-bachground-slider-product-one-one-veras-7']; ?>;
                line-height: 1;
                border-radius: 0 10px 10px 10px;
                font-size: 15px !important;
                height: fit-content;
                order: 1;
                display: flex;
                align-items: center;
                margin-rigth: 34px !important;
                margin: 0 10px;
            }

            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 .woocommerce-Price-currencySymbol {
                padding-right:3px
            }
            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 .woocommerce-Price-currencySymbol:after {
                content:var(--main-content);
            }
            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 del {
                color: #919191;
                padding: 5px 0;
                font-size: 15px;
                text-decoration: none;
                position: relative;
                width: fit-content;
            }
            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 del:before {
                content: "";
                position: absolute;
                height: 1px;
                width: 100%;
                top: 45%;
                transform: rotate(-8deg);
                background: #222222a6;
            }

            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 ins {
                text-decoration: none;
                color: <?php echo $settings['color-bachground-slider-product-one-one-veras-4']; ?>;
                font-size: 25px;
                width: 100%;
                order: 2;
            }
            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 .price-vera_start_p bdi {
                color: <?php echo $settings['color-bachground-slider-product-one-one-veras-5']; ?>;
            }
            .hush-product-slider .mySwiper-product-2 .price-product-hush-2 > .woocommerce-Price-amount bdi  {
                color: <?php echo $settings['color-bachground-slider-product-one-one-veras-5']; ?>;
            }
            .hush-product-slider .mySwiper-product-2 .button-add-cart-hush-2 {
                width: 49%;
                float: right;
                margin-top: 10px;
                display: flex;
                align-items: center;
                justify-content: right;
            }
            .hush-product-slider .mySwiper-product-2 .button-add-cart-hush-2 .like-containers {
                width: fit-content;
                margin-right: 15px;
            }

            .hush-product-slider .mySwiper-product-2 .timer-js-hush-2 {
                width: 49%;
                float: left;
            }

            .hush-product-slider .countdown-timer {
                font-size: 20px;
                float: right;
                -moz-font-feature-settings: "ss04" !important;
                -webkit-font-feature-settings: "ss04" !important;
                font-feature-settings: "ss04" !important;
            }

            .hush-product-slider .timer-section {
                float: right;
                display: grid;
                text-align: center;
                font-size: 13px;
                padding: 6px 18px;
                background: var(--main-color);
                margin: 0 3px;
                border-radius: 10px;
                color: #fff;
                font-family: digikala;
            }

            .hush-product-slider .timer-value {
                font-weight: bold;
                font-size: 18px;
                font-family: IRANYekanX;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }


            /*end code slider hash product*/

        </style>
        <script>
            $(function () {

                /*start sliders code java script hush product*/
                var swiper = new Swiper(".mySwiper-product-1", {
                    spaceBetween: 0,
                    slidesPerView: 4,
                    freeMode: true,
                    direction: "vertical",
                    watchSlidesProgress: true,
                    scrollbar: {
                        el: ".swiper-scrollbar",
                    },
                    mousewheel: true,
                });
                var swiper2 = new Swiper(".mySwiper-product-2", {
                    <?php if ($settings['show_loop-controle-slider-pro1']) { ?>
                    loop: true,
                    <?php  } ?>
                    <?php if ($settings['show_autoplay-controle-slider-pro1']) { ?>
                    autoplay: {
                        delay: <?php echo $settings['fast-slider-pro-autoplay-Timeout1']; ?>,
                        disableOnInteraction: true,
                    },
                    <?php } ?>
                    effect:"fade",
                    spaceBetween: 0,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    thumbs: {
                        swiper: swiper,
                    },
                });
                /*end sliders code java script hush product*/

            })
        </script>

        <div class="container">
            <div class="hush-product-sliders">
                <div class="name-sections-slider-hush">
                    <h3>
                        <?php echo $settings['text-img-one6566526465165']; ?>
                    </h3>
                </div>
                <div class="hush-product-slider">
                    <div style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff"
                         class="swiper mySwiper-product-2">
                        <div class="swiper-wrapper">
                            <?php
                            $pro = new WP_Query(array(
                                'post_type' => 'product',
                                  'post__in' => $settings['list_id_category_product'],
                            ));
                            if ($pro->have_posts()) {
                                while ($pro->have_posts()) : $pro->the_post(); ?>

                                    <div class="swiper-slide">
                                        <div class="swiper-slide-item-1">
                                            <a href="<?php echo get_post_permalink(); ?>"  class="image-product-hush-2">
                                                <?php
                                                the_post_thumbnail();
                                                ?>
                                            </a>
                                        </div>
                                        <div class="swiper-slide-item-2">

                                            <div class="name-product-hush-2">
                                                <?php
                                                global $product;
                                                if (!$product->is_in_stock()) {
                                                    echo '<p class="stock">ناموجود</p>';
                                                } ?>
                                                <a style="text-decoration:none;color:unset" href="<?php echo get_post_permalink(); ?>" >
                                                    <?php
                                                    the_title();
                                                    ?>
                                                </a>

                                            </div>
                                            <div class="price-product-hush-2">
                                                <?php
                                                global $product;
                                                 echo simple_product_saving_percentage();
                                                echo $product->get_price_html();
                                                ?>
                                            </div>
                                            <div class="rating-product-hush-2">
                                                <?php do_action("woocommerce_product_additional_information", $product); ?>
                                            </div>
                                            <div class="button-add-cart-hush-2">
                                                <button class="pushable">
                                                    <a href="<?php echo get_post_permalink(); ?>" class="front">
                                                        هدایت به صفحه محصول
                                                    </a>
                                                </button>

                                                <?php global $product;
                                                if ($settings['show-add-to-wishlist-product-sliders-theme'] == true) {
                                                $product_id = $product->get_id(); ?>
                                                <a class="like-containers">
                                                    <span class=" like-buttons" data-product-id="<?php echo $product_id; ?>"><i class="fa-light fa-heart"></i></span>
                                                </a>
                                                <?php
                                                }
                                                ?>
                                            </div>
                                            <?php
                                            if ($settings['show-timer-product-sliders-theme'] == true) {
                                            $off_on_timer = get_post_meta(get_the_id(), 'metaboxe_product-offers', true);
                                            if ($off_on_timer == "on") {
                                                $year = get_post_meta(get_the_id(), 'month-years-select-zero', true);
                                                $month = get_post_meta(get_the_id(), 'month-years-select-one', true);
                                                $day = get_post_meta(get_the_id(), 'month-years-select-two', true);
                                                $hour = get_post_meta(get_the_id(), 'month-years-select-there', true);
                                                ?>
                                                <div class="timer-js-hush-2">
                                                    <div class="countdown-timer" data-target-year="<?php echo $year ?>" data-target-month="<?php echo $month ?>"
                                                         data-target-day="<?php echo $day ?>"
                                                         data-target-hour="<?php echo $hour ?>" data-target-minute="00" data-target-second="00">
                                                        <div style="display: flex;align-items: center" class="massages-heddin">
                                                            <div class="timer-section days-section"><span
                                                                        class="timer-value days-value"></span> روز
                                                            </div>
                                                            <div class="timer-section hours-section"><span
                                                                        class="timer-value hours-value"></span> ساعت
                                                            </div>
                                                            <div class="timer-section minutes-section"><span
                                                                        class="timer-value minutes-value"></span> دقیقه
                                                            </div>
                                                            <div class="timer-section seconds-section"><span
                                                                        class="timer-value seconds-value"></span> ثانیه
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php
                                            }
                                            }
                                            ?>
                                        </div>
                                    </div>
                                <?php
                                endwhile;
                            }
                            ?>

                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                    <div thumbsSlider="" class="swiper mySwiper-product-1">
                        <div class="swiper-wrapper">
                            <?php
                            if ($pro->have_posts()) {
                                while ($pro->have_posts()) : $pro->the_post(); ?>
                                    <div class="swiper-slide">
                                        <div class="image-product-hush">
                                            <?php
                                            the_post_thumbnail();
                                            ?>
                                        </div>
                                        <div class="name-product-hush">
                                            <?php
                                            the_title();
                                            ?>
                                        </div>
                                        <div class="sale-product-hush">
                                            <span><?php echo simple_product_saving_percentage(); ?> </span>
                                        </div>
                                    </div>
                                <?php
                                endwhile;
                            }
                            ?>
                        </div>
                        <div class="swiper-scrollbar"></div>
                    </div>

                </div>
            </div>
        </div>


        <?php
    }


    protected function content_template()
    {
    }

}