<?php

class fore_img_diak_theme_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return '4-img-diak-theme';
	}

	public function get_title() {
		return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>شبکه تصویر (4)</h2>';
	}

	public function get_icon() {
		return 'eicon-photo-library';
	}

	public function get_categories() {
		return [ 'eleman-category' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'section_content-fore-img',
			[
				'label' => esc_html__( 'شبکه تصویر 4 عضوی', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'target-a-4-image',
			[
				'label' => esc_html__( 'باز شدن لینک های تصاویر در', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'_blank' => esc_html__( 'صفحه جدید', 'textdomain' ),
					'_self' => esc_html__( 'همین صفحه', 'textdomain' ),
				],

			]
		);
		$this->add_control(
			'image-item-one',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر اول', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-one',
			[
				'label' => 'لینک تصویر اول',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);
		$this->add_control(
			'image-item-two',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر دوم', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-two',
			[
				'label' => 'لینک تصویر دوم',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);
		$this->add_control(
			'image-item-there',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر سوم', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-there',
			[
				'label' => 'لینک تصویر سوم',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);
		$this->add_control(
			'image-item-fore',
			[
				'label' => esc_html__( 'انتخاب یا آپلود تصویر چهارم', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link-img-fore',
			[
				'label' => 'لینک تصویر چهارم',
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://site.com/shop', 'textdomain' ),
				'options' => [ 'url' ],
				'label_block' => true,
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'استایل های تصاویر', 'textdomain' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'number-border-radios-image',
			[
				'label' => esc_html__( 'منحنی گوشه های تصاویر', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 10,
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		?>
		<style>
            /*start 4 item  image figory*/
            .img-4-item-images-site {
                display: flex;
                align-items: center;
                justify-content: center;
                width: 100%;
                float: right;
                padding: 10px 0;
            }

            .img-4-item-images-site figure {
                display: flex;
                align-items: center;
                justify-content: space-between;
            }

            .img-4-item-images-site figure a {
                width: 24%;
                margin: 0.25%;
            }
            .img-4-item-images-site figure img {
                width: 100%;
                border-radius: <?php echo $settings['number-border-radios-image']."px"; ?> !important;
                height: auto;
            }

            @media screen and (max-width: 1000px) {
                .img-4-item-images-site figure {
                    flex-wrap: wrap !important;
                }

                .img-4-item-images-site figure a {
                    width: 49%;
                    margin: 0;
                    margin-bottom: 5px;
                }
                .img-4-item-images-site figure a img {
                    width: 100%;
                }
            }

            /*end 4 item  image figory*/

        </style>


        <div class="container">
            <div class=" img-4-item-images-site">
                <figure>
                    <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-one']['url']; ?>">
                            <img src="<?php echo $settings['image-item-one']['url']; ?>">
                    </a>
                    <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-two']['url']; ?>">
                            <img src="<?php echo $settings['image-item-two']['url']; ?>">
                    </a>
                    <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-there']['url']; ?>">
                            <img src="<?php echo $settings['image-item-there']['url']; ?>">
                    </a>
                    <a target="<?php echo $settings['target-a-4-image']; ?>" href="<?php echo $settings['link-img-fore']['url']; ?>">
                            <img src="<?php echo $settings['image-item-fore']['url']; ?>">
                    </a>
                </figure>
            </div>
        </div>

		<?php
	}


	protected function content_template() {
	}

}
