<?php

ob_start();
function add_theme_styles() {
    wp_enqueue_style("style-all",get_template_directory_uri()."/css/all.css");
    wp_enqueue_style("style-swiper",get_template_directory_uri()."/css/swiper.min.css");
    wp_enqueue_style("style-responsive",get_template_directory_uri()."/css/responsive/css.responsive.css");
    wp_enqueue_style("style-pop-op-open",get_template_directory_uri()."/inc/vera-theme/woocommerce-template/dimbox.min.css");
    wp_enqueue_style("style-alert",get_template_directory_uri()."/css/iziToast.min.css");
    wp_enqueue_style('style', get_stylesheet_uri());
}
function add_theme_scripts() {
    wp_enqueue_script('js', get_template_directory_uri() . '/js/jquery-3.7.1.min.js', array(), false, true);
    wp_enqueue_script('head-room-js', get_template_directory_uri() . '/js/headroom.js',array('jquery'), false, true);
    wp_enqueue_script('swiper-js', get_template_directory_uri() . '/js/swiper-element-bundle.min.js',array('jquery'), false, true);
    wp_enqueue_script('main-js', get_template_directory_uri() . '/js/main.js',array('jquery'), false, true);
    wp_enqueue_script('script-js', get_template_directory_uri() . '/js/script.js',array('jquery'), false, true);
    wp_enqueue_script('js-form', get_template_directory_uri() . '/vera_option/js-form-vera.js',array('jquery'), false, true);
    wp_enqueue_script('alert-js', get_template_directory_uri() . '/js/iziToast.min.js',array('jquery'), false, true);
    if( is_account_page() ) {
        wp_enqueue_script('chart', get_template_directory_uri() . '/js/chart.min.js', array('jquery'), false, true);
    }
    wp_enqueue_script('ex-like-js', get_template_directory_uri() . '/inc/vera-theme/ex-like-post/ex-like.js',array('jquery'), false, true);
    wp_enqueue_script('ex-likes-js', get_template_directory_uri() . '/inc/vera-theme/ex-like-product/ex-like.js',array('jquery'), false, true);
    if (is_singular('product')) {
        wp_enqueue_script('js-pop-op-open', get_template_directory_uri() . '/inc/vera-theme/woocommerce-template/dimbox.min.js',array('jquery'), false, true);
        wp_enqueue_script('js-3d-image', get_template_directory_uri() . '/js/js-cloudimage-360-view.min.js', array('jquery'), false, true);
    }
}
add_action('wp_enqueue_scripts','add_theme_styles');
add_action('wp_enqueue_scripts','add_theme_scripts');

function admin_theme_scripts()
{
    wp_enqueue_style("style-allss",get_template_directory_uri()."/css/all.css");
    wp_enqueue_script('conditional-cmb2', get_template_directory_uri() . '/js/cmb2-conditional-logic.js', array('jquery'), false, 'true');
}
add_action('admin_enqueue_scripts', 'admin_theme_scripts');
function custom_admin_open_sans_font() {
    echo '<link href='. get_template_directory_uri()."/font/fontiran.css" .' rel="stylesheet">' . PHP_EOL;
    include_once __DIR__."/inc/admin/admin-init.php";
}
add_action( 'admin_head', 'custom_admin_open_sans_font' );

/*فانکشن ایجاد ویجت | ابزارک قالب*/
function vera_theme_slug_widgets_init()
{
    register_sidebar(array(
        'name' => __('سایدبار کنار صفحه فروشگاه'),
        'id' => 'sidebar-product',
        'description' => __('برای شخشی سازی قسمت کناری ساید بار صفحه آرشیو و یا دسته بندی  فروشگاه خود از این قسمت میتوانید استفاده کنید'),
        'before_widget' => '<div class="sidebars-single">',
        'after_widget' => '</div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
    ));

}
add_action('widgets_init', 'vera_theme_slug_widgets_init');


/*add theme request*/
function vera_theme_setup_theme()
{
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');
    add_theme_support('dokan');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('ajax');
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 20 );

    add_image_size("size_product","","350");
    register_nav_menus(array(
            'main-menu' => __('جایگاه منو هدر اصلی'),
            'footer-menu' => __('جایگاه منو دسترسی سریع فوتر')
        )
    );

}
add_action('after_setup_theme', 'vera_theme_setup_theme');
/*add ex file jalale php*/
require_once "inc/elementor/widget-workut-elenemt.php";
/*add ex file jalale php*/
require_once "inc/jdf.php";
/*add ex wishlist single product*/
require_once "inc/vera-theme/ex-like-product/ex-like.php";
/*add ex like single post*/
require_once "inc/vera-theme/ex-like-post/ex-like.php";
/*add ex view single post*/
require_once "inc/vera-theme/ex-view-post/ex-view.php";
/*add icon nav code*/
require_once "inc/vera-theme/add-icon-nav/add-icon-nav.php";
/*add cmb2 plugin*/
require_once 'inc/vera-theme/CMB2-develop/example-functions.php';
/*add cmb2 post meta box custom*/
require_once 'inc/vera-theme/add-post-meta-box/add-post-meta-box.php';
/*add cmb2 product meta box custom*/
require_once 'inc/vera-theme/add-product-meta-box/add-product-meta-box.php';
/*add option theme*/
require_once 'inc/vera-theme/add-option/add-option.php';
/*add notification account woo*/
require_once 'inc/vera-theme/add-option/notification-panel.php';
/*add template_head*/
require_once 'inc/template/head_template.php';
/*add themeplate_footer*/
require_once 'inc/template/footer_template.php';

/*starts widgets verax*/
require_once 'inc/widget/price_widget.php';

/*add TGM-plugin*/
require_once 'inc/TGM-plugin/class-tgm-plugin-activation.php';
require_once 'inc/TGM-plugin/tgm-plugin-activation.php';
if ( ! class_exists( 'Guard_vera_theme' ) ) {
    require_once get_template_directory().'/inc/settings_theme/redux-framework-4.4.1/ReduxCore/inc/vera_lc.php';
}
/*add setting theme*/
/**********Add Redux************/
if (!class_exists('ReduxFramework') && file_exists(dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/redux-core/framework.php')) {
    require_once dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/redux-core/framework.php';
}
if (!isset($redux_remo) && file_exists(dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/sample/sample-config.php')) {
    require_once dirname(__FILE__) . '/inc/settings_theme/redux-framework-4.4.1/sample/sample-config.php';
}

add_filter( 'woocommerce_product_tabs', 'wcs_woo_remove_more_seller_product_tab', 98 );
function wcs_woo_remove_more_seller_product_tab($tabs) {
    unset($tabs['more_seller_product']);
    return $tabs;
}
// افزودن گزینه مرتب‌سازی جدید به منوی مرتب‌سازی
function custom_woocommerce_catalog_orderby( $orderby ) {
    // اضافه کردن گزینه مرتب‌سازی براساس قیمت تخفیف خورده
    $orderby['discount'] = 'مرتب‌سازی بر اساس تخفیف';
    return $orderby;
}
add_filter( 'woocommerce_catalog_orderby', 'custom_woocommerce_catalog_orderby' );

// تغییرات در کوئری محصولات برای مرتب‌سازی بر اساس تخفیف


// تغییر ترتیب پیش‌فرض فروشگاه برای مرتب‌سازی بر اساس تخفیف فقط در صفحه فروشگاه یا دسته‌بندی
function custom_woocommerce_default_catalog_orderby( $orderby ) {
    // فقط در صفحه فروشگاه یا دسته‌بندی محصولات این تغییرات را اعمال می‌کنیم
    if ( is_shop() || is_product_category() ) {
        if ( isset( $_GET['orderby'] ) && $_GET['orderby'] == 'discount' ) {
            $orderby = 'meta_value_num'; // مرتب‌سازی بر اساس مقدار عددی (برای قیمت تخفیف خورده)
        }
    }
    return $orderby;
}
add_filter( 'woocommerce_default_catalog_orderby', 'custom_woocommerce_default_catalog_orderby' );


function ReplaceDashTOSpace($char){
    $char = str_replace(array('-', '_'), ' ', $char);
    return $char;
}

function ajax_filter_products1() {

    // دریافت دسته‌بندی از درخواست
    $category_id = $_POST['cat_id'];
    $min_price = $_POST['min_price'];
    $max_price = $_POST['max_price'];

    // آماده کردن کوئری برای دریافت محصولات از دسته‌بندی
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $category_id,
            ),
            'meta_query' => array(
            array(
                'key' => '_price',
                'value' => array($min_price[1], $max_price[1]),
                'compare' => 'BETWEEN',
                'type' => 'NUMERIC',
            ),
        ),
        ),
        'meta_query' => array('relation' => 'AND'), // فیلترهای ویژگی‌ها
    );

//    print_r($_POST);
    // بررسی و افزودن فیلترهای انتخابی به کوئری
    foreach ($_POST as $key => $value) {
        if ($value == '' || $key == 'cat_id' || $key == 'action') {
            continue; // اگر فیلتر انتخاب نشده یا فیلترهای غیرمرتبط
        }

        // افزودن فیلتر ویژگی‌ها به meta_query
        $args['meta_query'][] = array(
            'key'     => 'pa_' . sanitize_text_field($key), // فیلتر بر اساس ویژگی
            'value'   => sanitize_text_field($value), // مقدار انتخاب‌شده
            'compare' => 'LIKE',
        );
    }
    // اجرای کوئری محصولات
    $products = new WP_Query($args);

    // بررسی وجود محصولات و نمایش نتایج
    if ($products->have_posts()) {
        while ($products->have_posts()) {
            $products->the_post();
            wc_get_template_part('content', 'product'); // نمایش قالب محصول ووکامرس
        }
    } else {
        echo '<p>هیچ محصولی یافت نشد.</p>';
    }

    wp_die(); // پایان درخواست AJAX
}

function ajax_filter_products() {
    // دریافت دسته‌بندی از درخواست
    $category_id = $_POST['cat_id'];

    // آماده کردن کوئری برای دریافت محصولات از دسته‌بندی
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $category_id,
            ),
        ),
    );

    // اجرای کوئری برای دریافت محصولات از دسته‌بندی
    $products = new WP_Query($args);

    // بررسی وجود محصولات
    if ($products->have_posts()) {
        $filtered_products = array(); // آرایه برای نگهداری محصولات فیلتر شده

        // حلقه برای بررسی هر محصول
        while ($products->have_posts()) {
            $products->the_post();
            $product_id = get_the_ID();

            // دریافت ویژگی‌های سریالایز شده محصول
            $attributes = get_post_meta($product_id, '_product_attributes', true);

            // متغیر برای اینکه بررسی کنیم آیا محصول با همه فیلترها تطابق دارد یا خیر
            $product_matches = true;

            // بررسی هر ویژگی در درخواست (AND)
            foreach ($_POST as $key => $value) {
                $found_match = false; // فرض کنیم که ویژگی پیدا نشده است
                if($value == '' || $key == 'cat_id' || $key == 'action' || $key == 'min_price' || $key == 'max_price' ){}else{

                    $key = ReplaceDashTOSpace($key);
                    // بررسی اینکه آیا ویژگی در ویژگی‌های محصول وجود دارد
                    foreach ($attributes as $encoded_key => $attribute) {
                        $decoded_key = ReplaceDashTOSpace(urldecode($encoded_key)); // دیکد کردن کلید از حالت URL-encoded
//                        echo $decoded_key.':'.$key.'</br>';
                        if ($decoded_key == $key) {
                            $attribute_value = $attribute['value'];

                            // بررسی تطابق ویژگی
                            if (strpos($attribute_value, $value) !== false) {
                                $found_match = true; // ویژگی پیدا شده و تطابق دارد
                                break; // به دلیل پیدا کردن تطابق، از حلقه خارج می‌شویم
                            }
                        }
                    }


                    // اگر هیچ تطابقی پیدا نشد، محصول حذف می‌شود
                    if (!$found_match) {
                        $product_matches = false;
                        break; // از حلقه خارج می‌شویم چون محصول نباید نمایش داده شود
                    }


                }
            }
            // اگر محصول با همه فیلترها تطابق داشت، به آرایه محصولات فیلتر شده اضافه می‌شود
            if ($product_matches == true) {
//                        echo $product_id.'</br>';
                $filtered_products[] = $product_id;
            }
        }
        // نمایش محصولات فیلتر شده
        if ($products->have_posts()) {
            // حلقه برای بررسی هر محصول
            while ($products->have_posts()) {
                $products->the_post();
                $product_id = get_the_ID();
                if(in_array($product_id ,$filtered_products )){
                    // دریافت اطلاعات محصول
                    $product = wc_get_product($product_id);
                    $product_link = get_permalink($product_id);
                    $product_title = get_the_title($product_id);
                    $product_price = $product->get_price_html(); // دریافت قیمت به فرمت HTML
                    $product_thumbnail = get_the_post_thumbnail_url($product_id, 'full'); // تصویر محصول

                    // فرض می‌کنیم محصول چند تصویر دارد و به آنها دسترسی داریم
                    $gallery_image_ids = $product->get_gallery_image_ids(); // دریافت گالری تصاویر
                    $gallery_image_2 = !empty($gallery_image_ids) ? wp_get_attachment_image_url($gallery_image_ids[0], 'full') : '';

                    // HTML سفارشی برای نمایش محصول
                    echo '<li class="product type-product post-' . esc_attr($product_id) . ' status-publish instock product_cat-'. esc_attr($category_id) .' has-post-thumbnail shipping-taxable purchasable product-type-variable">';
                    echo '  <a href="' . esc_url($product_link) . '" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">';
                    echo '    <div class="image-product">';
                    echo '      <figure>';
                    echo '        <span class="loading_imagesss"></span>';
                    echo '        <img class="img-product-sliders-1" src="' . esc_url($product_thumbnail) . '" />';
                    if (!empty($gallery_image_2)) {
                        echo '        <img class="img-product-sliders-2" src="' . esc_url($gallery_image_2) . '" />';
                    }
                    echo '      </figure>';
                    echo '    </div>';
                    echo '  </a>';
                    echo '  <div class="columnd-1-set">';
                    echo '    <a href="' . esc_url($product_link) . '" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">';
                    echo '    </a>';
                    echo '    <div class="category-one-list">';
                    echo '    </div>';
                    echo '    <a href="' . esc_url($product_link) . '">';
                    echo '      <h2 class="woocommerce-loop-product__title">' . esc_html($product_title) . '</h2>';
                    echo '    </a>';
                    echo '    <div class="price-product-woo">' . $product_price . '</div>';
                    echo '    <div class="button-add_cart_ex">';
                    echo '      <a href="' . esc_url($product_link) . '" class="button product_type_variable add_to_cart_button">انتخاب گزینه‌ها</a>';
                    echo '      <div class="like-containers">';
                    echo '        <a class="like-buttons" data-product-id="' . esc_attr($product_id) . '"><i class="fa-light fa-heart"></i></a>';
                    echo '      </div>';
                    echo '    </div>';
                    echo '  </div>';
                    echo '</li>';
                }
            }

            wp_reset_postdata(); // ریست کردن داده‌ها پس از حلقه
        } else {
            echo '<p>هیچ محصولی یافت نشد.</p>';
        }


        wp_reset_postdata(); // ریست کردن داده‌ها پس از حلقه
    } else {
        echo '<p>هیچ محصولی یافت نشد.</p>';
    }

    wp_die();
}




// ثبت اکشن‌های ایجکس
add_action('wp_ajax_ajax_filter_products', 'ajax_filter_products');
add_action('wp_ajax_nopriv_ajax_filter_products', 'ajax_filter_products');


function get_min_max_price_in_category($category_id) {
    global $wpdb;

    // کوئری برای دریافت کمترین و بیشترین قیمت محصولات در یک دسته‌بندی خاص
    $prices = $wpdb->get_row("
        SELECT MIN(CAST(meta_value AS UNSIGNED)) AS min_price, MAX(CAST(meta_value AS UNSIGNED)) AS max_price
        FROM {$wpdb->postmeta} pm
        INNER JOIN {$wpdb->term_relationships} tr ON pm.post_id = tr.object_id
        INNER JOIN {$wpdb->term_taxonomy} tt ON tr.term_taxonomy_id = tt.term_taxonomy_id
        WHERE tt.term_id = {$category_id}
        AND tt.taxonomy = 'product_cat'
        AND pm.meta_key = '_price'
        AND pm.meta_value > 0
    ");

    return $prices;
}






function enqueue_owl_carousel() {
    // بارگذاری فایل‌های CSS برای Owl Carousel
    wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/css/owl.carousel.min.css');
    wp_enqueue_style('owl-theme', get_template_directory_uri() . '/css/owl.theme.default.min.css');

    // بارگذاری فایل‌های JS برای Owl Carousel
    wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), '2.3.4', true);
    wp_enqueue_script('owl-carousel_script', get_template_directory_uri() . '/js/carosuel.js', array('jquery'), '2.3.4', true);
}
add_action('wp_enqueue_scripts', 'enqueue_owl_carousel');




add_filter('woocommerce_product_get_image', 'remove_prefix_from_product_images', 10, 2);
add_filter('woocommerce_gallery_image_html_attachment_image_params', 'remove_prefix_from_gallery_images', 10, 3);

function remove_prefix_from_product_images($image, $product) {
    $prefix = 'https://kharidstore.com/wp-content/uploads/';
    if (strpos($image, $prefix) === 0) {
        $image = str_replace($prefix, '', $image);
    }
    return $image;
}

function hdm_remove_image_query_string( $url ) {
    // فقط بخش اصلی آدرس را نگه می‌داریم و کوئری را حذف می‌کنیم
    $parsed_url = explode('?', $url);
    return $parsed_url[0];
}

// فیلتر برای URL تصویر شاخص، گالری و غیره
add_filter( 'wp_get_attachment_image_src', function( $image ) {
    if ( is_array( $image ) && isset( $image[0] ) ) {
        $image[0] = hdm_remove_image_query_string( $image[0] );
    }
    return $image;
});
// فیلتر برای محتوای پست‌ها (تصاویر داخل محتوا)
add_filter( 'the_content', function( $content ) {
    return preg_replace_callback( '/<img[^>]+src="([^"]+)"[^>]*>/i', function( $matches ) {
        $clean_src = preg_replace('/\?.*/', '', $matches[1]);
        return str_replace($matches[1], $clean_src, $matches[0]);
    }, $content );
});





// تنظیم حداقل قیمت فیلتر WOoF به عددی بالای صفر
function set_min_price_for_woof_filter( $args ) {
    // تعیین حداقل قیمت دلخواه (مثلاً 1 تومان)
    $min_price = 1;
    // بررسی اینکه آیا min_price در آرگومان‌ها وجود دارد و کمتر از حداقل تعیین‌شده است
    if ( isset( $args['min_price'] ) && $args['min_price'] < $min_price ) {
        $args['min_price'] = $min_price;
    }
    return $args;
}
add_filter( 'woof_get_price_filter', 'set_min_price_for_woof_filter' );


function update_homepage_latest_product_ids() {
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 10,
        'post_status'    => 'publish',
        'meta_query'     => array(
            "relation" => "AND",
            array(
                'key' => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ),
        ),
        'orderby'        => 'date',
        'order'          => 'DESC'
    );

    $query = new WP_Query($args);
    $product_ids = wp_list_pluck($query->posts, 'ID');
    $count_uopdate = get_option('homepage_latest_product_count');
    if($count_uopdate == ""){$count_uopdate = 0;}
    $count_uopdate+= 1;
    update_option('homepage_latest_product', $product_ids);
    update_option('homepage_latest_product_count', $count_uopdate);
}

function update_homepage_best_selling_product_ids() {
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 10,
        'post_status'    => 'publish',
        'meta_query'     => array(
            'relation' => 'AND',
            array(
                'key' => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ),
        ),
        'meta_key'       => 'total_sales',
        'orderby'        => 'meta_value_num',
        'order'          => 'DESC'
    );

    $query = new WP_Query($args);
    $product_ids = wp_list_pluck($query->posts, 'ID');

    $count_update = get_option('homepage_best_selling_product_count');
    if ($count_update == "") {
        $count_update = 0;
    }
    $count_update += 1;

    update_option('homepage_best_selling_product', $product_ids);
    update_option('homepage_best_selling_product_count', $count_update);
}

function update_homepage_smartwatch_product_ids() {
    // بررسی نهایی وجود ووکامرس
    if (!function_exists('wc_get_products')) {
        error_log('Woocommerce not loaded!');
        return;
    }

    // بررسی وجود taxonomy
    if (!taxonomy_exists('product_cat')) {
        error_log('Attempting to register product_cat...');
        WC_Post_Types::register_taxonomies(); // ثبت دستی taxonomyها

        if (!taxonomy_exists('product_cat')) {
            error_log('Fatal: product_cat still not exists!');
            return;
        }
    }

    $term_id = 1561;
    $term = get_term($term_id, 'product_cat');

    if (!$term || is_wp_error($term)) {
        error_log("Category {$term_id} not found!");
        return;
    }

    // اجرای کوئری اصلی
    $query = new WP_Query([
        'post_type'      => 'product',
        'posts_per_page' => 10,
        'post_status'    => 'publish',
        'meta_query'     => [
            'relation' => 'AND',
            [
                'key'     => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ]

        ],
        'tax_query' => [
            [
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $term_id,
            ]
        ],
        'orderby' => 'date',
        'order'   => 'DESC'
    ]);

    if ($query->have_posts()) {
        $product_ids = wp_list_pluck($query->posts, 'ID');
        print_r($product_ids);
        update_option('homepage_smartwatch_products', $product_ids);

        // آپدیت شمارنده
        $count = (int) get_option('homepage_smartwatch_products_count', 0);
        update_option('homepage_smartwatch_products_count', $count + 1);

        error_log('Successfully updated products: ' . print_r($product_ids, true));
        return $product_ids;
    }

    error_log('No products found in category ' . $term_id);
    return false;
}

// 5. تابع اصلی برای اسباب‌بازی
function update_homepage_toys_product_ids() {
    // بررسی وجود ووکامرس
    if (!function_exists('wc_get_products')) {
        error_log('Woocommerce not loaded for toys!');
        return;
    }

    // بررسی taxonomy
    if (!taxonomy_exists('product_cat')) {
        WC_Post_Types::register_taxonomies();
    }

    $term_id = 1625;
    $term = get_term($term_id, 'product_cat');

    if (!$term || is_wp_error($term)) {
        error_log("Toys category {$term_id} not found!");
        return;
    }

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 10,
        'post_status'    => 'publish',
        'meta_query'     => array(
            'relation' => 'AND',
            array(
                'key' => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ),
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $term_id,
            )
        ),
        'orderby' => 'date',
        'order'   => 'DESC'
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $product_ids = wp_list_pluck($query->posts, 'ID');
        update_option('homepage_toys_products', $product_ids);

        $count = (int) get_option('homepage_toys_products_count', 0);
        update_option('homepage_toys_products_count', $count + 1);

        error_log('Toys products updated: ' . print_r($product_ids, true));
        return $product_ids;
    }

    error_log('No toys products found in category ' . $term_id);
    return false;
}

function update_homepage_headphones_product_ids() {
    // بررسی وجود ووکامرس
    if (!function_exists('wc_get_products')) {
        error_log('Woocommerce not loaded for headphones!');
        return;
    }

    // بررسی taxonomy
    if (!taxonomy_exists('product_cat')) {
        WC_Post_Types::register_taxonomies();
    }

    $term_id = 1535;
    $term = get_term($term_id, 'product_cat');

    if (!$term || is_wp_error($term)) {
        error_log("Headphones category {$term_id} not found!");
        return;
    }

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 10,
        'post_status'    => 'publish',
        'meta_query'     => array(
            'relation' => 'AND',
            array(
                'key' => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ),
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $term_id,
            )
        ),
        'orderby' => 'date',
        'order'   => 'DESC'
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $product_ids = wp_list_pluck($query->posts, 'ID');
        update_option('homepage_headphones_products', $product_ids);

        $count = (int) get_option('homepage_headphones_products_count', 0);
        update_option('homepage_headphones_products_count', $count + 1);

        error_log('Headphones products updated: ' . print_r($product_ids, true));
        return $product_ids;
    }

    error_log('No headphones products found in category ' . $term_id);
    return false;
}

// 5. تابع اصلی برای دستگاه‌های بازی
function update_homepage_gaming_devices_product_ids() {
    // بررسی وجود ووکامرس
    if (!function_exists('wc_get_products')) {
        error_log('Woocommerce not loaded for gaming devices!');
        return;
    }

    // بررسی taxonomy
    if (!taxonomy_exists('product_cat')) {
        WC_Post_Types::register_taxonomies();
    }

    $term_id = 1565;
    $term = get_term($term_id, 'product_cat');

    if (!$term || is_wp_error($term)) {
        error_log("Gaming devices category {$term_id} not found!");
        return;
    }

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 10,
        'post_status'    => 'publish',
        'meta_query'     => array(
            'relation' => 'AND',
            array(
                'key' => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ),
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $term_id,
            )
        ),
        'orderby' => 'date',
        'order'   => 'DESC'
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $product_ids = wp_list_pluck($query->posts, 'ID');
        update_option('homepage_gaming_devices_products', $product_ids);

        $count = (int) get_option('homepage_gaming_devices_products_count', 0);
        update_option('homepage_gaming_devices_products_count', $count + 1);

        error_log('Gaming devices products updated: ' . print_r($product_ids, true));
        return $product_ids;
    }

    error_log('No gaming devices products found in category ' . $term_id);
    return false;
}

// 5. تابع اصلی برای تجهیزات گیمینگ (چند دسته‌بندی)
function update_homepage_gaming_equipment_product_ids() {
    // بررسی وجود ووکامرس
    if (!function_exists('wc_get_products')) {
        error_log('Woocommerce not loaded for gaming equipment!');
        return;
    }

    // بررسی taxonomy
    if (!taxonomy_exists('product_cat')) {
        WC_Post_Types::register_taxonomies();
    }

    $term_ids = array(1601, 1607, 1609, 1610, 1602, 1606, 1605, 1604, 1603, 1608);

    // بررسی وجود دسته‌بندی‌ها
    foreach ($term_ids as $term_id) {
        $term = get_term($term_id, 'product_cat');
        if (!$term || is_wp_error($term)) {
            error_log("Gaming equipment category {$term_id} not found!");
            return;
        }
    }

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 20, // تعداد بیشتر برای پوشش همه دسته‌بندی‌ها
        'post_status'    => 'publish',
        'meta_query'     => array(
            'relation' => 'AND',
            array(
                'key' => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ),
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $term_ids,
                'operator' => 'IN'
            )
        ),
        'orderby' => 'date',
        'order'   => 'DESC'
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $product_ids = wp_list_pluck($query->posts, 'ID');
        update_option('homepage_gaming_equipment_products', $product_ids);

        $count = (int) get_option('homepage_gaming_equipment_products_count', 0);
        update_option('homepage_gaming_equipment_products_count', $count + 1);

        error_log('Gaming equipment products updated: ' . print_r($product_ids, true));
        return $product_ids;
    }

    error_log('No gaming equipment products found in categories: ' . implode(', ', $term_ids));
    return false;
}
function update_homepage_smart_gadgets_product_ids() {
    // بررسی وجود ووکامرس
    if (!function_exists('wc_get_products')) {
        error_log('Woocommerce not loaded for smart gadgets!');
        return;
    }

    // بررسی taxonomy
    if (!taxonomy_exists('product_cat')) {
        WC_Post_Types::register_taxonomies();
    }

    $term_ids = array(1566, 1539, 1603); // دسته‌بندی‌های گجت هوشمند

    // بررسی وجود دسته‌بندی‌ها
    foreach ($term_ids as $term_id) {
        $term = get_term($term_id, 'product_cat');
        if (!$term || is_wp_error($term)) {
            error_log("Smart gadgets category {$term_id} not found!");
            continue; // ادامه بررسی سایر دسته‌بندی‌ها حتی اگر یکی وجود نداشت
        }
    }

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 15, // تعداد مناسب برای پوشش همه دسته‌بندی‌ها
        'post_status'    => 'publish',
        'meta_query'     => array(
            'relation' => 'AND',
            array(
                'key' => 'b_price_update_stock_checker_circle',
                'value' => 1,
                'compare' => '='
            ),
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $term_ids,
                'operator' => 'IN'
            )
        ),
        'orderby' => 'date',
        'order'   => 'DESC'
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $product_ids = wp_list_pluck($query->posts, 'ID');
        update_option('homepage_smart_gadgets_products', $product_ids);

        $count = (int) get_option('homepage_smart_gadgets_products_count', 0);
        update_option('homepage_smart_gadgets_products_count', $count + 1);

        error_log('Smart gadgets products updated: ' . print_r($product_ids, true));
        return $product_ids;
    }

    error_log('No smart gadgets products found in categories: ' . implode(', ', $term_ids));
    return false;
}

function LoadProductWithNewTemplate($post_IDS,$title){
    if($post_IDS == ''){
        $return = '';
    }else{
    if(isset($_GET['show'])){
        $display = '';
    }else{
        $display = ';';
    }
    $return = '
    <div class="Products_list_New_template" style="display:'.$display.';">
        <div class="container">
        <div class="title_section">'.$title.'</div>
        <div class="list_of_products_items owl-carousel owl-theme owl_list_of_product_carousel">
    ';

    foreach($post_IDS as $item_id){

        // نام محصول
        $title = get_the_title($item_id);

        // لینک محصول
        $link = get_permalink($item_id);

        // تصویر شاخص محصول
        $thumbnail = get_the_post_thumbnail($item_id, 'medium'); // یا 'woocommerce_thumbnail'

        // دسته‌بندی‌های محصول
        $terms = get_the_terms($item_id, 'product_cat');
        $categories = '';
        if (!is_wp_error($terms) && !empty($terms)) {
            $cat_names = wp_list_pluck($terms, 'name');
            $categories = implode(', ', $cat_names);
        }
//        $product = wc_get_product($item_id);
//
//        if (!$product || !is_a($product, 'WC_Product')) return;
//
//// اگر محصول ساده بود
//        if ($product->is_type('simple')) {
//            $regular_price = $product->get_regular_price();
//            $sale_price    = $product->get_sale_price();
//
//            if ($sale_price && $sale_price < $regular_price) {
//                $price_html = '<span class="sale-price">'. wc_price($sale_price) .'</span> <del class="regular-price">'. wc_price($regular_price) .'</del>';
//            } else {
//                $price_html = '<span class="regular-price">'. wc_price($regular_price) .'</span>';
//            }
//
//// اگر محصول متغیر بود
//        } elseif ($product->is_type('variable')) {
//            $available_variations = $product->get_available_variations();
//            $variation_prices = [];
//
//            foreach ($available_variations as $variation) {
//                if (isset($variation['display_price']) && $variation['display_price'] > 0) {
//                    $variation_prices[] = $variation['display_price'];
//                }
//            }
//
//            if (!empty($variation_prices)) {
//                $min_price = min($variation_prices);
//                $price_html = '<span class="from-price">از '. wc_price($min_price) .'</span>';
//            } else {
//                $price_html = '<span class="no-price">قیمت نامشخص</span>';
//            }
//
//// اگر نوع ناشناخته بود
//        } else {
//            $price_html = '<span class="no-price">قیمت نامشخص</span>';
//        }

        $price_html= get_post_meta($item_id,'b_price',true);
        // آیتم HTML
        $return .= '
            <div class="product_item_box" style="display:'.$display.';">
                <a href="'. esc_url($link) .'">
                    <div class="product_thumbnail">'. $thumbnail .'</div>
                    <div class="product_info">
                        <div class="product_categories">'. esc_html($categories) .'</div>
                        <div class="product_title">'. esc_html($title) .'</div>
                        <div class="box_info">
                            <div class="product_price">'. number_format($price_html) .' تومان</div>
                            <div class="add-cart-product">
                                <i class="fa-light fa-cart-circle-plus"></i>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        ';
    }

    $return .= '</div></div></div>';
    }
    return $return;
}

//LoadHomePageProduct();
function LoadHomePageProduct(){
    update_homepage_smart_gadgets_product_ids();
    update_homepage_gaming_equipment_product_ids();
    update_homepage_gaming_devices_product_ids();
    update_homepage_headphones_product_ids();
    update_homepage_toys_product_ids();
    update_homepage_smartwatch_product_ids();
    update_homepage_best_selling_product_ids();
    update_homepage_latest_product_ids();
}
add_filter('cron_schedules', function ($schedules) {
    $schedules['every_5_hours'] = array(
        'interval' => 5 * HOUR_IN_SECONDS,
        'display'  => __('Every 5 Hours')
    );
    return $schedules;
});
register_activation_hook(__FILE__, function () {
    if (!wp_next_scheduled('load_homepage_product_hook')) {
        wp_schedule_event(time(), 'every_5_hours', 'load_homepage_product_hook');
    }

    // اجرای فوری نیز در صورت نیاز:
    LoadHomePageProduct();
});
add_action('load_homepage_product_hook', 'LoadHomePageProduct');


function showProductNewTemplateShortcode($arg){
    $template = $arg["template"];
    $post_IDS = get_option($template);
    if($post_IDS == ''){
        return '';
    }else{
        return LoadProductWithNewTemplate($post_IDS,$arg["title"]);
    }
}
add_shortcode('showProductNewTemplateShortcode','showProductNewTemplateShortcode');






// Set TO Zero With Grock
function update_product_stock_status() {
    // مسیر فایل لاگ
    $log_file = WP_CONTENT_DIR . '/stock_update.log';
    $start_time = date('Y-m-d H:i:s');

    // آماده‌سازی لاگ اولیه
    $log_message = "شروع به‌روزرسانی موجودی محصولات در $start_time\n";
    file_put_contents($log_file, $log_message, FILE_APPEND);

    $args = [
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
    ];

    $products = new WP_Query($args);
    $total_products = $products->found_posts;
    $processed_products = 0;
    $outofstock_count = 0;
    $instock_count = 0;

    if ($products->have_posts()) {
        while ($products->have_posts()) {
            $products->the_post();
            $product_id = get_the_ID();
            $product = wc_get_product($product_id);

            if (!$product) {
                $log_message = "[$start_time] محصول با ID $product_id یافت نشد.\n";
                file_put_contents($log_file, $log_message, FILE_APPEND);
                continue;
            }

            $b_price_update = get_post_meta($product_id, 'b_price_update', true);

            // بررسی شرایط ناموجودی
            if (empty($b_price_update) || $b_price_update == '0') {
                $product->set_manage_stock(true);
                $product->set_stock_quantity(0);
                $product->set_stock_status('outofstock');
                $log_message = "[$start_time] محصول با ID $product_id ناموجود شد (b_price_update: $b_price_update).\n";
                $outofstock_count++;
            } else {
//                $product->set_manage_stock(true);
//                $product->set_stock_quantity(100); // مقدار پیش‌فرض برای موجودی
//                $product->set_stock_status('instock');
                $log_message = "[$start_time] محصول با ID $product_id موجود شد (b_price_update: $b_price_update).\n";
                $instock_count++;
            }

            $product->save();
            file_put_contents($log_file, $log_message, FILE_APPEND);
            $processed_products++;
        }
        wp_reset_postdata();
    } else {
        $log_message = "[$start_time] هیچ محصولی یافت نشد.\n";
        file_put_contents($log_file, $log_message, FILE_APPEND);
    }

    // گزارش نهایی
    $end_time = date('Y-m-d H:i:s');
    $summary = "پایان به‌روزرسانی در $end_time\n" .
        "تعداد کل محصولات: $total_products\n" .
        "محصولات پردازش‌شده: $processed_products\n" .
        "محصولات موجود: $instock_count\n" .
        "محصولات ناموجود: $outofstock_count\n" .
        "--------------------\n";
    file_put_contents($log_file, $summary, FILE_APPEND);
}

// اجرای تابع به‌صورت دستی یا با کرون
add_action('update_product_stock_status_cron', 'update_product_stock_status');

// ثبت کرون برای اجرای روزانه
add_action('wp', function () {
    if (!wp_next_scheduled('update_product_stock_status_cron')) {
        wp_schedule_event(time(), 'daily', 'update_product_stock_status_cron');
    }
});

// اجرای دستی برای تست
// update_product_stock_status();



//
//
//add_filter('woocommerce_is_purchasable', 'hdm_conditionally_disable_purchase', 10, 2);
//
//function hdm_conditionally_disable_purchase($purchasable, $product) {
//    $price_update   = get_post_meta($product->get_id(), 'b_price_update', true);
//    $update_circle  = get_post_meta($product->get_id(), 'b_update_circle', true);
//
//    if ((floatval($price_update) <= 0 || empty($price_update)) && intval($update_circle) !== 1) {
//        return false; // خرید غیرفعال
//    }
//
//    return $purchasable;
//}
//
//add_filter('woocommerce_get_price_html', 'hdm_hide_price_for_unpurchasable_products', 10, 2);
//
//function hdm_hide_price_for_unpurchasable_products($price, $product) {
//    $price_update   = get_post_meta($product->get_id(), 'b_price_update', true);
//    $update_circle  = get_post_meta($product->get_id(), 'b_update_circle', true);
//
//    if ((floatval($price_update) <= 0 || empty($price_update)) && intval($update_circle) !== 1) {
//        return '<span class="price not-available">ناموجود</span>';
//    }
//
//    return $price;
//}
//
//add_filter('woocommerce_loop_add_to_cart_link', 'hdm_remove_add_to_cart_button_archive', 10, 2);
//
//function hdm_remove_add_to_cart_button_archive($button, $product) {
//    $price_update   = get_post_meta($product->get_id(), 'b_price_update', true);
//    $update_circle  = get_post_meta($product->get_id(), 'b_update_circle', true);
//
//    if ((floatval($price_update) <= 0 || empty($price_update)) && intval($update_circle) !== 1) {
//        return '<span class="not-buyable">ناموجود</span>';
//    }
//
//    return $button;
//}
//
//




// OLD Sort and In stock

//
//add_filter('woocommerce_is_purchasable', 'hdm_conditionally_disable_purchase', 10, 2);
//function hdm_conditionally_disable_purchase($purchasable, $product) {
//    // اگر محصول متغیر است، از والدش بررسی کن
//    if ($product->is_type('variation')) {
//        $product_id = $product->get_parent_id();
//    } else {
//        $product_id = $product->get_id();
//    }
//
//    $price_update   = get_post_meta($product_id, 'b_price_update', true);
//    $update_circle  = get_post_meta($product_id, 'b_update_circle', true);
//
//    // چک: اگر b_price_update وجود نداشته باشه یا مقدارش <= 0 باشه
//    $invalid_price = !isset($price_update) || $price_update === '' || floatval($price_update) <= 0;
//
//    // اگر قیمت نامعتبر است یا update_circle != 1 یا محصول در انبار نیست
//    if (
//        ($invalid_price && intval($update_circle) !== 1)
//        || !wc_get_product($product_id)->is_in_stock()
//    ) {
//        return false; // دکمه خرید غیرفعال
//    }
//
//    return $purchasable;
//}
//
//
//
//add_filter('woocommerce_get_price_html', 'hdm_hide_price_for_unpurchasable_products', 10, 2);
//function hdm_hide_price_for_unpurchasable_products($price, $product) {
//    if ($product->is_type('variation')) {
//        return $price;
//    }
//
//    $price_update   = get_post_meta($product->get_id(), 'b_price_update', true);
//    $update_circle  = get_post_meta($product->get_id(), 'b_update_circle', true);
//
//    if ((floatval($price_update) <= 0 || empty($price_update)) && intval($update_circle) !== 1) {
//        return '<span class="price not-available">ناموجود</span>';
//    }
//
//    return $price;
//}
//
//add_filter('woocommerce_loop_add_to_cart_link', 'hdm_remove_add_to_cart_button_archive', 10, 2);
//function hdm_remove_add_to_cart_button_archive($button, $product) {
//    if ($product->is_type('variation')) {
//        return $button;
//    }
//
//    $price_update   = get_post_meta($product->get_id(), 'b_price_update', true);
//    $update_circle  = get_post_meta($product->get_id(), 'b_update_circle', true);
//
//    if ((floatval($price_update) <= 0 || empty($price_update)) && intval($update_circle) !== 1) {
//        return '<span class="not-buyable">ناموجود</span>';
//    }
//
//    return $button;
//}
//
//
//function custom_orderby_b_price_update($clauses) {
//    global $wpdb;
//
//    // مرتب‌سازی بر اساس b_price_update و ناموجودی
//    $clauses['orderby'] = "
//        CASE
//            -- محصولات موجود (b_price_update > 0 و update_circle = 1)
//            WHEN (
//                (SELECT CAST(meta_value AS DECIMAL(10,2)) FROM {$wpdb->postmeta} pm1
//                 WHERE pm1.post_id = {$wpdb->posts}.ID
//                 AND pm1.meta_key = 'b_price_update') > 0
//                AND (
//                    SELECT meta_value FROM {$wpdb->postmeta} pm2
//                    WHERE pm2.post_id = {$wpdb->posts}.ID
//                    AND pm2.meta_key = 'b_update_circle'
//                ) = '1'
//            ) THEN 1
//            -- محصولات ناموجود
//            ELSE 2
//        END ASC,
//        (SELECT CAST(meta_value AS DECIMAL(10,2)) FROM {$wpdb->postmeta} pm3
//         WHERE pm3.post_id = {$wpdb->posts}.ID
//         AND pm3.meta_key = 'b_price_update') DESC,
//        {$wpdb->posts}.post_title ASC
//    ";
//
//    // حذف فیلتر برای جلوگیری از تداخل
//    remove_filter('posts_clauses', 'custom_orderby_b_price_update', 1000);
//
//    return $clauses;
//}
//add_filter('posts_clauses', 'custom_orderby_b_price_update', 1000);
//
//add_action('woocommerce_product_query', 'sort_products_by_b_price_update', 999);
//function sort_products_by_b_price_update($query) {
//    // فقط در دسته‌بندی محصولات و حلقه اصلی
//    if (!is_admin() && $query->is_main_query() && is_product_category()) {
//        // تنظیم meta_query برای مرتب‌سازی
//        $meta_query = array(
//            'relation' => 'OR',
//            array(
//                'key' => 'b_price_update',
//                'compare' => 'EXISTS',
//            ),
//            array(
//                'key' => 'b_price_update',
//                'compare' => 'NOT EXISTS',
//            ),
//        );
//
//        $query->set('meta_query', $meta_query);
//
//        // مرتب‌سازی با استفاده از posts_clauses برای کنترل دقیق
//        add_filter('posts_clauses', 'custom_orderby_b_price_update', 1000);
//    }
//}


add_filter('woocommerce_is_purchasable', 'hdm_conditionally_disable_purchase', 10, 2);
function hdm_conditionally_disable_purchase($purchasable, $product) {
    if ($product->is_type('variation')) {
        $product_id = $product->get_parent_id();
    } else {
        $product_id = $product->get_id();
    }

    $price_update = get_post_meta($product_id, 'b_price_update', true);
    $update_circle = get_post_meta($product_id, 'b_update_circle', true);
    $stock_checker_circle = get_post_meta($product_id, 'b_price_update_stock_checker_circle', true);

    $invalid_price = !isset($price_update) || $price_update === '' || floatval($price_update) <= 0;

    if (
        ($invalid_price && intval($update_circle) !== 1)
        || !wc_get_product($product_id)->is_in_stock()
        || intval($stock_checker_circle) !== 1
    ) {
        return false;
    }

    return $purchasable;
}

add_filter('woocommerce_get_price_html', 'hdm_hide_price_for_unpurchasable_products', 10, 2);
function hdm_hide_price_for_unpurchasable_products($price, $product) {
    if ($product->is_type('variation')) {
        return $price;
    }

    $product_id = $product->get_id();
    $price_update = get_post_meta($product_id, 'b_price_update', true);
    $update_circle = get_post_meta($product_id, 'b_update_circle', true);
    $stock_checker_circle = get_post_meta($product_id, 'b_price_update_stock_checker_circle', true);

    if (
        ((floatval($price_update) <= 0 || empty($price_update)) && intval($update_circle) !== 1)
        || intval($stock_checker_circle) !== 1
    ) {
        return '<span class="price not-available">ناموجود</span>';
    }

    return $price;
}

add_filter('woocommerce_loop_add_to_cart_link', 'hdm_remove_add_to_cart_button_archive', 10, 2);
function hdm_remove_add_to_cart_button_archive($button, $product) {
    if ($product->is_type('variation')) {
        return $button;
    }

    $product_id = $product->get_id();
    $price_update = get_post_meta($product_id, 'b_price_update', true);
    $update_circle = get_post_meta($product_id, 'b_update_circle', true);
    $stock_checker_circle = get_post_meta($product_id, 'b_price_update_stock_checker_circle', true);

    if (
        ((floatval($price_update) <= 0 || empty($price_update)) && intval($update_circle) !== 1)
        || intval($stock_checker_circle) !== 1
    ) {
        return '<span class="not-buyable">ناموجود</span>';
    }

    return $button;
}
function hdm_custom_product_ordering($query) {
    if (!is_admin() && $query->is_main_query() && is_product_category()) {
        add_filter('posts_join', 'hdm_join_postmeta_for_ordering');
        add_filter('posts_orderby', 'hdm_orderby_custom_logic');
    }
}
add_action('woocommerce_product_query', 'hdm_custom_product_ordering', 999);

function hdm_join_postmeta_for_ordering($join) {
    global $wpdb;

    $join .= " 
        LEFT JOIN {$wpdb->postmeta} AS pm_price_update 
            ON {$wpdb->posts}.ID = pm_price_update.post_id 
            AND pm_price_update.meta_key = 'b_price_update'

        LEFT JOIN {$wpdb->postmeta} AS pm_update_circle 
            ON {$wpdb->posts}.ID = pm_update_circle.post_id 
            AND pm_update_circle.meta_key = 'b_update_circle'

        LEFT JOIN {$wpdb->postmeta} AS pm_stock_checker 
            ON {$wpdb->posts}.ID = pm_stock_checker.post_id 
            AND pm_stock_checker.meta_key = 'b_price_update_stock_checker_circle'
    ";

    return $join;
}

function hdm_orderby_custom_logic($orderby) {
    global $wpdb;

    $orderby = "
        CASE 
            WHEN 
                CAST(pm_price_update.meta_value AS DECIMAL(10,2)) > 0 
                AND pm_update_circle.meta_value = '1' 
                AND pm_stock_checker.meta_value = '1'
            THEN 0
            ELSE 1
        END ASC,
        CAST(pm_price_update.meta_value AS DECIMAL(10,2)) DESC,
        {$wpdb->posts}.post_title ASC
    ";

    return $orderby;
}





add_action('admin_bar_menu', 'hdm_add_product_url_to_admin_bar', 100);

function hdm_add_product_url_to_admin_bar($wp_admin_bar) {
    if (!is_admin() && is_product() && current_user_can('administrator') && is_user_logged_in()) {
        global $post;

        if (!$post || $post->post_type !== 'product') {
            return;
        }

        $product_url = get_post_meta($post->ID, 'b_product_url', true);
        $b_price_update_test = get_post_meta($post->ID, 'b_price_update_stock_checker_circle', true);

        if (!empty($product_url)) {
            $wp_admin_bar->add_node(array(
                'id'    => 'hdm_product_url',
                'title' => 'لینک محصول (کرال)' . '---'.$b_price_update_test,
                'href'  => esc_url($product_url),
                'meta'  => array(
                    'target' => '_blank',
                    'title'  => 'مشاهده لینک کرال‌شده -- ',
                ),
            ));
        }
    }
}




// Run Variation Checker




function LoadProductEXIST(){

    $args = [
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        "meta_query" => array(
            "relation" => "AND",
            array(
                "key" => "b_price_update",
                "value" => "0",
                "compare" => "!="
            ),
            array(
                "key" => "b_variations",
                "compare" => "EXISTS"
            )
        )
    ];

    $products = get_posts($args);

    echo '<table border="1" width="100%">
                <tr>
                    <td>#</td>
                    <td>ID</td>
                    <td>نام محصول</td>
                    <td>لینک محصول</td>
                    <td>لینک بروز کالا</td>
                </tr>
                ' ;
    $i=0;
    foreach($products as $item){
        hdm_refresh_variations_cron($item->ID);
        $i++;
        echo '
            <tr>
                <td>'.$i.'</td>
                <td>'.$item->ID.'</td>
                <td>'.$item->post_title.'</td>
                <td><a href="'.get_the_permalink($item->ID).'">خرید استور</a> </td>
                <td><a href="'.get_post_meta($item->ID,"b_product_url",true).'">به روز کالا</a> </td>
            </tr>
        ';
    }
    echo '</table>';

}

if(isset($_GET["ShowProductExist"])){
    LoadProductEXIST();
    die();
}



add_action('wp_enqueue_scripts', function () {
    if (is_checkout()) {
        wp_enqueue_script('hdm-checkout-login-redirect', get_stylesheet_directory_uri() . '/checkout-login.js', ['jquery'], null, true);

        wp_localize_script('hdm-checkout-login-redirect', 'hdm_checkout_data', array(
            'is_user_logged_in' => is_user_logged_in() ? '1' : '0',
        ));
    }
});


add_filter('wc_order_statuses', 'custom_order_status_name');
function custom_order_status_name($statuses) {
    $statuses['wc-on-hold'] = 'در حال آماده سازی';
    return $statuses;
}


add_filter('woocommerce_reports_order_statuses', 'custom_order_status_filter_name');
function custom_order_status_filter_name($statuses) {
    $key = array_search('on-hold', $statuses);
    if ($key !== false) {
        $statuses[$key] = 'در حال آماده سازی';
    }
    return $statuses;
}



// add_filter('bulk_actions-edit-shop_order', 'custom_bulk_actions_status_name');
// function custom_bulk_actions_status_name($actions) {
//     if (isset($actions['mark_pending'])) {
//         $actions['mark_pending'] = 'در حال آماده سازی';
//     }
//     return $actions;
// }

add_filter('woocommerce_admin_order_statuses', 'custom_admin_order_status_tab_name');
function custom_admin_order_status_tab_name($statuses) {
    if (isset($statuses['wc-on-hold'])) {
        $statuses['wc-on-hold']['label'] = 'در حال آماده سازی';
    }
    return $statuses;
}

add_filter('views_edit-shop_order', 'custom_order_status_tab_name');
function custom_order_status_tab_name($views) {
    if (isset($views['wc-on-hold'])) {
        $views['wc-on-hold'] = str_replace('در انتظار بررسی', 'در حال آماده سازی', $views['wc-on-hold']);
    }
    return $views;
}


add_action('woocommerce_after_single_product_summary', 'hdm_show_product_b_information_inner', 15);

function hdm_show_product_b_information_inner() {
    global $post;

    // فقط برای نوع پست محصول
    if ('product' !== $post->post_type) {
        return;
    }

    // مقدار متای b_information_inner
    $technical_specs = get_post_meta($post->ID, 'b_information_inner', true);
    $b_description = get_post_meta($post->ID, 'b_description', true);


        echo '<ul class="custom_tab">
            <li id="custom_information" class="active">مشخصات فنی</li>
            <li id="custom_description">توضیحات</li>
        </ul>';

        echo '<div class="custom_information div_of_tab_custom active" >';
        echo '<h2 style="margin-bottom:10px;">مشخصات فنی</h2>';
        echo wpautop(wp_kses_post($technical_specs));
        echo '</div>';
        echo '<div class="custom_information div_of_tab_custom" >';
        echo '<h2 style="margin-bottom:10px;">توضیحات</h2>';
        echo wpautop(wp_kses_post($b_description));
        echo '</div>';

}

function my_get_order_shipping_method_names( $order_id ) {
    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return false;
    }

    $items   = $order->get_items( 'shipping' );
    $methods = array();

    foreach ( $items as $item ) {
        $methods[] = $item->get_method_title(); // مثل «پیک موتوری»
    }

    return empty( $methods ) ? false : implode( ', ', $methods );
}


add_filter( 'woocommerce_get_related_product_ids', 'my_keep_only_price_updated_ids', 10, 3 );

function my_keep_only_price_updated_ids( $related_ids, $product_id, $args ) {

    // فیلترکردن با array_filter
    $related_ids = array_values( array_filter( $related_ids, function ( $pid ) {
        $val = get_post_meta( $pid, 'b_price_update', true );
        return is_numeric( $val ) && floatval( $val ) > 0;
    } ) );

    return $related_ids;
}


remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('admin_print_styles', 'print_emoji_styles');
remove_filter('the_content_feed', 'wp_staticize_emoji');
remove_filter('comment_text_rss', 'wp_staticize_emoji');
remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'wp_shortlink_wp_head');
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'wp_oembed_add_discovery_links');
remove_action('wp_head', 'rest_output_link_wp_head');
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'wp_oembed_add_host_js');

add_filter('xmlrpc_enabled', '__return_false');


add_action( 'wp_enqueue_scripts', function() {
    wp_dequeue_style( 'wp-block-library' );
    wp_dequeue_style( 'wp-block-library-theme' );
    wp_dequeue_style( 'wc-blocks-style' );
    wp_dequeue_style( 'global-styles' );

}, 20 );



function remove_jquery_migrate( $scripts ) {
   if ( ! is_admin() && isset( $scripts->registered['jquery'] ) ) {
        $script = $scripts->registered['jquery'];
   if ( $script->deps ) {
// Check whether the script has any dependencies

        $script->deps = array_diff( $script->deps, array( 'jquery-migrate' ) );
 }
 }
 }
add_action( 'wp_default_scripts', 'remove_jquery_migrate' );




add_action( 'wp_enqueue_scripts', 'dequeue_woocommerce_styles_scripts', 99 );

function dequeue_woocommerce_styles_scripts() {
    if ( function_exists( 'is_woocommerce' ) ) {
        if ( ! is_woocommerce() && ! is_cart() && ! is_checkout() ) {
            # Styles
            wp_dequeue_style( 'woocommerce-general' );
            wp_dequeue_style( 'woocommerce-layout' );
            wp_dequeue_style( 'woocommerce-smallscreen' );
            wp_dequeue_style( 'woocommerce_frontend_styles' );
            wp_dequeue_style( 'woocommerce_fancybox_styles' );
            wp_dequeue_style( 'woocommerce_chosen_styles' );
            wp_dequeue_style( 'woocommerce_prettyPhoto_css' );
            # Scripts
            wp_dequeue_script( 'wc_price_slider' );
            wp_dequeue_script( 'wc-single-product' );
            wp_dequeue_script( 'wc-add-to-cart' );
            wp_dequeue_script( 'wc-cart-fragments' );
            wp_dequeue_script( 'wc-checkout' );
            wp_dequeue_script( 'wc-add-to-cart-variation' );
            wp_dequeue_script( 'wc-single-product' );
            wp_dequeue_script( 'wc-cart' );
            wp_dequeue_script( 'wc-chosen' );
            wp_dequeue_script( 'woocommerce' );
            wp_dequeue_script( 'prettyPhoto' );
            wp_dequeue_script( 'prettyPhoto-init' );
            wp_dequeue_script( 'jquery-blockui' );
            wp_dequeue_script( 'jquery-placeholder' );
            wp_dequeue_script( 'fancybox' );
            wp_dequeue_script( 'jqueryui' );


        }
    }
}

function force_remove_js_form_vera_script() {
    wp_dequeue_script( 'js-form' );
    wp_deregister_script( 'js-form' );
}
add_action( 'wp_print_scripts', 'force_remove_js_form_vera_script', 100 );



 function taktheme_remove_specific_css_from_html($tag, $handle) {
    $handles_to_remove = [
        'wc-blocks-style-rtl',
        'wc-blocks-style'
    ];

    if (in_array($handle, $handles_to_remove)) {
        return '';
    }

    return $tag;
}
add_filter('style_loader_tag', 'taktheme_remove_specific_css_from_html', 10, 2);

// Auto-add width and height attributes to images without them
add_action('template_redirect', function() {
    ob_start(function($html) {
        return preg_replace_callback('/<img([^>]+)>/i', function($matches) {
            // Skip if width and height already exist
            if (strpos($matches[1], 'width=') !== false && strpos($matches[1], 'height=') !== false) {
                return '<img' . $matches[1] . '>';
            }

            // Extract src attribute
            if (preg_match('/src=["\']([^"\']+)["\']/', $matches[1], $srcMatch)) {
                $src = $srcMatch[1];

                // Only continue for local images
                if (strpos($src, home_url()) !== false || strpos($src, '/') === 0) {
                    // Make src into a file path
                    $src_path = str_replace(home_url('/'), ABSPATH, $src);
                    if (file_exists($src_path)) {
                        $size = @getimagesize($src_path);
                        if (!empty($size)) {
                            // Append width and height
                            return '<img' . $matches[1] . ' width="' . $size[0] . '" height="' . $size[1] . '">';
                        }
                    }
                }
            }

            // Otherwise return unmodified
            return '<img' . $matches[1] . '>';
        }, $html);
    });
});


add_filter('digits_filter_name_maxlength', function($length){
    return 250; // یا هر عددی که دوست داری مثلا 250 کاراکتر
});


// افزودن ستون سفارشی
add_filter('manage_edit-shop_order_columns', 'hdm_add_customer_mobile_column');
function hdm_add_customer_mobile_column($columns) {
    $new_columns = [];

    foreach ($columns as $key => $column) {
        $new_columns[$key] = $column;
        if ($key === 'order_total') {
            $new_columns['customer_mobile'] = 'شماره موبایل';
        }
    }

    return $new_columns;
}

// مقداردهی به ستون سفارشی
add_action('manage_shop_order_posts_custom_column', 'hdm_show_customer_mobile_column');
function hdm_show_customer_mobile_column($column) {
    global $post;

    if ($column === 'customer_mobile') {
        $order = wc_get_order($post->ID);
        $user_id = $order->get_customer_id(); // همان _customer_user
        if ($user_id) {
            $mobile = get_user_meta($user_id, 'billing_phone', true); // اگر شماره موبایل به عنوان یوزرنیم ذخیره شده:
            if (!$mobile) {
                $user = get_user_by('ID', $user_id);
                $mobile = $user ? $user->user_login : '-';
            }
            echo esc_html($mobile);
        } else {
            echo '-';
        }
    }
}


function hdm_filter_shop_products_by_custom_meta($query) {
    if (!is_admin() && $query->is_main_query() && is_shop()) {
        $meta_query = $query->get('meta_query');

        if (!is_array($meta_query)) {
            $meta_query = [];
        }

        // فقط محصولاتی که مقدار b_price_update_stock_checker_circle برابر ۱ هست را نمایش بده
        $meta_query[] = [
            'key'     => 'b_price_update_stock_checker_circle',
            'value'   => '1',
            'compare' => '=',
        ];

        $query->set('meta_query', $meta_query);
    }
}
add_action('pre_get_posts', 'hdm_filter_shop_products_by_custom_meta');




add_filter('wp_footer', 'virax_custom_breadcrumb_fix');
function virax_custom_breadcrumb_fix() {
    if (is_product()) {
        ?>
        <script>
            jQuery(document).ready(function($) {
                // پیدا کردن لینک دسته‌بندی "فروشگاه" در بردکرامپ
                var $breadcrumb = $('.add_product_breadcrumb .breadcrumb');
                $breadcrumb.find('a[href="https://kharidstore.com/product-category/%d9%81%d8%b1%d9%88%d8%b4%da%af%d8%a7%d9%87/"]').next('span').remove(); // حذف جداکننده
                $breadcrumb.find('a[href="https://kharidstore.com/product-category/%d9%81%d8%b1%d9%88%d8%b4%da%af%d8%a7%d9%87/"]').remove(); // حذف لینک "فروشگاه"
            });
        </script>
        <?php
    }
}

add_filter('get_terms', 'hide_specific_product_category', 10, 3);
function hide_specific_product_category($terms, $taxonomies, $args) {
    // فقط برای دسته‌بندی‌های محصولات ووکامرس اعمال شود
    if (in_array('product_cat', $taxonomies)) {
        foreach ($terms as $key => $term) {
            if (is_object($term) && $term->term_id == 1629) {
                unset($terms[$key]); // دسته‌بندی با ID 1629 حذف می‌شود
            }
        }
    }
    return $terms;
}

