<?php
require_once 'includes/class-crawler.php';
require_once 'includes/class-wc-integration.php';


// افزودن صفحه به منوی مدیریت
add_action('admin_menu', 'berozkala_add_admin_menu');
function berozkala_add_admin_menu() {
    add_menu_page(
        'Berozkala Crawler',       // عنوان صفحه
        'Berozkala Crawler',       // عنوان منو
        'manage_options',          // سطح دسترسی
        'berozkala-crawler',       // اسلاگ منو
        'berozkala_crawler_page',  // تابعی که صفحه را نمایش می‌دهد
        'dashicons-update',        // آیکون منو
        100                        // موقعیت منو
    );
}

// محتوای صفحه تنظیمات
function berozkala_crawler_page() {
    ?>
    <div class="wrap">
        <h1>Berozkala Crawler Logs</h1>
        <h2>Logs</h2>
        <form method="post" action="">
            <?php wp_nonce_field('start_crawler_action', 'start_crawler_nonce'); ?>
            <input type="hidden" name="action" value="start_crawler">
            <button type="submit" class="button button-primary">Start Crawler</button>
        </form>
        <textarea rows="20" style="width:100%;"><?php echo esc_textarea(get_option('berozkala_crawler_logs', 'No logs yet.')); ?></textarea>
        <form method="post" action="">
            <?php wp_nonce_field('clear_logs_action', 'clear_logs_nonce'); ?>
            <input type="hidden" name="action" value="clear_logs">
            <button type="submit" class="button">Clear Logs</button>
        </form>
    </div>
    <?php
}



add_action('admin_init', 'berozkala_handle_crawler_action');
function berozkala_handle_crawler_action() {
    if (
        isset($_POST['action']) &&
        $_POST['action'] === 'start_crawler' &&
        check_admin_referer('start_crawler_action', 'start_crawler_nonce')
    ) {
        berozkala_start_crawler();
    }
}

// تابع برای استارت کرالر
function berozkala_start_crawler() {
    // مقداردهی کلاس‌ها
    $crawler = new Berozkala_Crawler();
    $wp_integration = new Berozkala_WP_Integration();

    // لینک دسته‌بندی
    $category_url = 'https://berozkala.com/category/internal-hard-drive-for-pc';

    // اجرای کرالر
    $products = $crawler->fetch_category_products($category_url);

    // پردازش محصولات
    $logs = "Starting crawler...\n";
    foreach ($products as $product) {
        $post_id = $wp_integration->save_product_to_wp($product);
        $logs .= "Saved product: {$product['title']} (Post ID: $post_id)\n";
    }

    $logs .= "Crawler finished.\n";

    // ذخیره لاگ‌ها
    update_option('berozkala_crawler_logs', $logs);
}

/**
 * ثبت لاگ‌ها در دیتابیس یا فایل
 * @param string $message پیام لاگ
 */
function berozkala_log($message) {
    $current_logs = get_option('berozkala_crawler_logs', '');
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[$timestamp] $message\n";
    $current_logs .= $log_entry;

    // ذخیره لاگ‌ها در دیتابیس
    update_option('berozkala_crawler_logs', $current_logs);
}

add_action('admin_init', 'berozkala_handle_clear_logs');
function berozkala_handle_clear_logs() {
    if (
        isset($_POST['action']) &&
        $_POST['action'] === 'clear_logs' &&
        check_admin_referer('clear_logs_action', 'clear_logs_nonce')
    ) {
        update_option('berozkala_crawler_logs', '');
    }
}

if(isset($_GET['run'])){

    $product_details = Berozkala_Crawler::fetch_product_details('https://berozkala.com/fa/product/16202/مادربرد-ایسوس-asus-prime-b760m-a-d4');
    echo '<pre>';
    print_r($product_details);
    echo '</pre>';

    die();
}

add_filter('woocommerce_product_get_image', 'set_product_thumbnail_from_meta', 10, 2);

function set_product_thumbnail_from_meta($image, $product) {
    $thumbnail_url = get_post_meta($product->get_id(), 'b_product_thumbnail', true);

    if ($thumbnail_url) {
        return sprintf('<img src="%s" alt="%s" />', esc_url($thumbnail_url), esc_attr($product->get_name()));
    }

    return $image;
}

add_filter('woocommerce_product_get_gallery_image_ids', 'get_gallery_from_meta', 10, 2);

function get_gallery_from_meta($image_ids, $product) {
    $gallery = get_post_meta($product->get_id(), 'b_product_gallery', true);

    if (!empty($gallery)) {
        return array_map(function ($url) {
            // ایجاد ID مجازی برای تصاویر
            return $url;
        }, $gallery);
    }

    return $image_ids;
}

add_filter('woocommerce_product_get_attributes', 'get_attributes_from_meta', 10, 2);

function get_attributes_from_meta($attributes, $product) {
    $custom_attributes = get_post_meta($product->get_id(), 'b_product_attributes', true);

    if (!empty($custom_attributes)) {
        foreach ($custom_attributes as $custom_attribute) {
            $attribute_key = sanitize_title($custom_attribute['name']);

            $attributes[$attribute_key] = new WC_Product_Attribute([
                'name'         => $custom_attribute['name'],
                'value'        => $custom_attribute['value'],
                'position'     => 0,
                'is_visible'   => 1,
                'is_variation' => 0,
                'is_taxonomy'  => 0, // مقدار صحیح برای ویژگی‌های غیر طبقه‌بندی
            ]);
        }
    }

    return $attributes;
}



add_action('woocommerce_before_calculate_totals', 'apply_variations_to_cart');

function apply_variations_to_cart($cart) {
    // اگر سبد خرید خالی باشد، هیچ کاری انجام نده
    if (WC()->cart->is_empty()) {
        return;
    }

    foreach ($cart->get_cart() as $cart_item_key => $cart_item) {
        $product_id = $cart_item['product_id'];
        $variations = get_post_meta($product_id, 'b_product_variations', true);

        if (!empty($variations)) {
            // چک کردن اگر متغیر انتخاب‌شده در داده‌های سبد خرید موجود باشد
            $selected_variation = isset($cart_item['selected_variation']) ? $cart_item['selected_variation'] : null;

            // تغییر قیمت بر اساس متغیر انتخاب‌شده
            if ($selected_variation) {
                foreach ($variations as $variation_type => $variation_data) {
                    foreach ($variation_data as $variation) {
                        if ($variation['name'] === $selected_variation) {
                            // اعمال قیمت اضافی به قیمت محصول
                            $additional_price = floatval($variation['price']);
                            $cart_item['data']->set_price($cart_item['data']->get_price() + $additional_price);

                            // ثبت لاگ
                            error_log("Applied variation '$selected_variation' with additional price $additional_price for product ID $product_id.");
                        }
                    }
                }
            }
        }
    }
}

add_filter('woocommerce_add_cart_item_data', 'add_selected_variation_to_cart', 10, 2);

function add_selected_variation_to_cart($cart_item_data, $product_id) {
    // بررسی وجود متغیرهای انتخاب‌شده در فرم
    if (isset($_POST['selected_variation'])) {
        $cart_item_data['selected_variation'] = sanitize_text_field($_POST['selected_variation']);
    }

    return $cart_item_data;
}



add_filter('cron_schedules', 'add_one_minute_cron_interval');

function add_one_minute_cron_interval($schedules) {
    $schedules['one_minute'] = [
        'interval' => 60, // زمان به ثانیه (۱ دقیقه)
        'display'  => __('Every One Minute'),
    ];
    return $schedules;
}

// ثبت کران جاب
if (!wp_next_scheduled('process_product_details_cron')) {
    wp_schedule_event(time(), 'one_minute', 'process_product_details_cron');
}

// هوک برای کران جاب
add_action('process_product_details_cron', 'process_product_details');


//register_deactivation_hook(__FILE__, 'remove_process_product_details_cron');
//function remove_process_product_details_cron() {
//    $timestamp = wp_next_scheduled('process_product_details_cron');
//    if ($timestamp) {
//        wp_unschedule_event($timestamp, 'process_product_details_cron');
//    }
//}


function process_product_details() {
    berozkala_log("Cron Job Started: Processing product details...");

    // دریافت محصولاتی که نیاز به سینک دارند
    $products = get_posts([
        'post_type'  => 'product',
        'meta_key'   => 'b_product_single_sync',
        'meta_value' => 0, // محصولاتی که سینک نشده‌اند
        'numberposts' => 5, // تعداد محصولات برای پردازش در هر اجرا
    ]);

    if (empty($products)) {
        berozkala_log("No products to sync.");
    }

    foreach ($products as $product) {
        $product_id = $product->ID;
        $product_url = get_post_meta($product_id, 'b_product_url', true);

        berozkala_log("Fetching details for Product ID: $product_id, URL: $product_url");

        // استخراج اطلاعات صفحه داخلی محصول
        $details = Berozkala_Crawler::fetch_product_details($product_url);

        if ($details) {
            // ذخیره اطلاعات جزئی محصول
            Berozkala_WP_Integration::update_product_details($product_id, $details);

            // نشان دادن پردازش شده
            update_post_meta($product_id, 'b_product_single_sync', 1);

            berozkala_log("Successfully updated Product ID: $product_id.");
        } else {
            berozkala_log("Failed to fetch details for Product ID: $product_id.");
        }
    }

    berozkala_log("Cron Job Finished: Processing complete.");
}



add_filter('wp_image_editors', function ($editors) {
    if (!empty($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'https://berozkala.com') !== false) {
        return []; // غیرفعال کردن ویرایشگر تصویر برای تصاویر به‌روزکالا
    }
    return $editors;
});

if(isset($_GET['crwl'])){
    print_r("Cron Job Started: Processing product details...");

    // دریافت محصولاتی که نیاز به سینک دارند
    $products = get_posts([
        'post_type'  => 'product',
        'meta_key'   => 'b_product_single_sync',
        'meta_value' => 1, // محصولاتی که سینک نشده‌اند
        'numberposts' => 5, // تعداد محصولات برای پردازش در هر اجرا
    ]);

    if (empty($products)) {
        print_r("No products to sync.");
    }

    foreach ($products as $product) {
        $product_id = $product->ID;
        echo $product_id;
        if (is_numeric($product_id) && $product_id > 0) {
            $product = wc_get_product($product_id);
            if ($product) {
                print_r($product);
            } else {
                print_r("محصول با شناسه {$product_id} یافت نشد.");
            }
        } else {
            print_r("شناسه محصول نامعتبر است: {$product_id}");
        }


        $product = wc_get_product($product_id);
        echo
        die(var_dump($product));
        $product_url = get_post_meta($product_id, 'b_product_url', true);

        print_r("Fetching details for Product ID: $product_id, URL: $product_url");

        // استخراج اطلاعات صفحه داخلی محصول
        $details = Berozkala_Crawler::fetch_product_details($product_url);

        if ($details) {
            // ذخیره اطلاعات جزئی محصول
            Berozkala_WP_Integration::update_product_details($product_id, $details);

            // نشان دادن پردازش شده
            update_post_meta($product_id, 'b_product_single_sync', 1);

            print_r("Successfully updated Product ID: $product_id.");
        } else {
            print_r("Failed to fetch details for Product ID: $product_id.");
        }
    }

    berozkala_log("Cron Job Finished: Processing complete.");
    die();
}

?>