<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

if (!defined('ABSPATH')) {
    exit;
}

do_action('woocommerce_before_checkout_form', $checkout);

// If checkout registration is disabled and not logged in, the user cannot checkout.
if (!$checkout->is_registration_enabled() && $checkout->is_registration_required() && !is_user_logged_in()) {
    echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
    return;
}

?>
<style>

    .woocommerce-form-coupon-toggle .woocommerce-info {
        background: whitesmoke;
        border: 0;
        text-align: center;
        display: flex;
        justify-content: center;
        align-items: center;
        color: rgba(34, 34, 34, 0.62);
        font-weight: 400;
    }

    .woocommerce-form-coupon-toggle .woocommerce-info a {
        color: rgb(34, 34, 34) !important;
    }

    .woocommerce-form-coupon-toggle .woocommerce-info:before {
        content: "\f145";
        position: unset;
        padding-left: 15px;
        color: #222222;
    }

    .checkout_coupon {
        border: 0 !important;
        display: flex;
        width: 450px;
        max-width: 100%;
        justify-content: center;
        margin: 0 auto !important;
        flex-wrap: wrap;
        padding:20px 0 !important;
    }
.image-item-cart-order {
    width: 50px !important;
    margin-left: 10px
}
.image-item-cart-order img {
    width: 50px !important;
    max-width: 50px !important;
    height: auto !important;
}
    .checkout_coupon > p {
        font-size: 13px;
        font-weight: 400;
        color: #939393;
        padding: 0 0 15px;
        width: 100% !important;
    }

    .checkout_coupon input[type="text"] {
        padding: 15px 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 3px;
        border: 1px solid rgba(169, 169, 169, 0.77);
    }

    .checkout_coupon button {
        font-size: 14px;
        font-family: 'IRANYekanX';
        padding: 15px 10px !important;
        border: 0;
        color: #FFFFFF !important;
        background: var(--main-color) !important;
        font-weight: 400;
        width: 100%;
        transition: all .3s ease-in-out;
    }


    .woocommerce-form-login {
        border: 0 !important;
        display: flex;
        width: 450px;
        max-width: 100%;
        justify-content: center;
        margin: 0 auto !important;
        flex-wrap: wrap;
        padding:20px 0 !important;
    }

    .woocommerce-form-login > p {
        font-size: 13px;
        font-weight: 400;
        color: #939393;
        padding: 0 0 15px;
        width: 100% !important;
    }

    .woocommerce-form-login input[type="text"] {
        padding: 15px 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 3px;
        border: 1px solid rgba(169, 169, 169, 0.77);
    }
    .woocommerce-form-login input[type="password"] {
        padding: 15px 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 3px;
        border: 1px solid rgba(169, 169, 169, 0.77);
    }


    #account_password_field input[type="password"] {
        padding: 15px 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 3px;
        border: 1px solid rgba(169, 169, 169, 0.77);
    }
    .woocommerce-password-strength {
        padding: 6px .5em !important;
        margin: 10px 0 !important;
        font-size: 1em !important;
        border-radius: 8px !important;
        font-weight: 400 !important;
    }
    #account_password_field  .show-password-input {
        top: 16px !important;
    }
    #account_password_field  .show-password-input:after {
        content: "\f06e" !important;
        font-family: "Font Awesome 5 Pro" !important;
    }
    #account_password_field  .display-password:after {
        content: "\f070" !important;
        font-family: "Font Awesome 5 Pro" !important;
    }


    .woocommerce-form-login button {
        font-size: 14px;
        font-family: 'IRANYekanX';
        padding: 15px 10px !important;
        border: 0;
        color: #FFFFFF !important;
        background: var(--main-color) !important;
        font-weight: 400;
        width: 100%;
        transition: all .3s ease-in-out;
    }
    .woocommerce-form-login input[type="checkbox"] {
        display: grid;
        place-content: center;
        margin-left: 10px;
        float: right;
        width: 30px;
        height: 15px;
        -webkit-appearance: none;
        appearance: none;
        background-color: #fff;
        border: 1px solid rgba(204, 204, 204, 0.62);
        border-radius: 15px;
        position: relative;
    }

    .woocommerce-form-login input[type="checkbox"]::before {
        content: "";
        width: 14px;
        transition: all 1s ease-in-out !important;
        height: 14px;
        position: absolute;
        transform: scale(1);
        box-shadow: none !important;
        background: #0073aa;
        border-radius: 15px;
        left: 0;
    }

    .woocommerce-form-login input[type="checkbox"]:checked {
        background: rgba(0, 122, 255, 0.44);
    }
    .woocommerce-form-login input[type="checkbox"]:checked::before {
        right: 0;
        transition: all 1s ease-in-out !important;
    }
    i#gift-icon-cat-page {
        font-size: 20px;
        font-weight: 300;
        color: var(--main-color);
        position: relative;
        margin-right: 6px;
    }
    i#gift-icon-cat-page:after {
        content: "بسته بندی ویژه";
        position: absolute;
        left: 130%;
        width: max-content;
        top: 0;
        font-family: 'IRANYekanX';
        font-weight: 500;
        color: #ffffff;
        font-size: 13px;
        text-align: center;
        border-radius:3px;
        padding: 6px 5px;
        visibility: hidden;
        transition: all .3s ease-in-out;
        background: rgba(1, 1, 1, 0.62);
        box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
        backdrop-filter: blur(7px);
        -webkit-backdrop-filter: blur(6px);
    }
    i#gift-icon-cat-page:hover:after {
        opacity: 1;
        visibility: visible;
        left: 120%;
    }
    .woocommerce-form-login .woocommerce-form__label {
        display: flex !important;
        align-items: center;
        padding-bottom:1rem;
    }
    .woocommerce-form-login a {
        opacity: .7;
        color: #222222;
        text-decoration: none;
        transition: all .3s ease-in-out;
    }
    .woocommerce-form-login a:hover {
        opacity:1;
    }
    .woocommerce-form-login a:hover {
        opacity:1;
    }

    .woocommerce-form-login  .show-password-input {
        top: 18px !important;
    }
    .woocommerce-form-login  .show-password-input:after {
        content: "\f06e" !important;
        font-family: "Font Awesome 5 Pro" !important;
    }
    .woocommerce-form-login  .display-password:after {
        content: "\f070" !important;
        font-family: "Font Awesome 5 Pro" !important;
    }

    .blockUI {
        background: rgba(34, 34, 34, 0.37) !important;
        opacity: 1 !important;
        backdrop-filter: blur(0) !important;
        z-index: 10 !important;
    }

    form.checkout {
        display: flex;
        justify-content: space-between;
        align-items: start;
        background: #fff;
        padding: 15px 0;
        float: right;
        flex-wrap: wrap;
    }
.form.checkout .col2-set .col-1 label, form.checkout .col2-set  label.woocommerce-form__label-for-checkbox {
    display: flex;
    align-items: center;
}
    form.checkout input[type="checkbox"] {
        display: grid !important;
        place-content: center;
        margin-left: 10px;
        float: right;
        width: 30px;
        height: 15px;
        -webkit-appearance: none;
        appearance: none;
        background-color: #fff;
        border: 1px solid rgba(204, 204, 204, 0.62);
        border-radius: 15px;
        position: relative;
    }

    form.checkout input[type="checkbox"]::before {
        content: "";
        width: 14px;
        transition: all 1s ease-in-out !important;
        height: 14px;
        position: absolute;
        transform: scale(1);
        box-shadow: none !important;
        background: #0073aa;
        border-radius: 15px;
        left: 0;
    }

    form.checkout input[type="checkbox"]:checked {
        background: rgba(0, 122, 255, 0.44);
    }
    form.checkout input[type="checkbox"]:checked::before {
        right: 0;
        transition: all 1s ease-in-out !important;
    }

    form.checkout .col2-set {
        width: 59%;
    }

    form.checkout .col2-set .col-1 {
        width: 100%;
        float: right;
    }

    form.checkout .col2-set .col-2 {
        width: 100%;
        float: right;
    }

    .woocommerce table.shop_table td {
        padding: 9px 0;
    }

    form.checkout .col2-set .col-1 label, form.checkout .col2-set .col-2 label {
        font-weight: 400;
        font-size: 14px;
        padding-bottom: 10px;
    }

    form.checkout .col2-set .col-1 .woocommerce-billing-fields h3 {
        font-weight: 500;
        font-size: 20px;
        padding-bottom: 15px;
        width: 100%;
    }

    form.checkout .order_reviews h3#order_review_heading {
        font-weight: 500;
        font-size: 20px;
        padding-bottom: 15px;
        width: 100%;
    }

    form.checkout .col2-set .col-1 input[type="text"], form.checkout .col2-set .col-2 input[type="text"], form.checkout .col2-set .col-1 input[type="tel"], form.checkout .col2-set .col-2 input[type="tel"], form.checkout .col2-set .col-1 input[type="email"], form.checkout .col2-set .col-2 input[type="email"], form.checkout .col2-set .col-1 textarea, form.checkout .col2-set .col-2 textarea, .select2-container--default .select2-search__field {
        padding: 10px;
        width: 100% !important;
        font-family: IRANYekanX;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        border-radius: 5px;
        border: 1px solid rgba(169, 169, 169, 0.6);
        text-align: right;
        font-weight: 400;
    }

    form.checkout .col2-set .col-1 textarea, form.checkout .col2-set .col-2 textarea {
        height: 150px;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        direction: rtl;
        padding-right: 10px;
    }

    .select2-container .select2-selection--single {
        height: 45px;
        display: flex;
        justify-content: right;
        align-items: center;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        left: 5px;
        top: 10px;
    }

    .select2-container--default .select2-search__field:focus {
        outline: none;
    }

    form.checkout .order_reviews {
        width: 35%;
        border: 1px solid #b5b5b5;
        padding: 10px 2%;
    }

    form.checkout .order_reviews #order_review {
        width: 100%;
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
    }

    form.checkout .order_reviews #order_review table.shop_table {
        border: none !important;
        font-weight: 400;
    }

    form.checkout .order_reviews #order_review table.shop_table th.product-name {
        text-align: right;
        width: 50%;
        font-weight: 400;
    }

    form.checkout .order_reviews #order_review table.shop_table th.product-total {
        text-align: left;
        font-weight: 400;
    }

    form.checkout .order_reviews #order_review bdi {
        -moz-font-feature-settings: "ss02" !important;
        -webkit-font-feature-settings: "ss02" !important;
        font-feature-settings: "ss02" !important;
        display: flex;
        align-items: center;
        justify-content: left;
        font-weight: 400;
    }

    form.checkout .order_reviews #order_review bdi .woocommerce-Price-currencySymbol {
        padding-right: 5px;
        order: 1;
    }

    form.checkout .order_reviews #order_review bdi .woocommerce-Price-currencySymbol:after {
        content: var(--main-content);
    }

    .woocommerce table.shop_table tfoot th {
        font-weight: 400;
    }

    .woocommerce ul#shipping_method , .woocommerce ul.wc_payment_methods{
        background: none !important;
    }

    .woocommerce ul#shipping_method li  {
        display: flex;
        align-items: center;
        justify-content: right;
        font-size: 15px;
        font-weight: 600;
        border-radius: 10px;
        border: 3px solid #f0f1f2;
        padding: 10px 8px;
        background: rgba(255, 255, 255, .5215686275);
        cursor: pointer;
        position: relative;
    }
     .woocommerce ul.wc_payment_methods li {
        font-weight: 600;
        cursor: pointer;
        position: relative;
         margin: 10px 0;
    }

    .woocommerce ul#shipping_method li label bdi {
        padding-right: 5px;
        font-weight: 500;
    }

    .woocommerce ul#shipping_method li label  {
        width: 100%;
        display: flex;
        align-items: center;
        font-size: 13px;
        padding: 7px 10px;
        justify-content: center;
    }


    .woocommerce ul#shipping_method li input  , .woocommerce ul.wc_payment_methods li input {
        cursor: pointer;
        position: absolute;
        opacity: 0;
        margin: 0 !important;
        width: 100%;
        height: 100%;
        border-radius: 10px;
    }

    .woocommerce ul#shipping_method li input:checked + label:before  , .woocommerce ul.wc_payment_methods li input:checked + label:before {
        content: "";
        height: 100%;
        width: 100%;
        display: inline-block;
        position: absolute;
        background: #ffa41a;
        top: 0;
        right: 0;
        opacity: .07;
        color: #dd823b !important;
    }

    form.checkout .order_reviews #order_review .woocommerce-checkout-payment {
        background: none !important;
    }

    .woocommerce-checkout #payment div.payment_box {
        background-color: #f4f4f4;
        color: #515151;
        margin: 2em 0;
    }

    .woocommerce-checkout #payment ul.payment_methods li img {
        margin: -2px 0 0 .5em;
        float: right;
    }

    .woocommerce-checkout #payment div.payment_box:before {
        border: 1em solid #f3f3f3;
        border-left-color: transparent;
        border-right-color: transparent;
        border-top-color: transparent;
        margin: -1em 6px 0 2em;
    }

    form.checkout .order_reviews #order_review ul.wc_payment_methods {
        background: none !important;
        padding: 0 !important;
        border-radius: 0;
        border: none !important;
    }

    form.checkout .order_reviews #order_review ul.wc_payment_methods li {
        background: none !important;
        border-radius:15px;
        margin: 0 0 10px;
        text-align: right;
        padding-right: 5px;
    }

    form.checkout .order_reviews #order_review ul.wc_payment_methods li {
        border: 1px solid #cbcbcb;
        padding: 1em 10px;
    }
    form.checkout .order_reviews #order_review ul.wc_payment_methods li img {

    }

    form.checkout .order_reviews #order_review .woocommerce-privacy-policy-text {
        font-weight: 400;
        font-size: 14px;
    }

    form.checkout .order_reviews #order_review .woocommerce-privacy-policy-text a {
        text-decoration: none;
        color: #222222;
        opacity: .7;
        transition: all .3s ease-in-out;
        padding: 0 7px;
    }

    form.checkout .order_reviews #order_review .woocommerce-privacy-policy-text a:hover {
        opacity: 1;
    }

    form.checkout .order_reviews #order_review button.button {
        width: 100%;
        text-align: center;
        padding: 17px 0;
        background: var(--main-color);
        border-radius: 3px;
        font-family: IRANYekanX;
        margin: 1em 0;
    }
    @media screen and (max-width: 1000px) {
        form.checkout {
            flex-wrap: wrap;
        }

        form.checkout .col2-set {
            width: 100%;
        }

        form.checkout .order_reviews {
            width: 96%;
        }

        .woocommerce-form-coupon-toggle .woocommerce-info {
            font-size: 13px;
        }
    }
</style>
<form name="checkout" method="post" class="checkout woocommerce-checkout"
      action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data">

    <?php if ($checkout->get_checkout_fields()) : ?>

        <?php do_action('woocommerce_checkout_before_customer_details'); ?>

        <div class="col2-set" id="customer_details">
            <div class="col-1">
                <?php do_action('woocommerce_checkout_billing'); ?>
                <div class="col-2">
                    <?php do_action('woocommerce_checkout_shipping'); ?>
                </div>
            </div>
        </div>

        <?php do_action('woocommerce_checkout_after_customer_details'); ?>

    <?php endif; ?>

    <?php do_action('woocommerce_checkout_before_order_review_heading'); ?>
    <div class="order_reviews">
        <h3 id="order_review_heading"><?php esc_html_e('Your order', 'woocommerce'); ?></h3>

        <?php do_action('woocommerce_checkout_before_order_review'); ?>

        <div id="order_review" class="woocommerce-checkout-review-order">
            <?php do_action('woocommerce_checkout_order_review'); ?>
        </div>

        <?php do_action('woocommerce_checkout_after_order_review'); ?>
    </div>
</form>

<?php do_action('woocommerce_after_checkout_form', $checkout); ?>
