<?php

function hstngr_register_widget()
{

    register_widget('hstngr_widget');
}

add_action('widgets_init', 'hstngr_register_widget');

class hstngr_widget extends WP_Widget
{


    function __construct()
    {

        parent::__construct(
// widget ID
            'price_filter_virax_widget',
// widget name
            "فیلتر قیمت ( virax | ابزارک اختصاصی )",
// widget description
            array('description' => __('ابزارک اختصاصی فیلتر قیمت ووکامرس . از طریق این افزونه میتوانید به بخش سایدبار فروشگاه خود ابزارک برای فیلتر قیمت محصولات لحاظ کنید (این ابزارک اختصاصی قالب فعال شما (virax) میباشد ', 'hstngr_widget_domain'),)

        );

    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $steep = apply_filters('widget_steep', $instance['steep']);
        $space = apply_filters('widget_space', $instance['space']);
        echo $args['before_widget'];
        ?>
        <div class=" wc-blocks-filter-wrapper">
            <?php
        if (!empty($title))
            echo $args['before_title'];
            echo "<h3 class='wp-block-heading'> " . $title . "</h3>". $args['after_title'];
// دریافت کمترین و بیشترین قیمت از فروشگاه
        $argss = array(
            'post_type' => 'product',
            'posts_per_page' => -1, // Get all products
            'meta_query' => array(
                'relation' => 'OR',
                array(
                    'key' => '_price',
                    'value' => array(0, PHP_INT_MAX),
                    'compare' => 'BETWEEN',
                    'type' => 'NUMERIC'
                ),
                array(
                    'key' => '_sale_price',
                    'value' => array(0, PHP_INT_MAX),
                    'compare' => 'BETWEEN',
                    'type' => 'NUMERIC'
                )
            ),
            'fields' => 'ids' // Only return post IDs
        );
        $products = new WP_Query($argss);
        $product_ids = $products->posts;
        $min_price = PHP_INT_MAX;
        $max_price = 0;
        foreach ($product_ids as $product_id) {
            $product = wc_get_product($product_id);
            $price = $product->get_price();

            if (isset($_GET['max_price'])) {
                if ($price > $max_price) {
                    $maxs_price = $_GET['max_price'];
                }
            }
            else {
                if ($price > $max_price) {
                    $maxs_price = $price;
                }
            }

            if (isset($_GET['min_price'])) {
                if ($price < $min_price) {
                    $mins_price = $_GET['min_price'];
                }
            }
            else {
                if ($price < $min_price) {
                    $mins_price = $price;
                }
            }

            if ($price > $max_price) {
                $max_price = $price;
            }
            if ($price < $min_price) {
                $min_price = $price;
            }

        }
        if (isset($_GET['max_price'])) {
            $formatted_max_price = number_format($_GET['max_price'], 0, '', ',');
        }
        else {
            $formatted_max_price = number_format($max_price, 0, '', ',');
        }
        if (isset($_GET['min_price'])) {
            $formatted_min_price = number_format($_GET['min_price'], 0, '', ',');
        }
        else {
            $formatted_min_price = number_format($min_price, 0, '', ',');
        }
        ?>
        <div class="price_range_filter">
                       <div class="d-flex">
                    <form action="" method="get" class="wrapper">
                        <div class="slider">
                            <div class="progresss"></div>
                        </div>
                        <div class="range-input">
                            <input type="range" name="min_price" class="range-min" min="<?php echo $min_price; ?>"
                                   max="<?php echo $max_price; ?>" value="<?php echo $mins_price; ?>" step="<?php echo $steep; ?>">
                            <input type="range" name="max_price" class="range-max" min="<?php echo $min_price; ?>"
                                   max="<?php echo $max_price; ?>" value="<?php echo $maxs_price; ?>" step="<?php echo $steep; ?>">
                        </div>
                        <div class="price-input">
                            <div class="field">
                                <input type="text" class="input-min" disabled value="<?php echo $formatted_min_price; ?>">
                            </div>
                            <div class="separator">تومان</div>
                            <div class="field">
                                <input type="text" class="input-max" disabled value="<?php echo $formatted_max_price; ?>">
                            </div>
                        </div>
                        <div style="float:right;width:100%;display:flex;justify-content:space-between;align-items:center">
                            <button class="wp-block-button__link wc-block-filter-submit-button wc-block-components-filter-submit-button wc-block-price-filter__button wc-block-components-price-slider__button"
                                    type="submit">فیلتر کن
                            </button>
                            <?php
                            if (isset($_GET['min_price'] ) || isset($_GET['max_price']) ) :
                                $current_url = $_SERVER['REQUEST_URI'];
                                $current_url = explode("?",$current_url);
                                ?>
                                <a href="<?php echo $current_url[0]; ?>" class="reset_filter wp-block-button__link wc-block-filter-submit-button wc-block-components-filter-submit-button wc-block-price-filter__button wc-block-components-price-slider__button"
                                   type="submit">بازگردانی کن
                                </a>
                            <?php
                            endif;
                            ?>

                        </div>
                    </form>
                           <script>
                               const rangeInput = document.querySelectorAll(".range-input input"),
                                   priceInput = document.querySelectorAll(".price-input input"),
                                   range = document.querySelector(".slider .progresss");

                               let priceGap = <?php echo $space; ?>;

                               const formattedMinPrice = "<?php echo $formatted_min_price; ?>";
                               const formattedMaxPrice = "<?php echo $formatted_max_price; ?>";

                               function separate(x) {
                                   return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                               }
                               let minPrice = parseInt(priceInput[0].value.replace(/,/g, '')),
                                   maxPrice = parseInt(priceInput[1].value.replace(/,/g, ''));
                               range.style.right = (minPrice / rangeInput[0].max) * 100 + "%";
                               range.style.left = 100 - (maxPrice / rangeInput[1].max) * 100 + "%";

                               priceInput.forEach((input) => {
                                   input.addEventListener("input", (e) => {
                                       let minPrice = parseInt(priceInput[0].value.replace(/,/g, '')),
                                           maxPrice = parseInt(priceInput[1].value.replace(/,/g, ''));

                                       if (maxPrice - minPrice >= priceGap && maxPrice <= rangeInput[1].max) {
                                           if (e.target.className === "input-min") {
                                               rangeInput[0].value = minPrice;
                                               range.style.left = (minPrice / rangeInput[0].max) * 100 + "%";
                                               priceInput[0].value = separate(minPrice);
                                           } else {
                                               rangeInput[1].value = maxPrice;
                                               range.style.right = 100 - (maxPrice / rangeInput[1].max) * 100 + "%";
                                               priceInput[1].value = separate(maxPrice);
                                           }
                                       }
                                   });
                               });

                               rangeInput.forEach((input) => {
                                   input.addEventListener("input", (e) => {
                                       let minVal = parseInt(rangeInput[0].value),
                                           maxVal = parseInt(rangeInput[1].value);

                                       if (maxVal - minVal < priceGap) {
                                           if (e.target.className === "range-min") {
                                               rangeInput[0].value = maxVal - priceGap;
                                           } else {
                                               rangeInput[1].value = minVal + priceGap;
                                           }
                                       } else {
                                           const formattedMinVal = separate(minVal);
                                           const formattedMaxVal = separate(maxVal);
                                           priceInput[0].value = formattedMinVal;
                                           priceInput[1].value = formattedMaxVal;
                                           range.style.right = (minVal / rangeInput[0].max) * 100 + "%";
                                           range.style.left = 100 - (maxVal / rangeInput[1].max) * 100 + "%";
                                       }
                                   });
                               });
                           </script>
                           <style>
                               .price_range_filter .wrapper {
                                   width: 95%;
                                   padding: 20px 2.5% 20px;
                                   float: right;
                               }

                               .price_range_filter header h2 {
                                   font-size: 24px;
                                   font-weight: 600;
                               }

                               .price_range_filter header p {
                                   margin-top: 5px;
                                   font-size: 16px;
                               }

                               .price_range_filter .price-input {
                                   width: 100%;
                                   display: flex;
                                   margin: 15px 0 15px 0;
                                   justify-content: space-between;
                                   align-items: center;
                               }

                               .price_range_filter .price-input .field {
                                   display: flex;
                                   width: 100%;
                                   height: 45px;
                                   align-items: center;
                               }

                               .price_range_filter .field input {
                                   width: 100%;
                                   height: 100%;
                                   outline: none;
                                   font-size: 15px;
                                   border: 1px solid #ddddee85;
                                   border-radius: 10px;
                                   text-align: center;
                                   -moz-appearance: textfield;
                                   font-family: IRANYekanX;
                                   -moz-font-feature-settings: "ss03" !important;
                                   -webkit-font-feature-settings: "ss03" !important;
                                   font-feature-settings: "ss03" !important;
                               }
                               .price_range_filter .wc-block-components-filter-submit-button {
                                   padding: 9px 15px !important;
                                   max-width: fit-content;
                                   font-size: 13px;
                               }
                               .reset_filter  {
                                   background:none !important;
                                   order:-1;
                                   color:#222222 !important;
                               }
                               .price_range_filter input[type="number"]::-webkit-outer-spin-button,
                               .price_range_filter input[type="number"]::-webkit-inner-spin-button {
                                   -webkit-appearance: none;
                               }

                               .price_range_filter .price-input .separator {
                                   width: 130px;
                                   display: flex;
                                   font-size: 12px;
                                   line-height: 1;
                                   align-items: center;
                                   justify-content: center;
                                   font-family: IRANYekanX;
                                   -moz-font-feature-settings: "ss03" !important;
                                   -webkit-font-feature-settings: "ss03" !important;
                                   font-feature-settings: "ss03" !important;
                                   opacity: .5;
                                   font-weight: 900;
                                   padding: 0;
                                   transform: rotate(90deg);
                               }

                               .price_range_filter button.wp-block-button__link {
                                   width: 100%;
                               }

                               .price_range_filter .slider {
                                   height: 5px;
                                   position: relative;
                                   background: #ddd;
                                   border-radius: 5px;
                               }

                               .price_range_filter .slider .progresss {
                                   height: 100%;
                                   left: 0;
                                   right: 0;
                                   position: absolute;
                                   border-radius: 5px;
                                   background: rgba(23, 162, 184, 0.74); /* رنگ ارغوانی */
                               }

                               .price_range_filter .range-input {
                                   position: relative;
                               }

                               .price_range_filter .range-input input {
                                   position: absolute;
                                   width: 100%;
                                   height: 5px;
                                   top: -1px;
                                   background: none;
                                   pointer-events: none;
                                   -webkit-appearance: none;
                                   -moz-appearance: none;
                               }

                               .price_range_filter input[type="range"]::-webkit-slider-thumb {
                                   height: 17px;
                                   width: 17px;
                                   border-radius: 50% !important;
                                   background: #17a2b8;
                                   pointer-events: auto;
                                   -webkit-appearance: none;
                                   box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
                               }

                               .price_range_filter input[type="range"]::-moz-range-thumb {
                                   height: 17px;
                                   width: 17px;
                                   border: none;
                                   border-radius: 50% !important;
                                   background: #17a2b8;
                                   pointer-events: auto;
                                   -moz-appearance: none;
                                   box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
                               }
                           </style>
                </div>
            </div>
        </div>
        <?php

        echo $args['after_widget'];

    }

    public function form($instance)
    {
        /*فیلد نام آیتم*/
        if (isset($instance['title']))
            $title = $instance['title'];
        else
            $steep = __('فیلتر قیمت', 'hstngr_widget_domain');
        /*فیلد قدم آیتم*/
        if (isset($instance['steep']))
            $steep = $instance['steep'];
        else
            $steep = __('1000', 'hstngr_widget_domain');

        /*فیلد حداکثر فاصله دکمه min  و max بر اساس مبلغ آیتم*/
        if (isset($instance['space']))
            $space = $instance['space'];
        else
            $space = __('3000000', 'hstngr_widget_domain');

        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('steep'); ?>"><?php _e('قدم های اسلایدر مقدار قیمت :'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('steep'); ?>"
                   name="<?php echo $this->get_field_name('steep'); ?>" type="number"
                   value="<?php echo esc_attr($steep); ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('space'); ?>"><?php _e('حداکثر فاصله دکمه اسلایدر min و max به یکدیگر (بر اساس مبلغ) :'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('space'); ?>"
                   name="<?php echo $this->get_field_name('space'); ?>" type="number"
                   value="<?php echo esc_attr($space); ?>"/>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : 'فیلتر قیمت';
        $instance['steep'] = (!empty($new_instance['steep'])) ? strip_tags($new_instance['steep']) : '1000';
        $instance['space'] = (!empty($new_instance['space'])) ? strip_tags($new_instance['space']) : '3000000';
        return $instance;
    }

}