<?php
/**
 * Redux Framework checkbox config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;

Redux::set_section(
	$opt_name,
	array(
		'title'            => 'طرح هدر',
		'id'               => 'basic-options-header-one',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p style="border-bottom: 1px solid #ddd;padding-bottom: 5px">میتوانید در این قسمت از بین طرح های هدر یک نمونه انتخاب و به عنوان هدر اصلی ثبت نمایید * (دارای 1 آیتم) </p>',
		'fields'           => array(
			array(
				'id'       => 'basic-options-header-themes',
				'type'     => 'image_select',
				'title'    => 'طرح هدر سایت',
				'subtitle' => 'plan header',
				'options'  => array(
					'plan-one'   => array(
						'alt' => 'طرح اول هدر',
						'img' => get_template_directory_uri() . '/img/one_plan_header.png',
					),
					'plan-two'   => array(
						'alt' => 'طرح دوم هدر (دمو گیمو)',
						'img' => get_template_directory_uri() . '/img/two_plan_header.png',
					)

				),
				'default'  => 'plan-one'
			)

		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => 'تنضیمات مرورگر و قالب',
		'id'               => 'basic-options-volor-haber-ger-menu-215212',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p style="border-bottom: 1px solid #ddd;padding-bottom: 10px;">شما میتوانید از طریق این تنظیمات , تنظیمات اساسی مربوط به مرورگر و قالب را تغییر دهید</p>',
		'fields'           => array(
			/**add options theme hamberger menu**/
			array(
				'id'       => 'background-menu-hamberger-menu-color-1-545454',
				'type'     => 'color',
				'title'    => 'رنگ تم هد مرورگر (1.2) ',
				'subtitle' => 'Browser header color',
				'desc'     => 'شما از طریق این بخش رنگ سربرگ کلی مرورگر کاربر را میتوانید تغییر و شخصی سازی نمایید توجه کنید این قابلیت در بعضی از مرورگر ها پاسخگو میباشد ',
				'default'  => '#F0003C',
				'validate' => 'color',
			),

		),
	)
);

Redux::set_section(
	$opt_name,
	array(
		'title'            => 'تنظیمات جستجوی ajax ',
		'id'               => 'basic-options-header-search-ajax',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p  style="border-bottom: 1px solid #ddd;padding-bottom: 10px;">میتوانید از طریق این قسمت تنظیمات مربوط به جستجوی آجاکس | زنده فروشگاه را تغییر دهید</p>',
		'fields'           => array(
			/**add options theme header**/
			array(
				'id'       => 'basic-options-header-search-ajax-3',
				'type'     => 'color',
				'title'    => 'رنگ متن نام محصول از نتایج جستجو',
				'subtitle' => 'Product name text color from search results',
				'desc'     => 'شما میتوانید از این قسمت رنگ متن نام محصول از نتایج جستجو را تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'basic-options-header-search-ajax-4',
				'type'     => 'color',
				'title'    => 'رنگ قیمت عادی از نتایج جستجو',
				'subtitle' => 'Color the normal price of the search results',
				'desc'     => 'شما میتوانید از این قسمت رنگ قیمت عادی از نتایج جستجو را تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'basic-options-header-search-ajax-5',
				'type'     => 'color',
				'title'    => 'رنگ قیمت شگفت انگیز از نتایج جستجو',
				'subtitle' => 'Amazing price color from search results',
				'desc'     => 'شما میتوانید از این قسمت رنگ قیمت شگفت انگیز از نتایج جستجو را تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'basic-options-header-search-ajax-6',
				'type'     => 'color',
				'title'    => 'رنگ متن هشدار عدم وجود محصول جستجو شده',
				'subtitle' => 'Amazing price color from search results',
				'desc'     => 'شما میتوانید از این قسمت رنگ متن هشدار عدم وجود محصول جستجو شده را تغییر دهید',
				'validate' => 'color',
			),

			array(
				'id' => 'text_field-notifications-225252sdsd5',
				'type' => 'text',
				'title' => esc_html__('متن بخش جستجوی پیشنهادی', 'your-project-name'),
				'desc' => esc_html__('شما میتوانید از این بخش عنوان بخش جستجوی پیشنهادی محصولات را تغییر دهید', 'your-project-name'),
				'placeholder' => esc_html__('جستجوهای پیشنهادی', 'your-textdomain-here'),
			),
			array(
				'id' => 'text_field-notifications-225252sdsdgfdg5',
				'type' => 'text',
				'title' => esc_html__('لینک تصویر تبلیغاتی جستجوی محصولات', 'your-project-name'),
				'desc' => esc_html__('شما میتوانید برای تصویر تبلیغاتی جستجوی محصولات لینک هدایت مشخص کنید.', 'your-project-name'),
				'placeholder' => esc_html__('www.site.com/product/موبایل-سامسونک-a54', 'your-textdomain-here'),
			),

			array(
				'id' => 'repeater-field-data-noticdsdsd',
				'type' => 'repeater',
				'title' => esc_html__('لیست جستجوی سریع فروشگاه', 'your-textdomain-here'),
				'subtitle' => esc_html__('List of store search', 'your-textdomain-here'),
				'desc' => esc_html__('شما میتوانید در این بخش لیستی از جستجوهای سریع برای مشتریان خود درست کنید مثال (گوشی آیفون 12 یا مانیتور) توجه کنید وقتی این گزینه اضافه میگردد به صفحه جستجوی فروشگاه متصل میشود و باید دقت زیادی در عنوان محصول داشته باشید تا در جستجو دچار نقص و مشکل نشوید', 'your-textdomain-here'),
				'group_values' => true, // Group all fields below within the repeater ID
				//'item_name'    => '', // Add a repeater block name to the Add and Delete buttons
				//'bind_title'   => '', // Bind the repeater block title to this field ID
				//'static'       => 2, // Set the number of repeater blocks to be output
				//'limit'        => 2, // Limit the number of repeater blocks a user can create
				//'sortable'     => false, // Allow the users to sort the repeater blocks or not
				'fields' => array(

					array(
						'id' => 'text_field-notifications-2252525',
						'type' => 'text',
						'title' => esc_html__('متن جستجوی پیشنهادی شما', 'your-project-name'),
						'desc' => esc_html__('نام جستجوی پیشنهادی خود را مثال آیفون 12 پرو وارد کنید توجه کنید این نام را دقیق وارد کنید', 'your-project-name'),
						'placeholder' => esc_html__('آیفون 12 پرو', 'your-textdomain-here'),
					),

				),
				),

			array(
				'id'       => 'options-image-search_ads',
				'type'     => 'media',
				'url'      => true,
				'title'    => 'تصویر تبلیغاتی جستجوی فروشگاه',
				'desc'     => 'شما در این بخش میتوانید تصویر تبلیغاتی خود را آپلود نمایید و در سایت برای مشتری نمایش دهید توجه کنید در صورت عدم آپلود نمایش نخواهد گرفت',
				'subtitle' => 'Original logo',
				'default'  => array(
					'url' => get_template_directory_uri() . '/img/ads_search.jpg'
				),
			),
		),
	)
);


Redux::set_section(
	$opt_name,
	array(
		'title'            => 'تنظیمات سربرگ',
		'id'               => 'basic-options-header-two-one',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p style="border-bottom: 2px solid #ddd;">میتوانید از این قسمت تنظیمات طرح هدر اول را کنترول و اصلاح نمایید</p>',
		'fields'           => array(
			/*color rgba header 1*/
			array(
				'id'       => 'basic-options-header-background-color',
				'type'     => 'color_palette',
				'title'    => 'پس زمینه سربرگ  (1.2) ',
				'subtitle' => 'background color header',
				'desc'     => 'میتوانید از این قسمت رنگ پس زمینه هدر خود را کنترول کنید',
				'default'  => '#fff',
				'options'  => array(
					'colors' => Redux_Helpers::get_material_design_colors( 'all' ),
					'size'   => 17,
				),
				'output'   => array(
					'color'     => '.widget-title',
					'important' => true,
				),
			),
			array(
				'id'       => 'background-text-search-box-one-21521515',
				'type'     => 'color',
				'title'    => 'رنگ تاپ بار و پس زمینه الگویی لوگو (2)',
				'subtitle' => 'color',
				'desc'     => 'شما میتوانید از این قسمت رنگ تاپ بار و پس زمینه الگویی لوگو را تغییر و شحصی سازی کنید توجه کنید این بخش مختص سربرگ طرح دوم میباشد',
				'validate' => 'color',
				'default'  => '#ff7f0d',
			),
			/*color rgba header 1*/
			/*text place holder search box header 1*/
			array(
				'id'       => 'text-search-box-one',
				'type'     => 'textarea',
				'title'    => 'متن محو باکس جستجو (1.2) ',
				'subtitle' => 'background header',
				'desc'     => 'متن محو باکس جستجو را وارد کنید توجه کنید متن محو متنی است که فقط قابلیت نمایشی و راهنمایی در باکس جستو وجود دارد و قابلیت کپی و انتخاب را ندارد به صورت پیش فرض (برای جستجو نام محصول را وارد کنید)',
				'default'  => 'برای جستجو نام محصول را وارد کنید',
			),

			array(
				'id'       => 'background-text-search-box-one',
				'type'     => 'color',
				'title'    => 'رنگ پس زمینه سرچ باکس (1.2) ',
				'subtitle' => 'color background theme search box',
				'desc'     => 'شما میتوانید از این قسمت رنگ پسزمینه باکس جستجو را تغییر دهید',
				'validate' => 'color',
			),

			array(
				'id'       => 'color-icon-search-box-ones',
				'type'     => 'color',
				'title'    => 'رنگ آیکون ذره بین باکس جستجو (1.2) ',
				'subtitle' => 'icon box search color',
				'desc'     => 'شما میتوانید از این قسمت رنگ آیکون ذره بین باکس سرچ را تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id' => 'on-off-text-wishlist-header',
				'type' => 'switch',
				'title' => esc_html__('وضعیت بخش علاقه مندی (1.2) ', 'your-textdomain-here'),
				'subtitle' => esc_html__('Enable and disable', 'your-textdomain-here'),
				'default' => true,
			),
			array(
				'id' => 'on-off-text-tel-header',
				'type' => 'switch',
				'title' => esc_html__('وضعیت باکس ارتباط (1.2) ', 'your-textdomain-here'),
				'subtitle' => esc_html__('Enable and disable', 'your-textdomain-here'),
				'default' => true,
			),
			array(
				'id'       => 'text-tel-header-call-text-number',
				'type'     => 'text',
				'title'    => 'متن یا شماره تلفن (1.2) ',
				'subtitle' => 'Store phone & text number',
				'desc'     => 'شما میتوانید از طریق این بخش شماره تلفن فروشگاه را تغییر دهید همچنین میتوانید از متن هایی مثل ارتباط در واتساپ هم استفاده کنید در صورت استفاده از متن میتوانید برای تغییر لینک هدایت مثال هدایت به چت واتساپ لینک هدایت را از قسمت تنظیمات متفرقه اعمال کنید در صورتی که شمااره موباایل و یا شماره تلفن وارد کردید مشکلی نیست لینک هدایت tel: خواهد بود تا به صورت مستقیم به اپ phone مشتری وارد شود',
				'default'  => '021000000',
			),
			array(
				'id'       => 'color-tel-icon-headers-number-3',
				'type'     => 'color',
				'title'    => 'رنگ آیکون تماس (1.2) ',
				'subtitle' => 'color picker | Call icon color',
				'desc'     => 'میتوانید از این قسمت رنگ آیکون تماس را تغییر دهید ',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-tel-icon-headers-number-3-32132',
				'type'     => 'color',
				'title'    => 'رنگ متن شماره تماس (1.2) ',
				'subtitle' => 'color picker | Call icon color',
				'desc'     => 'میتوانید از این قسمت رنگ متن شماره تماس را تغییر دهید ',
				'validate' => 'color',
			),
			array(
				'id' => 'on-off-text-traking-header',
				'type' => 'switch',
				'title' => esc_html__('وضعیت بخش پیگیری سفارشات (1.2) ', 'your-textdomain-here'),
				'subtitle' => esc_html__('Enable and disable', 'your-textdomain-here'),
				'default' => true,
			),
			array(
				'id'       => 'color-tel-paykire_color_back_vera',
				'type'     => 'color',
				'title'    => 'رنگ پس زمینه بخش پیگیری سفارشات (1.2) ',
				'subtitle' => 'The background color of the order tracking section',
				'desc'     => 'میتوانید از این قسمت رنگ پس زمینه بخش پیگیری سفارشات را تغییر دهید ',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-tel-paykire_color_back_vera-1',
				'type'     => 'color',
				'title'    => 'رنگ متن بخش پیگیری سفارشات (1.2) ',
				'subtitle' => 'The text color of the order tracking section',
				'desc'     => 'میتوانید از این قسمت رنگ متن بخش پیگیری سفارشات را تغییر دهید ',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-tel-paykire_color_back_vera-1231231',
				'type'     => 'color',
				'title'    => 'رنگ بردر یا گوشه های بخش پیگیری سفارشات (2.1) ',
				'subtitle' => 'The border color of the order tracking section',
				'desc'     => 'میتوانید از این قسمت رنگ  گوشه یا بردر بخش پیگیری سفارشات را تغییر دهید ',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-tel-description_menus_color',
				'type'     => 'color',
				'title'    => 'رنگ پس زمینه توضیحات فهرست (2.1) ',
				'subtitle' => 'The background color of the list description',
				'desc'     => 'میتوانید از این قسمت رنگ پس زمینه توضیحات فهرست را تغییر دهید ',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-tel-description_menus_color-1',
				'type'     => 'color',
				'title'    => 'رنگ متن توضیحات فهرست (2.1) ',
				'subtitle' => 'The text color of the list description',
				'desc'     => 'میتوانید از این قسمت رنگ متن توضیحات فهرست را تغییر دهید ',
				'validate' => 'color',
			),

			array(
				'id'       => 'color-a-i-wishlist-sabad-color',
				'type'     => 'color',
				'title'    => 'رنگ دکمه پس زمینه انیمیشنی در حالت هاور علاقه مندی و سبد خرید و ورود و عضویت (2.1) ',
				'subtitle' => 'background the button cart | wishlist',
				'desc'     => 'میتوانید از این قسمت رنگ پس زمینه دکمه های سبد خرید و علاقه مندی را  تغییر دهید',
				'validate' => 'color',
			),


			array(
				'id'       => 'color-a-i-wishlist-sabad-color-i-hover-text-color',
				'type'     => 'color',
				'title'    => 'رنگ پس زمینه  تعداد سبد خرید | علاقه مندی (2.1) ',
				'subtitle' => 'Color number number of shopping cart Ajax',
				'desc'     => 'میتوانید از این قسمت رنگ پس زمینه  تعداد سبد خرید | علاقه مندی را  تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'color-a-i-wishlist-sabad-dlklscolor-i-hover-text-color',
				'type'     => 'color',
				'title'    => 'رنگ متن تعداد سبد خرید | علاقه مندی (2.1) ',
				'subtitle' => 'Color number number of shopping cart Ajax',
				'desc'     => 'میتوانید از این قسمت رنگ متن تعداد سبد خرید | علاقه مندی را  تغییر دهید',
				'validate' => 'color',
			),

		)
		)
	);


Redux::set_section(
	$opt_name,
	array(
		'title'            => 'تنظیمات تاپ بار طرح دوم سربرگ (گیمو)',
		'id'               => 'basic-options-header-fore-fdsdfds',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p style="border-bottom: 2px solid #ddd;"> شما میتوانید این طریق این تنظیمات بخش تاپ بار طرح دوم سربرگ را کنترول کنید و تنظیمات را تغییر و شخصی سازی کنید </p>',
		'fields'           => array(

			array(
				'id' => 'on-off-text-mega-menu-header-1381-1',
				'type' => 'switch',
				'title' => esc_html__('وضعیت تاپ بار', 'your-textdomain-here'),
				'desc'     => 'شما میتوانید وضعیت نمایش تاپ بار طرح دوم سربرگ را کنترول کنید ',
				'subtitle' => esc_html__('Enable and disable', 'your-textdomain-here'),
				'default' => true,
			),

			array(
				'id'       => 'code_icon_tel_me_header_icons-1381-2',
				'type'     => 'text',
				'title'    => 'لینک هدایت شبکه اجتماعی اینستاگرام',
				'subtitle' => 'link instagram',
				'desc'     => 'میتوانید لینک شبکه اجتماعی اینستاگرام را کنترول کنید در صورت خالی گذاشتن نمایش داده نمیشود',
				'default'  => '#',
			),
			array(
				'id'       => 'code_icon_tel_me_header_icons-1381-3',
				'type'     => 'text',
				'title'    => 'لینک هدایت شبکه اجتماعی تلگرام',
				'subtitle' => 'link telegram',
				'desc'     => 'میتوانید لینک شبکه اجتماعی تلگرام را کنترول کنید در صورت خالی گذاشتن نمایش داده نمیشود',
				'default'  => '#',
			),
			array(
				'id'       => 'code_icon_tel_me_header_icons-1381-4',
				'type'     => 'text',
				'title'    => 'لینک هدایت شبکه اجتماعی فیسبوک',
				'subtitle' => 'link facebook',
				'desc'     => 'میتوانید لینک شبکه اجتماعی فیسبوک را کنترول کنید در صورت خالی گذاشتن نمایش داده نمیشود',
				'default'  => '#',
			),
			array(
				'id'       => 'code_icon_tel_me_header_icons-1381-5',
				'type'     => 'text',
				'title'    => 'لینک هدایت شبکه اجتماعی توییتر',
				'subtitle' => 'link twitter',
				'desc'     => 'میتوانید لینک شبکه اجتماعی توییتر را کنترول کنید در صورت خالی گذاشتن نمایش داده نمیشود',
				'default'  => '#',
			),
			array(
				'id'       => 'code_icon_tel_me_header_icons-1381-6',
				'type'     => 'text',
				'title'    => 'ایمیل شما',
				'subtitle' => 'email address',
				'desc'     => 'میتوانید آدرس ایمیل خود را وارد کنید و برای ارتباط کاربران فروشگاه با شما استفاده گردد توجه کنید که ایمیل خود را با فرمت خالی وارد کنید تا در صورت کلیک کاربر به ایمیل باکس خودشان هدایت شوند و در صورت خالی گذاشتن نمایش داده نمیشود',
				'default'  => 'shop@site.ir',
			),
			array(
				'id'       => 'code_icon_tel_me_header_icons-1381-7',
				'type'     => 'text',
				'title'    => 'تلفن شما',
				'subtitle' => 'tell number',
				'desc'     => 'میتوانید تلفن خود را برای ارتباط کاربران با فروشگاه وارد کنید توجه در صورت خالی گذاشتن نمایش داده نمیشود در تنظیمات پایین شما میتوانید انواع آیکون این بخش را کنترول کنید مثال واتساپ و همپنین لینک این بخش کنترول میگردد و نیازی نیست که حتما شماره تلفن وارد شود میتوانید ارتباط با واتساپ بنویسید و در لینک تنظیمات پایین لینک ارتباط با واتساپ را ست کنید و همپنین آیکون بخش را تغییر دهید',
				'default'  => '021000000',
			),
			array(
				'id'       => 'code_icon_tel_me_header_icons-1381-8',
				'type'     => 'text',
				'title'    => 'آیکون بخش تماس با ما (تلفن)',
				'subtitle' => 'icon box editor',
				'desc'     => 'شما میتوانید آیکون بخش تماس با ما (تلفن) را تغییر دهید مثال از آیکون تلفن به واتساپ یا تلگرام کد های آیکون به شرح مقابل میباشد توجه کنید که کد های آیکون با کاما(,) از هم جدا شده اند و شامل آیکون تلفن.موبایل.تلگرام.واتساپ.اینستااگرام میباشد ( fa-brands fa-telegram , fa-brands fa-whatsapp , fa-light fa-phone-volume , fa-light fa-mobile , fa-brands fa-instagram ) همچنین اگر کلاس آیکونی نباشد و این قسمت را خالی بگذارید آیکون نمایش داده نمیشود',
				'default'  => 'fa-light fa-phone-volume',
			),
			array(
				'id'       => 'code_icon_tel_me_header_iconsss-1381-9',
				'type'     => 'text',
				'title'    => ' (تلفن) لینک بخش تماس با ما',
				'subtitle' => 'link box editor',
				'desc'     => 'اگر میخواهید کاربر پس از کلیک روی روش ارتباطی شما مثل شماره تلفن یا آیکون اینستاگرام به لینکی دیگر هدایت شود در این قسمت لینک هدایت کاربر را بنویسید.',
			),
			array(
				'id'       => 'basic-options-header-search-ajax-10-1381-10',
				'type'     => 'color',
				'title'    => 'رنگ آیکون های تاپ بار',
				'subtitle' => 'color',
				'desc'     => 'شما میتوانید از این قسمت رنگ آیکون های تاپ بار را تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'basic-options-header-search-ajax-10-1381-12',
				'type'     => 'color',
				'title'    => 'رنگ متن های تاپ بار',
				'subtitle' => 'color',
				'desc'     => 'شما میتوانید از این قسمت رنگ متن های تاپ بار را تغییر دهید',
				'validate' => 'color',
			),
			array(
				'id'       => 'basic-options-header-search-ajax-10-1381-11',
				'type'     => 'color',
				'title'    => 'رنگ پس زمینه آیکون های تاپ بار',
				'subtitle' => 'color',
				'desc'     => 'شما میتوانید از این قسمت رنگ پس زمینه آیکون های تاپ بار را تغییر دهید',
				'validate' => 'color',
			),

		),
	)
);


Redux::set_section(
	$opt_name,
	array(
		'title'            => 'تنظیمات متفرقه',
		'id'               => 'basic-options-header-fore',
		'subsection'       => true,
		'customizer_width' => '450px',
		'desc'             => '<p style="border-bottom: 2px solid #ddd;">میتوانید ار این قسمت تنظیمات مواردی مانند متن محو باکس جستجو و یا متن سبد خرید و دکمه های را ویرایش و اصلاح کنید</p>',
		'fields'           => array(

			array(
				'id' => 'on-off-text-mega-menu-header',
				'type' => 'switch',
				'title' => esc_html__('وضعیت مگامنو فروشگاه', 'your-textdomain-here'),
				'desc'     => 'شما میتوانید مگامنو پیشرفته کلی فروشگاه که حاوی دسته بندی های فروشگاه میباشد غیر فعال و فعال نمایید توجه کنید که در صورت تغییر وضعیت وضعیت اعمال شده در بخش همبرگر منو یا به اصطلاح منو موبایل و در دسکتاپ اعمال میشود ',
				'subtitle' => esc_html__('Enable and disable', 'your-textdomain-here'),
				'default' => true,
			),
			array(
				'id' => 'on-off-text-main-menu-header',
				'type' => 'switch',
				'title' => esc_html__('وضعیت منو اصلی', 'your-textdomain-here'),
				'desc'     => 'شما میتوانید از طریق این بخش منو اصلی فروشگاه را غیر فعال و فعال سازی نمایید توجه کنید منو اصلی به دسته بندی دلخواه فروشگاه شما اشاره میشود و هر گونه تغییر وضعیت شما در دسکتاپ و موبایل و تبلت اعمال میگردد',
				'subtitle' => esc_html__('Enable and disable', 'your-textdomain-here'),
				'default' => true,
			),
			array(
				'id'       => 'code_icon_tel_me_header_icons',
				'type'     => 'text',
				'title'    => 'آیکون بخش تماس با ما',
				'subtitle' => 'icon box editor',
				'desc'     => 'شما میتوانید آیکون بخش تماس با ما را تغییر دهید مثال از آیکون تلفن به واتساپ یا تلگرام کد های آیکون به شرح مقابل میباشد توجه کنید که کد های آیکون با کاما(,) از هم جدا شده اند و شامل آیکون تلفن.موبایل.تلگرام.واتساپ.اینستااگرام میباشد ( fa-brands fa-telegram , fa-brands fa-whatsapp , fa-light fa-phone-volume , fa-light fa-mobile , fa-brands fa-instagram )',
				'default'  => 'fa-light fa-phone-volume',
			),
			array(
				'id'       => 'code_icon_tel_me_header_iconsss',
				'type'     => 'text',
				'title'    => 'لینک بخش تماس با ما',
				'subtitle' => 'link box editor',
				'desc'     => 'اگر میخواهید کاربر پس از کلیک روی روش ارتباطی شما مثل شماره تلفن یا آیکون اینستاگرام به لینکی دیگر هدایت شود در این قسمت لینک هدایت کاربر را بنویسید.',
			),

		),
	)
);





