<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
    return;
}
?>
<li <?php wc_product_class('', $product); ?>>
    <?php
    /**
     * Hook: woocommerce_before_shop_loop_item.
     *
     * @hooked woocommerce_template_loop_product_link_open - 10
     */
    do_action('woocommerce_before_shop_loop_item');

    ?>

    <div class="image-product">
        <figure>
            <span class="loading_images loading_imagesss"></span>

            <?php
            global $product;
            if (!empty($product->get_gallery_image_ids())) {
                $attachment_ids = $product->get_gallery_image_ids();
                $product_plan_two_img = wp_get_attachment_url($attachment_ids[0], 'large');
                ?>
                <img style="display:none;" class="img-product-sliders-1 loading_image" data-src="<?php echo get_the_post_thumbnail_url() ?>">
                <img  class="img-product-sliders-2" src="<?php echo $product_plan_two_img; ?>">
                <?php
            } else {
                ?>
                <div class="image_tak-related-product">
                    <?php
                    if (!empty(get_the_post_thumbnail())) {
                        ?>
                            <img style="display:none;" class="loading_image" data-src="<?php echo get_the_post_thumbnail_url() ?>">
                             <?php
                    }
                    else {
                        ?>
                        <img src="<?php echo get_template_directory_uri()."/img/not_found.jpg"; ?>">
                        <?php
                    }
                    ?>
                </div>
                <?php
            }
            ?>
            <?php
            global $options_vera_theme;
            $pro_product = get_post_meta(get_the_id(), 'metaboxe_product-offer_daghghgs', true);
            if ($pro_product == "on") {
            ?>
            <div class="shegeft_angiz_shop_items">
                <?php echo $options_vera_theme['on-off-text_shegeft_angiz']; ?>
            </div>
            <?php
            }
            ?>


        </figure>


    </div>
    <div class="columnd-1-set">
        <div class="category-one-list">
            <?php
            $product_id = $product->id;
            $primary_category = get_primary_product_category($product_id);

            if ($primary_category) {
                echo $primary_category;
            } else {
                echo 'No category';
            }
            ?>
        </div>
        <?php

        /**
         * Hook: woocommerce_shop_loop_item_title.
         *
         * @hooked woocommerce_template_loop_product_title - 10
         */
        ?>
        <a href="<?php echo get_permalink();  ?>">
        <?php
        do_action('woocommerce_shop_loop_item_title');
        ?>
        </a>
        <div class="price-product-woo">
            <?php
            global $product;
            echo $product->get_price_html();
            ?>
        </div>
        <?php if (is_plugin_active('dokan-lite/dokan.php')) { ?>
        <div style="width: 100%;float: right" class="dokan_store_name">
            <?php
            tidaweb_woo_sold_by();
            ?>
        </div>
        <?php  } ?>
        <div style="display: none" class="excript-product-item-columns-1">
            <?php
            the_excerpt();
            ?>
        </div>
        <div class="button-add_cart_ex">
            <?php
            /**
             * Hook: woocommerce_after_shop_loop_item.
             *
             * @hooked woocommerce_template_loop_product_link_close - 5
             * @hooked woocommerce_template_loop_add_to_cart - 10
             */
            do_action('woocommerce_after_shop_loop_item');

            ?>
            <?php global $product;
            $product_id = $product->get_id(); ?>
            <div class="like-containers">
                <a class="like-buttons" data-product-id="<?php echo $product_id; ?>"><i
                            class="fa-light fa-heart"></i></a>
                <a> <?php simple_product_saving_percentage() ?></a>
            </div>
        </div>
    </div>
</li>
