<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.9.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_cart'); ?>
<div class="div-cart-vera">
    <style>
        .div-cart-vera {
            display: flex;
            justify-content: space-between;
            align-items: start;
        }

        .div-cart-vera .woocommerce-cart-form {
            width: 69%;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item {
            width: 30%;
            padding: 10px 1.1%;
            float: right;
            box-shadow: rgba(0, 0, 0, 0.02) 0px 1px 3px 0px, rgba(27, 31, 35, 0.15) 0px 0px 0px 1px;
            background-color: #FFFFFF;
            overflow: hidden;
            margin-left: .5%;
            margin-right: .5%;
            margin-bottom: 10px;
            position: relative;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-remove a {
            position: absolute;
            right: 10px;
            top: 10px;
            z-index: 1;
            transition: all .3s ease-in-out;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-remove a:hover {
            background-color: #dc163e;
            color: #FFFFFF;
            transform: rotate(360deg);
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-price bdi {
            display: flex;
            align-items: center;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
            font-width: 600;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-price bdi .woocommerce-Price-currencySymbol {
            order: 1;
            padding-right: 3px;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-price bdi .woocommerce-Price-currencySymbol:after {
            content: var(--main-content);
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-name {
            overflow: hidden;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-name a {
            overflow: hidden;
            text-decoration: none;
            color: #222222;
            float: right;
            font-weight: 400;
            position: relative;
            font-size: 14px;
            width: 100%;
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 1
        }
        .div-cart-vera .woocommerce-cart-form .cart_item .product-thumbnail {
                height: 300px;
                display: flex;
                width: 96%;
                margin: 10px 2%;
                justify-content: center;
                align-items: center;
        }
        .div-cart-vera .woocommerce-cart-form .cart_item .product-thumbnail img {
                width: revert-layer !important;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .product-name a:after {
            content: "";
            position: absolute;
            left: 0;
            bottom: 0;
            height: 20%;
            width: 100%;
            background: linear-gradient(0deg, #ffffff57, #00000003);
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .quantity .qty input[type="number"] {
            -moz-appearance: textfield;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .quantity .qty:focus {
            outline: none;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .quantity .qty::-webkit-inner-spin-button,
        .div-cart-vera .woocommerce-cart-form .cart_item .quantity .qty::-webkit-outer-spin-button {
            -webkit-appearance: none;
            appearance: none;
            margin: 0;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .quantity {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .quantity .qty {
            font-family: IRANYekanX;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
            font-size: 15px;
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .quantity .plus {
            font-size: 12px;
            background: none;
            cursor: pointer;
            padding: 10px;
            background: #eaeaea;
            border-radius: 50%;
            color: rgba(0, 0, 0, 0.47);
        }

        .div-cart-vera .woocommerce-cart-form .cart_item .quantity .minus {
            font-size: 12px;
            background: none;
            cursor: pointer;
            padding: 10px;
            background: #eaeaea;
            border-radius: 50%;
            color: rgba(0, 0, 0, 0.47);
        }

        .div-cart-vera .woocommerce-cart-form .actions {
            width: 100%;
            float: right;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 15px 0;
            background-color: #FFFFFF;
            border-top: 1px solid rgba(27, 31, 35, 0.15);
            padding: 10px 0;
        }

        .div-cart-vera .woocommerce-cart-form .actions .coupon {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .div-cart-vera .woocommerce-cart-form .actions .coupon input[type="text"] {
            padding: 10px;
            font-family: 'IRANYekanX';
            border: 1px solid #ddddde;
        }

        .div-cart-vera .woocommerce-cart-form .actions .coupon input[type="text"]:focus {
            outline: none;
            border: 1px solid var(--main-color6);
        }

        .div-cart-vera .woocommerce-cart-form .actions .coupon button[type="submit"] {
            font-size: 14px;
            font-family: 'IRANYekanX';
            margin-right: 5px;
            padding: 12px;
            border: 0;
            background: var(--main-color);
            color: #fff;
            font-weight: 400;
            transition: all .3s ease-in-out;
        }

        .div-cart-vera .woocommerce-cart-form .actions > button.button {
            display: none !important;
        }

        .div-cart-vera .woocommerce-cart-form .actions button:hover {
            transform: scale(.9);
            background: var(--main-color) !important;
            color: #FFFFFF !important;
        }

        .div-cart-vera .cart-collaterals {
            float: left;
            width: 26%;
            padding: 10px 2%;
            border: 1px solid #dadadb;
        }

        .div-cart-vera .cart-collaterals h2 {
            font-weight: 300;
            font-size: 19px;
            padding-bottom: 10px;
        }

        .div-cart-vera .cart-collaterals .shop_table {
            border: none !important;
        }

        .div-cart-vera .cart-collaterals .shop_table tr th {
            font-weight: 400;
            width: 35%;
            padding-right: 0;
        }

        .div-cart-vera .cart-collaterals .shop_table tr td {
            text-align: left;
            width: 65%;
        }

        .div-cart-vera .cart-collaterals .shop_table tr td bdi {
            display: flex;
            align-items: center;
        }

        .div-cart-vera .cart-collaterals .shop_table tr td bdi {
            display: flex;
            align-items: center;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
        }

        .div-cart-vera .cart-collaterals .shop_table tr td bdi .woocommerce-Price-currencySymbol {
            order: 1;
            padding-right: 5px;
        }

        .div-cart-vera .cart-collaterals .shop_table tr td bdi .woocommerce-Price-currencySymbol:after {
            content: var(--main-content);
        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td {
            text-align: right !important;
        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td a.shipping-calculator-button {
            text-decoration: none;
            color: #222222;
            display: flex;
            align-items: center;
            margin: 10px 0;
        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td form.woocommerce-shipping-calculator {

        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td form.woocommerce-shipping-calculator .select2-selection__arrow b {
            top: 70%;
        }

        .select2-search--dropdown .select2-search__field {
            padding: 10px !important;
            font-family: IRANYekanX;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
            text-align: right;
        }

        .select2-search--dropdown .select2-search__field:focus {
            outline: none !important;
        }
        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td  form .form-row input.input-text {
            padding: 10px;
            width: 100%;
            font-family: IRANYekanX;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
            border-radius: 3px;
            border: 1px solid #a9a9a9;
        }
        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td form.woocommerce-shipping-calculator .select2-selection--single {
            display: flex;
            height: 40px;
            align-content: center;
            align-items: center;
        }
        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td form.woocommerce-shipping-calculator button {
            font-family: IRANYekanX;
            padding: 10px;
            font-size: 14px;
            background-color: var(--main-color);
            color: #FFFFFF;
            font-weight: 400;
            float: left;
        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td a.shipping-calculator-button:after {
            content: "\f078";
            font-family: FontAwesome;
            padding-right: 10px;
            font-size: 14px;
            opacity: .5;
        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td .woocommerce-shipping-destination {
            opacity: .5;
            margin: 5px 0;
        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td ul {
            background-color: unset !important;
            padding: 0 !important;
        }

        .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td ul li {
            background-color: unset !important;
            padding: 3px 0 !important;
        }

        .div-cart-vera .cart-collaterals .cart_totals {
            float: left;
            width: 100%;
        }
        .div-cart-vera .cart-collaterals .cart_totals a.checkout-button {
            width: 100%;
            text-align: center;
            padding: 17px 0;
            background: var(--main-color);
            border-radius: 10px;
        }
        i#gift-icon-cat-page {
            position: absolute;
            left: 10px;
            top: 10px;
            font-size: 20px;
            font-weight: 300;
            color: var(--main-color);
        }
        i#gift-icon-cat-page:after {
            content: "بسته بندی ویژه";
            position: absolute;
            left: 130%;
            width: max-content;
            top: 0;
            font-family: 'IRANYekanX';
            font-weight: 500;
            color: #ffffff;
            font-size: 13px;
            text-align: center;
            border-radius:3px;
            padding: 6px 5px;
            visibility: hidden;
            transition: all .3s ease-in-out;
            background: rgba(1, 1, 1, 0.62);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(7px);
            -webkit-backdrop-filter: blur(6px);
        }
        i#gift-icon-cat-page:hover:after {
            opacity: 1;
            visibility: visible;
            left: 120%;
        }
        .div-cart-vera .cart-collaterals .cart_totals a.checkout-button:before {
content: "\f07a";
            font-family: "Font Awesome 5 Pro";
            font-weight: 400;
            color:#FFFFFF;
            padding-left: 5px;
        }
        .blockElement {
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            border-radius: 0 !important;
        }
        .blockElement:before {
            content: " " !important;
            width: 40px !important;
            height: 40px !important;
            border-radius: 50% !important;
            border-right: 2px solid #222222;
            border-top: 2px solid #dddddd;
            border-bottom: 2px solid #dddddd;
            border-left: 2px solid #dddddd;
            animation:3s animate-lider-block infinite !important;
        }
        .div-cart-vera .blockOverlay:before {
            content: unset !important;
        }
        @keyframes animate-lider-block {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);

            }
        }
        .woocommerce ul#shipping_method li {
            display: flex;
            align-items: center;
            justify-content: right;
            font-size: 15px;
            font-weight: 600;
            border-radius: 10px;
            border: 3px solid #f0f1f2;
            padding: 10px 8px;
            background: rgba(255, 255, 255, .5215686275);
            cursor: pointer;
            position: relative;
        }
        .woocommerce ul#shipping_method li label {
            display: flex;
            align-items: center;
            justify-content: right;
            font-size: 13px;
            padding: 7px 10px;
        }
        .woocommerce ul#shipping_method li input {
            cursor: pointer;
            position: absolute;
            opacity: 0;
            margin: 0 !important;
            width: 100%;
            height: 100%;
            border-radius: 10px;
        }

        .woocommerce ul#shipping_method li input:checked + label:before {
            content: "";
            height: 100%;
            width: 100%;
            display: inline-block;
            position: absolute;
            background: #ffa41a;
            top: 0;
            right: 0;
            opacity: .07;
            color: #dd823b !important;
        }
        .div-cart-vera .ic-item-quantity-btn {
            display: none !important;
        }

        @media screen and (max-width: 1000px) {
            .div-cart-vera {
                flex-wrap: wrap;
            }
            footer {
                float: right;
                width: 100%;
            }
            .woocommerce table.shop_table_responsive tr:nth-child(2n) td, .woocommerce-page table.shop_table_responsive tr:nth-child(2n) td {
                background-color: rgba(0, 0, 0, 0);
            }
            .div-cart-vera .woocommerce-cart-form {
                width: 100%;
            }
            .div-cart-vera .cart-collaterals {
                width: 96%;
            }
            .div-cart-vera .woocommerce-cart-form .cart_item {
                width: 98%;
            }
            .div-cart-vera .cart-collaterals .shop_table tr td {
                text-align: left;
                width: 94%;
            }
            .div-cart-vera .cart-collaterals .shop_table tr.woocommerce-shipping-totals td:before {
               content: unset !important;
            }
            .div-cart-vera .cart-collaterals .shop_table tr td bdi {
                padding-right: 10px;
            }
        }
    </style>

    <?php


    add_action( 'wp_footer', 'ecommercehints_update_cart_on_quantity_change');
    function ecommercehints_update_cart_on_quantity_change() { ?>
        <script>
            jQuery( function( $ ) {
                let timeout;
                $("button.plus , button.minus").click(function() {
                    if ( timeout !== undefined ) {
                        clearTimeout( timeout );
                    }
                    timeout = setTimeout(function() {
                        $("[name='update_cart']").trigger("click");
                    }, 500 ); // 500 being MS (half a second)
                });
            } );
        </script>
    <?php }

    function bindQuantityButtons()
    {

        add_action('woocommerce_after_quantity_input_field', 'silva_display_quantity_plus');

        function silva_display_quantity_plus()
        {
            echo '<button type="button" class="plus hide-product" ><i class="fa-solid fa-plus-large"></i></button>';
        }

        add_action('woocommerce_before_quantity_input_field', 'silva_display_quantity_minus');

        function silva_display_quantity_minus()
        {
            echo '<button type="button" class="minus hide-product" ><i class="fa-solid fa-minus"></i></button>';
        }

        add_action('wp_footer', 'silva_add_cart_quantity_plus_minus');

        function silva_add_cart_quantity_plus_minus()
        {

            if (!is_product() && !is_cart()) return;

            wc_enqueue_js("   
            
      $('form.cart,form.woocommerce-cart-form').on( 'click', 'button.plus, button.minus', function() {
  
         var qty = $( this ).parent( '.quantity' ).find( '.qty' );
         var val = parseFloat(qty.val());
         var max = parseFloat(qty.attr( 'max' ));
         var min = parseFloat(qty.attr( 'min' ));
         var step = parseFloat(qty.attr( 'step' ));
 
         if ( $( this ).is( '.plus' ) ) {
            if ( max && ( max <= val ) ) {
               qty.val( max );
            } else {
               qty.val( val + step );
            }
         } else {
            if ( min && ( min >= val ) ) {
               qty.val( min );
            } else if ( val > 1 ) {
               qty.val( val - step );
            }
         }
 
      });
       
   ");
        }
    }

    bindQuantityButtons();

    ?>
    <script>
        function bindQuantityButtons() {
            $('form.cart,form.woocommerce-cart-form').on('click', 'button.plus, button.minus', function () {

                var qty = $(this).parent('.quantity').find('.qty');
                var val = parseFloat(qty.val());
                var max = parseFloat(qty.attr('max'));
                var min = parseFloat(qty.attr('min'));
                var step = parseFloat(qty.attr('step'));

                if ($(this).is('.plus')) {
                    if (max && (max <= val)) {
                        qty.val(max);
                    } else {
                        qty.val(val + step);
                    }
                } else {
                    if (min && (min >= val)) {
                        qty.val(min);
                    } else if (val > 1) {
                        qty.val(val - step);
                    }
                }

            });
            var updateButton = $('button[name="update_cart"]');
            $("button.plus").click(function () {
                updateButton.attr('disabled', false);
            })
            $("button.minus").click(function () {
                updateButton.attr('disabled', false);
            })

            jQuery( function( $ ) {
                let timeout;
                $("button.plus , button.minus").click(function() {
                    if ( timeout !== undefined ) {
                        clearTimeout( timeout );
                    }
                    timeout = setTimeout(function() {
                        $("[name='update_cart']").trigger("click");
                    }, 500 ); // 500 being MS (half a second)
                });
            } );

        }
        $(document).ready(function () {
        $('body').on('updated_wc_div', function () {
            bindQuantityButtons();
        });
        });
    </script>
    <form class="woocommerce-cart-form" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
        <?php do_action('woocommerce_before_cart_table'); ?>

        <div class="shop_table shop_table_responsive cart woocommerce-cart-form__contents">
            <div style="display: flex;justify-content:right;align-items: start;flex-wrap: wrap">
                <?php do_action('woocommerce_before_cart_contents'); ?>

                <?php
                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                    $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                    $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
                    /**
                     * Filter the product name.
                     *
                     * @param string $product_name Name of the product in the cart.
                     * @param array $cart_item The product in the cart.
                     * @param string $cart_item_key Key for the product in the cart.
                     * @since 2.1.0
                     */
                    $product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);

                    if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
                        $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                        ?>
                        <div class="woocommerce-cart-form__cart-item <?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">

                            <div class="product-thumbnail">
                                <?php
                                $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

                                if (!$product_permalink) {
                                    echo $thumbnail; // PHPCS: XSS ok.
                                } else {
                                    printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // PHPCS: XSS ok.
                                }
                                ?>
                            </div>

                            <div class="product-name woocommerce-loop-product__title" data-title="<?php esc_attr_e('Product', 'woocommerce'); ?>">
                                <?php
                                if (!$product_permalink) {
                                    echo wp_kses_post($product_name . '&nbsp;');
                                } else {
                                    /**
                                     * This filter is documented above.
                                     *
                                     * @since 2.1.0
                                     */
                                    echo wp_kses_post(apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s">%s</a>', esc_url($product_permalink), $_product->get_name()), $cart_item, $cart_item_key));
                                }

                                do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

                                // Meta data.
                                echo wc_get_formatted_cart_item_data($cart_item); // PHPCS: XSS ok.

                                // Backorder notification.
                                if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
                                    echo wp_kses_post(apply_filters('woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>', $product_id));
                                }
                                ?>
                            </div>

                            <div style="display: flex;justify-content: space-between;align-items: center">

                                <div class="product-price" data-title="<?php esc_attr_e('Price', 'woocommerce'); ?>">
                                    <?php
                                    echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // PHPCS: XSS ok.
                                    ?>
                                </div>

                                <div class="product-quantity"
                                     data-title="<?php esc_attr_e('Quantity', 'woocommerce'); ?>">
                                    <?php
                                    if ($_product->is_sold_individually()) {
                                        $min_quantity = 1;
                                        $max_quantity = 1;
                                    } else {
                                        $min_quantity = 0;
                                        $max_quantity = $_product->get_max_purchase_quantity();
                                    }

                                    $product_quantity = woocommerce_quantity_input(
                                        array(
                                            'input_name' => "cart[{$cart_item_key}][qty]",
                                            'input_value' => $cart_item['quantity'],
                                            'max_value' => $max_quantity,
                                            'min_value' => $min_quantity,
                                            'product_name' => $product_name,
                                        ),
                                        $_product,
                                        false
                                    );

                                    echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
                                    ?>
                                </div>
                            </div>
                            <div class="product-remove">
                                <?php
                                echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                    'woocommerce_cart_item_remove_link',
                                    sprintf(
                                        '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s"><i class="fa-light fa-circle-xmark"></i></a>',
                                        esc_url(wc_get_cart_remove_url($cart_item_key)),
                                        /* translators: %s is the product name */
                                        esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
                                        esc_attr($product_id),
                                        esc_attr($_product->get_sku())
                                    ),
                                    $cart_item_key
                                );
                                ?>
                            </div>

                        </div>
                        <?php
                    }
                }
                ?>

                <?php do_action('woocommerce_cart_contents'); ?>

                <div style="width: 100%;float: right">
                    <div colspan="6" class="actions">

                        <?php if (wc_coupons_enabled()) { ?>
                            <div class="coupon">
                                <label for="coupon_code"
                                       class="screen-reader-text"><?php esc_html_e('Coupon:', 'woocommerce'); ?></label>
                                <input type="text" name="coupon_code" class="input-text" id="coupon_code" value=""
                                       placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>"/>
                                <button type="submit"
                                        class="button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                        name="apply_coupon"
                                        value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?></button>
                                <?php do_action('woocommerce_cart_coupon'); ?>
                            </div>
                        <?php } ?>

                        <button type="submit"
                                class="button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                name="update_cart"
                                value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>

                        <?php do_action('woocommerce_cart_actions'); ?>

                        <?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
                    </div>
                </div>

                <?php do_action('woocommerce_after_cart_contents'); ?>
            </div>
        </div>
        <?php do_action('woocommerce_after_cart_table'); ?>
    </form>

    <?php do_action('woocommerce_before_cart_collaterals'); ?>

    <div class="cart-collaterals">
        <?php
        /**
         * Cart collaterals hook.
         *
         * @hooked woocommerce_cross_sell_display
         * @hooked woocommerce_cart_totals - 10
         */
        do_action('woocommerce_cart_collaterals');
        ?>
    </div>
</div>
<?php do_action('woocommerce_after_cart'); ?>
