<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header('shop');

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
?>
    <style>
        .product-cats {
            display: none !important;
        }

        header.woocommerce-products-header {
            width: 100%;
            float: right;
            padding: 20px 0;
            display: grid;
            justify-content: center;
            align-items: center;
            justify-items: center;
            position: relative;
            margin-bottom: 25px;
        }

        header.woocommerce-products-header .background_image_headre-woo {
            width: 100%;
            float: right;
            position: absolute;
            height: 100%;
            background-color: #f1f2f6;
            -webkit-mask-image: linear-gradient(black, transparent);
            mask-image: linear-gradient (black, transparent);
            background-repeat: no-repeat;
            background-size: cover !important;
            background-position: center center !important;
            background-repeat: no-repeat !important;
        }

        header.woocommerce-products-header h1 {
            text-align: center;
            font-weight: 500;
            padding: 10px 0 5px;
            z-index: 1;
        }

        @media screen and (max-width: 1000px) {
            header.woocommerce-products-header .woocommerce-breadcrumb {
                display: flex !important;
                flex-wrap: wrap;
            }
        }

        header.woocommerce-products-header .woocommerce-breadcrumb {
            font-weight: 500;
            width: 100%;
            float: right;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 5px;
            padding-top: 10px;
            background: none !important;
        }

        header.woocommerce-products-header .woocommerce-breadcrumb a {
            padding: 0 3px;
            text-decoration: none;
            color: #222222 !important;
        }

        header.woocommerce-products-header .woocommerce-breadcrumb i {
            padding: 0 8px;
            color: rgba(34, 34, 34, 0.66) !important;
        }

        header.woocommerce-products-header .woocommerce-breadcrumb span {
            color: rgba(34, 34, 34, 0.66);
        }

        header.woocommerce-products-header .term-description {
            z-index: 1 !important;
        }

        header.woocommerce-products-header .term-description p {
            padding: 0px 10px;
            margin-top: 10px;
            background: #a9a9a936;
            border-radius: 50px;
            color: #222;
            font-size: 12px;
        }

        .vera-div-woocommerce-shop {
            display: flex;
            width: 100%;
            justify-content: space-between;
            margin: 25px auto;
        }

        .div-heade-shop-before-total-product {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            float: right;
            width: 100%;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
            margin-bottom: 30px;
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 {

        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i {
            margin-left: 6px;
            padding: 5px;
            font-size: 20px;
            cursor: pointer;
            position: relative;
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i:after {
            content: "";
            position: absolute;
            background: #222222;
            padding: 2px 5px 4px;
            /* top: 100%; */
            top: -135%;
            z-index: 1;
            right: -100%;
            font-family: 'IRANYekanX';
            color: #fff;
            left: -100%;
            opacity: 0;
            visibility: hidden;
            text-align: center;
            font-weight: 200;
            font-size: 13px;
            line-height: 23px;
            display: flex;
            align-content: center;
            align-items: center;
            justify-content: center;
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i:hover:after {
            opacity: 1;
            visibility: visible;
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i.fa-list:after {
            content: "لیست";
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i.fa-grid:after {
            content: "3 ستون";
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i.fa-grid-2:after {
            content: "2 ستون";
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i.fa-grid-4:after {
            content: "4 ستون";
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 i:last-child {
            margin-left: 0;
        }

        .div-heade-shop-before-total-product .div-heade-shop-before-total-product-2 {

        }

        .div-heade-shop-before-total-product ul.list-sort_by {
            width: auto;
            float: right;
            z-index: 20;
        }

        .div-heade-shop-before-total-product ul.list-sort_by li:hover {
            box-shadow: 0 0 0 1px #dddddd91;
            border-radius: 10px 10px 0 0;
        }

        .div-heade-shop-before-total-product ul.list-sort_by li ul li {
            box-shadow: none !important;
            border-radius: 0 !important;
        }

        .div-heade-shop-before-total-product ul.list-sort_by li ul li:hover {
            background: rgba(44, 62, 80, 0.11);
        }

        .div-heade-shop-before-total-product ul.list-sort_by li {
            float: right;
            padding: 5px 10px ;
            background: #ffffff;
            text-align: right;
            position: relative;
            color: #303841;
            cursor: pointer;
            width: fit-content;
            list-style: none;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }


        .div-heade-shop-before-total-product ul.list-sort_by li i {
            padding-right: 15px;
        }

        .div-heade-shop-before-total-product ul.list-sort_by li ul {
            position: absolute;
            right: 0;
            top: 100%;
            border-radius: 0 0 10px 10px;
            color: #303841;
            background: #FFFFFF;
            width: 100%;
            z-index: 3;
            overflow: hidden;
            height: 0;
            box-shadow: 0 1px 0 1px #dddddd91;
            opacity: 0;
            visibility: hidden;
        }

        .div-heade-shop-before-total-product ul.list-sort_by li:hover ul {
            height: auto;
            opacity: 1;
            visibility: visible;
        }

        .div-heade-shop-before-total-product ul.list-sort_by ul li i {
            order: 2;
            padding-right: 15px;
        }
        .div-heade-shop-before-total-product ul.list-sort_by ul li  {
            width: 100%;
        }

        .div-heade-shop-before-total-product ul.list-sort_by li a {
            text-decoration: none;
            color: #303841;
            width: 100%;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
        }

        /*star  archive item code*/

        .loadingss {
            display: flex;
            align-items: start;
            justify-content: center;
            position: absolute;
            right: -1%;
            height: 102%;
            width: 102%;
            left: -1%;
            top: -1%;
            bottom: -100%;
            background: #FFFFFF;
            z-index: 10;
        }

        .loadingss::after {
            background: rgba(255, 255, 255, 0) !important;
            content: " " !important;
            width: 35px !important;
            height: 35px !important;
            border-radius: 50% !important;
            border-right: 2px solid #000000;
            border-top: 2px solid rgba(221, 221, 221, 0.5);
            border-bottom: 2px solid rgba(221, 221, 221, 0.5);
            border-left: 2px solid rgba(221, 221, 221, 0.5);
            animation-name: animate-lider-block !important;
            animation-duration: 1s;
            animation-iteration-count: infinite;
            z-index: 11;
            margin-top: 80px;
        }

        /**style email box send stock + **/

        .vera-div-woocommerce-shop-right {

        }

        .vera-div-woocommerce-shop-right ul.products {
            display: flex;
            flex-wrap: wrap;
            justify-content: right;
            position: relative;
            float: right;
            width: 100%;
            padding: 0;
            margin: 0;
        }

        .vera-div-woocommerce-shop-right ul.products li {
            overflow: hidden;
            box-shadow: 0 0 0 0.5px #ddd;
            background: #FFFFFF;
        }

        .vera-div-woocommerce-shop-right ul.columns-4 li {
            float: right !important;
            margin: 0 0 !important;
            width: 25% !important;
            padding-top: 10px !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-3 li {
            float: right !important;
            margin: 0 0 !important;
            width: 33.30% !important;
            padding-top: 10px !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li {
            float: right !important;
            margin: 0 0 !important;
            width: 50% !important;
            padding-top: 10px !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li {
            float: right !important;
            margin: 10px 0 !important;
            width: 100% !important;
            background: none !important;
            display: flex;
            justify-content: right;
            border-bottom: 1px solid #cccccc;
            box-shadow: none !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li:last-child {
            border-bottom: none !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set {
            width: 69%;
            float: left;
            text-align: right;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
        }

        .vera-div-woocommerce-shop-right ul.products li .image-product figure {
            position: relative;
            height: 300px;
            display: flex;
            width: 96%;
            margin: 10px 2%;
            justify-content: center;
            align-items: center;
        }
        .vera-div-woocommerce-shop-right ul.products li .image-product figure .shegeft_angiz_shop_items {
            position: absolute;
            bottom: 10px;
            right: 10px;
            color: var(--main-color);
            font-family: digikala;
            box-shadow: inset 0 0 20px #fff;
            font-size: 15px;
            padding: 7px 10px 3px;
            border: .5px solid var(--main-color);
            line-height: 1;
            border-radius: 26px;
        }

        .vera-div-woocommerce-shop-right ul.products li .image-product img {
            max-width: 100% !important;
            max-height: 100%;
            height: fit-content !important;
            border-radius: 0;
            width: auto !important;
        }

        .vera-div-woocommerce-shop-right ul.products li .image-product img.img-product-sliders-2 {
            opacity: 0;
            visibility: hidden;
            top: auto;
            right: auto;
            width: 100%;
            position: absolute;
            transition: all .4s linear 0s;
        }

        .vera-div-woocommerce-shop-right ul.products li .image-product img.img-product-sliders-1 {
            transition: all .4s linear 0s;
        }

        .vera-div-woocommerce-shop-right ul.products li:hover .image-product .img-product-sliders-1 {
            opacity: 0;
            visibility: hidden;
        }

        .vera-div-woocommerce-shop-right ul.products li:hover .image-product .img-product-sliders-2 {
            opacity: 1;
            visibility: visible;
            position: absolute;
        }

        .vera-div-woocommerce-shop-right ul.products li a {
            text-decoration: none !important;
            color: #222222;
            text-align: center;
            margin: 10px auto;
        }

        .vera-div-woocommerce-shop-right ul.products .loading {
            display: flex;
            align-items: start;
            justify-content: center;
            position: relative !important;
            height: 100%;
            width: 100%;
            z-index: 10;
        }

        .vera-div-woocommerce-shop-right ul.products li a.button {
            display: inline-block;
            margin: 15px 0;
            width: 90%;
            padding: 0 0;
            background: none !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li a.button, .vera-div-woocommerce-shop-right ul.columns-3 li a.button, .vera-div-woocommerce-shop-right ul.columns-4 li a.button {
            margin: 10px 0 10px !important;
            padding: 12px 20px;
            display: flex !important;
            width: fit-content;
            background: var(--main-color) !important;
            color: #FFFFFF;
            font-weight: 500;
            border-radius:5px;
            align-items: center;
            justify-content: center;
            transition: all .3s linear;
        }

        @keyframes animate-shadow-animate {
            0% {
                box-shadow: 0 0 0 var(--main-color);
            }
            100% {
                box-shadow: 0 0 0 5px rgba(255, 255, 248, 0);
            }
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li a.button:hover, .vera-div-woocommerce-shop-right ul.columns-3 li a.button:hover, .vera-div-woocommerce-shop-right ul.columns-4 li a.button:hover {
            color: var(--main-color) !important;
            background: #FFFFFF !important;
            transition: all .3s linear;
        }


        .vera-div-woocommerce-shop-right ul.products li a.added_to_cart {
            display: none !important;
        }

        .vera-div-woocommerce-shop-right ul.products li .woocommerce-loop-product__title {
            font-size: 14px !important;
            font-weight: 400;
            padding: 0 2.5% 5px !important;
            line-height: 25px;
            display: flex;
            height: 50px;
            overflow: hidden;
            width: 95%;
            float: right;
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 2;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers {
            position: absolute;
            right: 10px;
            top: 10px;
            width: auto;
            padding: 0;
            transform: translateX(200%);
            transition: .5s linear;
            display: grid;
            justify-items: center;
            align-items: start;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li:hover .like-containers, .vera-div-woocommerce-shop-right ul.columns-3 li:hover .like-containers, .vera-div-woocommerce-shop-right ul.columns-4 li:hover .like-containers {
            transform: translateX(0);
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers .like-buttons, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers .like-buttons, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers .like-buttons {
            padding: 7px !important;
            margin: 0 !important;
            background: #ffffff;
            border-radius: 50%;
            box-shadow: 0 0 5px 1px #cbcbcb;
            position: relative;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers .like-buttons:before, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers .like-buttons:before, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers .like-buttons:before {
            font-weight: 200;
            content: "افزودن به علاقه مندی ها";
            width: max-content;
            padding: 3px 6px;
            background: #222222;
            position: absolute;
            right: 150%;
            font-size: 11px;
            top: 0;
            color: #fff;
            opacity: 0;
            z-index: 2;
            visibility: hidden;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers .like-buttons:after, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers .like-buttons:after, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers .like-buttons:after {
            font-weight: 200;
            content: "";
            width: 13px;
            height: 13px;
            background: #222222;
            position: absolute;
            right: 130%;
            font-size: 11px;
            transform: rotate(45deg);
            top: 30%;
            z-index: 1;
            color: #fff;
            opacity: 0;
            visibility: hidden;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers .like-buttons:hover:before, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers .like-buttons:hover:before, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers .like-buttons:hover:before {
            opacity: 1;
            visibility: visible;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers .like-buttons:hover:after, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers .like-buttons:hover:after, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers .like-buttons:hover:after {
            opacity: 1;
            visibility: visible;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers .like-buttons i, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers .like-buttons i, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers .like-buttons i {
            margin: 0 !important;
            font-size: 16px !important;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo {
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
            width: 100%;
            float: right;
            padding: 5px 0;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: center;
            height: 60px;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo > .woocommerce-Price-amount > bdi {
            padding: 0 4px 0 4px;
            width: fit-content;
            float: right;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo  bdi {
            float: right;
            padding: 0 5px;
            display: flex;
            justify-content: center;
            width: fit-content;
            font-weight: 600;
            font-size: 16px;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo ins bdi {
            float: right;
            padding: 0 5px;
            display: flex;
            justify-content: center;
            width: fit-content;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo del bdi {
            float: right;
            padding: 0 5px;
            display: flex;
            justify-content: center;
            width: fit-content;
            opacity: .8 !important;
            font-size: 14px !important;
            font-weight: 500 !important;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo bdi .woocommerce-Price-currencySymbol {
            padding-right: 2px;
            order: 1;
            float: left;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo bdi .woocommerce-Price-currencySymbol:after {
            content: var(--main-content);
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo del {
            opacity: .5 !important;
            float: right;
            text-align: center;
            display: flex;
            width: 100%;
            justify-content: center;
        }

        .vera-div-woocommerce-shop-right ul.products li .price-product-woo ins {
            text-decoration: none;
            font-size: 16px;
            float: right;
            width: 100%;
            font-weight: 600;
            text-align: center;
            display: flex;
            justify-content: center;
        }

        .vera-div-woocommerce-shop-right ul.columns-4 li .columnd-1-set {
            text-align: center;
        }

        .vera-div-woocommerce-shop-right ul.columns-3 li .columnd-1-set {
            text-align: center;
        }

        .vera-div-woocommerce-shop-right ul.columns-2 li .columnd-1-set {
            text-align: center;
        }


        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .excript-product-item-columns-1 {
            display: block !important;
            float: right;
            width: 100%;
            padding: 10px 0;
            text-align: justify;
            opacity: .6;
            font-weight: 400;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .woocommerce-loop-product__title {
            text-align: right;
            font-size: 18px !important;
            font-weight: 400;
            float: right;
            width: 100%;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li a.button {
            height: fit-content !important;
            padding: 15px 30px !important;
            float: left !important;
            margin: 0 10px !important;
            text-align: center !important;
            border-radius: 0;
            width: fit-content;
            border: 2px solid #ddd;
            color: #22222291;
            transition: all .3s ease-in-out;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li a.button:hover {
            background: var(--main-color) !important;
            color: #FFFFFF;
            border-color: var(--main-color) !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .button-add_cart_ex {
            display: flex !important;
            justify-content: right !important;
            align-items: center !important;
            width: 100% !important;
            padding: 20px 0;
            flex-direction: row-reverse;
        }
        .vera-div-woocommerce-shop-right ul.columns-1 li .button-add_cart_ex #saving_total_price {
            order: -1;
            margin: 5px 10px !important;
        }
        .vera-div-woocommerce-shop-right ul.products li .button-add_cart_ex {
            display: flex;
            float: right;
            align-items: center;
            justify-content: center;
            margin: auto;
            width: 100%;
        }
        .vera-div-woocommerce-shop-right ul.products li .button-add_cart_ex #saving_total_price {
            margin: 0;
            height: 28px;
            font-size: 13px;
            display: flex;
            width: 28px;
            float: right;
            font-family: 'IRANYekanX' !important;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
            border-radius: 50%;
            position: relative;
            background: var(--main-color);
            color: #fff;
            align-items: center;
            justify-content: center;
            transition: all 1s ease-in-out;
            animation: 1s animate-shadow-animate infinite  !important;
        }

            .vera-div-woocommerce-shop-right ul.products li .columnd-1-set .category-one-list {
            opacity: .6;
            transition: all .3s ease-in-out;
            font-size: 12px;
            font-weight: 400;
            width: 100%;
            text-align: center;
            float: right;
        }

        .vera-div-woocommerce-shop-right ul.products li .columnd-1-set .category-one-list:hover {
            opacity: 1;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .category-one-list {
            text-align: right !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .button-add_cart_ex .like-containers {
            float: right;
            width: fit-content;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .button-add_cart_ex .like-containers a.like-buttons {

        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .price-product-woo {
            float: right;
            justify-content: right;
            height: auto !important;
        }
        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .price-product-woo bdi {

        }
        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .price-product-woo del  {
            width: fit-content !important;
        }
        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .price-product-woo ins  {
            width: fit-content !important;
        }
        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .price-product-woo .price-vera_start_p {
            display:flex;
            justify-content: right;
            align-items:center;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li > .woocommerce-LoopProduct-link:first-child {
            float: right;
            width: 25% !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set .woocommerce-LoopProduct-link:first-child {
            float: left;
            width: 96%;
            margin: auto;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .image-product {
            float: right;
            width: 100% !important;
        }

        .iconic-available-attributes {
            margin: 0 !important;
            position: absolute;
            left: 10px;
            top: 10px;
            display: block;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .iconic-available-attributes {
            right: 10px;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .iconic-available-attributes span {
            right: 120%;
        }

        .iconic-available-attributes .item-color-shop-loop-tootal {
            width: 17px;
            height: 17px;
            border-radius: 50%;
            border: 1px solid #ddd;
            margin-bottom: 6px;
            position: relative;
        }

        .iconic-available-attributes .item-color-shop-loop-tootal span {
            position: absolute;
            left: 110%;
            background: #ffffff;
            border: 1px solid #ddd;
            padding: 0 7px;
            color: #222;
            border-radius: 5px;
            font-weight: 500;
            font-size: 11px;
            width: max-content;
            opacity: 0;
            visibility: hidden;
            top: -3px;
            transition: all .2s ease-in-out;
        }

        .iconic-available-attributes .item-color-shop-loop-tootal:hover span {
            opacity: 1;
            visibility: visible;
            left: 130%;
        }


        .vera-div-woocommerce-shop-right ul.columns-1 li .image-product figure {
            float: right;
            width: 100% !important;
            margin: 10px !important;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .image-product figure img {
            max-width: 100% !important;
            height: auto !important;
        }

        .vera-div-woocommerce-shop-right ul.products li .loading {
            display: flex;
            align-items: center;
            justify-content: center;
            right: 0;
            height: 100%;
            width: 100%;
            left: 0;
            top: 0;
            bottom: 0;
            background: #FFFFFF;
        }

        .vera-div-woocommerce-shop-right ul.products li .loading:before {
            content: "";
            position: absolute;
            right: 0;
            height: 100%;
            width: 100%;
            left: 0;
            top: 0;
            bottom: 0;
            background: #FFFFFF;
            z-index: 10;
        }

        .vera-div-woocommerce-shop-right ul.products li .loading::after {
            background: rgba(255, 255, 255, 0) !important;
            content: " " !important;
            width: 15px !important;
            height: 15px !important;
            border-radius: 50% !important;
            border-right: 2px solid #000000;
            border-top: 2px solid rgba(221, 221, 221, 0.5);
            border-bottom: 2px solid rgba(221, 221, 221, 0.5);
            border-left: 2px solid rgba(221, 221, 221, 0.5);
            animation-name: animate-lider-block !important;
            animation-duration: 1s;
            animation-iteration-count: infinite;
            z-index: 11;
            right: auto;
            left: auto;
            position: absolute;
        }

        .vera-div-woocommerce-shop-right ul.columns-1 li .loading::after {
            position: absolute;
            top: 30%;
            right: 45%;
        }

        .price-vera_start_p {
            display: grid;
            width: fit-content;
        }
        .price-vera_start_p bdi {
            padding: 6px 0 !important;
        }

        .list-sort_bys {
            display: none;
        }
        @media screen and (max-width: 1000px) {
            .vera-div-woocommerce-shop .vera-div-woocommerce-shop-side {
                position: fixed;
                right: 0;
                left: 0;
                top: 0;
                background: #fff;
                width: 90% !important;
                z-index: 2000;
                padding: 10px 5%;
                transform: translateY(105%);
                transition: all 1s linear(0 0%, 0 1.8%, 0.01 3.6%, 0.03 6.35%, 0.07 9.1%, 0.13 11.4%, 0.19 13.4%, 0.27 15%, 0.34 16.1%, 0.54 18.35%, 0.66 20.6%, 0.72 22.4%, 0.77 24.6%, 0.81 27.3%, 0.85 30.4%, 0.88 35.1%, 0.92 40.6%, 0.94 47.2%, 0.96 55%, 0.98 64%, 0.99 74.4%, 1 86.4%, 1 100%);
                overflow: auto;
                height: 100%;
            }

            .show-side-bar_woocommerce {
                transform: translateY(0) !important;
            }

            .vera-div-woocommerce-shop .vera-div-woocommerce-shop-right {
                width: 100% !important;
            }

            .vera-div-woocommerce-shop-right ul.columns-3 li {
                width: 49% !important;
                border: 1px solid  #ddd !important;
                box-shadow: none !important;
            }
            .vera-div-woocommerce-shop-right ul.products li .price-product-woo > .woocommerce-Price-amount > bdi {
                padding: 0 !important;
            }
            .vera-div-woocommerce-shop-right ul.products li .image-product figure {
                height: 150px ;
            }
            .vera-div-woocommerce-shop-right ul.products li .price-product-woo > .woocommerce-Price-amount > bdi {
                width: 100% !important;
                float: right !important;
                display: flex !important;
                justify-content: center !important;
            }
            .vera-div-woocommerce-shop-right ul.columns-1 li {
                flex-wrap: wrap;
            }
            .vera-div-woocommerce-shop-right ul.columns-1 li > .woocommerce-LoopProduct-link:first-child {
                width: 100% !important;
            }
            .vera-div-woocommerce-shop-right ul.columns-1 li .image-product figure {
                height: auto !important;
            }
            .vera-div-woocommerce-shop-right ul.columns-1 li .image-product figure {
                height: auto !important;
                margin: 0 !important;
            }
            .vera-div-woocommerce-shop-right ul.columns-1 li .columnd-1-set {
                width: 100% !important;
            }
            .vera-div-woocommerce-shop-right ul.columns-4 li {
                width: 50% !important;
            }
            .div-heade-shop-before-total-product .div-heade-shop-before-total-product-1 {
                display: none !important;
            }
            .list-sort_by {
                display: none !important;
            }
            .list-sort_bys {
                display: block !important;
            }
            .list-sort_bys label {

            }
            .list-sort_bys label i {
                padding-right: 3px;
                opacity: .7;
            }
            .list-sort_bys select {
                position: absolute;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                padding: 0;
                width: 100%;
                border: none;
                background: transparent;
                font-weight: 400;
                text-indent: -9999px;
                -webkit-appearance: none;
                -moz-appearance: none;
            }
            .list-sort_bys select {
                vertical-align: top;
            }
            .vera-div-woocommerce-shop-right ul.columns-2 li .like-containers, .vera-div-woocommerce-shop-right ul.columns-3 li .like-containers, .vera-div-woocommerce-shop-right ul.columns-4 li .like-containers {
                transform: translateX(0) !important;
            }
            .vera-div-woocommerce-shop-right ul.columns-2 li a.button, .vera-div-woocommerce-shop-right ul.columns-3 li a.button, .vera-div-woocommerce-shop-right ul.columns-4 li a.button {
                padding: 7.5px 10px !important;
                font-size: 12px !important;
            }
            .vera-div-woocommerce-shop-right ul.products li .button-add_cart_ex #saving_total_price {
                font-size: 13px !important;
            }  .vera-div-woocommerce-shop-right ul.products li .button-add_cart_ex #saving_total_price:before {
               bottom: 30% !important;
            }

        }
        .woocommerce nav.woocommerce-pagination ul  {
           width: 100%;
            overflow: auto;
            margin: 15px 0;
            display: flex;
            justify-content: center;
            align-items: center;
            float: right;
            border: none !important;
        }
        .woocommerce nav.woocommerce-pagination ul li {
           margin: 0 5px;
            border: none !important;
            -moz-font-feature-settings: "ss02" !important;
            -webkit-font-feature-settings: "ss02" !important;
            font-feature-settings: "ss02" !important;
        }
        .woocommerce nav.woocommerce-pagination ul li a {
           text-decoration: none;
            color:#222222;
            background: none !important;
            padding: 10px;
            border: .5px solid #ddd;
            border-radius: 5px;
        }
        .woocommerce nav.woocommerce-pagination ul li span {
           text-decoration: none;
            color:#222222;
            background: none !important;
            padding: 10px;
            border: .5px solid #ddd;
            border-radius: 3px;
        }
    </style>
    <header class="woocommerce-products-header">
        <?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
            <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
            <div class="background_image_headre-woo"></div>
        <?php endif; ?>
        <?php if (is_shop()) { ?>
            <nav class="woocommerce-breadcrumb">
                <a href="<?php echo get_home_url(); ?>">خانه</a>
                <i class="fa-light fa-angle-left"></i>
                <span>فروشگاه</span>
            </nav>
            <?php
        } else {
            if (function_exists('woocommerce_breadcrumb')) {
                woocommerce_breadcrumb(array(
                    'delimiter' => ' <i class="fa fa-angle-left"></i> ',
                    'wrap_before' => '<nav class="woocommerce-breadcrumb">',
                    'wrap_after' => '</nav>',
                    'before' => '<span>',
                    'after' => '</span>',
                    'home' => _x('خانه', 'breadcrumb', 'woocommerce'),
                ));
            }
        }
        ?>
        <?php

        /**
         * Hook: woocommerce_archive_description.
         *
         * @hooked woocommerce_taxonomy_archive_description - 10
         * @hooked woocommerce_product_archive_description - 10
         */
        do_action('woocommerce_archive_description');
        ?>
    </header>
    <div class="vera-div-woocommerce-shop woocommerce container">
        <div id="product_woocommerce" class="vera-div-woocommerce-shop-right">
            <?php
            if (woocommerce_product_loop()) {

                /**
                 * Hook: woocommerce_before_shop_loop.
                 *
                 * @hooked woocommerce_output_all_notices - 10
                 * @hooked woocommerce_result_count - 20
                 * @hooked woocommerce_catalog_ordering - 30
                 */
                function after_woocommerce_before_shop_loop()
                {
                    echo '<div class="div-heade-shop-before-total-product-1">
<i id="list-shop" class="fa-light fa-list"></i>
<i id="list-grid-2" class="fa-light fa-grid-2"></i>
<i id="list-grid" class="fa-light fa-grid"></i>
<i id="list-grid-4" class="fa-light fa-grid-4"></i>
                        </div>';
                }

                add_action("woocommerce_before_shop_loops", "after_woocommerce_before_shop_loop");
                function after_woocommerce_before_shop_loopss()
                {
                    echo '<div class="div-heade-shop-before-total-product-2">
  ' . woocommerce_result_count() . '
                        </div>';
                }

                add_action("woocommerce_before_shop_loops", "after_woocommerce_before_shop_loopss");
                ?>
                <div class="div-heade-shop-before-total-product">
                    <?php
                    // Add Sort by select box
                    function custom_sort_by()
                    {

                        $url = wc_get_page_permalink('shop');
                        echo "<ul class='list-sort_by'>";
                        echo "<li>مرتب سازی بر اساس <i class='fa-light fa-caret-down'></i>";
                        echo '<ul class="sort-by">';

                        echo '<li><a href="' . $url . '?orderby=popularity">محبوب ترین</a></li>';

                        echo '<li><a href="' . $url . '?orderby=rating">پرفروش ترین</a></li>';

                        echo '<li><a href="' . $url . '?orderby=date">جدیدترین</a></li>';

                        echo '<li><a href="' . $url . '?orderby=price">ارزان ترین</a></li>';

                        echo '<li><a href="' . $url . '?orderby=price-desc">گران ترین</a></li>';

                        echo '</ul>';
                        echo '</li>';
                        echo '</ul>';


                        echo "<div class='list-sort_bys'>";
                        echo "<label for='sort'>مرتب سازی بر اساس <i class='fa-regular fa-arrow-down-short-wide'></i></label>";
                        echo "<select  name='sort'>";
                        echo '<option selected ><a>مرتب سازی بر اساس پیش فرض</a></option>';
                        echo '<option><a href="' . $url . '?orderby=popularity">مرتب سازی بر اساس محبوب ترین</a></option>';

                        echo '<option><a href="' . $url . '?orderby=rating">مرتب سازی بر اساس پرفروش ترین</a></option>';

                        echo '<option><a href="' . $url . '?orderby=date">مرتب سازی بر اساس جدیدترین</a></option>';

                        echo '<option><a href="' . $url . '?orderby=price">مرتب سازی بر اساس ارزان ترین</a></option>';

                        echo '<option><a href="' . $url . '?orderby=price-desc">مرتب سازی بر اساس گران ترین</a></option>';
                        echo '</select>';
                        echo '</div>';


                    }

                    add_action('woocommerce_before_shop_loops', 'custom_sort_by', 30);
                    // Disable default sorting filters
                    remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
                    remove_action('woocommerce_after_shop_loop', 'woocommerce_catalog_ordering', 10);
                    remove_action('woocommerce_after_shop_loop', 'woocommerce_result_count', 20);




                    add_filter('woocommerce_default_catalog_orderby', 'custom_woocommerce_default_catalog_orderby', 20);
                    do_action('woocommerce_before_shop_loops');
                    ?>
                </div>
                <?php

                woocommerce_product_loop_start();
                ?>
                <span class="add-class-custom"></span>

                <?php
                if (wc_get_loop_prop('total')) {
                    while (have_posts()) {
                        the_post();
                        /**
                         * Hook: woocommerce_shop_loop.
                         */
                        do_action('woocommerce_shop_loop');

                        wc_get_template_part('vera', 'product');
                    }
                }
                woocommerce_product_loop_end();

                /**
                 * Hook: woocommerce_after_shop_loop.
                 *
                 * @hooked woocommerce_pagination - 10
                 */
                do_action('woocommerce_after_shop_loop');
            } else {
                /**
                 * Hook: woocommerce_no_products_found.
                 *
                 * @hooked wc_no_products_found - 10
                 */
                do_action('woocommerce_no_products_found');
            }

            /**
             * Hook: woocommerce_after_main_content.
             *
             * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
             */
            ?>
        </div>
        <style>

            .vera-div-woocommerce-shop .vera-div-woocommerce-shop-right {
                width: 75%;
            }

            .vera-div-woocommerce-shop .vera-div-woocommerce-shop-side {
                width: 23%;
                order: -1;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }

            .vera-div-woocommerce-shop .vera-div-woocommerce-shop-side .vera-div-woocommerce-shop-sides {
                float: right;
                width: 100%;
                position: sticky;
                top: 2rem;
            }

            .vera-div-woocommerce-shop-side .sidebars-single {
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                float: right;
                width: 100%;
                height: auto;
                padding: 0;
            }

            .wc-block-product-categories {
                padding-bottom: 10px;
                float: right;
                width: 100%;
                border-bottom: 1px solid #ddd;
                margin: 0;
            }

            .vera-div-woocommerce-shop-side .sidebars-single:last-child .wc-blocks-filter-wrapper {
                border-bottom: none !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .is-loading {
                border-radius: 5px !important;
            }

            .show-loading-state__inner {
                border-radius: 5px !important;
            }

            .wc-block-active-filters__clear-all-placeholder {
                border-radius: 5px !important;
            }

            .input-loading {
                border-radius: 5px !important;
            }

            .wp-block-woocommerce-price-filter, .wp-block-woocommerce-stock-filter, .wp-block-woocommerce-attribute-filter {
                transition: .5s ease-in-out;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .wp-block-heading {
                font-weight: 400;
                margin: 0 0 15px;
                float: right;
                width: 100%;
                display: flex;
                align-items: center;
                justify-content: space-between;
                cursor: pointer;
            }

            .editor-styles-wrapper .wc-block-components-checkbox, .wc-block-components-checkbox {
                margin-top: 8px !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .wp-block-heading:before {
                content: "\f107";
                font-family: FontAwesome;
                order: 1;
                transform: rotate(180deg);
                transition: .5s ease-in-out;
            }

            .wp-block-heading.rotated::before {
                transform: rotate(360deg) !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .wc-blocks-filter-wrapper {
                float: right;
                width: 100%;
                border-bottom: 1px solid #ddd;
                padding-bottom: 10px;
                margin-bottom: 20px;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .wc-block-active-filters__list-item {
                float: right;
                margin-right: 10px;
                display: flex;
                justify-content: center;
                align-items: center;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .wp-block-woocommerce-active-filters .wc-block-active-filters__clear-all {
                display: none !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .wc-block-active-filters__list-item-type {
                display: none !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single .wc-block-active-filters__list-item-name {
                margin: 0 !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single ul {
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                width: 100%;
                float: right;
            }

            .vera-div-woocommerce-shop-side .sidebars-single ul li {
                list-style: none;
                float: right;
                width: 100%;
                display: flex;
                flex-wrap: wrap;
                justify-content: space-between;
                align-items: center;
            }

            .vera-div-woocommerce-shop-side .sidebars-single ul li ul li {
                margin-bottom: 0.34rem;
                list-style: none;
                float: right;
                width: 100%;
                display: flex;
                flex-wrap: wrap;
                justify-content: space-between;
                align-items: center;
            }

            .vera-div-woocommerce-shop-side .sidebars-single ul li a {
                text-decoration: none;
                color: #222222;
                margin: 0 0 0;
                float: right;
                padding: 3px 0;
                opacity: .6;
                transition: all .3s ease-in-out;
            }

            .vera-div-woocommerce-shop-side .sidebars-single ul li a:hover {
                opacity: 1;
            }

            .vera-div-woocommerce-shop-side .sidebars-single ul li ul li ul {
                padding-right: 15px;
            }

            .wc-block-components-price-slider__range-input-progress {
                --track-background: linear-gradient(to left, #cc181800 var(--low), var(--range-color) 0, var(--range-color) var(--high), #eb616100 0) no-repeat 0 100% /100% 100% !important;
                --range-color: var(--main-color) !important;
                background: var(--track-background) !important;
            }

            input[type="range"]::-webkit-slider-thumb {
                -webkit-appearance: none;
                appearance: none;
                margin-top: -6px;
                border-radius: 3px !important;
                background-color: #fff;
                box-shadow: 0 0 3px rgba(34, 34, 34, 0.56);
                height: 1rem;
                width: 1rem;
                border: none;
            }

            input[type="range"]::-webkit-slider-thumb:hover {
                -webkit-appearance: none;
                appearance: none;
                margin-top: -6px;
                background-color: #fff;
                box-shadow: 0 0 3px rgba(34, 34, 34, 0.56);
                transform: scale(1.2);
                height: 1rem;
                width: 1rem;
                border: none;
            }

            .wc-block-components-price-slider--is-input-inline .wc-block-components-price-slider__controls .wc-block-components-price-slider__amount {
                max-width: 50% !important;
                border: none !important;
                text-align: center !important;
                direction: rtl !important;
                font-family: IRANYekanX !important;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
            }

            .wc-block-components-price-slider__range-text {
                align-items: center;
                display: flex;
                justify-content: right;
                align-items: center;
                float: right;
                margin: 15px 0 !important;
            }

            .wc-block-components-price-slider__range-text span {
                padding-left: 6px;
                border-left: 1px solid #ddd;
                margin-left: 6px;
            }

            .wc-block-components-price-slider__range-text span:last-child {
                border-left: none !important;
                margin-left: 0 !important;
            }

            .wc-block-components-price-slider__actions {
                margin: 13px 0;
                float: left;
            }

            button.wc-block-components-filter-reset-button {
                text-decoration: none;
                font-family: IRANYekanX;
            }
.wp-block-woocommerce-attribute-filter{
transition:all 1s ease-in-out;
}
button.wp-block-button__link {
                text-decoration: none;
                font-family: IRANYekanX;
                background: var(--main-color2);
                color: #FFFFFF;
                border-radius: 0;
                font-weight: 600;
                float: left;
                border-radius: 4px;
            }

            .wc-block-stock-filter__actions, .wc-block-attribute-filter__actions {
                float: left;
            }

            .wc-block-components-filter-reset-button {
                text-decoration: none;
                font-family: IRANYekanX;
                background: var(--main-color);
                color: #FFFFFF;
                border-radius: 0;
                font-weight: 600;
                font-size: .875em;
                padding: .5em 1em;
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"] {
                --primary-color: #1677ff;
                --secondary-color: #fff;
                --primary-hover-color: #4096ff;
                /* checkbox */
                --checkbox-diameter: 20px;
                --checkbox-border-radius: 5px;
                --checkbox-border-color: #d9d9d9;
                --checkbox-border-width: 1px;
                --checkbox-border-style: solid;
                /* checkmark */
                --checkmark-size: 1.2;
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"] {
                -webkit-appearance: none;
                -moz-appearance: none;
                appearance: none;
                width: var(--checkbox-diameter);
                height: var(--checkbox-diameter);
                border-radius: var(--checkbox-border-radius);
                background: var(--secondary-color);
                border: var(--checkbox-border-width) var(--checkbox-border-style) var(--checkbox-border-color);
                -webkit-transition: all 0.3s;
                -o-transition: all 0.3s;
                transition: all 0.3s;
                cursor: pointer;
                position: relative;
                outline: none !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"]::after {
                content: "";
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                -webkit-box-shadow: 0 0 0 calc(var(--checkbox-diameter) / 2.5) var(--primary-color);
                box-shadow: 0 0 0 calc(var(--checkbox-diameter) / 2.5) var(--primary-color);
                border-radius: inherit;
                opacity: 0;
                -webkit-transition: all 0.5s cubic-bezier(0.12, 0.4, 0.29, 1.46);
                -o-transition: all 0.5s cubic-bezier(0.12, 0.4, 0.29, 1.46);
                transition: all 0.5s cubic-bezier(0.12, 0.4, 0.29, 1.46);
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"]::before {
                top: 40%;
                left: 50%;
                content: "";
                position: absolute;
                width: 4px;
                height: 7px;
                box-shadow: none !important;
                border-right: 2px solid var(--secondary-color);
                border-bottom: 2px solid var(--secondary-color);
                -webkit-transform: translate(-50%, -50%) rotate(45deg) scale(0);
                -ms-transform: translate(-50%, -50%) rotate(45deg) scale(0);
                transform: translate(-50%, -50%) rotate(45deg) scale(0);
                opacity: 0;
                -webkit-transition: all 0.1s cubic-bezier(0.71, -0.46, 0.88, 0.6), opacity 0.1s;
                -o-transition: all 0.1s cubic-bezier(0.71, -0.46, 0.88, 0.6), opacity 0.1s;
                transition: all 0.1s cubic-bezier(0.71, -0.46, 0.88, 0.6), opacity 0.1s;
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"]:hover {
                border-color: var(--primary-color);
                outline: none !important;
            }

            .wc-block-components-checkbox .wc-block-components-checkbox__mark {
                fill: #fff !important;
                display: none !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"]:checked {
                background: var(--primary-color);
                border-color: transparent;
                color: #FFFFFF;
                outline: none !important;
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"]:checked::before {
                opacity: 1;
                -webkit-transform: translate(-50%, -50%) rotate(45deg) scale(var(--checkmark-size));
                -ms-transform: translate(-50%, -50%) rotate(45deg) scale(var(--checkmark-size));
                transform: translate(-50%, -50%) rotate(45deg) scale(var(--checkmark-size));
                -webkit-transition: all 0.2s cubic-bezier(0.12, 0.4, 0.29, 1.46) 0.1s;
                -o-transition: all 0.2s cubic-bezier(0.12, 0.4, 0.29, 1.46) 0.1s;
                transition: all 0.2s cubic-bezier(0.12, 0.4, 0.29, 1.46) 0.1s;
            }

            .vera-div-woocommerce-shop-side .sidebars-single input[type="checkbox"]:active:not(:checked)::after {
                -webkit-transition: none;
                -o-transition: none;
                -webkit-box-shadow: none;
                box-shadow: none;
                transition: none;
                opacity: 1;
            }


        </style>
        <?php
        if (!empty(is_active_sidebar('sidebar-product'))) {
?>
            <div class="vera-div-woocommerce-shop-side">
            <div class="vera-div-woocommerce-shop-sides">

<?php
                dynamic_sidebar('sidebar-product');
                ?>
            </div>
        </div>
            <?php
            }
        else {
                ?>
                <style>
                    .vera-div-woocommerce-shop .vera-div-woocommerce-shop-right {
                        width: 100% !important;
                    }
                </style>
                <?php
            }
            ?>
        <?php
        do_action('woocommerce_after_main_content');
        ?>
    </div>
<?php
get_footer('shop');
