<?php

class story_create_elementor extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'story_create_elementor';
    }

    public function get_title()
    {
        return '<h2><p style="position: absolute;font-family: fantasy;top: 3px;right: 5px;color:#FFFFFF;background: #f53d88;border-radius: 5px;padding: 5px;">pro</p>استوری ساز المنتور </h2>';
    }

    public function get_icon()
    {
        return 'eicon-slider-3d';
    }

    public function get_categories()
    {
        return ['text-image-category'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'section_content-fore-img',
            [
                'label' => esc_html__('المان تصویری و متن دسته بندی', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'list_widgets',
            [
                'label' => esc_html__('لیست آیتم های اسلایدر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'img-upload-slider_widget_w-2',
                        'label' => esc_html__('آپلود تصویر اول معرفی', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'description' => 'میتوانید از این قسمت هم تصویر معرفی اول اسلایدر را انتخاب و یا آپلود کنید ',
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ]
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-8',
                        'label' => esc_html__('آپلود تصویر اصلی استوری', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'description' => 'میتوانید از این قسمت هم تصویر اسلایدر اصلی استوری را انتخاب و یا آپلود کنید ',
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ]
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-3',
                        'label' => 'متن بخش کوچک روی تصویر',
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'description' => 'شما میتوانید برای هر آیتم متن بخش کوچک روی تصویر بخصوصی بنویسید',
                        'placeholder' => esc_html__('14:00', 'textdomain'),
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-7',
                        'label' => 'متن توضیح اسلایدر',
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'description' => 'شما میتوانید برای هر آیتم متن توضیح اسلایدر بخصوصی بنویسید',
                        'placeholder' => esc_html__('چاس سبز یا سیاه؟', 'textdomain'),
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-10',
                        'label' => 'متن لینک هدایت',
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'description' => 'شما میتوانید برای هر آیتم متن لینک هدایت بخصوصی بنویسید در صورتی که این قسمت را خالی بگذارید لینک نمایش نخواهد گرفت',
                        'placeholder' => esc_html__('هدایت به اینستاگرام', 'textdomain'),
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-4',
                        'label' => 'لینک هدایت آیتم اسلایدر',
                        'type' => \Elementor\Controls_Manager::URL,
                        'description' => 'میتوانید از این بخش لینک هدایت بعد از کلیک کاربر را ست کنید که کاربر بعد از کلیک به لینک هدایت شود مثال (آدرس دسته بندی موبایل سامسونگ)',
                        'placeholder' => esc_html__('https://site.com/shop/', 'textdomain'),
                    ],
                    [
                        'name' => 'img-upload-slider_widget_w-5',
                        'label' => esc_html__('باز شدن لینک در :', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '_blank',
                        'description' => 'میتوانید از این باکس طریقه باز شدن لین ها را انتخاب کنید مثلا وقتی کاربر بر روی لینک کلیک کرد در تب جدیدی از مرورگر به موضوع هدایت شود یا همان تب اصلی',
                        'options' => [
                            '_blank' => esc_html__('باز شدن در صفحه جدید (لینک)', 'textdomain'),
                            '_self' => esc_html__('باز شدن در همان صفحه (لینک)', 'textdomain'),
                        ],
                    ]
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل های المان', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_background-icon-left-link-freast-hover-35225252215242',
            [
                'label' => esc_html__('رنگ عنوان اصلی آیتم', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ عنوان اصلی آیتم را تغییر و شخصی سازی کنید',
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast-hover-355252215242dd',
            [
                'label' => esc_html__('رنگ کناره و بردر و رنگ عنوان آیتم در صورت هاور ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ کناره و بردر آیتم و عنوان در صورت هاور را تغییر و شخصی سازی کنید',
                'default' => '#F0003C',
            ]
        );
        $this->add_control(
            'text_background-icon-left-link-freast-hover-3521524225422',
            [
                'label' => esc_html__('رنگ پس زمینه هر آیتم', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'شما میتوانید رنگ پس زمینه هر آیتم را تغییر و شخصی سازی کنید',
                'default' => '#FFFFFF',
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>
        <style>
            /*start code slider cat product*/
            .story_creatr_elementor {
                float: right;
                width: 100%;
                padding-bottom: 10px;
                padding-top: 10px;
                overflow: hidden;
                margin-bottom: 20px;
            }

            .story_creatr_elementor .swiper {
                float: right;
                max-width: fit-content;
                height: max-content;
                padding-bottom: 10px;
                overflow: unset;
            }

            .story_creatr_elementor .swiper-scrollbar {
                bottom: -10px;
            }

            .story_creatr_elementor .mySwiper_story .swiper-slide {
                text-align: center;
                font-size: 18px;
                margin: 0 10px 0 0 !important;
                position: relative;
                float: right;
                padding: 3px;
                background: linear-gradient(45deg, #f9ce34, #ee2a7b, #6228d7);
                display: flex;
                justify-content: center;
                width: 90px !important;
                height: 90px !important;
                align-items: center;
                flex-wrap: wrap;
                border-radius: 50%;
                text-decoration: none;
                color: var(--main-color3);
                transition: all .3s ease-in-out;
            }

            .story_creatr_elementor .mySwiper_story .swiper-slide:hover {

            }

            .story_creatr_elementor .mySwiper_story .swiper-slide p {
                float: right;
                width: 100%;
                height: 11px;
                font-size: 14px;
                font-size: 11px;
                display: flex;
                flex-direction: column;
                align-content: center;
                justify-content: flex-start;
                align-items: center;
                padding: 5px 0;
            }

            .story_creatr_elementor .mySwiper_story .swiper-slide span {
                width: 100%;
                float: right;
                -moz-font-feature-settings: "ss02" !important;
                -webkit-font-feature-settings: "ss02" !important;
                font-feature-settings: "ss02" !important;
                padding: 5px;
                position: absolute;
                font-size: 9px;
                font-family: 'IRANYekanX';
                color: #f0003c !important;
                background: #ffd2dd;
                height: auto;
                line-height: 1;
                display: flex;
                justify-content: center;
                align-items: center;
                bottom: -2px;
                border-radius: 7px;
                width: fit-content;
                max-width: 70px;
                border: 1px solid #fff;
            }

            .story_creatr_elementor .mySwiper_story .swiper-slide img {
                display: block;
                width: 100%;
                height: auto;
                min-height: 100%;
                max-height: max-content;
                object-fit: cover;
                border-radius: 50%;
            }

            .story_creatr_elementor .mySwiper2_story {
                position: fixed;
                right: 0;
                left: 0;
                top: 0;
                bottom: 0;
                background: rgba(4, 4, 4, 0.89);
                display: none;
                align-items: center;
                justify-content: center;
                z-index: 1000000;
                height: 100%;
            }
            .display_flex {
                display: flex !important;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-wrapper {
                height: 100% !important;
                text-align: center;
                position: relative;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-wrapper .swiper-slide {
                margin: auto;
                height: 95% !important;
                max-height: 95%;
                text-align:center;
               position:relative;
            }
            .story_creatr_elementor .mySwiper_story .swiper-slide {
                width: 25%;
                height: 100%;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-slide figure {
                position: relative;
                display: inline-block;
                transform: scale(.9);
                transition: all .3s ease-in-out;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-slide figure .store_link a {
                position: absolute;
                right: 0;
                left: 0;
                margin: auto;
                background: #FFFFFF;
                float: right;
                color: #222;
                line-height: 1;
                padding: 15px 20px !important;
                z-index: 10000;
                bottom: 20px;
                font-weight: bold;
                width: fit-content;
                border-radius: 50px;
                box-shadow: 0 0 5px rgb(34 34 34 / 40%);
                transform: translateY(200%);
                opacity: 0;
                transition: all .5s ease-in-out;
                border: 5px solid #bebcbc1f;
                box-shadow: 0 0 0 5px #ffffff4f;
            }

            .story_creatr_elementor .mySwiper2_story .swiper-slide figure .store_info {
                position: absolute;
                right: 20px;
                top: 10px;
                display: flex;
                align-items: center;
                background: #0000004f;
                justify-content: right;
                padding: 3px 10px;
                border-radius: 10px;
                transform: translateY(-200%);
                opacity: 0;
                transition: all 1s ease-in-out;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-slide .store_info > img {
                width: 50px !important;
                height: 50px !important;
                border-radius: 50% !important;
                border: 2px solid #ddd;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-slide .store_info p {
                font-size: 12px;
                color: #ffffff;
                padding-right: 5px;
                font-weight: 600;
            }

            .story_creatr_elementor .mySwiper2_story .swiper-wrapper .swiper-slide  .store_info {
                position: absolute;
                right: 20px;
                top: 10px;
                display: flex;
                align-items: center;
                background: #0000004f;
                justify-content: right;
                padding: 3px 10px;
                border-radius: 10px;
            }

            .story_creatr_elementor .mySwiper2_story .swiper-wrapper .swiper-slide  .store_info p {
                font-size: 12px;
                color: #ffffff;
                padding-right: 5px;
                font-weight: 600;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-wrapper .swiper-slide  .store_info i {
                color: #fff;
                font-size: 30px;
                font-weight: 300;
            }


            .story_creatr_elementor .mySwiper2_story  .swiper-slide-active .store_info {
                opacity: 1 !important;
                transform: translateY(0) !important;
            }

            .story_creatr_elementor .mySwiper2_story  .swiper-slide-active .store_link a  {
                opacity: 1 !important;
                transform: translateY(0) !important;
            }
            .story_creatr_elementor .mySwiper2_story  .swiper-slide-active figure {
                transform: scale(1) !important;
            }
            .story_creatr_elementor .mySwiper2_story .swiper-wrapper .swiper-slide img {
                width: 450px;
                max-width: 95%;
                height: auto;
                max-height: 95%;
                border-radius:10px
            }

            .swiper-progress-bar {
                display: block;
                z-index: 5;
                height: 5px;
                position: absolute;
                right: auto;
                top: 5px;
                width: 450px;
                max-width: 90%;
                margin: auto;
                overflow: hidden; /* اضافه شده */
            }

            .swiper-progress-bar .slide_progress-bar {
                position: absolute;
                height: 5px;
                background: rgba(0, 0, 0, 0.3);
                border-radius: 10px;
                overflow: hidden;
                width: 100%; /* تغییر یافته */
                clear: both;
                opacity: 1; /* تغییر یافته */
                top: 0;
                left: 0;
                right: 0;
            }

            .swiper-progress-bar .slide_progress-bar:after {
                position: absolute;
                top: 0;
                left: 0;
                background: #ffffff;
                height: 100%;
                width: 0; /* تغییر یافته */
                content: "";
                transition: 0.1s width linear;
            }

            .swiper-progress-bar.animate .slide_progress-bar:after {
                transition: width linear;
                transition-delay: unset;
                width: 100%;
                transition-duration: 10s;
            }

            @media screen and (max-width:1000px) {
                .story_creatr_elementor .swiper-button-next {
                    display:none !important;
                }
                .story_creatr_elementor .mySwiper2_story .swiper-wrapper .swiper-slide > .store_info {
                    background: #0606061f;
                    right: unset;
                    width: fit-content;
                    left: 20px !important;
                    z-index: 1000;
                }
            }
            .mySwiper_story .swiper-slide.viewed {
                opacity: 0.7;
                background: #30384124;
                padding: 8px;
            }
            /*end code slider cat product*/

        </style>
        <script>
            $(function () {


                var swiper = new Swiper(".mySwiper_story", {
                    spaceBetween: 10,
                    freeMode: true,
                    watchSlidesProgress: true,
                });
                // Function to set the viewed class based on the cookie
                function setViewedSlidesFromCookie() {
                    var viewedSlidesCookie = document.cookie.replace(/(?:(?:^|.*;\s*)viewedSlides\s*\=\s*([^;]*).*$)|^.*$/, "$1");
                    var viewedSlidesIndexes = viewedSlidesCookie.split(',').map(Number);
                    viewedSlidesIndexes.forEach(function (index) {
                        swiper.slides[index].classList.add('viewed');
                    });
                }
                var viewedSlidesCookie = document.cookie.replace(/(?:(?:^|.*;\s*)viewedSlides\s*\=\s*([^;]*).*$)|^.*$/, "$1");
                if (viewedSlidesCookie) {
                    setViewedSlidesFromCookie();
                }
                $(".mySwiper_story .swiper-slide").click(function () {
                    $(".swiper-progress-bar").eq(0).addClass("animate");
                    $(".swiper-progress-bar").eq(0).addClass("active");
                    $(this).addClass('viewed');
                });
                var swiper2 = new Swiper(".mySwiper2_story", {
                    spaceBetween: 10,
                    autoplay: {
                        delay: 10000,
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    thumbs: {
                        swiper: swiper,
                    },
                    on: {
                        init: function () {
                            $(".swiper-progress-bar").removeClass("animate");
                            $(".swiper-progress-bar").removeClass("active");
                            $(".swiper-progress-bar").eq(0).addClass("animate");
                            $(".swiper-progress-bar").eq(0).addClass("active");
                        },
                        slideChangeTransitionStart: function () {
                            $(".swiper-progress-bar").removeClass("animate");
                            $(".swiper-progress-bar").removeClass("active");
                            $(".swiper-progress-bar").eq(0).addClass("active");
                        },
                        slideChangeTransitionEnd: function () {
                            $(".swiper-progress-bar").eq(0).addClass("animate");

                            var currentSlideIndex = swiper2.activeIndex;
                            swiper.slides[currentSlideIndex].classList.add('viewed');

                            var viewedSlides = [];
                            swiper.slides.forEach(function (slide, index) {
                                if (slide.classList.contains('viewed')) {
                                    viewedSlides.push(index);
                                }
                            });
                            document.cookie = "viewedSlides=" + viewedSlides.join(',') + "; path=/";

                        }

                    }
                });

                });
        </script>
        <div class="container">
            <div class="story_creatr_elementor">

                <div style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff;"
                     class="swiper mySwiper2_story">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['list_widgets'] as $index => $item) : ?>
                            <div class="swiper-slide">
                                <div  class="cloas_story store_info">
                                    <i class="fa-light fa-xmark-large"></i>
                                </div>
                                <figure>
                                <img src="<?php echo $item['img-upload-slider_widget_w-8']['url']; ?>"/>
                                <div class="store_info">
                                    <img src="<?php echo $item['img-upload-slider_widget_w-2']['url']; ?>"/>
                                    <p><?php echo $item['img-upload-slider_widget_w-7']; ?></p>
                                </div>
                                <div class="store_link">
                                    <?php
                                    if (!empty($item['img-upload-slider_widget_w-10'])) :
                                    ?>

                                    <a
                                        <?php if ($item['img-upload-slider_widget_w-5'] !== "img") { ?>
                                            target="<?php echo $item['img-upload-slider_widget_w-5']; ?>"
                                        <?php } ?>
                                        <?php if (!empty($item['img-upload-slider_widget_w-4']['url'])) { ?>
                                            href="<?php echo $item['img-upload-slider_widget_w-4']['url']; ?>"
                                        <?php } ?>
                                    ><?php echo $item['img-upload-slider_widget_w-10']; ?></a>
                                    <?php
                                    endif;
                                    ?>
                                </div>
                                </figure>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-progress-bar">
                        <span class="slide_progress-bar"></span>
                    </div>
                </div>

                <div thumbsSlider="" class="swiper mySwiper_story">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['list_widgets'] as $index => $item) : ?>
                            <a class="swiper-slide">
                                <img src="<?php echo $item['img-upload-slider_widget_w-2']['url']; ?>">
                                <?php
                                if (!empty($item['img-upload-slider_widget_w-3'])) {
                                    ?>
                                    <span><?php echo $item['img-upload-slider_widget_w-3']; ?></span>
                                    <?php
                                }
                                ?>
                                <p><?php echo $item['img-upload-slider_widget_w-7']; ?></p>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>

            </div>
        </div>


        <?php
    }


    protected function content_template()
    {
    }

}
