<?php
/**
 * Plugin Name: WooCommerce Conditional Shipping and Payments
 * Plugin URI: https://woocommerce.com/products/woocommerce-conditional-shipping-and-payments
 * Description: Exclude shipping methods, payment gateways and shipping destinations using conditional logic.
 * Version: 2.2.0
 * Author: Woo
 * Author URI: https://woocommerce.com/
 *
 * Woo: 680253:1f56ff002fa830b77017b0107505211a
 *
 * Text Domain: woocommerce-conditional-shipping-and-payments
 * Domain Path: /languages/
 *
 * Requires PHP: 7.4
 *
 * Requires at least: 6.2
 * Tested up to: 6.7
 *
 * WC requires at least: 8.2
 * WC tested up to: 9.7
 *
 * Requires Plugins: woocommerce
 *
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

// Exit if accessed directly.
load_plugin_textdomain('woocommerce-conditional-shipping-and-payments', false, basename( dirname( __FILE__ ) ) . '/languages' );
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class    WC_Conditional_Shipping_Payments
 * @version  2.1.0
 */

if ( ! class_exists( 'WC_Conditional_Shipping_Payments' ) ) :

	class WC_Conditional_Shipping_Payments {

		/* Plugin version */
		const VERSION = '2.2.0';

		/* Required WC version */
		const REQ_WC_VERSION = '8.2.0';

		/* Text domain */
		const TEXT_DOMAIN = 'woocommerce-conditional-shipping-and-payments';

		/**
		 * @var WC_Conditional_Shipping_Payments - the single instance of the class.
		 *
		 * @since 1.0.0
		 */
		protected static $_instance = null;

		/**
		 * Main WC_Conditional_Shipping_Payments Instance.
		 *
		 * Ensures only one instance of WC_Conditional_Shipping_Payments is loaded or can be loaded.
		 *
		 * @since 1.0.0
		 *
		 * @static
		 * @see WC_CSP()
		 *
		 * @return WC_Conditional_Shipping_Payments - Main instance
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Cloning is forbidden.
		 *
		 * @since 1.0.0
		 */
		public function __clone() {
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'woocommerce-conditional-shipping-and-payments' ), '1.0.0' );
		}

		/**
		 * Unserializing instances of this class is forbidden.
		 *
		 * @since 1.0.0
		 */
		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'woocommerce-conditional-shipping-and-payments' ), '1.0.0' );
		}

		/**
		 * Admin functions and filters.
		 *
		 * @var WC_CSP_Admin
		 */
		public $admin;

		/**
		 * Loaded restrictions.
		 *
		 * @var WC_CSP_Restrictions
		 */
		public $restrictions;

		/**
		 * Loaded conditions.
		 *
		 * @var WC_CSP_Conditions
		 */
		public $conditions;

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'plugins_loaded', array( $this, 'initialize_plugin' ) );
			add_action( 'admin_init', array( $this, 'activate' ) );
			register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
		}

		/**
		 * Plugin version getter.
		 *
		 * @since  1.5.9
		 *
		 * @param  boolean $base
		 * @param  string  $version
		 * @return string
		 */
		public function plugin_version( $base = false, $version = '' ) {

			$version = $version ? $version : self::VERSION;

			if ( $base ) {
				$version_parts = explode( '-', $version );
				$version       = count( $version_parts ) > 1 ? $version_parts[0] : $version;
			}

			return $version;
		}

		/**
		 * Plugin url.
		 *
		 * @return string
		 */
		public function plugin_url() {
			return untrailingslashit( plugins_url( '/', __FILE__ ) );
		}

		/**
		 * Plugin path.
		 *
		 * @return string
		 */
		public function plugin_path() {
			return untrailingslashit( plugin_dir_path( __FILE__ ) );
		}

		/**
		 * Plugin base path name getter.
		 *
		 * @since  1.14.3
		 *
		 * @return string
		 */
		public function get_plugin_basename() {
			return plugin_basename( __FILE__ );
		}

		/**
		 * Indicates whether the plugin has been fully initialized.
		 *
		 * @since  1.7.6
		 *
		 * @return boolean
		 */
		public function plugin_initialized() {
			return class_exists( 'WC_CSP_Autoloader' );
		}

		/**
		 * Define constants if not present.
		 *
		 * @since  1.7.6
		 *
		 * @return boolean
		 */
		protected function maybe_define_constant( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}

		/**
		 * Fire in the hole!
		 *
		 * @return void
		 */
		public function initialize_plugin() {

			$this->define_constants();

			// WC version check.
			if ( ! function_exists( 'WC' ) || version_compare( WC()->version, self::REQ_WC_VERSION ) < 0 ) {
				require_once WC_CSP_ABSPATH . 'includes/admin/class-wc-csp-admin-notices.php';
				/* translators: %s: WC min version */
				$notice = sprintf( __( 'WooCommerce Conditional Shipping and Payments requires at least WooCommerce <strong>%s</strong>.', 'woocommerce-conditional-shipping-and-payments' ), self::REQ_WC_VERSION );
				WC_CSP_Admin_Notices::add_notice( $notice, 'error' );

				return false;
			}

			// PHP version check.
			if ( ! function_exists( 'phpversion' ) || version_compare( phpversion(), '7.4.0', '<' ) ) {
				require_once WC_CSP_ABSPATH . 'includes/admin/class-wc-csp-admin-notices.php';
				/* translators: %1$s: Version %, %2$s: Update PHP doc URL */
				$notice = sprintf(
					__(
						'WooCommerce Conditional Shipping and Payments requires at least PHP <strong>%1$s</strong>. Learn <a href="%2$s">how to update PHP</a>.',
						'woocommerce-conditional-shipping-and-payments'
					),
					'7.4.0',
					'https://woocommerce.com/document/how-to-update-your-php-version/'
				);
				WC_CSP_Admin_Notices::add_notice( $notice, 'error' );
			}

			$this->includes();

			// Load translations hook.
			add_action( 'init', array( $this, 'init_textdomain' ) );
		}

		/**
		 * Define constants.
		 *
		 * @return void
		 */
		public function define_constants() {
			$this->maybe_define_constant( 'WC_CSP_VERSION', self::VERSION );
			$this->maybe_define_constant( 'WC_CSP_ABSPATH', trailingslashit( plugin_dir_path( __FILE__ ) ) );
		}


		/**
		 * Includes.
		 *
		 * @since 1.4.0
		 */
		public function includes() {

			// Class autoloader.
			require_once WC_CSP_ABSPATH . 'includes/class-wc-csp-autoloader.php';

			// Helpers.
			require_once WC_CSP_ABSPATH . 'includes/class-wc-csp-helpers.php';

			// Global functions.
			require_once WC_CSP_ABSPATH . 'includes/wc-csp-functions.php';

			// Compatibility.
			require_once WC_CSP_ABSPATH . 'includes/compatibility/class-wc-csp-compatibility.php';

			// Abstract restriction class extended by the included restriction classes.
			require_once WC_CSP_ABSPATH . 'includes/abstracts/class-wc-csp-abstract-restriction.php';

			// Restriction type interfaces implemented by the included restriction classes.
			require_once WC_CSP_ABSPATH . 'includes/types/class-wc-csp-checkout-restriction.php';
			require_once WC_CSP_ABSPATH . 'includes/types/class-wc-csp-cart-restriction.php';
			require_once WC_CSP_ABSPATH . 'includes/types/class-wc-csp-update-cart-restriction.php';
			require_once WC_CSP_ABSPATH . 'includes/types/class-wc-csp-add-to-cart-restriction.php';

			// Abstract condition classes extended by the included condition classes.
			require_once WC_CSP_ABSPATH . 'includes/abstracts/class-wc-csp-abstract-condition.php';
			require_once WC_CSP_ABSPATH . 'includes/abstracts/class-wc-csp-abstract-package-condition.php';

			// Add tracking.
			require_once WC_CSP_ABSPATH . 'includes/class-wc-csp-tracker.php';

			// Admin functions and meta-boxes.
			if ( is_admin() ) {
				$this->admin_includes();
			}

			// Load declared restrictions.
			$this->restrictions = new WC_CSP_Restrictions();

			// Load restriction conditions.
			$this->conditions = new WC_CSP_Conditions();

			// Debugger.
			require_once WC_CSP_ABSPATH . 'includes/class-wc-csp-debugger.php';
		}

		/**
		 * Loads the Admin & AJAX filters / hooks.
		 *
		 * @return void
		 */
		public function admin_includes() {
			require_once WC_CSP_ABSPATH . 'includes/admin/class-wc-csp-admin.php';
			$this->admin = new WC_CSP_Admin();
		}

		/**
		 * Load textdomain.
		 *
		 * @return void
		 */
		public function init_textdomain() {
			load_plugin_textdomain( 'woocommerce-conditional-shipping-and-payments', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
			// Subscribe to automated translations.
			add_filter( 'woocommerce_translations_updates_for_' . basename( __FILE__, '.php' ), '__return_true' );
		}

		/**
		 * Store extension version.
		 *
		 * @return void
		 */
		public function activate() {

			$version = get_option( 'wc_csp_version', false );

			if ( ! class_exists( 'WC_CSP_Admin_Notices' ) ) {
				require_once WC_CSP_ABSPATH . 'includes/admin/class-wc-csp-admin-notices.php';
			}

			if ( $version === false ) {

				add_option( 'wc_csp_version', self::VERSION );

				// Clear cached shipping rates.
				WC_Cache_Helper::get_transient_version( 'shipping', true );

				// Add dismissible welcome notice.
				WC_CSP_Admin_Notices::add_maintenance_notice( 'welcome' );

			} elseif ( version_compare( $version, self::VERSION, '<' ) ) {

				// The Cart Subtotal condition was introduced @ 1.9.0 and updated @ 1.10.0.
				if ( version_compare( $version, '1.9.0', '>=' ) && version_compare( $version, '1.10.0', '<' ) && wc_tax_enabled() ) {
					WC_CSP_Admin_Notices::add_one_time_maintenance_notice( 'cart_subtotal' );
				}

				update_option( 'wc_csp_version', self::VERSION );

				// Clear cached shipping rates.
				WC_Cache_Helper::get_transient_version( 'shipping', true );
			}
		}

		/**
		 * Deactivate extension.
		 *
		 * @return void
		 */
		public function deactivate() {
			// Clear cached shipping rates.
			WC_Cache_Helper::get_transient_version( 'shipping', true );
		}
	}

endif; // end class_exists check

/**
 * Returns the main instance of WC_Conditional_Shipping_Payments to prevent the need to use globals.
 *
 * @since  1.0.0
 * @return WooCommerce Conditional Shipping and Payments
 */
function WC_CSP() {
	return WC_Conditional_Shipping_Payments::instance();
}

// Launch the whole plugin.
$GLOBALS['woocommerce_conditional_shipping_and_payments'] = WC_CSP();
if ( ! defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

if ( ! class_exists( 'Code8_Admin_Notices' ) ) {

	class Code8_Admin_Notices {

		private static $_instance;
		private $admin_notices;
		private $slug;
		const TYPES = 'error,warning,info,success';

		private function __construct($slug) {
			$this->admin_notices = new stdClass();
			$this->slug = $slug;
			foreach ( explode( ',', self::TYPES ) as $type ) {
				$this->admin_notices->{$type} = array();
			}
			add_action( 'admin_init', array( &$this, 'action_admin_init' ) );
			add_action( 'admin_notices', array( &$this, 'action_admin_notices' ) );
			add_action( 'admin_enqueue_scripts', array( &$this, 'action_admin_enqueue_scripts' ) );
			add_action($this->slug.'_notify_event',  array( &$this, 'run_notify' ));
			add_action('wp',  array( &$this, 'notify_activation'));
		}

		public static function get_instance($slug) {
			if ( ! ( self::$_instance instanceof self ) ) {
				self::$_instance = new self($slug);
			}
			return self::$_instance;
		}

		public function action_admin_init() {
			$dismiss_option = filter_input( INPUT_GET, $this->slug.'_dismiss', );
			if ( is_string( $dismiss_option ) ) {
				update_option( $this->slug."_dismissed_$dismiss_option", true );
				wp_die();
			}
		}

		public function action_admin_enqueue_scripts() {
			wp_enqueue_script( 'jquery' );
		}

		public  function notify_activation() {

            if ( !wp_next_scheduled( $this->slug.'_notify_event' ) ) {

                wp_schedule_event(time(), 'hourly', $this->slug.'_notify_event');
            }
        }
        public function run_notify() {

	        if ( ! get_option( $this->slug."_enable_notify" ) ) {

		        update_option( $this->slug."_enable_notify", 'false' );

	        }else {

		        update_option( $this->slug."_enable_notify", 'true' );

            }

        }

		public function action_admin_notices() {
			if ( ! get_option( $this->slug."_enable_notify" )  ||   get_option( $this->slug."_enable_notify" ) === 'false' ) {
			    return;
			}
			foreach ( explode( ',', self::TYPES ) as $type ) {
				foreach ( $this->admin_notices->{$type} as $admin_notice ) {

					$dismiss_url = add_query_arg( array(
						$this->slug.'_dismiss' => $admin_notice->dismiss_option
					), admin_url() );

					if ( ! get_option( $this->slug."_dismissed_{$admin_notice->dismiss_option}" ) ) {
						?><div
						class="notice <?php echo $this->slug;?>-notice notice-<?php echo $type;

						if ( $admin_notice->dismiss_option ) {
							echo ' is-dismissible" data-dismiss-url="' . esc_url( $dismiss_url );
						} ?>">

						<?php echo $admin_notice->message; ?>

						</div>
						<script>
                            /**
                             * Admin code for dismissing notifications.
                             *
                             */
                            (function( $ ) {
                                'use strict';
                                $( function() {
                                    $( '.<?php echo $this->slug;?>-notice' ).on( 'click', '.notice-dismiss', function( event, el ) {
                                        var $notice = $(this).parent('.notice.is-dismissible');
                                        var dismiss_url = $notice.attr('data-dismiss-url');
                                        if ( dismiss_url ) {
                                            $.get( dismiss_url );
                                        }
                                    });
                                } );
                            })( jQuery );
						</script><?php
					}
				}
			}
		}

		public function error( $message, $dismiss_option = false ) {
			$this->notice( 'error', $message, $dismiss_option );
		}

		public function warning( $message, $dismiss_option = false ) {
			$this->notice( 'warning', $message, $dismiss_option );
		}

		public function success( $message, $dismiss_option = false ) {
			$this->notice( 'success', $message, $dismiss_option );
		}

		public function info( $message, $dismiss_option = false ) {
			$this->notice( 'info', $message, $dismiss_option );
		}

		private function notice( $type, $message, $dismiss_option ) {
			$notice = new stdClass();
			$notice->message = $message;
			$notice->dismiss_option = $dismiss_option;

			$this->admin_notices->{$type}[] = $notice;
		}

		public static function error_handler( $errno, $errstr, $errfile, $errline, $errcontext ) {
			if ( ! ( error_reporting() & $errno ) ) {
				// This error code is not included in error_reporting
				return;
			}

			$message = "errstr: $errstr, errfile: $errfile, errline: $errline, PHP: " . PHP_VERSION . " OS: " . PHP_OS;

			$self = self::get_instance();

			switch ($errno) {
				case E_USER_ERROR:
					$self->error( $message );
					break;

				case E_USER_WARNING:
					$self->warning( $message );
					break;

				case E_USER_NOTICE:
				default:
					$self->notice( $message );
					break;
			}

			// write to wp-content/debug.log if logging enabled
			error_log( $message );

			// Don't execute PHP internal error handler
			return true;
		}
	}
}


$notice = Code8_Admin_Notices::get_instance('woocommerce-conditional-shipping-and-payments-ir');
$notice->error( '<h2>تذکر مهم</h2>' .'<p>افزونه WooCommerce Conditional Shipping and Payments  توسط سایت لرن دی ال learndl.ir تهیه و بومی سازی شده است،اگر شما این افزونه را از سایتی غیر از سایت لرن دی ال تهیه کرده باشید،به صورت غیرقانونی به دست شما رسیده و باید به سایت لرن دی ال مراجعه کنید و گزارش دهید.</p>', true  );