<?php

wp_head();

$front = new FCI_Front();
$front->set_type('invoice');


$data = [];
if($_GET['order-id']) {
    $data = FCI_View_Render::header($_GET['order-id'], 'invoice', $front->get_font_family());
}

$font_size = get_fci_settings('invoice' . '-font-size');
$custom_css = get_fci_settings('custom-css');
$font_family = $front->get_font_family();
$font = $front->get_font($font_family);

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, maximum-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="<?php echo FCI_CSS_URL; ?>/views/invoice-elementor.css">

    <?php echo $font; ?>

    <style>
        <?php if ($font_size): ?>
        body {
            font-size: <?php echo esc_html($font_size); ?>px;
        }
        <?php endif; ?>

        <?php if ($custom_css): ?>
        <?php echo esc_html($custom_css); ?>
        <?php endif; ?>



        <?php if ($font_family): ?>
        *, body, select, input {
            font-family: <?php echo esc_html($font_family); ?>, Tahoma, Arial, sans-serif !important;
        }
        <?php endif; ?>

    </style>
</head>

<body class="<?php echo $front->append_body_class(); ?>">

<div class="view-elementor">
    <?php
    the_post();
the_content();
?>

    <?php echo  $data['watermark']; ?>
</div>



<?php if (\Elementor\Plugin::$instance->preview->is_preview_mode()) : ?>
    <?php wp_footer(); ?>
<?php endif; ?>


<?php if (get_fci_settings('persian-number') && !$front->get_check_email()): ?>
    <?php echo FCI_View_Render::footer_js(); ?>
<?php endif; ?>


<?php if (!\Elementor\Plugin::$instance->preview->is_preview_mode()) : ?>
    <?php echo FCI_View_Render::footer_action_btn($_GET['order-id'], 'invoice'); ?>
<?php endif; ?>


<?php if (get_fci_settings('page-break')): ?>
    <p style="page-break-before: always;"></p>
<?php endif; ?>


</body>
</html>