<?php
if (!defined('ABSPATH')){
    exit(__( 'No Access!', 'fci' ));
}

include(FCI_VIEW_PATH . 'header.php');
$colspan = 0;

$billing_phones = get_post_meta($_GET['order-id'],"billing_phones",true);

function get_order_shipping_titles_by_id( $order_id ) {
    if ( ! $order_id ) {
        return [];
    }

    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return [];
    }

    $shipping_titles = [];

    // گرفتن همه روش‌های ارسال ثبت‌شده در سفارش
    $shipping_items = $order->get_shipping_methods();

    if ( ! empty( $shipping_items ) ) {
        foreach ( $shipping_items as $shipping_item ) {
            if ( is_object( $shipping_item ) && method_exists( $shipping_item, 'get_name' ) ) {
                $title = $shipping_item->get_name();
            } else {
                $title = '';
            }

            $title = trim( (string) $title );
            if ( $title !== '' ) {
                $shipping_titles[] = $title;
            }
        }
    }

    // فالس‌بک اگر هیچ چیزی پیدا نشد
    if ( empty( $shipping_titles ) ) {
        $fallback = trim( (string) $order->get_shipping_method() );
        if ( $fallback !== '' ) {
            $shipping_titles[] = $fallback;
        }
    }

    // حذف تکراری‌ها و فیلتر خالی
    $shipping_titles = array_unique( array_filter( $shipping_titles ) );

    return $shipping_titles;
}
$shipping_titles = get_order_shipping_titles_by_id( $_GET['order-id'] );


?>
    <div class="view-1 container">
        <div class="inner">
            <table class="fci-border-table fci-fix-table">

                <?php if(get_fci_settings('tapin-status')): ?>
                      <?php echo $data['postbarcode']?>
                <?php endif; ?>

                <tbody>
                <tr>
                    <?php if ( $data['recipient'] || $data['full_name'] || $data['r_postcode'] || $data['r_phone'] ||
                         $data['r_email'] || $data['order_date'] ||  $data['trans_id'] || $data['national_id'] || $data['user_meta'] ||
                        $data['order_meta'] || $data['customer_note'] || $data['barcode'] ): ?>
                        <td>
                            <?php echo $data['recipient']; ?>
                            <?php echo $data['full_name']; ?>
                            <div class="section full-name"><span class="body"><span class="title">شماره موبایل:</span><span class="content-holder"><?=$billing_phones?></span></span></div>
                            <?php echo $data['r_postcode']; ?>
                            <?php echo  $data['r_phone']; ?>
                            <?php echo   $data['r_email']; ?>
                            <?php echo  $data['order_date'] ; ?>
                            <?php echo $data['trans_id']; ?>
                            <?php echo  $data['national_id']; ?>
                            <?php echo $data['user_meta']; ?>
                            <?php echo  $data['order_meta']; ?>
                            <?php echo $data['customer_note']; ?>
                            <?php echo $data['barcode']; ?>
                            <div class="section order-date"><span class="body"><span class="title">نحوه ارسال:</span><span class="content-holder"><?=esc_html( implode( '، ', $shipping_titles ) )?></span></span></div>
                        </td>
                        <?php $colspan++ ?>
                    <?php endif; ?>
                    <?php if ($data['logo'] || $data['title'] || $data['sender'] || $data['postcode'] ||
                     $data['economical'] || $data['reg'] || $data['phone'] || $data['email'] || $data['url']): ?>
                        <td>
                            <?php echo $data['logo']; ?>
                            <?php echo $data['title']; ?>
                            <?php echo $data['sender'] ; ?>
                            <?php echo  $data['postcode']; ?>
                            <?php echo  $data['economical']; ?>
                            <?php echo $data['reg']; ?>
                            <?php echo  $data['phone']; ?>
                            <?php echo $data['email']; ?>
                            <?php echo  $data['url']; ?>
                        </td>
                        <?php $colspan++ ?>
                    <?php endif; ?>
                </tr>
                <?php if ( $data['products_list']): ?>
                    <tr>
                        <td colspan="<?php echo $colspan; ?>">
                            <?php echo  $data['products_list']; ?>
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
                <?php if ( $data['shipping'] ||  $data['pay_method'] ||  $data['order_id_html'] ||
                     $data['order_status'] || $data['print_date'] || $data['transmission_date']): ?>
                    <tfoot>
                    <tr>
                        <td colspan="2">
                            <div>
                                <?php echo  $data['shipping']; ?>
                                <?php echo  $data['pay_method']; ?>
                                <?php echo $data['order_id_html']; ?>
                                <?php echo    $data['order_status']; ?>
                                <?php echo $data['print_date']; ?>
                                <?php echo  $data['transmission_date']; ?>
                            </div>
                        </td>
                    </tr>
                    </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>
<?php
include(FCI_VIEW_PATH . 'footer.php');