<?php
namespace ElementorFci\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use FCI_View_Render;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Fci_Tapin extends Widget_Base {

    public function get_name() {
        return 'fci_tapin';
    }
    public function get_title() {
        return __( 'tapin', 'fci' );
    }
    public function get_icon() {
        return 'eicon-envelope';
    }
    public function get_categories() {
        return [ 'fci-post-label' ];
    }
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tapin',
            [
                'label' => esc_html__('tapin', 'fci'),
                'type' => Controls_Manager::SECTION,
            ]
        );


        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($_GET['order-id']) {
            $data = FCI_View_Render::header($_GET['order-id'] , 'post-label', '');

        } else {
            $id = get_fci_settings('test-order-id');
            $data = FCI_View_Render::header($id, 'post-label', '');
        }
        ?>

        <?php if (get_fci_settings('tapin-status')): ?>
            <div><?php echo $data['postbarcode'] ?></div>
        <?php endif; ?>

        <?php
    }
}