/**
 * jquery.dotanimator.js
 * @author Igor Karbachinsky <igorkarbachinsky@mail.ru>
 * @description Creates a simple dot flicker animation for arbitrary jquery element.
 * (c) September 2015
 *
 */
(function ($) {
    /**
     * Initialize
     * @param {Jquery selector} $block
     * @return
     */
    function DotAnimation($block, params) {
        var self = this;

        self.$block = $block;

        self.params = {
            speed: 400,
            numDots: 3,
            dotElement: '.'
        };

        if ("object" == typeof (params)) {
            $.extend(self.params, params);
        }

        self._bindEvents();
        self.$block.trigger('startDotAnimation');

        return self;
    }

    /**
     * Start animation
     * @return
     */
    DotAnimation.prototype._bindEvents = function () {
        var self = this;

        self.$block.bind('startDotAnimation', function () {
            self._start();
        });

        self.$block.bind('stopDotAnimation', function () {
            self._stop();
        });

        return self;
    },

        /**
         * Start animation
         * @return
         */
        DotAnimation.prototype._start = function (i) {
            var self = this;

            var i = 0;
            var html = self.$block.html();

            self.intervalId = setInterval(function () {
                i = ++i % (self.params['numDots'] + 1);
                self.$block.html(html + Array(i + 1).join(self.params['dotElement']));
            }, self.params['speed']);

            return self;
        };

    /**
     * Stop animation
     * @return
     */
    DotAnimation.prototype._stop = function () {
        var self = this;
        clearInterval(self.intervalId);

        return self;
    };

    /**
     * Wrapper for JQuery
     * @param {Objeet} params
     * @return DotAnimation object
     */
    $.fn.dotAnimation = function (params) {
        return new DotAnimation(this, params);
    };

})(jQuery);

jQuery(document).ready(function ($) {

    var nonce = $('meta[name="fci-nonce"]').attr('content');


    $('.post-type-shop_order .bulkactions #doaction, .post-type-shop_order .bulkactions #doaction2').click(function (e) {
        var $val = $('#bulk-action-selector-top').val();
        if ($val.match("^fci_bulk_print")) {
            e.preventDefault();
            var $type = $val.replace('fci_bulk_print_', '');
            var ids = '';
            var cbox = $("#posts-filter [name='post[]']:checked");

            var all = cbox.length;
            if (!all) {
                return false;
            }

            cbox.each(function (index) {
                ids += $(this).val();
                if (index !== all - 1) {
                    ids += ',';
                }
            });
            // window.open(FCI_JS_DATA.base_url + '?action=fci-show&type=' + $type + '&order-id=' + ids + '&fci-nonce=' + nonce, '_blank');
            window.open(FCI_JS_DATA.base_url + '?action=fci-show&type=' + $type + '&order-id=' + ids);
        }
    });


    $('#fci-send-invoice').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        
        var order_id = parseInt($this.data('id'));
        if (!order_id) {
            return false;
        }

        $this.dotAnimation({
            speed: 400,
            dotElement: '.',
            numDots: 3
        });
        
        $this.text(FCI_JS_DATA.waiting);
        $this.prop('disabled', true);
        
        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 45000,
            data: {
                action: 'fci_send_invoice_email',
                fciNonce: nonce,
                orderID: order_id
            },
            success: function (response) {
                // show simple alert
                if (response.result === true) {
                    alert(FCI_JS_DATA.invoice_send);
                }
                
            },
            error: function () {
                alert(FCI_JS_DATA.error_happend);
            },
            complete: function (data) {
                $this.text(FCI_JS_DATA.send_invoice);
                $this.prop('disabled', false);
                
                $this.trigger('stopDotAnimation');
            }
        });
    });
    $('#fci-send-invoice-payment').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        
        var order_id = parseInt($this.data('id'));
        if (!order_id) {
            return false;
        }

        $this.dotAnimation({
            speed: 300,
            dotElement: '.',
            numDots: 3
        });
        
        $this.text(FCI_JS_DATA.waiting);
        $this.prop('disabled', true);
       

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 45000,
            data: {
                action: 'fci_send_invoice_email_payment',
                fciNonce: nonce,
                orderID: order_id
            },
            success: function (response) {
                // simple alert
                if (response.result === true) {
                    alert(FCI_JS_DATA.payment_link_send);
                }
            },
            error: function () {
                alert(FCI_JS_DATA.error_happend);
            },
            complete: function (data) {
                $this.text(FCI_JS_DATA.send_payment_link);
                $this.prop('disabled', false);
                $this.trigger('stopDotAnimation');
            }
        });
    });

    $('#fci-send-invoice-sms').click(function (e) {
        e.preventDefault();
        var $this = $(this);

        var order_id = parseInt($this.data('id'));
        if (!order_id) {
            return false;
        }

        $this.dotAnimation({
            speed: 300,
            dotElement: '.',
            numDots: 3
        });

        $this.text(FCI_JS_DATA.waiting);
        $this.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 45000,
            data: {
                action: 'fci_send_invoice_sms',
                fciNonce: nonce,
                orderID: order_id
            },
            success: function (response) {
                // simple alert
                if (response.result === true) {
                    alert(FCI_JS_DATA.invoice_send);
                }
            },
            error: function () {
                alert(FCI_JS_DATA.error_happend);
            },
            complete: function (data) {
                $this.text(FCI_JS_DATA.send_invoice_sms);
                $this.prop('disabled', false);

                $this.trigger('stopDotAnimation');
            }
        });
    });

    $('#fci-send-invoice-wa').click(function (e) {
        e.preventDefault();
        var $this = $(this);

        var order_id = parseInt($this.data('id'));
        if (!order_id) {
            return false;
        }

        $this.dotAnimation({
            speed: 300,
            dotElement: '.',
            numDots: 3
        });

        $this.text(FCI_JS_DATA.waiting);
        $this.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 45000,
            data: {
                action: 'fci_send_invoice_wa',
                fciNonce: nonce,
                orderID: order_id
            },
            success: function (response) {
                // simple alert
                if (response.result === true) {
                    alert(FCI_JS_DATA.invoice_send);
                }
            },
            error: function () {
                alert(FCI_JS_DATA.error_happend);
            },
            complete: function (data) {
                $this.text(FCI_JS_DATA.send_invoice_sms);
                $this.prop('disabled', false);

                $this.trigger('stopDotAnimation');
            }
        });
    });

    $('.wp-list-table .fci-invoice, .wp-list-table .fci-packing-slip, .wp-list-table .fci-post-label, .wp-list-table .fci-order-label, .wp-list-table .fci-shop-label, .wp-list-table .fci-customer-label, .wp-list-table .fci-product-label').attr('target', '_blank');


    $('#fci-send-invoice-sms-payment').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var order_id = parseInt($this.data('id'));
        if (!order_id) {
            return false;
        }

        $this.dotAnimation({
            speed: 300,
            dotElement: '.',
            numDots: 3
        });


        $this.text(FCI_JS_DATA.waiting);
        $this.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 45000,
            data: {
                action: 'fci_send_invoice_sms_payment',
                fciNonce: nonce,
                orderID: order_id
            },
            success: function (response) {
                //simple alert
                if (response.result === true) {
                    alert(FCI_JS_DATA.payment_link_send);
                }
            },
            error: function () {
                alert(FCI_JS_DATA.error_happend);
            },
            complete: function (data) {
                $this.text(FCI_JS_DATA.send_payment_link);
                $this.prop('disabled', false);

                $this.trigger('stopDotAnimation');
            }
        });
    });

});